/*
 * Decompiled with CFR 0.152.
 */
package oracle.tip.tools.ide.pm.bpelgraph.editors;

import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.List;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JTable;
import javax.swing.ListSelectionModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;
import oracle.tip.tools.ide.common.bpelparser.iface.Activity;
import oracle.tip.tools.ide.common.bpelparser.iface.CorrelationSet;
import oracle.tip.tools.ide.common.bpelparser.iface.CorrelationSets;
import oracle.tip.tools.ide.common.bpelparser.iface.Scope;
import oracle.tip.tools.ide.common.graph.GraphUtils;
import oracle.tip.tools.ide.common.ui.ImageColumnTableCellRenderer;
import oracle.tip.tools.ide.common.ui.ToolBar;
import oracle.tip.tools.ide.common.ui.UIHelper;
import oracle.tip.tools.ide.common.ui.models.BaseTableModel;
import oracle.tip.tools.ide.pm.bpelgraph.editors.BaseEditingPage;
import oracle.tip.tools.ide.pm.bpelgraph.editors.CorrelationSetDialog;
import oracle.tip.tools.ide.pm.bpelgraph.editors.CorrelationSetsTableModel;
import oracle.tip.tools.ide.pm.bpelgraph.views.BPELGraphPane;
import oracle.tip.tools.ide.pm.i18n.BPELStringTranslator;
import oracle.tip.tools.ide.pm.resources.images.ImageCache;

public class CorrelationSetsPage
extends BaseEditingPage
implements ActionListener,
ListSelectionListener {
    protected JTable m_correlationSetsTable;
    protected JButton m_addCorrelationSetsBtn;
    protected JButton m_removeCorrelationSetsBtn;
    protected JButton m_editCorrelationSetsBtn;
    protected Activity m_activity;
    protected BPELGraphPane m_graph;

    public CorrelationSetsPage(BPELGraphPane graphPane) {
        super(graphPane);
        this.m_graph = graphPane;
        this.createControls();
        this.layoutControls();
        this.updateButtons();
    }

    @Override
    public void setUserObject(Object model) {
        super.setUserObject(model);
        this.m_activity = (Activity)model;
        this.loadControls();
        this.updateButtons();
    }

    @Override
    public String getTitle() {
        return BPELStringTranslator.getString("COLLAXALAF_CORR_SETS");
    }

    protected void loadControls() {
        List correlationSets = null;
        CorrelationSetsTableModel model = (CorrelationSetsTableModel)((Object)this.m_correlationSetsTable.getModel());
        model.getData().removeAllElements();
        if (this.m_activity instanceof Scope) {
            CorrelationSets sets = ((Scope)this.m_activity).getCorrelationSets();
            if (sets != null) {
                correlationSets = sets.getCorrelationSets();
            }
        } else {
            return;
        }
        if (correlationSets == null) {
            model.refresh();
            return;
        }
        for (CorrelationSet cs : correlationSets) {
            model.getData().addElement(cs);
        }
        model.refresh();
    }

    protected void createControls() {
        this.m_correlationSetsTable = new JTable();
        this.m_correlationSetsTable.setRowHeight(18);
        this.m_correlationSetsTable.setModel((TableModel)((Object)new CorrelationSetsTableModel()));
        this.m_correlationSetsTable.setAutoResizeMode(4);
        this.m_correlationSetsTable.getSelectionModel().addListSelectionListener(this);
        TableColumnModel colModel = this.m_correlationSetsTable.getColumnModel();
        for (int i = 0; i < colModel.getColumnCount(); ++i) {
            TableColumn col = colModel.getColumn(i);
            if (i == 0) {
                col.setMinWidth(30);
                col.setMaxWidth(30);
                col.setCellRenderer((TableCellRenderer)new ImageColumnTableCellRenderer(ImageCache.getIcon("correlation_set_node")));
            }
            col.setPreferredWidth(120);
        }
        this.m_addCorrelationSetsBtn = UIHelper.createToolBarButton((int)0);
        this.m_addCorrelationSetsBtn.addActionListener(this);
        this.m_removeCorrelationSetsBtn = UIHelper.createToolBarButton((int)2);
        this.m_removeCorrelationSetsBtn.addActionListener(this);
        this.m_editCorrelationSetsBtn = UIHelper.createToolBarButton((int)1);
        this.m_editCorrelationSetsBtn.addActionListener(this);
    }

    protected void layoutControls() {
        ToolBar toolBar = new ToolBar();
        toolBar.add((Component)this.m_addCorrelationSetsBtn);
        toolBar.add((Component)this.m_editCorrelationSetsBtn);
        toolBar.add((Component)this.m_removeCorrelationSetsBtn);
        this.setLayout(new GridBagLayout());
        GraphUtils.addComponent((Container)this, (Component)toolBar, (int)1, (int)0, (int)1, (int)1, (int)13, (int)0, (Insets)new Insets(10, 10, 0, 10), (int)0, (int)0, (double)1.0, (double)0.0);
        GraphUtils.addComponent((Container)this, (Component)GraphUtils.getScrollPane((Component)this.m_correlationSetsTable), (int)0, (int)1, (int)2, (int)1, (int)17, (int)1, (Insets)new Insets(0, 10, 10, 10), (int)0, (int)0, (double)1.0, (double)1.0);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Object src = e.getSource();
        if (src == this.m_addCorrelationSetsBtn) {
            this.handleAdd();
        } else if (src == this.m_editCorrelationSetsBtn) {
            this.handleEdit();
        } else if (src == this.m_removeCorrelationSetsBtn) {
            this.handleRemove();
        }
    }

    protected void updateButtons() {
        this.m_addCorrelationSetsBtn.setEnabled(true);
        int numSelectedRows = this.m_correlationSetsTable.getSelectedRowCount();
        if (numSelectedRows > 0) {
            this.m_removeCorrelationSetsBtn.setEnabled(true);
            this.m_editCorrelationSetsBtn.setEnabled(true);
        } else {
            this.m_removeCorrelationSetsBtn.setEnabled(false);
            this.m_editCorrelationSetsBtn.setEnabled(false);
        }
    }

    protected void handleAdd() {
        ArrayList<CorrelationSet> list = new ArrayList<CorrelationSet>();
        CorrelationSetDialog dlg = new CorrelationSetDialog(GraphUtils.getFrame((Component)this), this.m_graph);
        CorrelationSetsTableModel model = (CorrelationSetsTableModel)((Object)this.m_correlationSetsTable.getModel());
        Vector data = model.getData();
        for (int i = 0; i < data.size(); ++i) {
            CorrelationSet var = (CorrelationSet)data.elementAt(i);
            list.add(var);
        }
        if (dlg.create(this.m_activity, list) != 0) {
            return;
        }
        CorrelationSet correlationSet = dlg.getCorrelationSet();
        model.getData().addElement(correlationSet);
        model.refresh();
        this.updateButtons();
    }

    protected void handleEdit() {
        ListSelectionModel model = this.m_correlationSetsTable.getSelectionModel();
        if (model.isSelectionEmpty()) {
            return;
        }
        int row = model.getLeadSelectionIndex();
        CorrelationSetsTableModel tableModel = (CorrelationSetsTableModel)((Object)this.m_correlationSetsTable.getModel());
        CorrelationSet data = (CorrelationSet)tableModel.getRowData(row);
        CorrelationSetDialog dlg = new CorrelationSetDialog(GraphUtils.getFrame((Component)this), this.m_graph);
        Vector v = tableModel.getData();
        ArrayList<CorrelationSet> list = new ArrayList<CorrelationSet>();
        for (int i = 0; i < v.size(); ++i) {
            CorrelationSet var = (CorrelationSet)v.elementAt(i);
            list.add(var);
        }
        if (dlg.edit(data, list) == 0) {
            tableModel.refresh();
        }
    }

    protected void handleRemove() {
        TableModel model = this.m_correlationSetsTable.getModel();
        if (model instanceof BaseTableModel) {
            BaseTableModel tabModel = (BaseTableModel)model;
            int[] rows = this.m_correlationSetsTable.getSelectedRows();
            tabModel.removeRows(rows);
            this.updateButtons();
        }
    }

    @Override
    public void saveChanges() {
        CorrelationSet[] correlationSets = null;
        CorrelationSetsTableModel tableModel = (CorrelationSetsTableModel)((Object)this.m_correlationSetsTable.getModel());
        Vector v = tableModel.getData();
        if (v != null) {
            correlationSets = v.toArray(new CorrelationSet[0]);
        }
        if (this.m_activity instanceof Scope) {
            ((Scope)this.m_activity).deleteCorrelationSets();
            if (correlationSets != null) {
                for (int i = 0; i < correlationSets.length; ++i) {
                    CorrelationSet cs = correlationSets[i];
                    ((Scope)this.m_activity).addCorrelationSet(cs);
                }
            }
        }
    }

    @Override
    public void valueChanged(ListSelectionEvent e) {
        this.updateButtons();
    }
}

