/*
 * Decompiled with CFR 0.152.
 */
package oracle.tip.tools.ide.pm.bpelgraph.editors;

import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.Action;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.xml.namespace.QName;
import oracle.tip.tools.ide.common.bpeldesigner.models.bpel.CorrelationSetProperty;
import oracle.tip.tools.ide.common.datasources.schema.SchemaTypesDataSource;
import oracle.tip.tools.ide.common.graph.GraphUtils;
import oracle.tip.tools.ide.common.typeexplorer.TypeChooser;
import oracle.tip.tools.ide.common.typeexplorer.TypeObject;
import oracle.tip.tools.ide.common.ui.ToolBar;
import oracle.tip.tools.ide.common.ui.UIHelper;
import oracle.tip.tools.ide.common.ui.treeexplorer.TreeExplorerDataSource;
import oracle.tip.tools.ide.pm.bpelgraph.views.BPELGraphPane;
import oracle.tip.tools.ide.pm.i18n.BPELStringTranslator;

public class CorrelationSetPropertyPanel
extends JPanel
implements ActionListener {
    public static final String NAME_CHANGED = "NAME_CHANGED";
    public static final String TYPE_CHANGED = "TYPE_CHANGED";
    protected JTextField m_nameField;
    protected JTextField m_typeField;
    protected TypeObject m_typeObj;
    protected JButton m_typeBrowseBtn;
    protected JPanel m_aliasPnl;
    protected BPELGraphPane m_graph;
    protected CorrelationSetProperty m_property;

    public CorrelationSetPropertyPanel(BPELGraphPane graph) {
        this.m_graph = graph;
        this.createControls();
        this.layoutControls();
    }

    public boolean isDataValid() {
        String s = this.m_nameField.getText();
        if (s == null || s.length() == 0) {
            return false;
        }
        return this.m_typeObj != null;
    }

    public void setProperty(String propName, QName qname) {
        if (propName != null) {
            this.m_nameField.setText(propName);
        }
        if (qname != null) {
            this.m_typeObj = new TypeObject(0, (Object)qname);
            this.m_typeField.setText("{" + qname.getNamespaceURI() + "}" + qname.getLocalPart());
        }
    }

    public void setProperty(CorrelationSetProperty property) {
        this.m_property = property;
        if (this.m_property != null) {
            this.m_nameField.setText(this.m_property.getName());
            QName qname = this.m_property.getType();
            if (qname != null) {
                this.m_typeObj = new TypeObject(0, (Object)qname);
                this.m_typeField.setText("{" + qname.getNamespaceURI() + "}" + qname.getLocalPart());
            }
        }
    }

    public CorrelationSetProperty getProperty() {
        return this.m_property;
    }

    public CorrelationSetProperty saveToModel() {
        String name;
        if (this.m_property == null) {
            this.m_property = new CorrelationSetProperty();
        }
        if ((name = this.m_nameField.getText()) != null) {
            this.m_property.setName(name.trim());
        }
        QName qname = null;
        TypeObject to = this.m_typeObj;
        if (to != null) {
            qname = to.getQName();
        }
        this.m_property.setType(qname);
        return this.m_property;
    }

    protected void createControls() {
        this.m_nameField = new JTextField();
        this.m_nameField.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent e) {
                CorrelationSetPropertyPanel.this.firePropertyChange(CorrelationSetPropertyPanel.NAME_CHANGED, null, CorrelationSetPropertyPanel.this.m_nameField.getText());
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                CorrelationSetPropertyPanel.this.firePropertyChange(CorrelationSetPropertyPanel.NAME_CHANGED, null, CorrelationSetPropertyPanel.this.m_nameField.getText());
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                CorrelationSetPropertyPanel.this.firePropertyChange(CorrelationSetPropertyPanel.NAME_CHANGED, null, CorrelationSetPropertyPanel.this.m_nameField.getText());
            }
        });
        this.m_typeField = new JTextField();
        this.m_typeField.setEditable(false);
        this.m_typeBrowseBtn = UIHelper.createBrowseButton((String)BPELStringTranslator.getString("EDITOR_ACT_VAR_SEN_BWS_TYPE"));
        this.m_typeBrowseBtn.addActionListener(this);
    }

    protected void layoutControls() {
        ToolBar browseTB = new ToolBar();
        browseTB.setBorderInsets(new Insets(0, 0, 0, 0));
        browseTB.add((Component)this.m_typeBrowseBtn);
        this.setLayout(new GridBagLayout());
        JLabel nameLbl = new JLabel();
        BPELStringTranslator.setLabel(nameLbl, this.m_nameField, BPELStringTranslator.getString("GENERAL_EDITOR_NAME"));
        JLabel typeLbl = new JLabel();
        BPELStringTranslator.setLabel(typeLbl, this.m_typeField, BPELStringTranslator.getString("EDITOR_COR_SET_PNL_TYPE"));
        int row = 0;
        GraphUtils.addComponent((Container)this, (Component)nameLbl, (int)0, (int)row, (int)1, (int)1, (int)17, (int)0, (Insets)new Insets(5, 5, 0, 0), (int)0, (int)0, (double)0.0, (double)0.0);
        GraphUtils.addComponent((Container)this, (Component)this.m_nameField, (int)1, (int)row++, (int)1, (int)1, (int)17, (int)2, (Insets)new Insets(5, 5, 0, 5), (int)0, (int)0, (double)1.0, (double)0.0);
        GraphUtils.addComponent((Container)this, (Component)typeLbl, (int)0, (int)row, (int)1, (int)1, (int)17, (int)0, (Insets)new Insets(5, 5, 5, 0), (int)0, (int)0, (double)0.0, (double)0.0);
        GraphUtils.addComponent((Container)this, (Component)this.m_typeField, (int)1, (int)row, (int)1, (int)1, (int)17, (int)2, (Insets)new Insets(5, 5, 5, 5), (int)0, (int)0, (double)1.0, (double)0.0);
        GraphUtils.addComponent((Container)this, (Component)browseTB, (int)2, (int)row++, (int)1, (int)1, (int)17, (int)0, (Insets)new Insets(5, 0, 5, 5), (int)0, (int)0, (double)0.0, (double)0.0);
    }

    protected void handleTypeBrowse() {
        TypeChooser chooser = new TypeChooser(GraphUtils.getFrame((Component)this));
        chooser.getTypeExplorer().setToolBarActions(new Action[0]);
        SchemaTypesDataSource ds = new SchemaTypesDataSource();
        if (chooser.display((TreeExplorerDataSource)ds, true) == 0) {
            this.m_typeObj = chooser.getTypeObject();
            this.m_typeField.setText(this.m_typeObj.getQName().toString());
            this.firePropertyChange(TYPE_CHANGED, null, this.m_typeObj);
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Object src = e.getSource();
        if (src == this.m_typeBrowseBtn) {
            this.handleTypeBrowse();
        }
    }
}

