/*
 * Decompiled with CFR 0.152.
 */
package oracle.tip.tools.ide.pm.bpelgraph.editors;

import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.xml.namespace.QName;
import oracle.tip.tools.ide.common.bpeldesigner.models.bpel.CorrelationSetProperty;
import oracle.tip.tools.ide.common.bpeldesigner.util.WSDLPropertyUtil;
import oracle.tip.tools.ide.common.graph.GraphUtils;
import oracle.tip.tools.ide.common.ide.bpel.BPELProject;
import oracle.tip.tools.ide.pm.bpelgraph.editors.CorrelationSetPropertyPanel;
import oracle.tip.tools.ide.pm.bpelgraph.views.BPELGraphPane;
import oracle.tip.tools.ide.pm.gui.generalpurpose.BPELBaseDialog;
import oracle.tip.tools.ide.pm.i18n.BPELStringTranslator;

public class CorrelationSetPropertyDialog
extends BPELBaseDialog
implements ActionListener,
PropertyChangeListener {
    public static final int OK = 0;
    public static final int CANCEL = 1;
    private JButton m_okBtn;
    private JButton m_cancelBtn;
    protected JButton m_helpBtn;
    protected CorrelationSetPropertyPanel m_propPanel;
    protected BPELGraphPane m_graph;
    protected int m_retVal = 1;
    protected boolean m_bEditing = false;

    public CorrelationSetPropertyDialog(JFrame f, BPELGraphPane graph) {
        super(f, BPELStringTranslator.getString("EDITOR_COR_SET_PTY_DLG"), true);
        this.m_graph = graph;
        this.createAndLayoutControls();
        this.updateButtons();
    }

    public void saveToModel() {
        this.m_propPanel.saveToModel();
    }

    public CorrelationSetProperty getCorrelationSetProperty() {
        return this.m_propPanel.getProperty();
    }

    public int create() {
        this.m_bEditing = false;
        this.setTitle(BPELStringTranslator.getString("EDITOR_COR_SET_PTY_DLG_CRT"));
        return this.display();
    }

    public int create(String propName, QName propType) {
        this.m_bEditing = false;
        this.m_propPanel.setProperty(propName, propType);
        return this.display();
    }

    public int edit(CorrelationSetProperty p) {
        this.m_bEditing = true;
        this.setTitle(BPELStringTranslator.getString("EDITOR_COR_SET_PTY_DLG_EDIT") + p.getName());
        this.m_propPanel.setProperty(p);
        return this.display();
    }

    private int display() {
        this.setVisible(true);
        return this.m_retVal;
    }

    protected void createAndLayoutControls() {
        this.m_propPanel = new CorrelationSetPropertyPanel(this.m_graph);
        this.m_propPanel.addPropertyChangeListener(this);
        this.m_okBtn = new JButton();
        BPELStringTranslator.setButton(this.m_okBtn, BPELStringTranslator.getString("OK_BUTTON_TEXT_RES"));
        this.m_okBtn.addActionListener(this);
        this.m_cancelBtn = new JButton();
        BPELStringTranslator.setButton(this.m_cancelBtn, BPELStringTranslator.getString("CANCEL_BUTTON_TEXT_RES"));
        this.m_cancelBtn.addActionListener(this);
        this.m_helpBtn = new JButton();
        BPELStringTranslator.setButton(this.m_helpBtn, BPELStringTranslator.getString("HELP_BUTTON_TEXT_RES"));
        this.m_helpBtn.addActionListener(this);
        JPanel btnPnl = new JPanel(new GridLayout(1, 2, 5, 0));
        btnPnl.add(this.m_okBtn);
        btnPnl.add(this.m_cancelBtn);
        Container c = this.getContentPane();
        c.setLayout(new GridBagLayout());
        int row = 0;
        GraphUtils.addComponent((Container)c, (Component)this.m_propPanel, (int)0, (int)row++, (int)2, (int)1, (int)17, (int)1, (Insets)new Insets(5, 5, 5, 5), (int)0, (int)0, (double)1.0, (double)1.0);
        GraphUtils.addComponent((Container)c, (Component)this.m_helpBtn, (int)0, (int)row, (int)1, (int)1, (int)17, (int)0, (Insets)new Insets(5, 10, 10, 10), (int)0, (int)0, (double)1.0, (double)0.0);
        GraphUtils.addComponent((Container)c, (Component)btnPnl, (int)1, (int)row++, (int)1, (int)1, (int)13, (int)0, (Insets)new Insets(5, 0, 10, 10), (int)0, (int)0, (double)1.0, (double)0.0);
        this.setSize(345, 130);
        GraphUtils.centerInScreen((Component)((Object)this));
    }

    protected void updateButtons() {
        this.m_okBtn.setEnabled(this.m_propPanel.isDataValid());
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Object src = e.getSource();
        if (src == this.m_okBtn) {
            String origName;
            if (!this.m_propPanel.isDataValid()) {
                GraphUtils.displayMessage((Component)((Object)this), (String)BPELStringTranslator.getString("ERROR_INVALID_PROP_SET", "Property settings are not valid!"), (int)0);
                return;
            }
            String name = this.m_propPanel.m_nameField.getText().trim();
            if (name == null || name.length() == 0) {
                GraphUtils.displayMessage((Component)GraphUtils.getFrame((Component)((Object)this)), (String)BPELStringTranslator.getString("EDITOR_INVALID_NAME"));
                return;
            }
            if (this.m_bEditing ? (origName = this.m_propPanel.getProperty().getName()) != null && !origName.equals(name) && this.doesNameExist(name) : this.doesNameExist(name)) {
                return;
            }
            this.m_propPanel.saveToModel();
            this.m_retVal = 0;
            this.dispose();
        } else if (src == this.m_cancelBtn) {
            this.handleCancel();
        } else if (src == this.m_helpBtn) {
            this.helpInvoked();
        }
    }

    protected boolean doesNameExist(String name) {
        try {
            List lst = WSDLPropertyUtil.getBPELProperties((BPELProject)this.m_graph.getBPELProject());
            for (CorrelationSetProperty prop : lst) {
                if (!prop.getName().equals(name)) continue;
                GraphUtils.displayMessage((Component)((Object)this), (String)BPELStringTranslator.getString("ERROR_PROP_EXISTS", "Property with same name already exists!"), (int)0);
                return true;
            }
        }
        catch (Exception ex) {
            GraphUtils.displayMessage((Component)((Object)this), (String)BPELStringTranslator.getString("ERROR_RETRIVE_PROPS", "Could not retrieve properties!"), (int)2);
        }
        return false;
    }

    protected void handleCancel() {
        this.m_retVal = 1;
        this.dispose();
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        Object src = evt.getSource();
        if (src == this.m_propPanel) {
            this.updateButtons();
        }
    }

    protected void helpInvoked() {
        this.handleHelp(this.m_propPanel);
    }
}

