/*
 * Decompiled with CFR 0.152.
 */
package oracle.tip.tools.ide.pm.bpelgraph.editors;

import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.List;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.border.TitledBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;
import javax.xml.namespace.QName;
import oracle.tip.tools.ide.common.bpeldesigner.models.bpel.CorrelationSetProperty;
import oracle.tip.tools.ide.common.bpeldesigner.util.WSDLPropertyUtil;
import oracle.tip.tools.ide.common.bpelparser.iface.CorrelationSet;
import oracle.tip.tools.ide.common.bpelparser.iface.Process;
import oracle.tip.tools.ide.common.graph.GraphUtils;
import oracle.tip.tools.ide.common.ide.bpel.BPELProject;
import oracle.tip.tools.ide.common.ui.ImageColumnTableCellRenderer;
import oracle.tip.tools.ide.common.ui.ToolBar;
import oracle.tip.tools.ide.common.ui.UIHelper;
import oracle.tip.tools.ide.pm.addin.model.BPELXmlModel;
import oracle.tip.tools.ide.pm.bpelgraph.editors.CorrelationSetPropertiesTableModel;
import oracle.tip.tools.ide.pm.bpelgraph.editors.CorrelationSetPropertyDialog;
import oracle.tip.tools.ide.pm.bpelgraph.model.BPELGraphModel;
import oracle.tip.tools.ide.pm.bpelgraph.views.BPELGraphPane;
import oracle.tip.tools.ide.pm.gui.dialogs.choosers.property.PropertyChooser;
import oracle.tip.tools.ide.pm.i18n.BPELStringTranslator;
import oracle.tip.tools.ide.pm.resources.images.ImageCache;

public class CorrelationSetPanel
extends JPanel
implements ActionListener,
ListSelectionListener {
    protected JTextField m_nameField;
    protected JTable m_propsTable;
    protected JButton m_addBtn;
    protected JButton m_removeBtn;
    protected JButton m_editBtn;
    protected ToolBar m_toolBar;
    protected BPELGraphPane m_graph;
    protected CorrelationSet m_correlationSet;
    protected JCheckBox m_namespaceCB;

    public CorrelationSetPanel(BPELGraphPane graph) {
        this.m_graph = graph;
        this.createControls();
        this.layoutControls();
        this.updateButtons();
    }

    public void setCorrelationSet(CorrelationSet cs) {
        this.m_correlationSet = cs;
        if (cs != null) {
            this.m_nameField.setText(cs.getName());
        }
        this.loadProperties();
    }

    public String getCorrelationSetName() {
        return this.m_nameField.getText().trim();
    }

    protected void loadProperties() {
        BPELXmlModel mainModel = this.m_graph.getBPELXmlModel();
        List<Object> lst = null;
        try {
            lst = mainModel.getPropertyModel().getProperties();
        }
        catch (Exception e) {
            GraphUtils.displayMessage((Component)this, (String)BPELStringTranslator.getString("EDITOR_COR_SET_PNL_CANT_READ_PTY"), (int)0);
        }
        Vector<CorrelationSetProperty> v = new Vector<CorrelationSetProperty>();
        QName[] props = this.m_correlationSet.getProperties();
        if (props != null) {
            block2: for (int i = 0; i < props.length; ++i) {
                QName prop = props[i];
                String name1 = prop.getLocalPart();
                for (CorrelationSetProperty correlationSetProperty : lst) {
                    if (!name1.equals(correlationSetProperty.getName())) continue;
                    v.addElement(correlationSetProperty);
                    continue block2;
                }
            }
        }
        CorrelationSetPropertiesTableModel model = (CorrelationSetPropertiesTableModel)((Object)this.m_propsTable.getModel());
        model.setData(v);
        model.refresh();
    }

    public CorrelationSet getCorrelationSet() {
        return this.m_correlationSet;
    }

    public void saveToModel() {
        BPELGraphModel graphModel = (BPELGraphModel)this.m_graph.getModel();
        Process process = graphModel.getProcess();
        this.m_correlationSet.setName(this.m_nameField.getText().trim());
        CorrelationSetPropertiesTableModel model = (CorrelationSetPropertiesTableModel)((Object)this.m_propsTable.getModel());
        Vector v = model.getData();
        Vector<QName> tmp = new Vector<QName>();
        for (int i = 0; i < v.size(); ++i) {
            CorrelationSetProperty p = (CorrelationSetProperty)v.elementAt(i);
            String ns = p.getTargetNamespace();
            String prefix = null;
            if (ns != null) {
                prefix = process.addNamespace(ns);
            }
            String name = p.getName();
            QName q = new QName(ns, name, prefix);
            tmp.addElement(q);
        }
        Object[] propQNames = new QName[tmp.size()];
        tmp.copyInto(propQNames);
        this.m_correlationSet.setProperties((QName[])propQNames);
    }

    protected void createControls() {
        this.m_namespaceCB = new JCheckBox(BPELStringTranslator.getString("EDITOR_COR_EDIT_PGE_SHOW_URI"), false);
        BPELStringTranslator.setButton(this.m_namespaceCB, BPELStringTranslator.getString("EDITOR_COR_EDIT_PGE_SHOW_URI_RES"));
        this.m_namespaceCB.addActionListener(this);
        this.m_addBtn = UIHelper.createToolBarButton((int)3);
        this.m_addBtn.addActionListener(this);
        this.m_removeBtn = UIHelper.createToolBarButton((int)2);
        this.m_removeBtn.addActionListener(this);
        this.m_editBtn = UIHelper.createToolBarButton((int)1);
        this.m_editBtn.addActionListener(this);
        this.m_nameField = new JTextField();
        CorrelationSetPropertiesTableModel model = new CorrelationSetPropertiesTableModel();
        model.showNamespaces(this.m_namespaceCB.isSelected());
        this.m_propsTable = new JTable((TableModel)((Object)model));
        this.m_propsTable.getSelectionModel().addListSelectionListener(this);
        this.m_propsTable.getTableHeader().setReorderingAllowed(false);
        TableColumnModel colModel = this.m_propsTable.getColumnModel();
        for (int i = 0; i < colModel.getColumnCount(); ++i) {
            TableColumn col = colModel.getColumn(i);
            if (i == 0) {
                col.setMinWidth(30);
                col.setMaxWidth(30);
                col.setCellRenderer((TableCellRenderer)new ImageColumnTableCellRenderer(ImageCache.getIcon("property_node")));
            }
            col.setPreferredWidth(120);
        }
        this.m_propsTable.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                Point origin = e.getPoint();
                int row = CorrelationSetPanel.this.m_propsTable.rowAtPoint(origin);
                int column = CorrelationSetPanel.this.m_propsTable.columnAtPoint(origin);
                if (row == -1 || column == -1) {
                    return;
                }
                if (e.getClickCount() == 2) {
                    CorrelationSetPanel.this.handleEdit();
                }
            }

            @Override
            public void mouseReleased(MouseEvent e) {
            }
        });
    }

    protected void layoutControls() {
        JPanel btnPnl = new JPanel(new GridLayout(1, 2, 5, 0));
        btnPnl.add(this.m_addBtn);
        btnPnl.add(this.m_removeBtn);
        ToolBar toolBar = new ToolBar();
        toolBar.setBorderInsets(new Insets(0, 0, 0, 0));
        toolBar.add((Component)this.m_addBtn);
        toolBar.add((Component)this.m_editBtn);
        toolBar.add((Component)this.m_removeBtn);
        JPanel propsPnl = new JPanel(new GridBagLayout());
        propsPnl.setBorder(new TitledBorder(BPELStringTranslator.getString("EDITOR_COR_SET_PNL_PTY")));
        GraphUtils.addComponent((Container)propsPnl, (Component)toolBar, (int)0, (int)0, (int)1, (int)1, (int)13, (int)0, (Insets)new Insets(0, 5, 0, 5), (int)0, (int)0, (double)1.0, (double)0.0);
        GraphUtils.addComponent((Container)propsPnl, (Component)GraphUtils.getScrollPane((Component)this.m_propsTable), (int)0, (int)1, (int)1, (int)1, (int)17, (int)1, (Insets)new Insets(0, 5, 0, 5), (int)0, (int)0, (double)1.0, (double)1.0);
        GraphUtils.addComponent((Container)propsPnl, (Component)this.m_namespaceCB, (int)0, (int)2, (int)1, (int)1, (int)17, (int)0, (Insets)new Insets(2, 5, 0, 5), (int)0, (int)0, (double)1.0, (double)0.0);
        this.setLayout(new GridBagLayout());
        JLabel nameLbl = new JLabel();
        BPELStringTranslator.setLabel(nameLbl, this.m_nameField, BPELStringTranslator.getString("GENERAL_EDITOR_NAME"));
        int row = 0;
        GraphUtils.addComponent((Container)this, (Component)nameLbl, (int)0, (int)row, (int)1, (int)1, (int)17, (int)0, (Insets)new Insets(5, 5, 5, 0), (int)0, (int)0, (double)0.0, (double)0.0);
        GraphUtils.addComponent((Container)this, (Component)this.m_nameField, (int)1, (int)row++, (int)1, (int)1, (int)17, (int)2, (Insets)new Insets(5, 5, 5, 5), (int)0, (int)0, (double)1.0, (double)0.0);
        GraphUtils.addComponent((Container)this, (Component)propsPnl, (int)0, (int)row, (int)2, (int)1, (int)17, (int)1, (Insets)new Insets(5, 5, 5, 5), (int)0, (int)0, (double)1.0, (double)1.0);
    }

    protected void handleAdd() {
        PropertyChooser chooser = new PropertyChooser(GraphUtils.getFrame((Component)this), this.m_graph);
        if (chooser.display() == 0) {
            CorrelationSetPropertiesTableModel model = (CorrelationSetPropertiesTableModel)((Object)this.m_propsTable.getModel());
            CorrelationSetProperty p = chooser.getSelectedProperty();
            for (Object obj : model.getData()) {
                CorrelationSetProperty one = (CorrelationSetProperty)obj;
                if (!one.equals((Object)p)) continue;
                GraphUtils.displayMessage((Component)GraphUtils.getFrame((Component)this), (String)BPELStringTranslator.getString("ERROR_PROP_EXISTS_IN_SET", "Property with same name already exists in correlation set!"), (int)1);
                return;
            }
            model.getData().addElement(p);
            model.refresh();
        }
    }

    protected void handleEdit() {
        CorrelationSetPropertyDialog dlg = new CorrelationSetPropertyDialog(GraphUtils.getFrame((Component)this), this.m_graph);
        CorrelationSetPropertiesTableModel model = (CorrelationSetPropertiesTableModel)((Object)this.m_propsTable.getModel());
        int idx = this.m_propsTable.getSelectionModel().getLeadSelectionIndex();
        if (idx != -1) {
            CorrelationSetProperty prop = (CorrelationSetProperty)model.getRowData(idx);
            String origName = prop.getName();
            if (dlg.edit(prop) == 0) {
                try {
                    BPELXmlModel mainModel = this.m_graph.getBPELXmlModel();
                    mainModel.getPropertyModel().deleteProperty(origName);
                }
                catch (Exception e) {
                    e.printStackTrace();
                    UIHelper.displayErrorMessage((Component)this, (String)BPELStringTranslator.getString("EDITOR_COR_SET_PNL_FAIL_DEL"));
                }
                dlg.saveToModel();
                prop = dlg.getCorrelationSetProperty();
                try {
                    WSDLPropertyUtil.saveProperty((BPELProject)this.m_graph.getBPELProject(), (CorrelationSetProperty)prop);
                }
                catch (Exception e) {
                    e.printStackTrace();
                    UIHelper.displayErrorMessage((Component)this, (String)BPELStringTranslator.getString("EDITOR_COR_SET_PNL_FAIL_SAVE"));
                }
                model.fireTableRowsUpdated(idx, idx);
            }
        }
    }

    protected void removeProps() {
        int[] rows = this.m_propsTable.getSelectedRows();
        if (rows != null && rows.length > 0) {
            CorrelationSetPropertiesTableModel model = (CorrelationSetPropertiesTableModel)((Object)this.m_propsTable.getModel());
            model.removeRows(rows);
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Object src = e.getSource();
        if (src == this.m_addBtn) {
            this.handleAdd();
        } else if (src == this.m_editBtn) {
            this.handleEdit();
        } else if (src == this.m_removeBtn) {
            this.removeProps();
        } else if (src == this.m_namespaceCB) {
            CorrelationSetPropertiesTableModel model = (CorrelationSetPropertiesTableModel)((Object)this.m_propsTable.getModel());
            model.showNamespaces(this.m_namespaceCB.isSelected());
        }
    }

    protected void updateButtons() {
        this.m_addBtn.setEnabled(true);
        int numSelectedRows = this.m_propsTable.getSelectedRowCount();
        if (numSelectedRows > 0) {
            this.m_removeBtn.setEnabled(true);
            this.m_editBtn.setEnabled(true);
        } else {
            this.m_removeBtn.setEnabled(false);
            this.m_editBtn.setEnabled(false);
        }
    }

    @Override
    public void valueChanged(ListSelectionEvent e) {
        this.updateButtons();
    }
}

