/*
 * Decompiled with CFR 0.152.
 */
package oracle.tip.tools.ide.pm.bpelgraph.editors;

import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.border.TitledBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;
import javax.xml.namespace.QName;
import oracle.ide.net.URLFileSystem;
import oracle.tip.tools.ide.common.bpeldesigner.models.bpel.CorrelationPropertyAlias;
import oracle.tip.tools.ide.common.bpeldesigner.models.bpel.CorrelationSetProperty;
import oracle.tip.tools.ide.common.bpeldesigner.util.BPELModelerUtil;
import oracle.tip.tools.ide.common.bpeldesigner.util.Helper;
import oracle.tip.tools.ide.common.bpelparser.BPELParser;
import oracle.tip.tools.ide.common.bpelparser.iface.Activity;
import oracle.tip.tools.ide.common.bpelparser.iface.CorrelationSet;
import oracle.tip.tools.ide.common.bpelparser.iface.Invoke;
import oracle.tip.tools.ide.common.bpelparser.iface.OnMessage;
import oracle.tip.tools.ide.common.bpelparser.iface.Process;
import oracle.tip.tools.ide.common.bpelparser.iface.Receive;
import oracle.tip.tools.ide.common.bpelparser.iface.Reply;
import oracle.tip.tools.ide.common.bpelparser.iface.Scope;
import oracle.tip.tools.ide.common.bpelparser.iface.Variable;
import oracle.tip.tools.ide.common.bpelparser.util.BPELModelUtil;
import oracle.tip.tools.ide.common.graph.GraphUtils;
import oracle.tip.tools.ide.common.ide.bpel.BPELProject;
import oracle.tip.tools.ide.common.ide.bpel.BPELProjectUtil;
import oracle.tip.tools.ide.common.ui.ImageColumnTableCellRenderer;
import oracle.tip.tools.ide.common.ui.ToolBar;
import oracle.tip.tools.ide.common.ui.UIHelper;
import oracle.tip.tools.ide.common.utils.DeploymentFile;
import oracle.tip.tools.ide.common.utils.WSDLUtil;
import oracle.tip.tools.ide.pm.addin.model.BPELXmlModel;
import oracle.tip.tools.ide.pm.addin.model.PropertyModel;
import oracle.tip.tools.ide.pm.bpelgraph.editors.CorrelationPropertyAliasCreationDialog;
import oracle.tip.tools.ide.pm.bpelgraph.editors.CorrelationSetPropertiesCreationTableModel;
import oracle.tip.tools.ide.pm.bpelgraph.editors.CorrelationSetPropertiesCreationTableObject;
import oracle.tip.tools.ide.pm.bpelgraph.editors.PartnerLinkSelectionDialog;
import oracle.tip.tools.ide.pm.bpelgraph.model.BPELGraphModel;
import oracle.tip.tools.ide.pm.bpelgraph.views.BPELGraphPane;
import oracle.tip.tools.ide.pm.gui.dialogs.choosers.scope.ScopeChooser;
import oracle.tip.tools.ide.pm.i18n.BPELStringTranslator;
import oracle.tip.tools.ide.pm.resources.images.ImageCache;

public class CorrelationSetCreationPanel
extends JPanel
implements ActionListener,
ListSelectionListener {
    protected JTextField m_nameField;
    protected JTextField m_scopeField;
    protected JTable m_propsTable;
    protected JButton m_scopeBtn;
    protected JButton m_addBtn;
    protected JButton m_removeBtn;
    protected JButton m_editBtn;
    protected ToolBar m_toolBar;
    protected BPELGraphPane m_graph;
    protected CorrelationSet m_correlationSet;
    protected JCheckBox m_namespaceCB;
    protected Activity m_activity;
    protected Scope m_selScope;
    protected Scope m_origScope;
    protected String m_pattern = null;

    public CorrelationSetCreationPanel(BPELGraphPane graph, Activity activity) {
        this.m_graph = graph;
        this.m_activity = activity;
        BPELGraphModel graphModel = (BPELGraphModel)this.m_graph.getModel();
        this.m_selScope = graphModel.getProcess();
        this.createControls();
        this.layoutControls();
        this.updateButtons();
    }

    public void setCorrelationSet(CorrelationSet cs, String pattern) {
        Scope scope;
        this.m_pattern = pattern;
        this.m_correlationSet = cs;
        if (cs != null) {
            this.m_nameField.setText(cs.getName());
        }
        if ((scope = BPELModelUtil.getScopeForCorrelation((Activity)this.m_activity, (String)cs.getName())) != null) {
            this.m_scopeBtn.setEnabled(false);
            this.m_origScope = this.m_selScope = scope;
            this.m_scopeField.setText(scope.getName());
        }
        this.loadProperties();
    }

    public String getCorrelationSetName() {
        return this.m_nameField.getText().trim();
    }

    /*
     * WARNING - void declaration
     */
    protected void loadProperties() {
        URL plURL;
        BPELXmlModel mainModel = this.m_graph.getBPELXmlModel();
        BPELProject prj = mainModel.getBPELProject();
        PropertyModel propertyModel = mainModel.getPropertyModel();
        if (BPELProjectUtil.isEmptyBPELProcess((BPELProject)prj) && (plURL = CorrelationSetCreationPanel.findPartnerLinkForSaving(this.m_graph, this)) == null) {
            return;
        }
        List<Object> lst = null;
        List<CorrelationPropertyAlias> alst = null;
        try {
            lst = propertyModel.getProperties();
            alst = propertyModel.getPropertyAliases();
        }
        catch (Exception e) {
            GraphUtils.displayMessage((Component)this, (String)BPELStringTranslator.getString("EDITOR_COR_SET_PNL_CANT_READ_PTY"), (int)0);
        }
        Vector<CorrelationSetPropertiesCreationTableObject> v = new Vector<CorrelationSetPropertiesCreationTableObject>();
        QName[] props = this.m_correlationSet.getProperties();
        if (props != null) {
            block2: for (int i = 0; i < props.length; ++i) {
                List<QName> msgs;
                QName prop = props[i];
                String name1 = prop.getLocalPart();
                CorrelationPropertyAlias alias = null;
                CorrelationPropertyAlias alias2 = null;
                if (alst != null && (msgs = this.getMsgTypes()).size() > 0) {
                    void var14_17;
                    boolean bl = false;
                    while (var14_17 < msgs.size()) {
                        QName qname = msgs.get((int)var14_17);
                        if (qname != null) {
                            for (int j = 0; j < alst.size(); ++j) {
                                CorrelationPropertyAlias cp = alst.get(j);
                                if (cp.getPropertyName() == null || !prop.equals(cp.getPropertyName()) || (cp.getMessageType() == null || !cp.getMessageType().equals(qname)) && (cp.getElement() == null || !cp.getElement().equals(qname))) continue;
                                if (var14_17 == false) {
                                    alias = cp;
                                    break;
                                }
                                if (var14_17 != true) break;
                                alias2 = cp;
                                break;
                            }
                        }
                        ++var14_17;
                    }
                }
                for (CorrelationSetProperty correlationSetProperty : lst) {
                    if (!name1.equals(correlationSetProperty.getName())) continue;
                    CorrelationSetPropertiesCreationTableObject pdo = new CorrelationSetPropertiesCreationTableObject(correlationSetProperty, alias);
                    if (alias2 != null) {
                        pdo.m_propAlias2 = alias2;
                    }
                    v.addElement(pdo);
                    continue block2;
                }
            }
        }
        CorrelationSetPropertiesCreationTableModel model = (CorrelationSetPropertiesCreationTableModel)((Object)this.m_propsTable.getModel());
        model.setData(v);
        model.refresh();
    }

    public CorrelationSet getCorrelationSet() {
        return this.m_correlationSet;
    }

    public void saveToModel() {
        BPELGraphModel graphModel = (BPELGraphModel)this.m_graph.getModel();
        Process process = graphModel.getProcess();
        if (this.m_correlationSet == null) {
            this.m_correlationSet = (CorrelationSet)BPELParser.createImplementation(CorrelationSet.class);
        }
        this.m_correlationSet.setName(this.m_nameField.getText().trim());
        CorrelationSetPropertiesCreationTableModel model = (CorrelationSetPropertiesCreationTableModel)((Object)this.m_propsTable.getModel());
        Vector v = model.getData();
        HashSet<QName> tmp = new HashSet<QName>();
        for (int i = 0; i < v.size(); ++i) {
            CorrelationSetPropertiesCreationTableObject obj = (CorrelationSetPropertiesCreationTableObject)v.elementAt(i);
            String ns = obj.m_prop.getTargetNamespace();
            String prefix = null;
            if (ns != null) {
                prefix = process.addNamespace(ns);
            }
            String name = obj.m_prop.getName();
            QName q = new QName(ns, name, prefix);
            tmp.add(q);
        }
        QName[] propQNames = new QName[tmp.size()];
        tmp.toArray(propQNames);
        this.m_correlationSet.setProperties(propQNames);
        if (this.m_origScope == null) {
            this.m_selScope.addCorrelationSet(this.m_correlationSet);
        }
    }

    protected void createControls() {
        this.m_namespaceCB = new JCheckBox(BPELStringTranslator.getString("EDITOR_COR_EDIT_PGE_SHOW_URI"), false);
        BPELStringTranslator.setButton(this.m_namespaceCB, BPELStringTranslator.getString("EDITOR_COR_EDIT_PGE_SHOW_URI_RES"));
        this.m_namespaceCB.addActionListener(this);
        this.m_addBtn = UIHelper.createModelerButton((String)BPELStringTranslator.getString("ADD_BUTTON_TEXT"), (Icon)ImageCache.getIcon("add16"));
        BPELStringTranslator.setButton(this.m_addBtn, BPELStringTranslator.getString("ADD_BUTTON_TEXT_RES_A"));
        this.m_addBtn.addActionListener(this);
        this.m_removeBtn = UIHelper.createModelerButton((String)BPELStringTranslator.getString("DEL_BUTTON_TEXT"), (Icon)ImageCache.getIcon("delete16"));
        BPELStringTranslator.setButton(this.m_removeBtn, BPELStringTranslator.getString("DEL_BUTTON_TEXT_RES_E"));
        this.m_removeBtn.addActionListener(this);
        this.m_editBtn = UIHelper.createModelerButton((String)BPELStringTranslator.getString("EDIT_BUTTON_TEXT"), (Icon)ImageCache.getIcon("edit16"));
        BPELStringTranslator.setButton(this.m_editBtn, BPELStringTranslator.getString("EDIT_BUTTON_TEXT_RES_T"));
        this.m_editBtn.addActionListener(this);
        this.m_scopeBtn = UIHelper.createBrowseButton((String)"Browse Scopes...");
        this.m_scopeBtn.addActionListener(this);
        this.m_nameField = new JTextField();
        this.m_scopeField = new JTextField();
        this.m_scopeField.setEnabled(false);
        CorrelationSetPropertiesCreationTableModel model = new CorrelationSetPropertiesCreationTableModel();
        model.showNamespaces(this.m_namespaceCB.isSelected());
        this.m_propsTable = new JTable((TableModel)((Object)model));
        this.m_propsTable.setSelectionMode(0);
        this.m_propsTable.getSelectionModel().addListSelectionListener(this);
        this.m_propsTable.getTableHeader().setReorderingAllowed(false);
        TableColumnModel colModel = this.m_propsTable.getColumnModel();
        for (int i = 0; i < colModel.getColumnCount(); ++i) {
            TableColumn col = colModel.getColumn(i);
            if (i == 0) {
                col.setMinWidth(30);
                col.setMaxWidth(30);
                col.setCellRenderer((TableCellRenderer)new ImageColumnTableCellRenderer(ImageCache.getIcon("property_node")));
            }
            col.setPreferredWidth(120);
        }
        this.m_propsTable.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                Point origin = e.getPoint();
                int row = CorrelationSetCreationPanel.this.m_propsTable.rowAtPoint(origin);
                int column = CorrelationSetCreationPanel.this.m_propsTable.columnAtPoint(origin);
                if (row == -1 || column == -1) {
                    return;
                }
                if (e.getClickCount() == 2) {
                    CorrelationSetCreationPanel.this.handleEdit();
                }
            }

            @Override
            public void mouseReleased(MouseEvent e) {
            }
        });
    }

    protected void layoutControls() {
        JLabel nameLbl = new JLabel();
        BPELStringTranslator.setLabel(nameLbl, this.m_nameField, BPELStringTranslator.getString("GENERAL_EDITOR_NAME"));
        ToolBar sBar = new ToolBar();
        sBar.add((Component)this.m_scopeBtn);
        JLabel slabel = new JLabel();
        BPELStringTranslator.setLabel(slabel, this.m_scopeField, "&Scope:");
        if (this.m_selScope != null) {
            this.m_scopeField.setText(this.m_selScope.getName());
        }
        JPanel btnPnl = new JPanel(new GridLayout(1, 2, 5, 0));
        btnPnl.add(this.m_addBtn);
        btnPnl.add(this.m_removeBtn);
        ToolBar toolBar = new ToolBar();
        toolBar.setBorderInsets(new Insets(0, 0, 0, 0));
        toolBar.add((Component)this.m_addBtn);
        toolBar.add((Component)this.m_editBtn);
        toolBar.add((Component)this.m_removeBtn);
        JPanel propsPnl = new JPanel(new GridBagLayout());
        propsPnl.setBorder(new TitledBorder(BPELStringTranslator.getString("EDITOR_COR_SET_PNL_PTY")));
        GraphUtils.addComponent((Container)propsPnl, (Component)toolBar, (int)0, (int)0, (int)1, (int)1, (int)13, (int)0, (Insets)new Insets(0, 5, 0, 5), (int)0, (int)0, (double)1.0, (double)0.0);
        GraphUtils.addComponent((Container)propsPnl, (Component)GraphUtils.getScrollPane((Component)this.m_propsTable), (int)0, (int)1, (int)1, (int)1, (int)17, (int)1, (Insets)new Insets(0, 5, 0, 5), (int)0, (int)0, (double)1.0, (double)1.0);
        GraphUtils.addComponent((Container)propsPnl, (Component)this.m_namespaceCB, (int)0, (int)2, (int)1, (int)1, (int)17, (int)0, (Insets)new Insets(2, 5, 0, 5), (int)0, (int)0, (double)1.0, (double)0.0);
        int row = 0;
        this.setLayout(new GridBagLayout());
        GraphUtils.addComponent((Container)this, (Component)nameLbl, (int)0, (int)row, (int)1, (int)1, (int)17, (int)0, (Insets)new Insets(5, 5, 5, 0), (int)0, (int)0, (double)0.0, (double)0.0);
        GraphUtils.addComponent((Container)this, (Component)this.m_nameField, (int)1, (int)row++, (int)2, (int)1, (int)17, (int)2, (Insets)new Insets(5, 5, 5, 5), (int)0, (int)0, (double)1.0, (double)0.0);
        GraphUtils.addComponent((Container)this, (Component)slabel, (int)0, (int)row, (int)1, (int)1, (int)17, (int)0, (Insets)new Insets(0, 5, 5, 0), (int)0, (int)0, (double)0.0, (double)0.0);
        GraphUtils.addComponent((Container)this, (Component)this.m_scopeField, (int)1, (int)row, (int)1, (int)1, (int)17, (int)2, (Insets)new Insets(0, 5, 5, 5), (int)0, (int)0, (double)1.0, (double)0.0);
        GraphUtils.addComponent((Container)this, (Component)sBar, (int)2, (int)row++, (int)1, (int)1, (int)17, (int)0, (Insets)new Insets(0, 0, 5, 5), (int)0, (int)0, (double)0.0, (double)0.0);
        GraphUtils.addComponent((Container)this, (Component)propsPnl, (int)0, (int)row, (int)3, (int)1, (int)17, (int)1, (Insets)new Insets(0, 5, 5, 5), (int)0, (int)0, (double)1.0, (double)1.0);
    }

    protected void handleAdd() {
        Object obj2;
        URL plURL;
        BPELProject prj = this.m_graph.getBPELProject();
        if (BPELProjectUtil.isEmptyBPELProcess((BPELProject)prj) && (plURL = CorrelationSetCreationPanel.findPartnerLinkForSaving(this.m_graph, this)) == null) {
            return;
        }
        CorrelationPropertyAliasCreationDialog dlg = new CorrelationPropertyAliasCreationDialog(GraphUtils.getFrame((Component)this), this.m_graph, this.m_activity);
        if (dlg.create() != 0) {
            return;
        }
        CorrelationSetProperty pro = dlg.getCorrelationSetProperty();
        CorrelationSetPropertiesCreationTableModel model = (CorrelationSetPropertiesCreationTableModel)((Object)this.m_propsTable.getModel());
        Vector v = model.getData();
        for (Object obj2 : v) {
            CorrelationSetPropertiesCreationTableObject tObj = (CorrelationSetPropertiesCreationTableObject)obj2;
            if (!tObj.m_prop.equals((Object)pro)) continue;
            GraphUtils.displayMessage((Component)GraphUtils.getFrame((Component)this), (String)BPELStringTranslator.getString("ERROR_PROP_EXISTS_IN_SET", "Property with same name already exists in correlation set!"), (int)1);
            return;
        }
        CorrelationPropertyAlias alias = dlg.getProperyAlias();
        if (alias != null) {
            ArrayList<CorrelationPropertyAlias> list = new ArrayList<CorrelationPropertyAlias>();
            list.add(alias);
            try {
                BPELProjectUtil.setPropertyAlias((BPELProject)prj, list, (Map)dlg.getAllNSNamespaces(), (Process)((BPELGraphModel)this.m_graph.getModel()).getProcess());
            }
            catch (Exception ex) {
                GraphUtils.displayMessage((Component)GraphUtils.getFrame((Component)this), (String)("ERROR:" + ex.getMessage()), (int)0);
            }
        }
        obj2 = new CorrelationSetPropertiesCreationTableObject(dlg.getCorrelationSetProperty(), alias);
        model.getData().addElement(obj2);
        model.refresh();
    }

    protected void handleEdit() {
        int[] rows = this.m_propsTable.getSelectedRows();
        if (rows == null || rows.length == 0) {
            return;
        }
        CorrelationSetPropertiesCreationTableModel model = (CorrelationSetPropertiesCreationTableModel)((Object)this.m_propsTable.getModel());
        CorrelationSetPropertiesCreationTableObject obj = (CorrelationSetPropertiesCreationTableObject)model.getRowData(rows[0]);
        CorrelationPropertyAliasCreationDialog dlg = new CorrelationPropertyAliasCreationDialog(GraphUtils.getFrame((Component)this), this.m_graph, this.m_activity);
        CorrelationPropertyAlias cpalias = new CorrelationPropertyAlias();
        int ret = -1;
        CorrelationPropertyAlias aliasOld = obj.m_propAlias;
        if (this.m_activity instanceof Invoke && this.m_pattern.equals("out-in") && (ret = JOptionPane.showOptionDialog(this, "Do you want to edit the in (response) or out (request) property alias?", "Edit Property Alias", 0, -1, null, new Object[]{"in", "out"}, "in")) == 1) {
            aliasOld = obj.m_propAlias2;
        }
        if (aliasOld != null) {
            cpalias.setMessageType(aliasOld.getMessageType());
            cpalias.setElement(aliasOld.getElement());
            cpalias.setPart(aliasOld.getPart());
            cpalias.setPropertyName(aliasOld.getPropertyName());
            cpalias.setQuery(aliasOld.getQuery());
        }
        if (dlg.edit(obj.m_prop, aliasOld) != 0) {
            return;
        }
        CorrelationPropertyAlias alias = dlg.getCorrelationPropertyAlias();
        CorrelationSetProperty prop = dlg.getCorrelationSetProperty();
        if (alias != null && prop != null) {
            BPELProject prj = this.m_graph.getBPELProject();
            ArrayList<CorrelationPropertyAlias> list = new ArrayList<CorrelationPropertyAlias>();
            list.add(alias);
            try {
                BPELXmlModel mainModel = this.m_graph.getBPELXmlModel();
                PropertyModel propertyModel = mainModel.getPropertyModel();
                if (!alias.equals((Object)cpalias)) {
                    propertyModel.deletePropertyAlias(cpalias);
                    BPELProjectUtil.setPropertyAlias((BPELProject)prj, list, (Map)dlg.getAllNSNamespaces(), (Process)((BPELGraphModel)this.m_graph.getModel()).getProcess());
                }
                propertyModel.saveProperty(prop);
            }
            catch (Exception ex) {
                GraphUtils.displayMessage((Component)GraphUtils.getFrame((Component)this), (String)("ERROR:" + ex.getMessage()), (int)0);
            }
        }
        obj.m_prop = prop;
        if (ret == 1) {
            obj.m_propAlias2 = alias;
        } else {
            obj.m_propAlias = alias;
        }
        model.refresh();
    }

    protected void removeProps() {
        int[] rows = this.m_propsTable.getSelectedRows();
        if (rows == null || rows.length == 0) {
            return;
        }
        boolean bDelete = this.confirmDelete(BPELStringTranslator.formatString("DELETE_GENERIC_TITLE", BPELStringTranslator.getString("PROPERTY_KEY_DELETE")), BPELStringTranslator.formatString("DELETE_GENERIC_MESSAGE", BPELStringTranslator.getString("PROPERTY_KEY_DELETE")));
        CorrelationSetPropertiesCreationTableModel model = (CorrelationSetPropertiesCreationTableModel)((Object)this.m_propsTable.getModel());
        if (!bDelete) {
            CorrelationSetPropertiesCreationTableObject obj = (CorrelationSetPropertiesCreationTableObject)model.getRowData(0);
            CorrelationSetProperty p = obj.m_prop;
            try {
                BPELXmlModel mainModel = this.m_graph.getBPELXmlModel();
                PropertyModel propertyModel = mainModel.getPropertyModel();
                propertyModel.deleteProperty(p.getName());
                propertyModel.deletePropertyAlias(obj.m_propAlias);
                if (obj.m_propAlias2 != null) {
                    propertyModel.deletePropertyAlias(obj.m_propAlias2);
                }
            }
            catch (Exception e) {
                GraphUtils.displayMessage((Component)GraphUtils.getFrame((Component)this), (String)BPELStringTranslator.formatString("ERROR", e.getMessage()), (int)0);
            }
        }
        model.removeRows(rows);
    }

    protected boolean confirmDelete(String title, String msg) {
        if (this.m_graph.getSettings().m_bConfirmDeletions) {
            return GraphUtils.showConfirmDialog((Component)GraphUtils.getFrame((Component)this), (String)msg, (String)title) == 0;
        }
        return true;
    }

    protected void handleBrowseScope() {
        ScopeChooser s = new ScopeChooser(GraphUtils.getFrame((Component)this), this.m_graph, this.m_activity);
        if (s.display() == 0) {
            this.m_selScope = s.getSelectedScope();
            this.m_scopeField.setText(this.m_selScope.getName());
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Object src = e.getSource();
        if (src == this.m_addBtn) {
            this.handleAdd();
        } else if (src == this.m_editBtn) {
            this.handleEdit();
        } else if (src == this.m_removeBtn) {
            this.removeProps();
        } else if (src == this.m_namespaceCB) {
            CorrelationSetPropertiesCreationTableModel model = (CorrelationSetPropertiesCreationTableModel)((Object)this.m_propsTable.getModel());
            model.showNamespaces(this.m_namespaceCB.isSelected());
        } else if (src == this.m_scopeBtn) {
            this.handleBrowseScope();
        }
    }

    protected void updateButtons() {
        this.m_addBtn.setEnabled(true);
        int numSelectedRows = this.m_propsTable.getSelectedRowCount();
        if (numSelectedRows > 0) {
            this.m_removeBtn.setEnabled(true);
            this.m_editBtn.setEnabled(true);
        } else {
            this.m_removeBtn.setEnabled(false);
            this.m_editBtn.setEnabled(false);
        }
    }

    @Override
    public void valueChanged(ListSelectionEvent e) {
        this.updateButtons();
    }

    public static URL findPartnerLinkForSaving(BPELGraphPane graph, JComponent comp) {
        BPELGraphModel graphModel;
        Process process;
        Map map;
        BPELProject prj = graph.getBPELProject();
        URL url = prj.getWSDLFileURL(prj.getProcessName());
        if (Helper.exists((URL)url)) {
            return url;
        }
        String s = (String)prj.getProjectData("PropertyPL");
        if (s != null) {
            try {
                url = new URL(s);
                if (URLFileSystem.exists((URL)url)) {
                    return url;
                }
            }
            catch (Exception ex) {
                // empty catch block
            }
        }
        if ((map = BPELModelerUtil.getWSDLURIsForPartnerLinks((Process)(process = (graphModel = (BPELGraphModel)graph.getModel()).getProcess()), (DeploymentFile)prj.getDeploymentFile())) == null) {
            if (GraphUtils.showConfirmDialog((Component)GraphUtils.getFrame((Component)comp), (String)"You must have a WSDL file to save the change.\nDo you want to create a new WSDL file?", (String)"No WSDL File Found For This Process") == 0) {
                url = WSDLUtil.getWSDLFileForEmptyProcess((BPELProject)prj);
                prj.storeProjectData("PropertyPL", (Object)url.toString());
                return url;
            }
            return null;
        }
        URL projURL = prj.getProjectURL();
        Object[] objs = map.keySet().toArray();
        for (int i = 0; i < objs.length; ++i) {
            try {
                Object name = objs[i];
                URI u = (URI)map.get(name);
                if (URLFileSystem.isBaseURLFor((URL)projURL, (URL)u.toURL())) continue;
                map.remove(name);
                continue;
            }
            catch (Exception ex) {
                // empty catch block
            }
        }
        if (map.size() == 0) {
            if (GraphUtils.showConfirmDialog((Component)GraphUtils.getFrame((Component)comp), (String)"You must have a WSDL file to save the change.\nDo you want to create a new WSDL file?", (String)"No WSDL File Found For This Process") == 0) {
                url = WSDLUtil.getWSDLFileForEmptyProcess((BPELProject)prj);
                prj.storeProjectData("PropertyPL", (Object)url.toString());
                return url;
            }
            return null;
        }
        if (map.size() == 1) {
            URI uri = (URI)map.values().iterator().next();
            try {
                url = uri.toURL();
            }
            catch (Exception ex) {
                GraphUtils.displayMessage((Component)GraphUtils.getFrame((Component)comp), (String)"Invalid URL for the selected partner link.", (int)0);
            }
        } else {
            PartnerLinkSelectionDialog dlg = new PartnerLinkSelectionDialog(GraphUtils.getFrame((Component)comp), map, 1);
            if (dlg.select() == 0) {
                url = dlg.getSelectedPartnerLinkURL();
            }
        }
        if (url != null) {
            prj.storeProjectData("PropertyPL", (Object)url.toString());
            try {
                prj.save();
            }
            catch (Exception ex) {
                // empty catch block
            }
        }
        return url;
    }

    private List<QName> getMsgTypes() {
        Variable v;
        ArrayList<QName> msgTypes = new ArrayList<QName>();
        String varName = null;
        String varName2 = null;
        if (this.m_activity instanceof Invoke) {
            if (this.m_pattern == null || this.m_pattern.equals("out")) {
                varName = ((Invoke)this.m_activity).getInputVariable();
            } else if (this.m_pattern.equals("in")) {
                varName = ((Invoke)this.m_activity).getOutputVariable();
            } else {
                varName = ((Invoke)this.m_activity).getOutputVariable();
                varName2 = ((Invoke)this.m_activity).getInputVariable();
            }
        } else if (this.m_activity instanceof OnMessage) {
            varName = ((OnMessage)this.m_activity).getVariable();
        } else if (this.m_activity instanceof Receive) {
            varName = ((Receive)this.m_activity).getVariable();
        } else if (this.m_activity instanceof Reply) {
            varName = ((Reply)this.m_activity).getVariable();
        }
        BPELGraphModel graphModel = (BPELGraphModel)this.m_graph.getModel();
        QName msgType = null;
        if (varName != null && (v = BPELModelUtil.getVariableForName((Process)graphModel.getProcess(), (String)varName, (boolean)true)) != null) {
            msgType = v.getMessageType();
            if (msgType == null) {
                msgType = v.getElement();
            }
            if (msgType == null) {
                msgType = v.getType();
            }
            if (msgType != null || this.m_pattern.equals("out-in")) {
                msgTypes.add(msgType);
            }
        }
        if (varName2 != null && (v = BPELModelUtil.getVariableForName((Process)graphModel.getProcess(), (String)varName2, (boolean)true)) != null) {
            QName msgType2 = v.getMessageType();
            if (msgType2 == null) {
                msgType2 = v.getElement();
            }
            if (msgType2 == null) {
                msgType2 = v.getType();
            }
            if (this.m_pattern.equals("out-in")) {
                msgTypes.add(msgType2);
            }
        }
        return msgTypes;
    }
}

