/*
 * Decompiled with CFR 0.152.
 */
package oracle.tip.tools.ide.pm.bpelgraph.editors;

import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JPanel;
import oracle.tip.tools.ide.common.bpelparser.BPELParser;
import oracle.tip.tools.ide.common.bpelparser.iface.Activity;
import oracle.tip.tools.ide.common.bpelparser.iface.CorrelationSet;
import oracle.tip.tools.ide.common.bpelparser.iface.Process;
import oracle.tip.tools.ide.common.bpelparser.util.BPELModelUtil;
import oracle.tip.tools.ide.common.graph.GraphUtils;
import oracle.tip.tools.ide.pm.bpelgraph.editors.CorrelationSetCreationPanel;
import oracle.tip.tools.ide.pm.bpelgraph.model.BPELGraphModel;
import oracle.tip.tools.ide.pm.bpelgraph.views.BPELGraphPane;
import oracle.tip.tools.ide.pm.gui.generalpurpose.BPELBaseDialog;
import oracle.tip.tools.ide.pm.i18n.BPELStringTranslator;

public class CorrelationSetCreationDialog
extends BPELBaseDialog
implements ActionListener {
    public static final int OK = 0;
    public static final int CANCEL = 1;
    private JButton m_okBtn;
    private JButton m_cancelBtn;
    private JButton m_helpBtn;
    protected CorrelationSetCreationPanel m_setPanel;
    protected BPELGraphPane m_graph;
    protected int m_retVal = 1;
    protected Activity m_activity;
    protected boolean m_bCreating = false;
    protected List m_csNameFilter;

    public CorrelationSetCreationDialog(JFrame f, BPELGraphPane graph, Activity activity) {
        super(f, BPELStringTranslator.getString("EDITOR_COR_SET_DLG"), true);
        this.m_graph = graph;
        this.m_activity = activity;
        this.createAndLayoutControls();
    }

    public CorrelationSet getCorrelationSet() {
        return this.m_setPanel.getCorrelationSet();
    }

    public int create(List csNameFilter) {
        this.m_csNameFilter = csNameFilter;
        this.m_bCreating = true;
        BPELGraphModel model = (BPELGraphModel)this.m_graph.getModel();
        Process p = model.getProcess();
        this.setTitle(BPELStringTranslator.getString("EDITOR_COR_SET_DLG_CREATE"));
        CorrelationSet cs = (CorrelationSet)BPELParser.createImplementation(CorrelationSet.class);
        String csname = BPELModelUtil.generateUniqueName((Process)p, (String)BPELStringTranslator.getString("EDITOR_COR_SET_DLG_INIT_NAME"), CorrelationSet.class);
        List nameLst = this.getNames(csNameFilter);
        if (this.doesNameExist(csNameFilter, csname)) {
            cs.setName(BPELModelUtil.createUniqueName((String)BPELStringTranslator.getString("EDITOR_COR_SET_DLG_INIT_NAME"), (String)csname, (List)nameLst));
        } else {
            cs.setName(csname);
        }
        this.m_setPanel.setCorrelationSet(cs, null);
        return this.display();
    }

    protected List getNames(List csname) {
        ArrayList<String> nameLst = new ArrayList<String>();
        if (csname != null) {
            for (CorrelationSet obj : csname) {
                nameLst.add(obj.getName());
            }
        }
        return nameLst;
    }

    protected boolean doesNameExist(List csname, String name) {
        if (csname != null) {
            for (CorrelationSet obj : csname) {
                if (obj.getName() == null || !obj.getName().equals(name)) continue;
                return true;
            }
        }
        return false;
    }

    public int edit(CorrelationSet cs, List csNameFilter, String pattern) {
        this.m_csNameFilter = csNameFilter;
        this.m_bCreating = false;
        this.setTitle(BPELStringTranslator.getString("EDITOR_COR_SET_DLG_EDIT") + cs.getName());
        this.m_setPanel.setCorrelationSet(cs, pattern);
        return this.display();
    }

    public int display() {
        this.setVisible(true);
        return this.m_retVal;
    }

    protected boolean isValidData() {
        String name = this.m_setPanel.getCorrelationSetName();
        if (name == null || name.trim().length() == 0) {
            GraphUtils.displayMessage((Component)GraphUtils.getFrame((Component)((Object)this)), (String)BPELStringTranslator.getString("EDITOR_INVALID_NAME"));
            return false;
        }
        if (this.m_bCreating) {
            if (!BPELModelUtil.isUniqueCorrelationSetName((List)this.m_csNameFilter, (String)name.trim())) {
                GraphUtils.displayMessage((Component)GraphUtils.getFrame((Component)((Object)this)), (String)BPELStringTranslator.getString("EDITOR_COR_CRE_DLG_COR_EXIST"));
                return false;
            }
        } else {
            String origName = this.m_setPanel.getCorrelationSet().getName();
            String newName = this.m_setPanel.getCorrelationSetName();
            if (newName == null || newName.length() == 0) {
                return false;
            }
            if (newName.equalsIgnoreCase(origName)) {
                return true;
            }
            if (!BPELModelUtil.isUniqueCorrelationSetName((List)this.m_csNameFilter, (String)newName)) {
                GraphUtils.displayMessage((Component)GraphUtils.getFrame((Component)((Object)this)), (String)BPELStringTranslator.getString("EDITOR_COR_CRE_DLG_COR_EXIST"));
                return false;
            }
        }
        return true;
    }

    protected void saveChanges() {
        this.m_setPanel.saveToModel();
    }

    protected void createAndLayoutControls() {
        this.m_setPanel = new CorrelationSetCreationPanel(this.m_graph, this.m_activity);
        this.m_okBtn = new JButton();
        BPELStringTranslator.setButton(this.m_okBtn, BPELStringTranslator.getString("OK_BUTTON_TEXT_RES"));
        this.m_okBtn.addActionListener(this);
        this.m_cancelBtn = new JButton();
        BPELStringTranslator.setButton(this.m_cancelBtn, BPELStringTranslator.getString("CANCEL_BUTTON_TEXT_RES"));
        this.m_cancelBtn.addActionListener(this);
        this.m_helpBtn = new JButton();
        BPELStringTranslator.setButton(this.m_helpBtn, BPELStringTranslator.getString("HELP_BUTTON_TEXT_RES"));
        this.m_helpBtn.addActionListener(this);
        JPanel btnPnl = new JPanel(new GridLayout(1, 2, 5, 0));
        btnPnl.add(this.m_okBtn);
        btnPnl.add(this.m_cancelBtn);
        Container c = this.getContentPane();
        c.setLayout(new GridBagLayout());
        int row = 0;
        GraphUtils.addComponent((Container)c, (Component)this.m_setPanel, (int)0, (int)row++, (int)2, (int)1, (int)17, (int)1, (Insets)new Insets(5, 5, 0, 5), (int)0, (int)0, (double)1.0, (double)1.0);
        GraphUtils.addComponent((Container)c, (Component)this.m_helpBtn, (int)0, (int)row, (int)1, (int)1, (int)17, (int)0, (Insets)new Insets(0, 10, 10, 10), (int)0, (int)0, (double)1.0, (double)0.0);
        GraphUtils.addComponent((Container)c, (Component)btnPnl, (int)1, (int)row++, (int)1, (int)1, (int)13, (int)0, (Insets)new Insets(0, 0, 10, 10), (int)0, (int)0, (double)1.0, (double)0.0);
        this.setSize(480, 380);
        this.setLocationRelativeTo(this.getParent());
    }

    protected void handleCancel() {
        this.m_retVal = 1;
        this.dispose();
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Object src = e.getSource();
        if (src == this.m_okBtn) {
            if (!this.isValidData()) {
                return;
            }
            this.saveChanges();
            this.m_retVal = 0;
            this.dispose();
        } else if (src == this.m_cancelBtn) {
            this.handleCancel();
        } else if (src == this.m_helpBtn) {
            this.helpInvoked();
        }
    }

    protected void helpInvoked() {
        this.handleHelp(this.m_setPanel);
    }
}

