/*
 * Decompiled with CFR 0.152.
 */
package oracle.tip.tools.ide.pm.bpelgraph.editors;

import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultComboBoxModel;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.wsdl.Definition;
import javax.xml.namespace.QName;
import oracle.tip.tools.ide.common.bpeldesigner.models.bpel.CorrelationPropertyAlias;
import oracle.tip.tools.ide.common.bpeldesigner.models.bpel.CorrelationSetProperty;
import oracle.tip.tools.ide.common.bpeldesigner.util.WSDLPropertyUtil;
import oracle.tip.tools.ide.common.graph.GraphUtils;
import oracle.tip.tools.ide.common.ide.bpel.BPELProject;
import oracle.tip.tools.ide.common.ide.bpel.BPELProjectUtil;
import oracle.tip.tools.ide.common.ui.CardPanel;
import oracle.tip.tools.ide.common.ui.ComponentBorderPane;
import oracle.tip.tools.ide.common.ui.ToolBar;
import oracle.tip.tools.ide.common.ui.UIHelper;
import oracle.tip.tools.ide.common.utils.NamespaceResolver;
import oracle.tip.tools.ide.common.utils.WSDLUtil;
import oracle.tip.tools.ide.pm.addin.model.WSDLModel;
import oracle.tip.tools.ide.pm.bpelgraph.editors.CorrelationPropertyAliasMessageTypePanel;
import oracle.tip.tools.ide.pm.bpelgraph.editors.CorrelationSetCreationPanel;
import oracle.tip.tools.ide.pm.bpelgraph.editors.CorrelationSetPropertyDialog;
import oracle.tip.tools.ide.pm.bpelgraph.editors.CorrelationSetPropertyListItem;
import oracle.tip.tools.ide.pm.bpelgraph.editors.InteractionActivityPluginListCellRenderer;
import oracle.tip.tools.ide.pm.bpelgraph.editors.InteractionPropAliasPluginListItem;
import oracle.tip.tools.ide.pm.bpelgraph.editors.PropertyAliasNamespaceResolver;
import oracle.tip.tools.ide.pm.bpelgraph.views.BPELGraphPane;
import oracle.tip.tools.ide.pm.gui.generalpurpose.GenericListCellRenderer;
import oracle.tip.tools.ide.pm.i18n.BPELStringTranslator;
import oracle.tip.tools.ide.pm.plugin.BPELModelerPlugin;
import oracle.tip.tools.ide.pm.plugin.BPELPlugInManager;
import oracle.tip.tools.ide.pm.plugin.interaction.CorrelationPropAliasEditor;
import oracle.tip.tools.ide.pm.plugin.interaction.InteractionActivityPlugin;
import oracle.tip.tools.ide.pm.resources.images.ImageCache;

public class CorrelationPropertyAliasPanel
extends JPanel
implements ActionListener,
PropertyChangeListener {
    public static final String PROPERTY_CHANGED = "PROPERTY_CHANGED";
    public static final String TYPE_CHANGED = "TYPE_CHANGED";
    private static final int MESSAGE_TYPE_INDEX = 0;
    private final String MESSAGE_TYPE_PANEL = "MESSAGE_TYPE_PANEL";
    protected JComboBox m_propertyNameCB;
    protected JButton m_createPropertyBtn;
    protected BPELGraphPane m_graph;
    protected CorrelationPropertyAlias m_alias;
    protected CardPanel m_cardPnl;
    protected CorrelationPropertyAliasMessageTypePanel m_messageTypePropAliasPnl;
    protected JComboBox m_interactionTypeCombo;

    public CorrelationPropertyAliasPanel(BPELGraphPane graph) {
        this.m_graph = graph;
        this.m_alias = new CorrelationPropertyAlias();
        this.createControls();
        this.layoutControls();
    }

    public boolean isDataValid() {
        InteractionPropAliasPluginListItem pluginItem;
        Object item = this.m_propertyNameCB.getSelectedItem();
        if (!(item instanceof CorrelationSetPropertyListItem)) {
            return false;
        }
        return !(this.m_interactionTypeCombo.getSelectedIndex() == 0 ? !this.m_messageTypePropAliasPnl.isDataValid() : !(pluginItem = (InteractionPropAliasPluginListItem)this.m_interactionTypeCombo.getSelectedItem()).getEditor().isValid());
    }

    public void setCorrelationPropertyAlias(CorrelationPropertyAlias alias) {
        this.m_alias = alias;
        ComboBoxModel m = this.m_interactionTypeCombo.getModel();
        InteractionPropAliasPluginListItem editingPlugin = null;
        for (int i = 0; i < m.getSize(); ++i) {
            InteractionPropAliasPluginListItem item = (InteractionPropAliasPluginListItem)m.getElementAt(i);
            InteractionActivityPlugin ip = item.getPlugin();
            if (!ip.isInterationForAlias(this.m_alias)) continue;
            editingPlugin = item;
        }
        if (editingPlugin != null) {
            m.setSelectedItem(editingPlugin);
        } else {
            this.m_interactionTypeCombo.setSelectedIndex(0);
        }
    }

    public CorrelationPropertyAlias getCorrelationPropertyAlias() {
        return this.m_alias;
    }

    public void saveCorrelationPropertyAlias() {
        CorrelationSetPropertyListItem item = (CorrelationSetPropertyListItem)this.m_propertyNameCB.getSelectedItem();
        CorrelationSetProperty property = item.getProperty();
        QName propertyQName = new QName(property.getTargetNamespace(), property.getName());
        this.m_alias.setPropertyName(propertyQName);
        if (this.m_interactionTypeCombo.getSelectedIndex() == 0) {
            this.m_messageTypePropAliasPnl.saveCorrelationPropertyAlias();
        } else {
            InteractionPropAliasPluginListItem pluginItem = (InteractionPropAliasPluginListItem)this.m_interactionTypeCombo.getSelectedItem();
            pluginItem.getEditor().save();
        }
    }

    public void loadControls() {
        this.loadProperties();
    }

    protected void preSelectData() {
        if (this.m_alias == null) {
            return;
        }
        QName propertyQName = this.m_alias.getPropertyName();
        String name = propertyQName.getLocalPart();
        DefaultComboBoxModel model = (DefaultComboBoxModel)this.m_propertyNameCB.getModel();
        for (int i = 0; i < model.getSize(); ++i) {
            CorrelationSetPropertyListItem item = (CorrelationSetPropertyListItem)model.getElementAt(i);
            CorrelationSetProperty p = item.getProperty();
            if (!p.getName().equals(name)) continue;
            model.setSelectedItem(item);
            break;
        }
    }

    public void loadProperties() {
        try {
            ArrayList<CorrelationSetPropertyListItem> itemLst = new ArrayList<CorrelationSetPropertyListItem>();
            List lst = WSDLPropertyUtil.getBPELProperties((BPELProject)this.m_graph.getBPELProject());
            for (CorrelationSetProperty p : lst) {
                itemLst.add(new CorrelationSetPropertyListItem(p));
            }
            final DefaultComboBoxModel<CorrelationSetPropertyListItem> model = new DefaultComboBoxModel<CorrelationSetPropertyListItem>(itemLst.toArray(new CorrelationSetPropertyListItem[0]));
            if (SwingUtilities.isEventDispatchThread()) {
                this.m_propertyNameCB.setModel(model);
            } else {
                Runnable r = new Runnable(){

                    @Override
                    public void run() {
                        CorrelationPropertyAliasPanel.this.m_propertyNameCB.setModel(model);
                    }
                };
                SwingUtilities.invokeLater(r);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            GraphUtils.displayMessage((Component)GraphUtils.getFrame((Component)this), (String)BPELStringTranslator.getString("EDITOR_COR_PTY_ALS_PNL_ERR_LOAD"));
        }
    }

    protected void createControls() {
        this.m_cardPnl = new CardPanel();
        this.m_interactionTypeCombo = new JComboBox();
        this.m_interactionTypeCombo.addActionListener(this);
        this.m_interactionTypeCombo.setRenderer(new InteractionActivityPluginListCellRenderer());
        this.m_messageTypePropAliasPnl = new CorrelationPropertyAliasMessageTypePanel(this.m_alias, this.m_graph);
        this.m_messageTypePropAliasPnl.addPropertyChangeListener(this);
        this.m_cardPnl.add("MESSAGE_TYPE_PANEL", (Component)this.m_messageTypePropAliasPnl);
        this.m_cardPnl.show("MESSAGE_TYPE_PANEL");
        this.m_createPropertyBtn = UIHelper.createModelerButton((Icon)ImageCache.getIcon("create16"));
        this.m_createPropertyBtn.setToolTipText(BPELStringTranslator.getString("EDITOR_COR_PTY_ALS_PNL_CRT_PTY"));
        this.m_createPropertyBtn.addActionListener(this);
        this.m_propertyNameCB = new JComboBox();
        this.m_propertyNameCB.addActionListener(this);
        this.m_propertyNameCB.setRenderer(new GenericListCellRenderer(ImageCache.getIcon("property_node")));
        DefaultComboBoxModel<Object> m = new DefaultComboBoxModel<Object>();
        m.insertElementAt(BPELStringTranslator.getString("MESSAGE_TYPE"), 0);
        for (BPELModelerPlugin plugin : BPELPlugInManager.getPlugins()) {
            InteractionActivityPlugin ip = plugin.getInteractionActivityPlugin();
            if (ip == null) continue;
            InteractionPropAliasPluginListItem item = new InteractionPropAliasPluginListItem(ip);
            m.addElement(item);
            CorrelationPropAliasEditor editor = ip.createPropAliasEditor(this.m_alias, this.m_graph);
            item.setEditor(editor);
            JComponent comp = editor.getEditorComponent();
            this.m_cardPnl.add(ip.getName(), (Component)comp);
        }
        this.m_interactionTypeCombo.setModel(m);
        this.m_interactionTypeCombo.setSelectedIndex(0);
        this.m_messageTypePropAliasPnl.loadControls();
    }

    protected void layoutControls() {
        this.setLayout(new GridBagLayout());
        ToolBar tb = new ToolBar();
        tb.setBorderInsets(new Insets(0, 0, 0, 0));
        tb.add((Component)this.m_createPropertyBtn);
        JLabel propLbl = new JLabel();
        BPELStringTranslator.setLabel(propLbl, this.m_propertyNameCB, BPELStringTranslator.getString("EDITOR_COR_PTY_ALS_PNL_PTY"));
        int row = 0;
        GraphUtils.addComponent((Container)this, (Component)propLbl, (int)0, (int)row, (int)1, (int)1, (int)17, (int)0, (Insets)new Insets(10, 10, 0, 0), (int)0, (int)0, (double)0.0, (double)0.0);
        GraphUtils.addComponent((Container)this, (Component)this.m_propertyNameCB, (int)1, (int)row, (int)1, (int)1, (int)17, (int)2, (Insets)new Insets(10, 5, 0, 5), (int)0, (int)0, (double)1.0, (double)0.0);
        GraphUtils.addComponent((Container)this, (Component)tb, (int)2, (int)row++, (int)1, (int)1, (int)17, (int)0, (Insets)new Insets(10, 0, 0, 10), (int)0, (int)0, (double)0.0, (double)0.0);
        JPanel p = new JPanel(new GridBagLayout());
        JLabel l = new JLabel();
        BPELStringTranslator.setLabel(l, this.m_interactionTypeCombo, BPELStringTranslator.getString("INTERACTION_TYPE_LBL"));
        GraphUtils.addComponent((Container)p, (Component)l, (int)0, (int)0, (int)1, (int)1, (int)17, (int)0, (Insets)new Insets(5, 5, 5, 5), (int)0, (int)0, (double)0.0, (double)0.0);
        GraphUtils.addComponent((Container)p, (Component)this.m_interactionTypeCombo, (int)1, (int)0, (int)1, (int)1, (int)17, (int)2, (Insets)new Insets(5, 0, 5, 5), (int)0, (int)0, (double)1.0, (double)0.0);
        ComponentBorderPane borderPane = new ComponentBorderPane((JComponent)p, (JComponent)this.m_cardPnl);
        GraphUtils.addComponent((Container)this, (Component)borderPane, (int)0, (int)row, (int)3, (int)1, (int)17, (int)1, (Insets)new Insets(5, 5, 5, 5), (int)0, (int)0, (double)1.0, (double)1.0);
    }

    protected void handleCreateProperty() {
        CorrelationSetProperty p;
        CorrelationSetPropertyDialog dlg = new CorrelationSetPropertyDialog(GraphUtils.getFrame((Component)this), this.m_graph);
        if (dlg.create() == 0 && (p = dlg.getCorrelationSetProperty()) != null) {
            ArrayList<CorrelationSetProperty> lst = new ArrayList<CorrelationSetProperty>();
            lst.add(p);
            try {
                WSDLPropertyUtil.setProperty((BPELProject)this.m_graph.getBPELProject(), lst);
                CorrelationSetPropertyListItem item = new CorrelationSetPropertyListItem(p);
                DefaultComboBoxModel model = (DefaultComboBoxModel)this.m_propertyNameCB.getModel();
                model.addElement(item);
                model.setSelectedItem(item);
            }
            catch (Exception e) {
                GraphUtils.displayMessage((Component)GraphUtils.getFrame((Component)this), (String)("ERROR:" + e.getMessage()), (int)0);
            }
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Object src = e.getSource();
        if (src == this.m_propertyNameCB) {
            this.firePropertyChange(PROPERTY_CHANGED, null, this.m_propertyNameCB.getSelectedItem());
        } else if (src == this.m_createPropertyBtn) {
            this.handleCreateProperty();
        } else if (src == this.m_interactionTypeCombo) {
            this.handleInteractionTypeSelection();
        }
    }

    protected void handleInteractionTypeSelection() {
        InteractionPropAliasPluginListItem item = this.getSelectedPlugin();
        if (item != null) {
            this.m_cardPnl.show(item.getPlugin().getName());
        } else if (this.m_interactionTypeCombo.getSelectedIndex() == 0) {
            this.m_cardPnl.show("MESSAGE_TYPE_PANEL");
        }
    }

    protected InteractionPropAliasPluginListItem getSelectedPlugin() {
        Object item = this.m_interactionTypeCombo.getSelectedItem();
        if (item instanceof InteractionPropAliasPluginListItem) {
            return (InteractionPropAliasPluginListItem)item;
        }
        return null;
    }

    public Map getNamespacesMap() {
        return this.m_alias.getNamespaceMap();
    }

    public static Map resolveNamespaceMapFromPLWSDL(BPELGraphPane graph, JComponent comp) {
        Map map = null;
        BPELProject prj = graph.getBPELProject();
        try {
            if (BPELProjectUtil.isEmptyBPELProcess((BPELProject)prj)) {
                URL wURL = null;
                String w = (String)prj.getProjectData("PropertyPL");
                wURL = w != null ? new URL(w) : CorrelationSetCreationPanel.findPartnerLinkForSaving(graph, comp);
                Definition def = WSDLUtil.parseWSDL((URL)wURL);
                map = def.getNamespaces();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return map;
    }

    public static NamespaceResolver getNSResolver(BPELGraphPane graph, JComponent comp) {
        PropertyAliasNamespaceResolver nsResolver = new PropertyAliasNamespaceResolver();
        WSDLModel wsdlModel = graph.getBPELXmlModel().getWSDLModel();
        Map map = wsdlModel.getNamespaceMapFromWSDL();
        if (map == null) {
            map = CorrelationPropertyAliasPanel.resolveNamespaceMapFromPLWSDL(graph, comp);
        }
        if (map == null) {
            return nsResolver;
        }
        Object[] keys = map.keySet().toArray();
        if (keys != null) {
            for (int i = 0; i < keys.length; ++i) {
                nsResolver.addNSEntry((String)keys[i], (String)map.get(keys[i]));
            }
        }
        return nsResolver;
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        this.firePropertyChange(TYPE_CHANGED, null, evt);
        Object src = evt.getSource();
        if (src == this.m_messageTypePropAliasPnl) {
            this.firePropertyChange(TYPE_CHANGED, null, evt);
        }
    }
}

