/*
 * Decompiled with CFR 0.152.
 */
package oracle.tip.tools.ide.pm.bpelgraph.editors;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseMotionAdapter;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.net.URL;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRootPane;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.xml.namespace.QName;
import oracle.tip.tools.ide.common.bpeldesigner.caches.VariableDocumentCache;
import oracle.tip.tools.ide.common.bpeldesigner.models.bpel.CorrelationPropertyAlias;
import oracle.tip.tools.ide.common.bpeldesigner.models.schema.BpelNSResolver;
import oracle.tip.tools.ide.common.bpeldesigner.models.schema.NSResolverFactory;
import oracle.tip.tools.ide.common.bpeldesigner.models.schema.ResolvedDocumentCacheKey;
import oracle.tip.tools.ide.common.bpeldesigner.models.schema.ResolvedDocumentObj;
import oracle.tip.tools.ide.common.bpeldesigner.models.schema.SchemaResolvedObj;
import oracle.tip.tools.ide.common.graph.GraphUtils;
import oracle.tip.tools.ide.common.ide.IDEProject;
import oracle.tip.tools.ide.common.typeexplorer.DefaultWSDLImportHandler;
import oracle.tip.tools.ide.common.typeexplorer.MessagePartInfo;
import oracle.tip.tools.ide.common.typeexplorer.TypeExplorer;
import oracle.tip.tools.ide.common.typeexplorer.TypeObject;
import oracle.tip.tools.ide.common.typeexplorer.WSDLImportHandler;
import oracle.tip.tools.ide.common.ui.GlobalImageCache;
import oracle.tip.tools.ide.common.ui.ToolBar;
import oracle.tip.tools.ide.common.ui.UIHelper;
import oracle.tip.tools.ide.common.ui.treeexplorer.DefaultTreeExplorerTreeNode;
import oracle.tip.tools.ide.common.ui.treeexplorer.NodeText;
import oracle.tip.tools.ide.common.ui.treeexplorer.TextInfo;
import oracle.tip.tools.ide.common.ui.treeexplorer.TreeExplorerDataSource;
import oracle.tip.tools.ide.common.utils.NamespaceResolver;
import oracle.tip.tools.ide.common.utils.WSDLPartData;
import oracle.tip.tools.ide.common.xpath.editor.XPathEditorPane;
import oracle.tip.tools.ide.common.xsdgrammar.MapperNSResolver;
import oracle.tip.tools.ide.pm.addin.model.WSDLModel;
import oracle.tip.tools.ide.pm.bpelgraph.editors.CorrelationPropertyAliasPanel;
import oracle.tip.tools.ide.pm.bpelgraph.editors.PropertyAliasNamespaceResolver;
import oracle.tip.tools.ide.pm.bpelgraph.model.BPELGraphModel;
import oracle.tip.tools.ide.pm.bpelgraph.views.BPELGraphPane;
import oracle.tip.tools.ide.pm.gui.dialogs.xpathselection.XPathSelectionDialog;
import oracle.tip.tools.ide.pm.gui.explorer.MessageTypeDataSource;
import oracle.tip.tools.ide.pm.i18n.BPELStringTranslator;
import oracle.tip.tools.ide.pm.resources.images.ImageCache;
import org.w3c.dom.Document;

public class CorrelationPropertyAliasMessageTypePanel
extends JPanel
implements ActionListener {
    public static final String PROPERTY_CHANGED = "PROPERTY_CHANGED";
    public static final String TYPE_CHANGED = "TYPE_CHANGED";
    protected JTextField m_partField;
    protected TypeExplorer m_typeExplorer;
    protected BPELGraphPane m_graph;
    protected CorrelationPropertyAlias m_alias;
    protected XPathEditorPane m_xpathBuilder;
    protected JPanel m_myGlassPane;
    protected Component m_jdevGlassPane;
    protected JButton m_selectXPathBtn;
    protected Document m_document;
    protected JLabel m_queryLbl;
    protected NamespaceResolver m_nsResolver;
    protected BpelNSResolver m_bpelNSResolver;

    public CorrelationPropertyAliasMessageTypePanel(CorrelationPropertyAlias alias, BPELGraphPane graph) {
        this.m_graph = graph;
        this.m_alias = alias;
        this.m_myGlassPane = new JPanel();
        this.m_myGlassPane.setOpaque(false);
        this.m_myGlassPane.addMouseListener(new MouseAdapter(){});
        this.m_myGlassPane.addMouseMotionListener(new MouseMotionAdapter(){});
        this.m_nsResolver = CorrelationPropertyAliasPanel.getNSResolver(this.m_graph, this);
        BPELGraphModel model = (BPELGraphModel)this.m_graph.getModel();
        this.m_bpelNSResolver = (BpelNSResolver)NSResolverFactory.getNSResolver((Object)model.getProcess());
        this.createControls();
        this.layoutControls();
    }

    public boolean isDataValid() {
        TypeObject to = this.m_typeExplorer.getSelectedTypeObject();
        if (to == null) {
            return false;
        }
        return to.getType() == 4;
    }

    public void saveCorrelationPropertyAlias() {
        TypeObject to;
        if (this.m_alias == null) {
            this.m_alias = new CorrelationPropertyAlias();
        }
        if ((to = this.m_typeExplorer.getSelectedTypeObject()).getType() == 4) {
            MessagePartInfo info = (MessagePartInfo)to.getDataValue();
            QName messageTypeQName = info.getMessageQName();
            this.m_alias.setMessageType(messageTypeQName);
            WSDLPartData partData = info.getWSDLPartData();
            this.m_alias.setPart(partData.getPartName());
            String query = this.m_xpathBuilder.getText();
            this.m_alias.setQuery(query);
        }
        this.m_bpelNSResolver.saveCachedNamespacesToProcess();
        this.m_alias.setNamespaceMap(((PropertyAliasNamespaceResolver)this.m_nsResolver).getNamespaceMap());
        this.m_alias.setElement(null);
    }

    public void loadControls() {
        this.loadTypeExplorer();
    }

    public void loadTypeExplorer() {
        BPELGraphModel model = (BPELGraphModel)this.m_graph.getModel();
        TextInfo info1 = new TextInfo(Color.black, TextInfo.PLAIN_FONT, BPELStringTranslator.getString("EDIT_TYPE_EXPLORER"));
        TextInfo info2 = new TextInfo(Color.black, TextInfo.PLAIN_FONT, BPELStringTranslator.getString("EDIT_TYPE_EXPLORER"));
        TextInfo[] expanded = new TextInfo[]{info1};
        TextInfo[] compact = new TextInfo[]{info2};
        NodeText nodeText = new NodeText(expanded, compact);
        Icon[] icons = new Icon[]{GlobalImageCache.getIcon((String)"browse16")};
        DefaultTreeExplorerTreeNode root = new DefaultTreeExplorerTreeNode(icons, nodeText, BPELStringTranslator.getString("EDIT_DISP_AVL_MSG_TYPES"));
        this.m_typeExplorer.setRoot(root);
        this.m_typeExplorer.setDataSource((TreeExplorerDataSource)new MessageTypeDataSource(model.getProcess(), this.m_graph.getBPELProject()));
        this.m_typeExplorer.load();
    }

    protected void createControls() {
        this.m_selectXPathBtn = UIHelper.createModelerButton((Icon)ImageCache.getIcon("browse_xpath16"));
        this.m_selectXPathBtn.setToolTipText(BPELStringTranslator.getString("BROWSE_XPATH", "Browse XPath"));
        this.m_selectXPathBtn.addActionListener(this);
        this.m_selectXPathBtn.setEnabled(false);
        this.m_partField = new JTextField();
        this.m_xpathBuilder = new XPathEditorPane(2);
        this.m_typeExplorer = new TypeExplorer(new Insets(5, 5, 5, 5), null, (WSDLImportHandler)new DefaultWSDLImportHandler((IDEProject)this.m_graph.getBPELProject()));
        this.m_typeExplorer.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                CorrelationPropertyAliasMessageTypePanel.this.updateControls();
                CorrelationPropertyAliasMessageTypePanel.this.firePropertyChange(CorrelationPropertyAliasMessageTypePanel.TYPE_CHANGED, null, CorrelationPropertyAliasMessageTypePanel.this.m_typeExplorer.getSelectedTypeObject());
            }
        });
    }

    protected void layoutControls() {
        this.setLayout(new GridBagLayout());
        this.m_queryLbl = new JLabel();
        this.m_queryLbl.setEnabled(false);
        BPELStringTranslator.setLabel(this.m_queryLbl, (Component)this.m_xpathBuilder, BPELStringTranslator.getString("EDITOR_COR_PTY_ALS_PNL_QRY"));
        ToolBar tb2 = new ToolBar();
        tb2.setBorderInsets(new Insets(0, 0, 0, 0));
        tb2.add((Component)this.m_selectXPathBtn);
        int row = 0;
        GraphUtils.addComponent((Container)this, (Component)this.m_typeExplorer, (int)0, (int)row++, (int)3, (int)1, (int)17, (int)1, (Insets)new Insets(5, 5, 0, 5), (int)0, (int)0, (double)1.0, (double)1.0);
        GraphUtils.addComponent((Container)this, (Component)this.m_queryLbl, (int)0, (int)row++, (int)2, (int)1, (int)17, (int)2, (Insets)new Insets(5, 5, 2, 5), (int)0, (int)0, (double)1.0, (double)0.0);
        GraphUtils.addComponent((Container)this, (Component)new JScrollPane((Component)this.m_xpathBuilder, 21, 31), (int)0, (int)row++, (int)3, (int)1, (int)17, (int)1, (Insets)new Insets(0, 5, 5, 5), (int)0, (int)0, (double)1.0, (double)0.5);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Object src = e.getSource();
        if (src == this.m_selectXPathBtn) {
            this.handleSelectXPath();
        }
    }

    protected void handleSelectXPath() {
        XPathSelectionDialog dlg = new XPathSelectionDialog(GraphUtils.getFrame((Component)this), this.m_graph, this.m_document);
        if (dlg.display() == 0) {
            String xPath = dlg.getSelectedXPath();
            if (xPath != null) {
                this.m_xpathBuilder.setText(xPath);
            } else {
                this.m_xpathBuilder.setText("");
            }
        }
    }

    protected void updateControls() {
        TypeObject typeObj = this.m_typeExplorer.getSelectedTypeObject();
        if (typeObj != null && typeObj.getType() == 4) {
            MessagePartInfo msgInfo = (MessagePartInfo)typeObj.getDataValue();
            WSDLPartData partData = msgInfo.getWSDLPartData();
            this.enableXPathBuilder(msgInfo.getWSDLPartData());
        } else {
            this.m_xpathBuilder.setText("");
            this.enableQueryField(false);
        }
    }

    protected void enableQueryField(boolean bEnable) {
        this.m_xpathBuilder.setEnabled(false);
        this.m_xpathBuilder.setBackground(UIManager.getColor("Panel.background"));
        this.m_selectXPathBtn.setEnabled(false);
        this.m_queryLbl.setEnabled(false);
    }

    protected void enableUserInput(final boolean bEnable) {
        Container p;
        for (p = this.getParent(); p != null && !(p instanceof JRootPane); p = p.getParent()) {
        }
        final Container pane = p;
        Runnable r = new Runnable(){

            @Override
            public void run() {
                if (pane instanceof JRootPane) {
                    JRootPane rootPane = (JRootPane)pane;
                    if (bEnable) {
                        CorrelationPropertyAliasMessageTypePanel.this.m_myGlassPane.setVisible(false);
                        if (CorrelationPropertyAliasMessageTypePanel.this.m_jdevGlassPane != null) {
                            rootPane.setGlassPane(CorrelationPropertyAliasMessageTypePanel.this.m_jdevGlassPane);
                            rootPane.getGlassPane().setVisible(false);
                        }
                    } else {
                        CorrelationPropertyAliasMessageTypePanel.this.m_jdevGlassPane = rootPane.getGlassPane();
                        rootPane.setGlassPane(CorrelationPropertyAliasMessageTypePanel.this.m_myGlassPane);
                        CorrelationPropertyAliasMessageTypePanel.this.m_myGlassPane.setVisible(true);
                        CorrelationPropertyAliasMessageTypePanel.this.m_myGlassPane.setCursor(Cursor.getPredefinedCursor(3));
                    }
                }
            }
        };
        if (SwingUtilities.isEventDispatchThread()) {
            r.run();
        } else {
            SwingUtilities.invokeLater(r);
        }
    }

    protected void enableXPathBuilder(WSDLPartData partData) {
        final NamespaceResolver nsResolver = this.m_nsResolver;
        final String initXPath = this.m_alias != null ? this.m_alias.getQuery() : null;
        final WSDLPartData fPartData = partData;
        this.enableUserInput(false);
        Runnable r = new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                try {
                    Document doc;
                    CorrelationPropertyAliasMessageTypePanel.this.m_document = doc = CorrelationPropertyAliasMessageTypePanel.this.createUIDom(fPartData);
                    Runnable r = new Runnable(){

                        @Override
                        public void run() {
                            CorrelationPropertyAliasMessageTypePanel.this.m_xpathBuilder.setEnabled(true);
                            CorrelationPropertyAliasMessageTypePanel.this.m_xpathBuilder.setBackground(Color.white);
                            CorrelationPropertyAliasMessageTypePanel.this.m_selectXPathBtn.setEnabled(true);
                            CorrelationPropertyAliasMessageTypePanel.this.m_queryLbl.setEnabled(true);
                            if (doc != null) {
                                CorrelationPropertyAliasMessageTypePanel.this.m_xpathBuilder.initializeEditorPane(doc, initXPath, nsResolver);
                                CorrelationPropertyAliasMessageTypePanel.this.m_xpathBuilder.setExpectsAbsoluteLocationPath(true);
                            }
                        }
                    };
                    SwingUtilities.invokeLater(r);
                }
                finally {
                    CorrelationPropertyAliasMessageTypePanel.this.enableUserInput(true);
                }
            }
        };
        new Thread(r).start();
    }

    protected Document createUIDom(WSDLPartData partData) {
        Document doc = null;
        try {
            String namespaceURI = partData.getTargetNamespace();
            boolean bIsElement = partData.getPartXSDType() == 1;
            QName rootQName = null;
            QName typeQName = null;
            String elementName = partData.getPartType();
            if (partData.getPartXSDType() == 2) {
                rootQName = new QName("", partData.getPartName());
                typeQName = new QName(namespaceURI, partData.getPartType());
            } else {
                rootQName = new QName(namespaceURI, partData.getPartType());
            }
            if ("http://www.w3.org/2001/XMLSchema".equals(namespaceURI)) {
                return null;
            }
            ResolvedDocumentCacheKey key = new ResolvedDocumentCacheKey(rootQName, typeQName);
            ResolvedDocumentObj rObj = VariableDocumentCache.getResolvedDocumentObj((URL)this.m_graph.getBPELProject().getBPELDirectoryURL(), (ResolvedDocumentCacheKey)key);
            if (rObj != null) {
                doc = rObj.getDocument();
            } else {
                BPELGraphModel model = (BPELGraphModel)this.m_graph.getModel();
                WSDLModel wsdlModel = this.m_graph.getBPELXmlModel().getWSDLModel();
                SchemaResolvedObj obj = wsdlModel.resolveNamespace(model.getProcess(), namespaceURI, elementName, bIsElement);
                if (obj == null) {
                    return null;
                }
                doc = SchemaResolvedObj.buildDocument((SchemaResolvedObj)obj, (QName)rootQName, (QName)typeQName, (MapperNSResolver)this.m_bpelNSResolver);
            }
        }
        catch (Exception sge) {
            System.out.println("Getting SchemaGrammarException exception" + sge);
            sge.printStackTrace();
        }
        return doc;
    }
}

