/*
 * Decompiled with CFR 0.152.
 */
package oracle.tip.tools.ide.pm.bpelgraph.editors;

import java.awt.Component;
import java.awt.Container;
import java.awt.Font;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import javax.swing.DefaultComboBoxModel;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.TitledBorder;
import javax.xml.namespace.QName;
import oracle.tip.tools.ide.common.bpeldesigner.models.bpel.CorrelationPropertyAlias;
import oracle.tip.tools.ide.common.bpeldesigner.models.bpel.CorrelationSetProperty;
import oracle.tip.tools.ide.common.bpeldesigner.util.Helper;
import oracle.tip.tools.ide.common.bpeldesigner.util.WSDLPropertyUtil;
import oracle.tip.tools.ide.common.bpelparser.iface.Activity;
import oracle.tip.tools.ide.common.bpelparser.iface.Invoke;
import oracle.tip.tools.ide.common.bpelparser.iface.OnMessage;
import oracle.tip.tools.ide.common.bpelparser.iface.Process;
import oracle.tip.tools.ide.common.bpelparser.iface.Receive;
import oracle.tip.tools.ide.common.bpelparser.iface.Reply;
import oracle.tip.tools.ide.common.bpelparser.iface.Variable;
import oracle.tip.tools.ide.common.bpelparser.util.BPELModelUtil;
import oracle.tip.tools.ide.common.bpelparser.validation.ValidationContext;
import oracle.tip.tools.ide.common.graph.GraphUtils;
import oracle.tip.tools.ide.common.ide.bpel.BPELProject;
import oracle.tip.tools.ide.common.ui.ToolBar;
import oracle.tip.tools.ide.common.ui.UIHelper;
import oracle.tip.tools.ide.common.utils.MessagePart;
import oracle.tip.tools.ide.common.utils.NamespaceResolver;
import oracle.tip.tools.ide.pm.addin.model.WSDLModel;
import oracle.tip.tools.ide.pm.bpelgraph.editors.CorrelationPropertyAliasPanel;
import oracle.tip.tools.ide.pm.bpelgraph.editors.CorrelationSetPropertyDialog;
import oracle.tip.tools.ide.pm.bpelgraph.editors.CorrelationSetPropertyListItem;
import oracle.tip.tools.ide.pm.bpelgraph.editors.PropertyAliasNamespaceResolver;
import oracle.tip.tools.ide.pm.bpelgraph.editors.XPathContentHelper;
import oracle.tip.tools.ide.pm.bpelgraph.model.BPELGraphModel;
import oracle.tip.tools.ide.pm.bpelgraph.views.BPELGraphPane;
import oracle.tip.tools.ide.pm.gui.dialogs.variablexpathbuilder.VariableXPathBuilderPanel;
import oracle.tip.tools.ide.pm.gui.generalpurpose.GenericListCellRenderer;
import oracle.tip.tools.ide.pm.i18n.BPELStringTranslator;
import oracle.tip.tools.ide.pm.resources.images.ImageCache;

public class CorrelationPropertyAliasCreationPanel
extends JPanel
implements ActionListener,
PropertyChangeListener {
    public static final String PROPERTY_CHANGED = "PROPERTY_CHANGED";
    public static final String VARIABLE_SELECTION_CHANGED = "VARIABLE_SELECTION_CHANGED";
    protected VariableXPathBuilderPanel m_aliasBuilderPnl;
    protected JComboBox m_propertyNameCB;
    protected JButton m_createPropertyBtn;
    protected BPELGraphPane m_graph;
    protected CorrelationPropertyAlias m_alias;
    protected CorrelationPropertyAlias m_tempalias;
    protected QName m_qname;
    protected Activity m_activity;
    protected NamespaceResolver m_nsResolver;
    protected boolean m_bEditMode = false;

    public CorrelationPropertyAliasCreationPanel(BPELGraphPane graph, Activity activity) {
        this.m_graph = graph;
        this.m_activity = activity;
        this.m_nsResolver = this.getNSResolver();
        this.createControls();
        this.layoutControls();
    }

    public boolean isDataValid() {
        Variable var = this.m_aliasBuilderPnl.getVariable();
        if (var == null) {
            return false;
        }
        Object item = this.m_propertyNameCB.getSelectedItem();
        if (!(item instanceof CorrelationSetPropertyListItem)) {
            return false;
        }
        this.m_alias = this.m_tempalias;
        if (this.m_alias == null) {
            return false;
        }
        CorrelationSetPropertyListItem citem = (CorrelationSetPropertyListItem)item;
        CorrelationSetProperty prop = citem.getProperty();
        if (this.m_bEditMode && this.m_qname != null) {
            prop.setType(this.m_qname);
        }
        this.m_alias.setPropertyName(new QName(prop.getTargetNamespace(), prop.getName()));
        return true;
    }

    public CorrelationPropertyAlias getCorrelationPropertyAlias() {
        return this.m_alias;
    }

    public void saveCachedNS() {
        this.m_aliasBuilderPnl.saveCachedNS();
    }

    public Map getNamespacesMap() {
        return ((PropertyAliasNamespaceResolver)this.m_nsResolver).getNamespaceMap();
    }

    public CorrelationSetProperty getCorrelationSetProperty() {
        Object item = this.m_propertyNameCB.getSelectedItem();
        if (!(item instanceof CorrelationSetPropertyListItem)) {
            return null;
        }
        return ((CorrelationSetPropertyListItem)item).getProperty();
    }

    public void loadControls() {
        this.loadControls(null, null);
    }

    public void loadControls(CorrelationSetProperty prop, CorrelationPropertyAlias alias) {
        if (prop != null) {
            this.m_bEditMode = true;
            this.m_propertyNameCB.setEnabled(false);
            this.m_createPropertyBtn.setEnabled(false);
            this.loadProperties(prop);
        }
        this.m_alias = alias;
        try {
            this.m_aliasBuilderPnl.load(this.m_activity);
            this.loadPropertyAlias();
        }
        catch (Exception e) {
            e.printStackTrace();
            GraphUtils.displayMessage((Component)this, (String)e.getMessage(), (int)0);
        }
    }

    protected void loadProperties() {
        boolean bProperty;
        if (this.m_tempalias == null) {
            return;
        }
        QName qname = null;
        if (this.m_tempalias.getPropertyName() != null) {
            qname = this.m_tempalias.getPropertyName();
            bProperty = true;
        } else {
            qname = this.m_qname;
            bProperty = false;
        }
        if (qname == null) {
            return;
        }
        try {
            ArrayList<CorrelationSetPropertyListItem> itemLst = new ArrayList<CorrelationSetPropertyListItem>();
            List lst = WSDLPropertyUtil.getBPELProperties((BPELProject)this.m_graph.getBPELProject());
            Iterator it = lst.iterator();
            boolean bEqual = false;
            while (it.hasNext()) {
                CorrelationSetProperty p = (CorrelationSetProperty)it.next();
                bEqual = bProperty ? qname.equals(new QName(p.getTargetNamespace(), p.getName())) : qname.equals(p.getType());
                if (!bEqual) continue;
                itemLst.add(new CorrelationSetPropertyListItem(p));
                bEqual = false;
            }
            this.loadPropertyModel(itemLst);
        }
        catch (Exception e) {
            e.printStackTrace();
            GraphUtils.displayMessage((Component)GraphUtils.getFrame((Component)this), (String)BPELStringTranslator.getString("EDITOR_COR_PTY_ALS_PNL_ERR_LOAD"));
        }
    }

    protected void loadProperties(CorrelationSetProperty prop) {
        try {
            ArrayList<CorrelationSetPropertyListItem> itemLst = new ArrayList<CorrelationSetPropertyListItem>();
            List lst = WSDLPropertyUtil.getBPELProperties((BPELProject)this.m_graph.getBPELProject());
            for (CorrelationSetProperty p : lst) {
                if (!p.equals((Object)prop)) continue;
                itemLst.add(new CorrelationSetPropertyListItem(p));
            }
            this.loadPropertyModel(itemLst);
        }
        catch (Exception e) {
            e.printStackTrace();
            GraphUtils.displayMessage((Component)GraphUtils.getFrame((Component)this), (String)BPELStringTranslator.getString("EDITOR_COR_PTY_ALS_PNL_ERR_LOAD"));
        }
    }

    protected void loadPropertyModel(List itemLst) {
        final DefaultComboBoxModel<CorrelationSetPropertyListItem> model = new DefaultComboBoxModel<CorrelationSetPropertyListItem>(itemLst.toArray(new CorrelationSetPropertyListItem[0]));
        if (SwingUtilities.isEventDispatchThread()) {
            this.m_propertyNameCB.setModel(model);
            if (model.getSize() > 0) {
                this.m_propertyNameCB.setSelectedIndex(0);
            }
        } else {
            Runnable r = new Runnable(){

                @Override
                public void run() {
                    CorrelationPropertyAliasCreationPanel.this.m_propertyNameCB.setModel(model);
                    if (model.getSize() > 0) {
                        CorrelationPropertyAliasCreationPanel.this.m_propertyNameCB.setSelectedIndex(0);
                    }
                }
            };
            SwingUtilities.invokeLater(r);
        }
    }

    protected void loadPropertyAlias() {
        String varName = null;
        boolean bInputVar = true;
        if (this.m_activity instanceof Receive) {
            varName = ((Receive)this.m_activity).getVariable();
        } else if (this.m_activity instanceof Invoke) {
            varName = ((Invoke)this.m_activity).getInputVariable();
            if (varName == null) {
                varName = ((Invoke)this.m_activity).getOutputVariable();
                bInputVar = false;
            }
        } else if (this.m_activity instanceof Reply) {
            varName = ((Reply)this.m_activity).getVariable();
        } else if (this.m_activity instanceof OnMessage) {
            varName = ((OnMessage)this.m_activity).getVariable();
        }
        if (varName == null) {
            return;
        }
        if (this.m_alias == null) {
            this.m_aliasBuilderPnl.selectVariable(varName, this.m_activity);
            return;
        }
        this.m_aliasBuilderPnl.setXPath(this.m_alias.getQuery());
        BPELGraphModel model = (BPELGraphModel)this.m_graph.getModel();
        Process p = model.getProcess();
        List parentScopes = BPELModelUtil.getParentScopes((Activity)this.m_activity);
        ValidationContext c = new ValidationContext(p);
        Variable var = BPELModelUtil.findVariable((ValidationContext)c, (List)parentScopes, (String)varName);
        if (var != null) {
            QName qname = var.getMessageType();
            if (qname != null && this.m_alias.getMessageType() != null && qname.equals(this.m_alias.getMessageType()) || var.getElement() != null && this.m_alias.getElement() != null && var.getElement().equals(this.m_alias.getElement())) {
                this.selectPropertyAliasNode(varName);
            }
            if (this.m_activity instanceof Invoke && bInputVar && (var = BPELModelUtil.findVariable((ValidationContext)c, (List)parentScopes, (String)(varName = ((Invoke)this.m_activity).getOutputVariable()))) != null && ((qname = var.getMessageType()) != null && this.m_alias.getMessageType() != null && qname.equals(this.m_alias.getMessageType()) || var.getElement() != null && this.m_alias.getElement() != null && var.getElement().equals(this.m_alias.getElement()))) {
                this.selectPropertyAliasNode(varName);
            }
        }
    }

    protected void createControls() {
        this.m_aliasBuilderPnl = new VariableXPathBuilderPanel(this.m_graph);
        this.m_aliasBuilderPnl.addPropertyChangeListener(this);
        this.m_propertyNameCB = new JComboBox();
        this.m_propertyNameCB.addActionListener(this);
        this.m_propertyNameCB.setRenderer(new GenericListCellRenderer(ImageCache.getIcon("property_node")));
        this.m_createPropertyBtn = UIHelper.createModelerButton((Icon)ImageCache.getIcon("create16"));
        this.m_createPropertyBtn.setToolTipText(BPELStringTranslator.getString("EDITOR_COR_PTY_ALS_PNL_CRT_PTY"));
        this.m_createPropertyBtn.addActionListener(this);
    }

    protected void layoutControls() {
        this.setLayout(new GridBagLayout());
        JPanel aliasPanel = new JPanel(new GridBagLayout());
        TitledBorder b = new TitledBorder(" Property Alias ");
        Font f = UIManager.getFont("Label.font");
        b.setTitleFont(new Font(f.getFontName(), 1, 14));
        aliasPanel.setBorder(b);
        aliasPanel.setOpaque(false);
        GraphUtils.addComponent((Container)aliasPanel, (Component)this.m_aliasBuilderPnl, (int)0, (int)0, (int)1, (int)1, (int)17, (int)1, (Insets)new Insets(0, 0, 0, 0), (int)0, (int)0, (double)1.0, (double)1.0);
        ToolBar tb = new ToolBar();
        tb.add((Component)this.m_createPropertyBtn);
        JLabel propLbl = new JLabel();
        BPELStringTranslator.setLabel(propLbl, this.m_propertyNameCB, BPELStringTranslator.getString("EDITOR_COR_PTY_ALS_PNL_PTY"));
        int row = 0;
        GraphUtils.addComponent((Container)this, (Component)aliasPanel, (int)0, (int)row++, (int)3, (int)1, (int)17, (int)1, (Insets)new Insets(5, 5, 5, 5), (int)0, (int)0, (double)1.0, (double)1.0);
        GraphUtils.addComponent((Container)this, (Component)propLbl, (int)0, (int)row, (int)1, (int)1, (int)17, (int)0, (Insets)new Insets(5, 5, 0, 0), (int)0, (int)0, (double)0.0, (double)0.0);
        GraphUtils.addComponent((Container)this, (Component)this.m_propertyNameCB, (int)1, (int)row, (int)1, (int)1, (int)17, (int)2, (Insets)new Insets(5, 5, 0, 5), (int)0, (int)0, (double)1.0, (double)0.0);
        GraphUtils.addComponent((Container)this, (Component)tb, (int)2, (int)row++, (int)1, (int)1, (int)17, (int)0, (Insets)new Insets(5, 0, 0, 5), (int)0, (int)0, (double)0.0, (double)0.0);
    }

    protected void handleCreateProperty() {
        CorrelationSetProperty p;
        CorrelationSetPropertyDialog dlg = new CorrelationSetPropertyDialog(GraphUtils.getFrame((Component)this), this.m_graph);
        String propName = null;
        if (this.m_tempalias != null) {
            propName = this.generateUniquePropertyName(this.m_aliasBuilderPnl.getVariable(), this.m_tempalias.getPart(), this.m_tempalias.getQuery());
        }
        if (dlg.create(propName, this.m_qname) == 0 && (p = dlg.getCorrelationSetProperty()) != null) {
            ArrayList<CorrelationSetProperty> lst = new ArrayList<CorrelationSetProperty>();
            lst.add(p);
            try {
                WSDLPropertyUtil.setProperty((BPELProject)this.m_graph.getBPELProject(), lst);
                CorrelationSetPropertyListItem item = new CorrelationSetPropertyListItem(p);
                DefaultComboBoxModel model = (DefaultComboBoxModel)this.m_propertyNameCB.getModel();
                model.addElement(item);
                model.setSelectedItem(item);
            }
            catch (Exception e) {
                GraphUtils.displayMessage((Component)GraphUtils.getFrame((Component)this), (String)("ERROR:" + e.getMessage()), (int)0);
            }
        }
    }

    protected void findPropertyAlias() {
        Variable var;
        this.m_qname = null;
        this.m_tempalias = null;
        if (!this.m_bEditMode) {
            this.m_propertyNameCB.removeAllItems();
        }
        if ((var = this.m_aliasBuilderPnl.getVariable()) == null) {
            return;
        }
        this.m_tempalias = new CorrelationPropertyAlias();
        this.m_tempalias.setMessageType(var.getMessageType());
        this.m_tempalias.setElement(var.getElement());
        String xpath = this.m_aliasBuilderPnl.getXPath();
        MessagePart part = this.m_aliasBuilderPnl.getPart();
        if (xpath != null && !xpath.trim().equals("")) {
            this.m_tempalias.setQuery(xpath);
            this.m_qname = XPathContentHelper.getQNameFromXPath(this.m_aliasBuilderPnl.getUIDOM(), "/schema" + xpath);
            if (part != null) {
                this.m_tempalias.setPart(part.getName());
            }
        } else if (part != null) {
            this.m_tempalias.setPart(part.getName());
            this.m_qname = part.getQName();
        } else {
            this.m_qname = var.getMessageType() != null ? var.getMessageType() : var.getElement();
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Object src = e.getSource();
        if (src == this.m_propertyNameCB) {
            this.firePropertyChange(PROPERTY_CHANGED, null, this.m_propertyNameCB.getSelectedItem());
        } else if (src == this.m_createPropertyBtn) {
            this.handleCreateProperty();
        }
    }

    protected final NamespaceResolver getNSResolver() {
        PropertyAliasNamespaceResolver nsResolver = new PropertyAliasNamespaceResolver();
        WSDLModel wsdlModel = this.m_graph.getBPELXmlModel().getWSDLModel();
        Map map = wsdlModel.getNamespaceMapFromWSDL();
        if (map == null) {
            map = CorrelationPropertyAliasPanel.resolveNamespaceMapFromPLWSDL(this.m_graph, this);
        }
        if (map == null) {
            return nsResolver;
        }
        Object[] keys = map.keySet().toArray();
        if (keys != null) {
            for (int i = 0; i < keys.length; ++i) {
                nsResolver.addNSEntry((String)keys[i], (String)map.get(keys[i]));
            }
        }
        return nsResolver;
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        Object src = evt.getSource();
        String s = evt.getPropertyName();
        if (src == this.m_aliasBuilderPnl && s.equals("TREE_SELECTION_OCCURRED")) {
            this.findPropertyAlias();
            this.firePropertyChange(VARIABLE_SELECTION_CHANGED, null, this);
            if (!this.m_bEditMode) {
                this.loadProperties();
            }
        }
    }

    protected List parseQueryQName(String query, Map wsdlNSMap) {
        BPELGraphModel model = (BPELGraphModel)this.m_graph.getModel();
        Process process = model.getProcess();
        StringTokenizer st = new StringTokenizer(query, "/");
        ArrayList<QName> l = new ArrayList<QName>();
        while (st.hasMoreTokens()) {
            String tok = st.nextToken();
            String prefix = null;
            String local = null;
            int index = tok.indexOf(":");
            if (index == -1) {
                return l;
            }
            prefix = tok.substring(0, index);
            local = tok.substring(index + 1);
            QName qname = null;
            if (prefix != null) {
                String ns = process.getNamespaceForPrefix(prefix);
                if (ns == null && wsdlNSMap != null && Helper.hasValue((String)(ns = (String)wsdlNSMap.get(prefix)))) {
                    prefix = process.getPrefixForNamespace(ns);
                }
                qname = new QName(ns, local, prefix);
            }
            if (qname == null) continue;
            l.add(qname);
        }
        return l;
    }

    protected void selectPropertyAliasNode(String varName) {
        boolean bSucceeded = false;
        if (varName != null && Helper.hasValue((String)this.m_alias.getPart())) {
            bSucceeded = this.m_aliasBuilderPnl.selectVariablePart(varName, this.m_alias.getPart(), this.m_activity, this.m_alias.getQuery());
        }
        if (!bSucceeded && varName != null && this.m_alias.getQuery() != null) {
            List qnames = this.parseQueryQName(this.m_alias.getQuery(), null);
            bSucceeded = this.m_aliasBuilderPnl.selectVariableXPathNode(varName, qnames, this.m_activity);
        }
        if (!bSucceeded && varName != null) {
            this.m_aliasBuilderPnl.selectVariable(varName, this.m_activity);
        }
    }

    protected String generateUniquePropertyName(Variable var, String part, String xPath) {
        int last;
        StringBuffer strBuf = new StringBuffer();
        if (var != null) {
            strBuf.append(var.getName());
            strBuf.append("_");
        }
        if (part != null) {
            strBuf.append(part);
            strBuf.append("_");
        }
        if (xPath != null && (last = xPath.lastIndexOf("/")) != -1 && (last = (xPath = xPath.substring(last + 1, xPath.length())).indexOf(":")) != -1) {
            strBuf.append(xPath.substring(last + 1, xPath.length()));
            strBuf.append("_");
        }
        strBuf.append("prop");
        String propName = strBuf.toString();
        List lst = null;
        try {
            lst = WSDLPropertyUtil.getBPELProperties((BPELProject)this.m_graph.getBPELProject());
        }
        catch (Exception ex) {
            // empty catch block
        }
        String propName0 = propName;
        if (lst != null) {
            boolean bFound = false;
            int count = 1;
            do {
                bFound = false;
                for (int i = 0; i < lst.size() && !bFound; ++i) {
                    CorrelationSetProperty p = (CorrelationSetProperty)lst.get(i);
                    if (!p.getName().equals(propName)) continue;
                    bFound = true;
                }
                if (!bFound) continue;
                propName = propName0 + count++;
            } while (bFound);
        }
        return propName;
    }
}

