/*
 * Decompiled with CFR 0.152.
 */
package oracle.tip.tools.ide.pm.bpelgraph.editors;

import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Map;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JPanel;
import oracle.tip.tools.ide.common.bpeldesigner.models.bpel.CorrelationPropertyAlias;
import oracle.tip.tools.ide.common.bpeldesigner.models.bpel.CorrelationSetProperty;
import oracle.tip.tools.ide.common.bpelparser.iface.Activity;
import oracle.tip.tools.ide.common.graph.GraphUtils;
import oracle.tip.tools.ide.pm.bpelgraph.editors.CorrelationPropertyAliasCreationPanel;
import oracle.tip.tools.ide.pm.bpelgraph.views.BPELGraphPane;
import oracle.tip.tools.ide.pm.gui.generalpurpose.BPELBaseDialog;
import oracle.tip.tools.ide.pm.i18n.BPELStringTranslator;

public class CorrelationPropertyAliasCreationDialog
extends BPELBaseDialog
implements ActionListener,
PropertyChangeListener {
    public static final int OK = 0;
    public static final int CANCEL = 1;
    private JButton m_okBtn;
    private JButton m_cancelBtn;
    private JButton m_helpBtn;
    protected CorrelationPropertyAliasCreationPanel m_propPanel;
    protected BPELGraphPane m_graph;
    protected int m_retVal = 1;
    protected Activity m_activity;
    protected boolean m_bCreating = true;

    public CorrelationPropertyAliasCreationDialog(JFrame f, BPELGraphPane graph, Activity activity) {
        super(f, BPELStringTranslator.getString("EDITOR_PTY_ALS_DLG"), true);
        this.m_graph = graph;
        this.m_activity = activity;
        this.createAndLayoutControls();
    }

    public CorrelationPropertyAlias getCorrelationPropertyAlias() {
        return this.m_propPanel.getCorrelationPropertyAlias();
    }

    public CorrelationSetProperty getCorrelationSetProperty() {
        return this.m_propPanel.getCorrelationSetProperty();
    }

    public Map getAllNSNamespaces() {
        return this.m_propPanel.getNamespacesMap();
    }

    public int edit(CorrelationSetProperty prop, CorrelationPropertyAlias alias) {
        this.m_bCreating = false;
        this.setTitle(BPELStringTranslator.getString("EDITOR_EDIT_PTY_ALS"));
        this.enableUserInput(false);
        final CorrelationSetProperty fprop = prop;
        final CorrelationPropertyAlias falias = alias;
        Runnable r = new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                try {
                    CorrelationPropertyAliasCreationDialog.this.m_propPanel.loadControls(fprop, falias);
                }
                finally {
                    CorrelationPropertyAliasCreationDialog.this.enableUserInput(true);
                }
            }
        };
        new Thread(r).start();
        return this.display();
    }

    public int create() {
        this.setTitle(BPELStringTranslator.getString("CREATE_PROPERTY_ALIAS"));
        this.enableUserInput(false);
        Runnable r = new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                try {
                    CorrelationPropertyAliasCreationDialog.this.m_propPanel.loadControls();
                }
                finally {
                    CorrelationPropertyAliasCreationDialog.this.enableUserInput(true);
                }
            }
        };
        new Thread(r).start();
        return this.display();
    }

    private int display() {
        this.setVisible(true);
        return this.m_retVal;
    }

    protected void createAndLayoutControls() {
        this.m_propPanel = new CorrelationPropertyAliasCreationPanel(this.m_graph, this.m_activity);
        this.m_propPanel.addPropertyChangeListener(this);
        this.m_okBtn = new JButton();
        BPELStringTranslator.setButton(this.m_okBtn, BPELStringTranslator.getString("OK_BUTTON_TEXT_RES"));
        this.m_okBtn.addActionListener(this);
        this.m_cancelBtn = new JButton();
        BPELStringTranslator.setButton(this.m_cancelBtn, BPELStringTranslator.getString("CANCEL_BUTTON_TEXT_RES"));
        this.m_cancelBtn.addActionListener(this);
        this.m_helpBtn = new JButton();
        BPELStringTranslator.setButton(this.m_helpBtn, BPELStringTranslator.getString("HELP_BUTTON_TEXT_RES"));
        this.m_helpBtn.addActionListener(this);
        JPanel btnPnl = new JPanel(new GridLayout(1, 2, 5, 0));
        btnPnl.add(this.m_okBtn);
        btnPnl.add(this.m_cancelBtn);
        Container c = this.getContentPane();
        c.setLayout(new GridBagLayout());
        int row = 0;
        GraphUtils.addComponent((Container)c, (Component)this.m_propPanel, (int)0, (int)row++, (int)2, (int)1, (int)17, (int)1, (Insets)new Insets(5, 5, 10, 5), (int)0, (int)0, (double)1.0, (double)1.0);
        GraphUtils.addComponent((Container)c, (Component)this.m_helpBtn, (int)0, (int)row, (int)1, (int)1, (int)17, (int)0, (Insets)new Insets(0, 10, 10, 10), (int)0, (int)0, (double)1.0, (double)0.0);
        GraphUtils.addComponent((Container)c, (Component)btnPnl, (int)1, (int)row++, (int)1, (int)1, (int)13, (int)0, (Insets)new Insets(0, 0, 10, 10), (int)0, (int)0, (double)1.0, (double)0.0);
        this.setSize(480, 480);
        GraphUtils.centerInScreen((Component)((Object)this));
    }

    protected void updateButtons() {
        this.m_okBtn.setEnabled(this.m_propPanel.isDataValid());
    }

    public CorrelationPropertyAlias getProperyAlias() {
        return this.m_propPanel.getCorrelationPropertyAlias();
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Object src = e.getSource();
        if (src == this.m_okBtn) {
            this.m_propPanel.saveCachedNS();
            this.m_retVal = 0;
            this.dispose();
        } else if (src == this.m_cancelBtn) {
            this.handleCancel();
        } else if (src == this.m_helpBtn) {
            this.helpInvoked();
        }
    }

    protected void handleCancel() {
        this.m_retVal = 1;
        this.dispose();
    }

    protected void helpInvoked() {
        this.handleHelp(this.m_propPanel);
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        Object src = evt.getSource();
        if (src == this.m_propPanel) {
            this.updateButtons();
        }
    }
}

