/*
 * Decompiled with CFR 0.152.
 */
package oracle.tip.tools.ide.pm.bpelgraph.editors;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Font;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.ListSelectionModel;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import javax.swing.table.DefaultTableCellRenderer;
import oracle.tip.tools.ide.common.bpelparser.extension.iface.Append;
import oracle.tip.tools.ide.common.bpelparser.extension.iface.CopyList;
import oracle.tip.tools.ide.common.bpelparser.extension.iface.From;
import oracle.tip.tools.ide.common.bpelparser.extension.iface.FromOpType;
import oracle.tip.tools.ide.common.bpelparser.extension.iface.InsertAfter;
import oracle.tip.tools.ide.common.bpelparser.extension.iface.InsertBefore;
import oracle.tip.tools.ide.common.bpelparser.extension.iface.Remove;
import oracle.tip.tools.ide.common.bpelparser.extension.iface.TargetOpType;
import oracle.tip.tools.ide.common.bpelparser.extension.iface.To;
import oracle.tip.tools.ide.common.bpelparser.iface.Activity;
import oracle.tip.tools.ide.common.bpelparser.iface.Copy;
import oracle.tip.tools.ide.common.graph.GraphUtils;
import oracle.tip.tools.ide.common.ui.ButtonMenu;
import oracle.tip.tools.ide.common.ui.UIHelper;
import oracle.tip.tools.ide.common.ui.models.BaseTableModel;
import oracle.tip.tools.ide.pm.bpelgraph.editors.BaseEditingPage;
import oracle.tip.tools.ide.pm.bpelgraph.editors.CopyDialogEditPage;
import oracle.tip.tools.ide.pm.bpelgraph.editors.CopyPageFactory;
import oracle.tip.tools.ide.pm.bpelgraph.editors.CopyPageInputs;
import oracle.tip.tools.ide.pm.bpelgraph.editors.CopyRuleDialog;
import oracle.tip.tools.ide.pm.bpelgraph.editors.CopyRuleTableModel;
import oracle.tip.tools.ide.pm.bpelgraph.views.BPELGraphPane;
import oracle.tip.tools.ide.pm.gui.generalpurpose.TablePanel;
import oracle.tip.tools.ide.pm.i18n.BPELStringTranslator;
import oracle.tip.tools.ide.pm.resources.images.ImageCache;

public class CopyRuleTablePanel
extends TablePanel {
    static Icon EXPRESSION_ICON = ImageCache.getIcon("edit_expression16");
    static Icon VARIABLE_ICON = ImageCache.getIcon("variable16");
    static Icon XML_FRAGMENT_ICON = ImageCache.getIcon("application/bpel/fragment16.png");
    static Icon ERROR_ICON = ImageCache.getIcon("application/bpel/error.png");
    protected static Border noFocusBorder = new EmptyBorder(1, 1, 1, 1);
    protected static final String DELIMITER = "/";
    protected BPELGraphPane m_graphPane;
    protected Activity m_activity;
    protected JButton m_upBtn;
    protected JButton m_downBtn;
    protected JButton m_emptyBtn;
    protected JButton m_createBtn;
    protected ButtonMenu m_btnMenu;

    public CopyRuleTablePanel(BaseTableModel tabModel, BPELGraphPane pane, boolean isCopyRuleOnly) {
        this(tabModel, pane);
        if (isCopyRuleOnly) {
            this.m_createBtn = UIHelper.createToolBarButton((int)0);
            this.m_createBtn.addActionListener(this);
            this.m_toolBar.removeAll();
            this.m_toolBar.add((Component)this.m_createBtn);
            this.m_toolBar.add((Component)this.m_editBtn);
            this.m_toolBar.add((Component)this.m_removeBtn);
            this.m_toolBar.add((Component)this.m_upBtn);
            this.m_toolBar.add((Component)this.m_downBtn);
        }
    }

    public CopyRuleTablePanel(BaseTableModel tabModel, BPELGraphPane pane) {
        super(tabModel);
        this.m_graphPane = pane;
        this.m_table.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                Point origin = e.getPoint();
                int row = CopyRuleTablePanel.this.m_table.rowAtPoint(origin);
                int column = CopyRuleTablePanel.this.m_table.columnAtPoint(origin);
                if (row == -1 || column == -1) {
                    return;
                }
                if (e.getClickCount() == 2) {
                    CopyRuleTablePanel.this.doEdit(row);
                }
            }

            @Override
            public void mouseReleased(MouseEvent e) {
            }
        });
        this.m_upBtn = UIHelper.createToolBarButton((Icon)ImageCache.getIcon("arrow_up_blue16"), (String)BPELStringTranslator.getString("MOVE_UP_TIP"), (String)BPELStringTranslator.getString("MOVE_UP_MNEMONIC"));
        this.m_downBtn = UIHelper.createToolBarButton((Icon)ImageCache.getIcon("arrow_down_blue16"), (String)BPELStringTranslator.getString("MOVE_DOWN_TIP"), (String)BPELStringTranslator.getString("MOVE_DOWN_MNEMONIC"));
        this.m_emptyBtn = UIHelper.createModelerButton((String)BPELStringTranslator.getString("EDIT_REMOVE_ALL_TEXT"), (Icon)ImageCache.getIcon("garbage_empty16"));
        BPELStringTranslator.setButton(this.m_emptyBtn, BPELStringTranslator.getString("EDIT_REMOVE_ALL_TEXT_RES"));
        this.m_upBtn.addActionListener(this);
        this.m_downBtn.addActionListener(this);
        this.m_emptyBtn.addActionListener(this);
        this.m_toolBar.removeAll();
        this.m_btnMenu = new ButtonMenu("", ImageCache.getIcon("create16"));
        Action[] actions = new Action[]{new CopyRuleAction(), new AppendAction(), new InsertAfterAction(), new InsertBeforeAction(), new CopyListAction(), new RemoveAction(), new RenameAction()};
        this.m_btnMenu.setActions(actions);
        this.m_toolBar.add((Component)this.m_btnMenu);
        this.m_toolBar.add((Component)this.m_editBtn);
        this.m_toolBar.add((Component)this.m_removeBtn);
        this.m_toolBar.add((Component)this.m_upBtn);
        this.m_toolBar.add((Component)this.m_downBtn);
    }

    public void setActivity(Activity activity) {
        this.m_activity = activity;
    }

    public void performAdd(int pageType) {
        CopyPageInputs in = new CopyPageInputs(this.m_activity);
        CopyDialogEditPage page = CopyPageFactory.newCopyDialogEditPage(pageType, this.m_graphPane, in);
        page.loadControls();
        String title = CopyPageFactory.getCreatePageTitle(pageType);
        CopyRuleDialog dlg = new CopyRuleDialog(GraphUtils.getFrame((Component)this), page, title);
        if (dlg.create() == 0) {
            Object rule = page.getCopyRule();
            CopyRuleTableModel model = (CopyRuleTableModel)((Object)this.m_table.getModel());
            model.insertRow(rule);
            model.refresh();
            this.setModified(true);
        }
    }

    @Override
    protected void doEdit(int row) {
        if (row == -1) {
            return;
        }
        CopyRuleTableModel model = (CopyRuleTableModel)((Object)this.m_table.getModel());
        Object obj = model.getRow(row);
        CopyPageInputs in = new CopyPageInputs(this.m_activity);
        CopyDialogEditPage page = CopyPageFactory.editCopyDialogEditPage(obj, this.m_graphPane, in);
        String title = CopyPageFactory.getEditPageTitle(obj, in);
        CopyRuleDialog dlg = new CopyRuleDialog(GraphUtils.getFrame((Component)this), page, title);
        page.loadControls();
        if (dlg.edit() == 0) {
            Object rule = page.getCopyRule();
            model.setRow(rule, row);
            this.setModified(true);
        }
    }

    @Override
    public void performRemove() {
        CopyRuleTableModel model = (CopyRuleTableModel)((Object)this.m_table.getModel());
        int[] rows = this.m_table.getSelectedRows();
        if (rows.length == 0) {
            GraphUtils.displayMessage((Component)this, (String)BPELStringTranslator.getString("EDITOR_CPY_RULE_TBL_PNL"), (String)BPELStringTranslator.getString("BPEL_ALTERT_TITLE"), (int)2);
            return;
        }
        model.deleteRows(rows);
        model.refresh();
        this.setModified(true);
    }

    protected void setModified(boolean b) {
        Container p;
        for (p = this.getParent(); p != null && !(p instanceof BaseEditingPage); p = p.getParent()) {
        }
        if (p instanceof BaseEditingPage) {
            BaseEditingPage page = (BaseEditingPage)p;
            page.setModified(b);
        }
    }

    @Override
    public void updateButtons() {
        super.updateButtons();
        ListSelectionModel model = this.m_table.getSelectionModel();
        int sel = model.getMinSelectionIndex();
        if (sel == -1) {
            this.m_upBtn.setEnabled(false);
            this.m_downBtn.setEnabled(false);
        } else if (sel == 0) {
            this.m_upBtn.setEnabled(false);
            this.m_downBtn.setEnabled(this.m_table.getModel().getRowCount() > 1);
        } else {
            this.m_upBtn.setEnabled(true);
            if (sel + 1 == this.m_table.getModel().getRowCount()) {
                this.m_downBtn.setEnabled(false);
            } else {
                this.m_downBtn.setEnabled(true);
            }
        }
        this.m_emptyBtn.setEnabled(!model.isSelectionEmpty());
    }

    public void performMoveUp() {
        CopyRuleTableModel model = (CopyRuleTableModel)((Object)this.m_table.getModel());
        ListSelectionModel smodel = this.m_table.getSelectionModel();
        int sel = smodel.getMinSelectionIndex();
        model.moveUp(sel);
        if (sel != -1) {
            smodel.setSelectionInterval(sel - 1, sel - 1);
            this.m_table.scrollRectToVisible(this.m_table.getCellRect(sel - 1, 0, true));
        }
    }

    public void performMoveDown() {
        CopyRuleTableModel model = (CopyRuleTableModel)((Object)this.m_table.getModel());
        ListSelectionModel smodel = this.m_table.getSelectionModel();
        int sel = smodel.getMinSelectionIndex();
        model.moveDown(sel);
        if (sel != -1) {
            smodel.setSelectionInterval(sel + 1, sel + 1);
            this.m_table.scrollRectToVisible(this.m_table.getCellRect(sel + 1, 0, true));
        }
    }

    public void performEmpty() {
        CopyRuleTableModel model = (CopyRuleTableModel)((Object)this.m_table.getModel());
        model.removeAllData();
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Object src = e.getSource();
        if (src == this.m_upBtn) {
            this.performMoveUp();
        } else if (src == this.m_downBtn) {
            this.performMoveDown();
        } else if (src == this.m_emptyBtn) {
            this.performEmpty();
        } else if (src == this.m_createBtn) {
            this.performAdd(1);
        } else {
            super.actionPerformed(e);
        }
    }

    public static class ImageColumnTableCellRenderer
    extends DefaultTableCellRenderer {
        public ImageColumnTableCellRenderer() {
            this.setHorizontalAlignment(0);
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            super.getTableCellRendererComponent(table, "", isSelected, hasFocus, row, column);
            if (value instanceof Copy) {
                this.setIcon(ImageCache.getIcon("copyrule16"));
                this.setToolTipText("Copy");
            } else if (value instanceof InsertAfter) {
                this.setIcon(ImageCache.getIcon("insertafter_copyrule"));
                this.setToolTipText("Insert After");
            } else if (value instanceof InsertBefore) {
                this.setIcon(ImageCache.getIcon("insertbefore_copyrule16"));
                this.setToolTipText("Insert Before");
            } else if (value instanceof CopyList) {
                this.setIcon(ImageCache.getIcon("copylist_copyrule16"));
                this.setToolTipText("Copylist");
            } else if (value instanceof Append) {
                this.setIcon(ImageCache.getIcon("append_copyrule16"));
                this.setToolTipText("Append");
            } else if (value instanceof Remove) {
                this.setIcon(ImageCache.getIcon("remove_copyrule16"));
                this.setToolTipText("Remove");
            } else {
                this.setIcon(ImageCache.getIcon("rename_copyrule16"));
                this.setToolTipText("Rename");
            }
            this.setBackground(Color.white);
            return this;
        }
    }

    public static class CopyCellPanel
    extends JPanel {
        protected Object m_copy;
        protected boolean m_bFrom;
        protected boolean m_bSelected;
        protected boolean m_bHasFocus;
        protected JTable m_table;

        public CopyCellPanel(JTable table, Object copy, boolean bFrom, boolean selected, boolean focus) {
            this.m_table = table;
            this.m_bHasFocus = focus;
            this.m_bSelected = selected;
            this.m_bFrom = bFrom;
            this.m_copy = copy;
            this.setBackground(Color.white);
            this.createControls();
        }

        protected void createControls() {
            CopyInfo cp;
            if (this.m_bSelected) {
                this.setBackground(this.m_table.getSelectionBackground());
            } else {
                this.setBackground(this.m_table.getBackground());
            }
            if (this.m_bHasFocus) {
                this.setBorder(UIManager.getBorder("Table.focusCellHighlightBorder"));
            } else {
                this.setBorder(noFocusBorder);
            }
            Color txtClr = Color.black;
            if (this.m_bSelected) {
                txtClr = Color.white;
            }
            String type = "No Type Specified!";
            JLabel detailLabel = new JLabel();
            detailLabel.setOpaque(false);
            Icon icon = ERROR_ICON;
            if (this.m_bFrom) {
                cp = this.getFromCopyInfo();
                if (cp != null) {
                    if (cp.exp != null) {
                        icon = EXPRESSION_ICON;
                        type = "Expression";
                        detailLabel = new JLabel(cp.exp, 0);
                        this.setToolTipText("<html><body bgcolor=white><table bgcolor=white border=0 width=450><tr><td align=center><font color=blue><b>Expression Value</b></font></td></tr><tr><td align=center>" + cp.exp + "</td></tr></table></body></html>");
                    } else if (cp.var != null) {
                        icon = VARIABLE_ICON;
                        type = "Variable";
                        detailLabel = new JLabel(cp.var, 0);
                        detailLabel.setForeground(txtClr);
                        this.setToolTipText("<html><body bgcolor=white><table bgcolor=white border=0 ><tr><td align=center><font color=blue><b>Variable XPath</b></font></td></tr><tr><td align=center>" + cp.var + "</td></tr></table></body></html>");
                    } else if (cp.literal != null) {
                        icon = XML_FRAGMENT_ICON;
                        type = "XML Fragment";
                        detailLabel = new JLabel(cp.literal, 0);
                        detailLabel.setForeground(txtClr);
                        String s = cp.literal.replaceAll("<", "&lt;");
                        s = s.replaceAll(">", "&gt;");
                        this.setToolTipText("<html><body bgcolor=white><table bgcolor=white border=0  width=450><tr><td align=center><font color=blue><b>XML Fragment</b></font></td></tr><tr><td align=center>" + s + "</td></tr></table></body></html>");
                    } else if (cp.partnerLink != null) {
                        icon = ImageCache.getIcon("partner_link_node");
                        type = "PartnerLink";
                        detailLabel = new JLabel(cp.partnerLink, 0);
                        this.setToolTipText("<html><body bgcolor=white><table bgcolor=white border=0 ><tr><td align=center><font color=blue><b>Partner Link</b></font></td></tr><tr><td align=center>" + cp.partnerLink + "</td></tr></table></body></html>");
                        detailLabel.setForeground(txtClr);
                    }
                } else {
                    type = "";
                    icon = null;
                }
            } else {
                cp = this.getToCopyInfo();
                if (cp != null) {
                    if (cp.var != null) {
                        icon = VARIABLE_ICON;
                        type = "Variable";
                        detailLabel = new JLabel(cp.var, 0);
                        detailLabel.setForeground(txtClr);
                        this.setToolTipText("<html><body bgcolor=white><table bgcolor=white border=0 ><tr><td align=center><font color=blue><b>Variable XPath</b></font></td></tr><tr><td align=center>" + cp.var + "</td></tr></table></body></html>");
                    } else if (cp.partnerLink != null) {
                        icon = ImageCache.getIcon("partner_link_node");
                        type = "PartnerLink";
                        detailLabel = new JLabel(cp.partnerLink, 0);
                        detailLabel.setForeground(txtClr);
                        this.setToolTipText("<html><body bgcolor=white><table bgcolor=white border=0 ><tr><td align=center>" + cp.partnerLink + "</td></tr></table></body></html>");
                    }
                }
            }
            JLabel lbl = icon == null ? new JLabel(type) : new JLabel(type, icon, 0);
            lbl.setOpaque(false);
            lbl.setForeground(txtClr);
            Font f = lbl.getFont();
            lbl.setFont(new Font(f.getFamily(), 1, f.getSize()));
            this.setLayout(new GridBagLayout());
            int row = 0;
            GraphUtils.addComponent((Container)this, (Component)lbl, (int)1, (int)row++, (int)1, (int)1, (int)10, (int)2, (Insets)new Insets(2, 0, 0, 2), (int)0, (int)0, (double)1.0, (double)0.0);
            GraphUtils.addComponent((Container)this, (Component)detailLabel, (int)0, (int)row, (int)2, (int)1, (int)17, (int)1, (Insets)new Insets(2, 2, 2, 2), (int)0, (int)0, (double)1.0, (double)1.0);
        }

        private CopyInfo getFromCopyInfo() {
            CopyInfo cp = null;
            if (this.m_copy instanceof Copy) {
                cp = new CopyInfo();
                oracle.tip.tools.ide.common.bpelparser.iface.From f = ((Copy)this.m_copy).getFrom();
                if (f != null) {
                    if (f.getExpression() != null) {
                        cp.exp = f.getExpression();
                    } else if (f.getVariable() != null) {
                        StringBuffer strBuf = new StringBuffer(f.getVariable());
                        strBuf.append(CopyRuleTablePanel.DELIMITER);
                        if (f.getPart() != null) {
                            strBuf.append(f.getPart());
                        }
                        strBuf.append(CopyRuleTablePanel.DELIMITER);
                        if (f.getQuery() != null) {
                            strBuf.append(f.getQuery());
                        }
                        cp.var = strBuf.toString();
                    } else if (f.getLiteral() != null) {
                        cp.literal = new String(f.getLiteral());
                        cp.literal = cp.literal.replaceAll("\n", " ");
                    } else if (f.getPartnerLink() != null) {
                        cp.partnerLink = f.getPartnerLink();
                    }
                }
            } else if (this.m_copy instanceof FromOpType) {
                cp = new CopyInfo();
                From f = ((FromOpType)this.m_copy).getFrom();
                if (f != null) {
                    if (f.getExpression() != null) {
                        cp.exp = f.getExpression();
                    } else if (f.getVariable() != null) {
                        StringBuffer strBuf = new StringBuffer(f.getVariable());
                        strBuf.append(CopyRuleTablePanel.DELIMITER);
                        if (f.getPart() != null) {
                            strBuf.append(f.getPart());
                        }
                        strBuf.append(CopyRuleTablePanel.DELIMITER);
                        if (f.getQuery() != null) {
                            strBuf.append(f.getQuery());
                        }
                        cp.var = strBuf.toString();
                    } else if (f.getLiteral() != null) {
                        cp.literal = f.getLiteral();
                        cp.literal = cp.literal.replaceAll("\n", " ");
                    }
                }
            }
            return cp;
        }

        private CopyInfo getToCopyInfo() {
            To to;
            CopyInfo cp = null;
            if (this.m_copy instanceof Copy) {
                cp = new CopyInfo();
                oracle.tip.tools.ide.common.bpelparser.iface.To to2 = ((Copy)this.m_copy).getTo();
                if (to2 != null && to2.getVariable() != null) {
                    StringBuffer strBuf = new StringBuffer(to2.getVariable());
                    strBuf.append(CopyRuleTablePanel.DELIMITER);
                    if (to2.getPart() != null) {
                        strBuf.append(to2.getPart());
                    }
                    strBuf.append(CopyRuleTablePanel.DELIMITER);
                    if (to2.getQuery() != null) {
                        strBuf.append(to2.getQuery());
                    }
                    cp.var = strBuf.toString();
                } else if (to2 != null && to2.getPartnerLink() != null) {
                    cp.partnerLink = to2.getPartnerLink();
                }
            } else if (this.m_copy instanceof FromOpType) {
                To to3 = ((FromOpType)this.m_copy).getTo();
                if (to3 != null && to3.getVariable() != null) {
                    cp = new CopyInfo();
                    StringBuffer strBuf = new StringBuffer(to3.getVariable());
                    strBuf.append(CopyRuleTablePanel.DELIMITER);
                    if (to3.getPart() != null) {
                        strBuf.append(to3.getPart());
                    }
                    strBuf.append(CopyRuleTablePanel.DELIMITER);
                    if (to3.getQuery() != null) {
                        strBuf.append(to3.getQuery());
                    }
                    cp.var = strBuf.toString();
                }
            } else if (this.m_copy instanceof TargetOpType && (to = ((TargetOpType)this.m_copy).getTarget()) != null && to.getVariable() != null) {
                cp = new CopyInfo();
                StringBuffer strBuf = new StringBuffer(to.getVariable());
                strBuf.append(CopyRuleTablePanel.DELIMITER);
                if (to.getPart() != null) {
                    strBuf.append(to.getPart());
                }
                strBuf.append(CopyRuleTablePanel.DELIMITER);
                if (to.getQuery() != null) {
                    strBuf.append(to.getQuery());
                }
                cp.var = strBuf.toString();
            }
            return cp;
        }

        private class CopyInfo {
            public String exp;
            public String var;
            public String literal;
            public String partnerLink;

            private CopyInfo() {
            }
        }
    }

    public static class MyRenderer
    extends DefaultTableCellRenderer {
        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            double prefheight;
            CopyCellPanel p = new CopyCellPanel(table, value, column == 1, isSelected, hasFocus);
            int height = table.getRowHeight(row);
            if (height < (int)(prefheight = p.getPreferredSize().getHeight())) {
                table.setRowHeight(row, (int)prefheight);
            }
            return p;
        }
    }

    class RenameAction
    extends AbstractAction {
        public RenameAction() {
            super(BPELStringTranslator.getString("EDITOR_CPY_RULE_TBL_PNL_CRE_RULE_RENAME"), ImageCache.getIcon("rename_copyrule16"));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            CopyRuleTablePanel.this.performAdd(7);
        }
    }

    class RemoveAction
    extends AbstractAction {
        public RemoveAction() {
            super(BPELStringTranslator.getString("EDITOR_CPY_RULE_TBL_PNL_CRE_RULE_REMOVE"), ImageCache.getIcon("remove_copyrule16"));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            CopyRuleTablePanel.this.performAdd(6);
        }
    }

    class CopyListAction
    extends AbstractAction {
        public CopyListAction() {
            super(BPELStringTranslator.getString("EDITOR_CPY_RULE_TBL_PNL_CRE_RULE_COPYLIST"), ImageCache.getIcon("copylist_copyrule16"));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            CopyRuleTablePanel.this.performAdd(5);
        }
    }

    class AppendAction
    extends AbstractAction {
        public AppendAction() {
            super(BPELStringTranslator.getString("EDITOR_CPY_RULE_TBL_PNL_CRE_RULE_APPEND"), ImageCache.getIcon("append_copyrule16"));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            CopyRuleTablePanel.this.performAdd(2);
        }
    }

    class InsertAfterAction
    extends AbstractAction {
        public InsertAfterAction() {
            super(BPELStringTranslator.getString("EDITOR_CPY_RULE_TBL_PNL_CRE_RULE_INS_AFTER"), ImageCache.getIcon("insertafter_copyrule"));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            CopyRuleTablePanel.this.performAdd(3);
        }
    }

    class InsertBeforeAction
    extends AbstractAction {
        public InsertBeforeAction() {
            super(BPELStringTranslator.getString("EDITOR_CPY_RULE_TBL_PNL_CRE_RULE_INS_BEFORE"), ImageCache.getIcon("insertbefore_copyrule16"));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            CopyRuleTablePanel.this.performAdd(4);
        }
    }

    class CopyRuleAction
    extends AbstractAction {
        public CopyRuleAction() {
            super(BPELStringTranslator.getString("EDITOR_CPY_RULE_TBL_PNL_CRE_CP_RULE"), ImageCache.getIcon("copyrule16"));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            CopyRuleTablePanel.this.performAdd(1);
        }
    }
}

