/*
 * Decompiled with CFR 0.152.
 */
package oracle.tip.tools.ide.pm.bpelgraph.editors;

import oracle.tip.tools.ide.common.bpelparser.BPELParser;
import oracle.tip.tools.ide.common.bpelparser.extension.iface.Append;
import oracle.tip.tools.ide.common.bpelparser.extension.iface.CopyList;
import oracle.tip.tools.ide.common.bpelparser.extension.iface.FromOpType;
import oracle.tip.tools.ide.common.bpelparser.extension.iface.InsertAfter;
import oracle.tip.tools.ide.common.bpelparser.extension.iface.InsertBefore;
import oracle.tip.tools.ide.common.bpelparser.extension.iface.Remove;
import oracle.tip.tools.ide.common.bpelparser.extension.iface.Rename;
import oracle.tip.tools.ide.common.bpelparser.extension.iface.TargetOpType;
import oracle.tip.tools.ide.common.bpelparser.extension.iface.To;
import oracle.tip.tools.ide.common.bpelparser.extension.implementations.xmlef.TargetImpl;
import oracle.tip.tools.ide.common.bpelparser.iface.Activity;
import oracle.tip.tools.ide.common.bpelparser.iface.Copy;
import oracle.tip.tools.ide.common.bpelparser.iface.From;
import oracle.tip.tools.ide.pm.bpelgraph.editors.CopyDialogEditPage;
import oracle.tip.tools.ide.pm.bpelgraph.editors.CopyPageInputs;
import oracle.tip.tools.ide.pm.bpelgraph.editors.ExtGenCopyDialogEditPage;
import oracle.tip.tools.ide.pm.bpelgraph.editors.FromToOpTypeEditPage;
import oracle.tip.tools.ide.pm.bpelgraph.editors.RemoveEditPage;
import oracle.tip.tools.ide.pm.bpelgraph.editors.RenameEditPage;
import oracle.tip.tools.ide.pm.bpelgraph.views.BPELGraphPane;
import oracle.tip.tools.ide.pm.i18n.BPELStringTranslator;
import org.w3c.dom.Element;

public final class CopyPageFactory {
    public static final int COPY_RULE = 1;
    public static final int APPEND_RULE = 2;
    public static final int INSERT_AFTER_RULE = 3;
    public static final int INSERT_BEFORE_RULE = 4;
    public static final int COPYLIST_RULE = 5;
    public static final int REMOVE_RULE = 6;
    public static final int RENAME_RULE = 7;
    public static final int EXTENDED_GENERIC_COPY_RULE = 8;

    public static CopyDialogEditPage newCopyDialogEditPage(int type, BPELGraphPane pane, CopyPageInputs in) {
        Activity activity = (Activity)in.getData("Activity");
        Object copyRule = CopyPageFactory.createNewCopyRule(type, activity, in);
        return CopyPageFactory.createCopyDialogEditPage(type, copyRule, pane, in, false);
    }

    public static CopyDialogEditPage editCopyDialogEditPage(Object copyRule, BPELGraphPane pane, CopyPageInputs in) {
        int type = CopyPageFactory.getPageType(copyRule, in);
        return CopyPageFactory.createCopyDialogEditPage(type, copyRule, pane, in, true);
    }

    public static CopyDialogEditPage editCopyDialogEditPage(int type, Object copyRule, BPELGraphPane pane, CopyPageInputs in) {
        return CopyPageFactory.createCopyDialogEditPage(type, copyRule, pane, in, true);
    }

    public static String getEditPageTitle(Object obj, CopyPageInputs in) {
        int type = CopyPageFactory.getPageType(obj, in);
        String title = null;
        switch (type) {
            case 1: {
                title = BPELStringTranslator.getString("EDITOR_CPY_RULE_DLG_EDT_CP_RULE");
                break;
            }
            case 2: {
                title = BPELStringTranslator.getString("EDITOR_CPY_RULE_DLG_EDT_CP_RULE_APPEND");
                break;
            }
            case 3: {
                title = BPELStringTranslator.getString("EDITOR_CPY_RULE_DLG_EDT_CP_RULE_INS_AFTER");
                break;
            }
            case 4: {
                title = BPELStringTranslator.getString("EDITOR_CPY_RULE_DLG_EDT_CP_RULE_INS_BEFORE");
                break;
            }
            case 5: {
                title = BPELStringTranslator.getString("EDITOR_CPY_RULE_DLG_EDT_CP_RULE_COPYLIST");
                break;
            }
            case 6: {
                title = BPELStringTranslator.getString("EDITOR_CPY_RULE_DLG_EDT_CP_RULE_REMOVE");
                break;
            }
            case 7: {
                title = BPELStringTranslator.getString("EDITOR_CPY_RULE_DLG_EDT_CP_RULE_RENAME");
                break;
            }
            case 8: {
                Object o = in.getData("PageTitle");
                title = o == null ? BPELStringTranslator.getString("EDITOR_CPY_RULE_DLG_EDT_CP_RULE") : (String)o;
            }
        }
        return title;
    }

    public static String getCreatePageTitle(int type) {
        String title = null;
        switch (type) {
            case 1: {
                title = BPELStringTranslator.getString("EDITOR_CPY_RULE_DLG_CRE_CP_RULE");
                break;
            }
            case 2: {
                title = BPELStringTranslator.getString("EDITOR_CPY_RULE_DLG_CRE_CP_RULE_APPEND");
                break;
            }
            case 3: {
                title = BPELStringTranslator.getString("EDITOR_CPY_RULE_DLG_CRE_CP_RULE_INS_AFTER");
                break;
            }
            case 4: {
                title = BPELStringTranslator.getString("EDITOR_CPY_RULE_DLG_CRE_CP_RULE_INS_BEFORE");
                break;
            }
            case 5: {
                title = BPELStringTranslator.getString("EDITOR_CPY_RULE_DLG_CRE_CP_RULE_COPYLIST");
                break;
            }
            case 6: {
                title = BPELStringTranslator.getString("EDITOR_CPY_RULE_DLG_CRE_CP_RULE_REMOVE");
                break;
            }
            case 7: {
                title = BPELStringTranslator.getString("EDITOR_CPY_RULE_DLG_CRE_CP_RULE_RENAME");
            }
        }
        return title;
    }

    private static int getPageType(Object rule, CopyPageInputs in) {
        if (rule instanceof Copy) {
            if (in != null && in.getData("FromVariables") != null || in.getData("ToVariables") != null) {
                return 8;
            }
            return 1;
        }
        if (rule instanceof Append) {
            return 2;
        }
        if (rule instanceof InsertAfter) {
            return 3;
        }
        if (rule instanceof InsertBefore) {
            return 4;
        }
        if (rule instanceof CopyList) {
            return 5;
        }
        if (rule instanceof Remove) {
            return 6;
        }
        return 7;
    }

    private static CopyDialogEditPage createCopyDialogEditPage(int type, Object copyRule, BPELGraphPane pane, CopyPageInputs in, boolean isEditMode) {
        CopyDialogEditPage page = null;
        switch (type) {
            case 1: {
                page = new CopyDialogEditPage(pane, in, copyRule, isEditMode);
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                page = new FromToOpTypeEditPage(pane, in, copyRule, type, isEditMode);
                break;
            }
            case 6: {
                page = new RemoveEditPage(pane, in, copyRule, isEditMode);
                break;
            }
            case 7: {
                page = new RenameEditPage(pane, in, copyRule, isEditMode);
                break;
            }
            case 8: {
                page = new ExtGenCopyDialogEditPage(pane, in, copyRule, isEditMode);
            }
        }
        if (page != null) {
            page.init();
        }
        return page;
    }

    private static Object createNewCopyRule(int type, Activity activity, CopyPageInputs in) {
        Copy r = null;
        switch (type) {
            case 1: 
            case 8: {
                r = CopyPageFactory.createBPELCopyRule(activity);
                break;
            }
            case 2: {
                Append a = (Append)BPELParser.getImplementationFactory().createAssignOpType(Append.class, null);
                r = CopyPageFactory.createFromOpType(activity, (FromOpType)a);
                break;
            }
            case 3: {
                InsertAfter ia = (InsertAfter)BPELParser.getImplementationFactory().createAssignOpType(InsertAfter.class, null);
                r = CopyPageFactory.createFromOpType(activity, (FromOpType)ia);
                break;
            }
            case 4: {
                InsertBefore ib = (InsertBefore)BPELParser.getImplementationFactory().createAssignOpType(InsertBefore.class, null);
                r = CopyPageFactory.createFromOpType(activity, (FromOpType)ib);
                break;
            }
            case 5: {
                CopyList cl = (CopyList)BPELParser.getImplementationFactory().createAssignOpType(CopyList.class, null);
                r = CopyPageFactory.createFromOpType(activity, (FromOpType)cl);
                break;
            }
            case 6: {
                r = CopyPageFactory.createRemove(activity);
                break;
            }
            case 7: {
                r = CopyPageFactory.createRename(activity);
            }
        }
        return r;
    }

    private static Copy createBPELCopyRule(Activity activity) {
        Copy c = (Copy)BPELParser.createImplementation(Copy.class);
        Element assignElem = activity.getDOMElement();
        if (assignElem != null) {
            c.createDOMElement(assignElem.getOwnerDocument(), "http://schemas.xmlsoap.org/ws/2003/03/business-process/", true);
        }
        From from = (From)BPELParser.createImplementation(From.class);
        oracle.tip.tools.ide.common.bpelparser.iface.To to = (oracle.tip.tools.ide.common.bpelparser.iface.To)BPELParser.createImplementation(oracle.tip.tools.ide.common.bpelparser.iface.To.class);
        c.setFrom(from);
        c.setTo(to);
        return c;
    }

    private static FromOpType createFromOpType(Activity activity, FromOpType op) {
        Element assignElem = activity.getDOMElement();
        if (assignElem != null) {
            op.createDOMElement(assignElem.getOwnerDocument(), "http://schemas.oracle.com/bpel/extension", true);
        }
        oracle.tip.tools.ide.common.bpelparser.extension.iface.From from = (oracle.tip.tools.ide.common.bpelparser.extension.iface.From)BPELParser.createImplementation(oracle.tip.tools.ide.common.bpelparser.extension.iface.From.class);
        To to = (To)BPELParser.createImplementation(To.class);
        op.setFrom(from);
        op.setTo(to);
        return op;
    }

    private static TargetOpType createRemove(Activity activity) {
        Remove t = (Remove)BPELParser.getImplementationFactory().createAssignOpType(Remove.class, null);
        Element assignElem = activity.getDOMElement();
        if (assignElem != null) {
            t.createDOMElement(assignElem.getOwnerDocument(), "http://schemas.oracle.com/bpel/extension", true);
        }
        TargetImpl target = new TargetImpl();
        t.setTarget((To)target);
        return t;
    }

    private static Rename createRename(Activity activity) {
        Rename r = (Rename)BPELParser.getImplementationFactory().createAssignOpType(Rename.class, null);
        Element assignElem = activity.getDOMElement();
        if (assignElem != null) {
            r.createDOMElement(assignElem.getOwnerDocument(), "http://schemas.oracle.com/bpel/extension", true);
        }
        TargetImpl target = new TargetImpl();
        r.setTarget((To)target);
        return r;
    }
}

