/*
 * Decompiled with CFR 0.152.
 */
package oracle.tip.tools.ide.pm.bpelgraph.editors;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListCellRenderer;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.SwingUtilities;
import javax.swing.border.TitledBorder;
import javax.xml.namespace.QName;
import oracle.javatools.editor.BasicEditorPane;
import oracle.tip.tools.ide.common.bpeldesigner.models.schema.NSResolverFactory;
import oracle.tip.tools.ide.common.bpelparser.iface.Activity;
import oracle.tip.tools.ide.common.bpelparser.iface.Copy;
import oracle.tip.tools.ide.common.bpelparser.iface.From;
import oracle.tip.tools.ide.common.bpelparser.iface.PartnerLink;
import oracle.tip.tools.ide.common.bpelparser.iface.PartnerLinks;
import oracle.tip.tools.ide.common.bpelparser.iface.Process;
import oracle.tip.tools.ide.common.bpelparser.iface.To;
import oracle.tip.tools.ide.common.bpelparser.iface.Variable;
import oracle.tip.tools.ide.common.bpelparser.util.XMLHelper;
import oracle.tip.tools.ide.common.graph.GraphUtils;
import oracle.tip.tools.ide.common.ide.IDEResolver;
import oracle.tip.tools.ide.common.ui.CardPanel;
import oracle.tip.tools.ide.common.ui.ToolBar;
import oracle.tip.tools.ide.common.ui.UIHelper;
import oracle.tip.tools.ide.common.utils.MessagePart;
import oracle.tip.tools.ide.common.xpath.editor.XPathEditorPane;
import oracle.tip.tools.ide.common.xpath.editor.util.VariableDataCallBack;
import oracle.tip.tools.ide.pm.addin.model.BPELXmlModel;
import oracle.tip.tools.ide.pm.bpelgraph.editors.BaseEditingPage;
import oracle.tip.tools.ide.pm.bpelgraph.editors.CopyPageInputs;
import oracle.tip.tools.ide.pm.bpelgraph.editors.PMGeneralItem;
import oracle.tip.tools.ide.pm.bpelgraph.editors.PartnerLinkListItem;
import oracle.tip.tools.ide.pm.bpelgraph.editors.VariableDataCallBackImpl;
import oracle.tip.tools.ide.pm.bpelgraph.views.BPELGraphPane;
import oracle.tip.tools.ide.pm.gui.dialogs.variablexpathbuilder.VariableXPathBuilderPanel;
import oracle.tip.tools.ide.pm.gui.generalpurpose.GenericListCellRenderer;
import oracle.tip.tools.ide.pm.i18n.BPELStringTranslator;
import oracle.tip.tools.ide.pm.resources.images.ImageCache;

public class CopyDialogEditPage
extends BaseEditingPage
implements ActionListener {
    protected static final String FROM_VARIABLE_PANEL = "FROM_VARIABLE_PANEL";
    protected static final String FROM_EXPRESSION_PANEL = "FROM_EXPRESSION_PANEL";
    protected static final String FROM_LITERAL_PANEL = "FROM_LITERAL_PANEL";
    protected static final String FROM_PARTNERLINK_PANEL = "FROM_PARTNERLINK_PANEL";
    protected static final String TO_PARTNERLINK_PANEL = "TO_PARTNERLINK_PANEL";
    protected static final String TO_VARIABLE_PANEL = "TO_VARIABLE_PANEL";
    protected static final String ENDPOINT_REF_MY_ROLE = "myRole";
    protected static final String ENDPOINT_REF_PARTNER_ROLE = "partnerRole";
    protected static final String EDIT = "Edit";
    protected static final String CREATE = "Create";
    protected static final int FROM_SEL_VAR = 0;
    protected static final int FROM_SEL_EXP = 1;
    protected static final int FROM_SEL_LIT = 2;
    protected static final int FROM_SEL_PARTNER = 3;
    protected static final int TO_SEL_VAR = 0;
    protected static final int TO_SEL_PARTNER = 1;
    protected JComboBox m_fromTypeCB;
    protected VariableXPathBuilderPanel m_fromXPathBuilderPnl;
    protected JScrollPane m_fromExpScrollPane;
    protected XPathEditorPane m_fromExpXPathBuilder;
    protected JButton m_expressionBuilderBtn;
    protected BasicEditorPane m_fromLiteral;
    protected JPopupMenu m_popup;
    protected JMenuItem m_cutMenu;
    protected JMenuItem m_copyMenu;
    protected JMenuItem m_pasteMenu;
    protected JMenuItem m_delMenu;
    protected JMenuItem m_selAllMenu;
    protected JComboBox m_fromPartnerCB;
    protected JButton m_newFromPartnerLinkBtn;
    protected JComboBox m_fromEndpointCB;
    protected VariableXPathBuilderPanel m_toXPathBuilderPnl;
    protected JComboBox m_toTypeCB;
    protected JComboBox m_toPartnerCB;
    protected JButton m_newToPartnerLinkBtn;
    protected JRadioButton m_toPartnerLinkRadioBtn;
    protected Object m_copyRule;
    protected String m_initFromXPath;
    protected String m_initToXPath;
    protected Activity m_assignActivity;
    private int m_counter = 0;
    protected Component m_focusComponent;
    protected CardPanel m_toCardPnl;
    protected CardPanel m_fromCardPnl;
    protected CopyPageInputs m_pageInputs;
    protected boolean inEditMode;
    private String helpTopicId;

    protected CopyDialogEditPage(BPELGraphPane pane, CopyPageInputs in, Object copyRule, boolean editMode) {
        super(pane);
        this.m_pageInputs = in;
        this.m_assignActivity = this.m_pageInputs.getActivity();
        this.m_copyRule = copyRule;
        this.inEditMode = editMode;
    }

    public void init() {
        this.createControls();
        this.layoutControls();
    }

    protected void createControls() {
        this.createFromControls();
        this.createToControls();
    }

    protected void layoutControls() {
        JPanel p = new JPanel(new GridLayout(1, 2, 5, 5));
        if (this.showFromPanel()) {
            p.add(this.getFromPanel());
        }
        if (this.showToPanel()) {
            p.add(this.getToPanel());
        }
        this.setLayout(new GridBagLayout());
        GraphUtils.addComponent((Container)this, (Component)p, (int)0, (int)0, (int)1, (int)1, (int)17, (int)1, (Insets)new Insets(0, 0, 0, 0), (int)0, (int)0, (double)1.0, (double)1.0);
    }

    protected boolean showFromPanel() {
        return true;
    }

    protected boolean showToPanel() {
        return true;
    }

    protected void createFromControls() {
        this.m_fromTypeCB = new JComboBox();
        this.populateFromTypeCB();
        this.m_fromTypeCB.setRenderer(new MyListCellRenderer(this.m_fromTypeCB));
        this.m_fromTypeCB.setSelectedIndex(0);
        this.m_fromTypeCB.addActionListener(this);
        this.m_fromExpXPathBuilder = new XPathEditorPane();
        this.m_fromExpScrollPane = new JScrollPane((Component)this.m_fromExpXPathBuilder);
        this.m_fromExpXPathBuilder.setEditable(true);
        this.m_expressionBuilderBtn = UIHelper.createModelerButton((Icon)ImageCache.getIcon("expressionbuilder"));
        this.m_expressionBuilderBtn.setToolTipText(BPELStringTranslator.getString("XPATH_EXPRESSSION_BUILDER", "XPath Expression Builder..."));
        this.m_expressionBuilderBtn.addActionListener(this);
        this.m_fromLiteral = new BasicEditorPane();
        this.m_fromLiteral.setLanguageSupport("Temp.xml");
        this.m_fromLiteral.addMouseListener((MouseListener)new PopupListener());
        this.m_fromPartnerCB = new JComboBox();
        this.m_fromPartnerCB.setRenderer(new GenericListCellRenderer(ImageCache.getIcon("partner_link_node")));
        this.m_fromEndpointCB = new JComboBox();
        this.m_fromEndpointCB.setRenderer(new GenericListCellRenderer(ImageCache.getIcon("partner_link_node")));
        this.m_newFromPartnerLinkBtn = UIHelper.createModelerButton((Icon)ImageCache.getIcon("create16"));
        this.m_fromPartnerCB.setRenderer(new GenericListCellRenderer(ImageCache.getIcon("partner_link_node")));
        this.m_fromPartnerCB.addActionListener(this);
        this.m_newFromPartnerLinkBtn.setToolTipText(BPELStringTranslator.getString("EDITOR_PLD_CREATE_TITLE") + "...");
        this.m_newFromPartnerLinkBtn.addActionListener(this);
        this.m_fromCardPnl = this.createFromCardPanel();
    }

    protected void populateFromTypeCB() {
        DefaultComboBoxModel<String> model = new DefaultComboBoxModel<String>();
        model.addElement(BPELStringTranslator.getString("EDITOR_ACT_VAR_SEN_TBL_VAR"));
        model.addElement(BPELStringTranslator.getString("EDITOR_CPY_EDIT_FROM_EXP_SEL"));
        model.addElement(BPELStringTranslator.getString("EDITOR_CPY_EDIT_FROM_LIT_SEL"));
        model.addElement(BPELStringTranslator.getString("EDITOR_CPY_EDIT_FROM_PL_SEL"));
        this.m_fromTypeCB.setModel(model);
    }

    protected void createToControls() {
        this.m_toTypeCB = new JComboBox();
        this.m_toTypeCB.setRenderer(new MyListCellRenderer(this.m_toTypeCB));
        this.populateToTypeCB();
        this.m_toTypeCB.setSelectedIndex(0);
        this.m_toTypeCB.addActionListener(this);
        this.m_toPartnerCB = new JComboBox();
        this.m_newToPartnerLinkBtn = UIHelper.createModelerButton((Icon)ImageCache.getIcon("create16"));
        this.m_newToPartnerLinkBtn.setToolTipText(BPELStringTranslator.getString("EDITOR_PLD_CREATE_TITLE") + "...");
        this.m_newToPartnerLinkBtn.addActionListener(this);
        this.m_toPartnerCB.setRenderer(new GenericListCellRenderer(ImageCache.getIcon("partner_link_node")));
        this.m_toCardPnl = this.createToCardPanel();
    }

    protected void populateToTypeCB() {
        this.m_toTypeCB.addItem(BPELStringTranslator.getString("EDITOR_ACT_VAR_SEN_TBL_VAR"));
        this.m_toTypeCB.addItem(BPELStringTranslator.getString("EDITOR_CPY_EDIT_FROM_PL_SEL"));
    }

    protected JPanel getFromPanel() {
        JPanel fromPanel = new JPanel(new GridBagLayout());
        TitledBorder b = new TitledBorder(" " + BPELStringTranslator.getString("EDITOR_CPY_EDIT_FROM") + " ");
        fromPanel.setBorder(b);
        fromPanel.setOpaque(false);
        JLabel lblFrom = new JLabel();
        BPELStringTranslator.setLabel(lblFrom, this.m_fromTypeCB, BPELStringTranslator.getString("EDITOR_COR_SET_PNL_TYPE"));
        int row = 0;
        GraphUtils.addComponent((Container)fromPanel, (Component)lblFrom, (int)0, (int)row, (int)1, (int)1, (int)17, (int)0, (Insets)new Insets(5, 5, 0, 0), (int)0, (int)0, (double)0.0, (double)0.0);
        GraphUtils.addComponent((Container)fromPanel, (Component)this.m_fromTypeCB, (int)1, (int)row++, (int)1, (int)1, (int)17, (int)2, (Insets)new Insets(5, 5, 0, 5), (int)0, (int)0, (double)1.0, (double)0.0);
        GraphUtils.addComponent((Container)fromPanel, (Component)new JSeparator(), (int)0, (int)row++, (int)2, (int)1, (int)17, (int)2, (Insets)new Insets(10, 5, 10, 5), (int)0, (int)0, (double)1.0, (double)0.0);
        GraphUtils.addComponent((Container)fromPanel, (Component)this.m_fromCardPnl, (int)0, (int)row++, (int)2, (int)1, (int)17, (int)1, (Insets)new Insets(0, 0, 0, 0), (int)0, (int)0, (double)1.0, (double)1.0);
        return fromPanel;
    }

    protected CardPanel createFromCardPanel() {
        CardPanel fromCardPnl = new CardPanel();
        fromCardPnl.add(FROM_VARIABLE_PANEL, (Component)this.createFromVarPanel());
        fromCardPnl.add(FROM_EXPRESSION_PANEL, (Component)this.createFromExpressionPanel());
        fromCardPnl.add(FROM_LITERAL_PANEL, (Component)this.createFromLiteralPanel());
        fromCardPnl.add(FROM_PARTNERLINK_PANEL, (Component)this.createFromPartnerPanel());
        return fromCardPnl;
    }

    protected CardPanel createToCardPanel() {
        CardPanel toCardPnl = new CardPanel();
        toCardPnl.add(TO_VARIABLE_PANEL, (Component)this.createToVariablePanel());
        toCardPnl.add(TO_PARTNERLINK_PANEL, (Component)this.createToPartnerLinkPanel());
        return toCardPnl;
    }

    protected JPanel getToPanel() {
        JPanel toPanel = new JPanel(new GridBagLayout());
        TitledBorder b = new TitledBorder(" " + BPELStringTranslator.getString("EDITOR_CPY_EDIT_TO") + " ");
        toPanel.setBorder(b);
        toPanel.setOpaque(false);
        int row = 0;
        if (this.showToTypeCB()) {
            JLabel lbl = new JLabel();
            BPELStringTranslator.setLabel(lbl, this.m_toTypeCB, BPELStringTranslator.getString("EDITOR_COR_SET_PNL_TYPE2"));
            GraphUtils.addComponent((Container)toPanel, (Component)lbl, (int)0, (int)row, (int)1, (int)1, (int)10, (int)0, (Insets)new Insets(5, 5, 5, 0), (int)0, (int)0, (double)0.0, (double)0.0);
            GraphUtils.addComponent((Container)toPanel, (Component)this.m_toTypeCB, (int)1, (int)row++, (int)1, (int)1, (int)10, (int)2, (Insets)new Insets(5, 5, 5, 5), (int)0, (int)0, (double)1.0, (double)0.0);
            GraphUtils.addComponent((Container)toPanel, (Component)new JSeparator(), (int)0, (int)row++, (int)2, (int)1, (int)17, (int)2, (Insets)new Insets(5, 5, 10, 5), (int)0, (int)0, (double)1.0, (double)0.0);
        }
        GraphUtils.addComponent((Container)toPanel, (Component)this.m_toCardPnl, (int)0, (int)row++, (int)2, (int)1, (int)10, (int)1, (Insets)new Insets(0, 0, 0, 0), (int)0, (int)0, (double)1.0, (double)1.0);
        return toPanel;
    }

    protected boolean showToTypeCB() {
        return this.m_toTypeCB.getModel().getSize() > 1;
    }

    protected JPanel createFromVarPanel() {
        JPanel variablePanel = new JPanel(new GridBagLayout());
        this.m_fromXPathBuilderPnl = new VariableXPathBuilderPanel(this.m_graphPane);
        GraphUtils.addComponent((Container)variablePanel, (Component)this.m_fromXPathBuilderPnl, (int)0, (int)0, (int)1, (int)1, (int)17, (int)1, (Insets)new Insets(0, 0, 0, 0), (int)0, (int)0, (double)1.0, (double)1.0);
        return variablePanel;
    }

    protected JPanel createFromExpressionPanel() {
        JPanel expressionPanel = new JPanel(new GridBagLayout());
        JLabel lblExpression = new JLabel();
        BPELStringTranslator.setLabel(lblExpression, (Component)this.m_fromExpXPathBuilder, BPELStringTranslator.getString("EDITOR_CPY_EDIT_FROM_EXP"));
        ToolBar tb = new ToolBar();
        tb.setBorderInsets(new Insets(0, 0, 0, 0));
        tb.add((Component)this.m_expressionBuilderBtn);
        GraphUtils.addComponent((Container)expressionPanel, (Component)lblExpression, (int)0, (int)0, (int)1, (int)1, (int)16, (int)0, (Insets)new Insets(0, 5, 2, 5), (int)0, (int)0, (double)0.0, (double)0.0);
        GraphUtils.addComponent((Container)expressionPanel, (Component)tb, (int)1, (int)0, (int)1, (int)1, (int)13, (int)0, (Insets)new Insets(0, 5, 0, 0), (int)0, (int)0, (double)1.0, (double)0.0);
        GraphUtils.addComponent((Container)expressionPanel, (Component)this.m_fromExpScrollPane, (int)0, (int)1, (int)2, (int)1, (int)17, (int)1, (Insets)new Insets(0, 5, 5, 5), (int)0, (int)0, (double)1.0, (double)1.0);
        return expressionPanel;
    }

    protected JPanel createFromLiteralPanel() {
        JPanel literalPanel = new JPanel(new GridBagLayout());
        JLabel lblLiteral = new JLabel();
        BPELStringTranslator.setLabel(lblLiteral, (Component)this.m_fromLiteral, BPELStringTranslator.getString("EDITOR_CPY_EDIT_FROM_LIT"));
        GraphUtils.addComponent((Container)literalPanel, (Component)lblLiteral, (int)0, (int)0, (int)1, (int)1, (int)17, (int)0, (Insets)new Insets(0, 5, 0, 5), (int)0, (int)0, (double)1.0, (double)0.0);
        JScrollPane areaScrollPane = new JScrollPane((Component)this.m_fromLiteral);
        areaScrollPane.setMinimumSize(new Dimension(300, 75));
        GraphUtils.addComponent((Container)literalPanel, (Component)areaScrollPane, (int)0, (int)1, (int)1, (int)0, (int)17, (int)1, (Insets)new Insets(2, 5, 5, 5), (int)0, (int)1, (double)1.0, (double)1.0);
        return literalPanel;
    }

    protected JPanel createFromPartnerPanel() {
        JPanel plPanel = new JPanel(new GridBagLayout());
        JLabel lblFromPartner = new JLabel();
        JLabel lblFromEndpoint = new JLabel();
        ToolBar partnerLinkTB = new ToolBar();
        partnerLinkTB.setBorderInsets(new Insets(0, 0, 0, 0));
        partnerLinkTB.add((Component)this.m_newFromPartnerLinkBtn);
        BPELStringTranslator.setLabel(lblFromPartner, this.m_fromPartnerCB, BPELStringTranslator.getString("EDITOR_CPY_EDIT_FROM_PL"));
        BPELStringTranslator.setLabel(lblFromEndpoint, this.m_fromEndpointCB, BPELStringTranslator.getString("EDITOR_CPY_EDIT_FROM_ENDPTREF"));
        GraphUtils.addComponent((Container)plPanel, (Component)lblFromPartner, (int)0, (int)0, (int)1, (int)1, (int)17, (int)2, (Insets)new Insets(0, 5, 0, 5), (int)0, (int)0, (double)0.0, (double)0.0);
        GraphUtils.addComponent((Container)plPanel, (Component)this.m_fromPartnerCB, (int)0, (int)1, (int)1, (int)1, (int)17, (int)2, (Insets)new Insets(2, 5, 0, 0), (int)0, (int)0, (double)1.0, (double)0.0);
        GraphUtils.addComponent((Container)plPanel, (Component)partnerLinkTB, (int)1, (int)1, (int)1, (int)1, (int)17, (int)0, (Insets)new Insets(3, 4, 0, 5), (int)0, (int)0, (double)0.0, (double)0.0);
        GraphUtils.addComponent((Container)plPanel, (Component)lblFromEndpoint, (int)0, (int)2, (int)1, (int)1, (int)17, (int)0, (Insets)new Insets(5, 5, 0, 5), (int)0, (int)0, (double)0.0, (double)0.0);
        GraphUtils.addComponent((Container)plPanel, (Component)this.m_fromEndpointCB, (int)0, (int)3, (int)1, (int)1, (int)18, (int)2, (Insets)new Insets(2, 5, 5, 0), (int)0, (int)0, (double)1.0, (double)1.0);
        return plPanel;
    }

    protected JPanel createToVariablePanel() {
        JPanel variablePanel = new JPanel(new GridBagLayout());
        this.m_toXPathBuilderPnl = new VariableXPathBuilderPanel(this.m_graphPane);
        GraphUtils.addComponent((Container)variablePanel, (Component)this.m_toXPathBuilderPnl, (int)0, (int)0, (int)1, (int)1, (int)17, (int)1, (Insets)new Insets(0, 0, 0, 0), (int)0, (int)0, (double)1.0, (double)1.0);
        return variablePanel;
    }

    protected JPanel createToPartnerLinkPanel() {
        JPanel toPartnerPanel = new JPanel(new GridBagLayout());
        JLabel lblToPartner = new JLabel();
        BPELStringTranslator.setLabel(lblToPartner, this.m_toPartnerCB, BPELStringTranslator.getString("EDITOR_CPY_EDIT_TO_PL"));
        ToolBar partnerLinkTB = new ToolBar();
        partnerLinkTB.setBorderInsets(new Insets(0, 0, 0, 0));
        partnerLinkTB.add((Component)this.m_newToPartnerLinkBtn);
        GraphUtils.addComponent((Container)toPartnerPanel, (Component)lblToPartner, (int)0, (int)0, (int)1, (int)1, (int)17, (int)0, (Insets)new Insets(0, 5, 0, 5), (int)0, (int)0, (double)1.0, (double)0.0);
        GraphUtils.addComponent((Container)toPartnerPanel, (Component)this.m_toPartnerCB, (int)0, (int)1, (int)1, (int)1, (int)18, (int)2, (Insets)new Insets(3, 5, 5, 2), (int)0, (int)0, (double)1.0, (double)1.0);
        GraphUtils.addComponent((Container)toPartnerPanel, (Component)partnerLinkTB, (int)1, (int)1, (int)1, (int)1, (int)18, (int)2, (Insets)new Insets(0, 2, 0, 5), (int)0, (int)0, (double)0.0, (double)1.0);
        return toPartnerPanel;
    }

    public boolean checkValidInput() {
        int sel = this.m_fromTypeCB.getSelectedIndex();
        if (sel != -1 && sel == 2) {
            boolean bRet = XMLHelper.isValidXMLSegment((String)this.m_fromLiteral.getText());
            if (!bRet) {
                IDEResolver.getIDE().displayMessage((Component)((Object)this.m_graphPane), BPELStringTranslator.getString("EDITOR_CPY_EDIT_INVALID_LITERAL"), BPELStringTranslator.getString("GENERAL_EDITOR_ERROR"), 0);
            }
            return bRet;
        }
        return true;
    }

    public Object getCopyRule() {
        return this.m_copyRule;
    }

    public void populateCopyInfo() {
        From from = ((Copy)this.m_copyRule).getFrom();
        To to = ((Copy)this.m_copyRule).getTo();
        int sel = this.m_fromTypeCB.getSelectedIndex();
        if (sel == 1) {
            from.setExpression(this.m_fromExpXPathBuilder.getText());
            from.setVariable(null);
            from.setPart(null);
            from.setQuery(null);
            from.setLiteral(null);
            from.setPartnerLink(null);
            from.setEndpointReference(null);
            this.m_fromExpXPathBuilder.saveCachedNS();
        } else if (sel == 0) {
            from.setExpression(null);
            from.setLiteral(null);
            from.setPartnerLink(null);
            from.setEndpointReference(null);
            Variable v = this.m_fromXPathBuilderPnl.getVariable();
            if (v != null) {
                from.setVariable(v.getName());
            } else {
                from.setVariable(null);
            }
            MessagePart p = this.m_fromXPathBuilderPnl.getPart();
            if (p != null) {
                from.setPart(p.getName());
            } else {
                from.setPart(null);
            }
            String xpath = this.m_fromXPathBuilderPnl.getXPath();
            from.setQuery(xpath);
            this.m_fromXPathBuilderPnl.saveCachedNS();
        } else if (sel == 2) {
            from.setLiteral(this.m_fromLiteral.getText());
            from.setExpression(null);
            from.setVariable(null);
            from.setPart(null);
            from.setQuery(null);
            from.setPartnerLink(null);
            from.setEndpointReference(null);
        } else if (sel == 3) {
            from.setLiteral(null);
            from.setExpression(null);
            from.setVariable(null);
            from.setPart(null);
            from.setQuery(null);
            from.setPartnerLink(this.getSelectedPartnerLink(this.m_fromPartnerCB));
            PMGeneralItem item = (PMGeneralItem)this.m_fromEndpointCB.getSelectedItem();
            if (item != null) {
                from.setEndpointReference(item.getValue());
            } else {
                from.setEndpointReference(null);
            }
        }
        int toSelection = this.m_toTypeCB.getSelectedIndex();
        if (toSelection == 0) {
            Variable v = this.m_toXPathBuilderPnl.getVariable();
            if (v != null) {
                to.setVariable(v.getName());
            } else {
                to.setVariable(null);
            }
            MessagePart p = this.m_toXPathBuilderPnl.getPart();
            if (p != null) {
                to.setPart(p.getName());
            } else {
                to.setPart(null);
            }
            String xpath = this.m_toXPathBuilderPnl.getXPath();
            to.setQuery(xpath);
            to.setPartnerLink(null);
            this.m_toXPathBuilderPnl.saveCachedNS();
        } else {
            to.setVariable(null);
            to.setPart(null);
            to.setQuery(null);
            to.setPartnerLink(this.getSelectedPartnerLink(this.m_toPartnerCB));
        }
    }

    public void loadControls() {
        this.enableUserInput(false);
        Runnable r = new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                try {
                    CopyDialogEditPage.this.doLoad();
                }
                finally {
                    CopyDialogEditPage.this.enableUserInput(true);
                }
            }
        };
        if (SwingUtilities.isEventDispatchThread()) {
            r.run();
        } else {
            SwingUtilities.invokeLater(r);
        }
    }

    protected void doLoad() {
        String initXPath = null;
        try {
            this.m_fromXPathBuilderPnl.load(this.m_assignActivity);
            this.m_toXPathBuilderPnl.load(this.m_assignActivity);
        }
        catch (Exception e) {
            e.printStackTrace();
            GraphUtils.displayMessage((Component)this, (String)e.getMessage(), (int)0);
        }
        if (this.m_copyRule != null) {
            initXPath = this.loadCopyRule();
        } else {
            this.loadPartnerLinksAndEndPoint(this.m_fromPartnerCB, null, this.m_fromEndpointCB, null);
            this.loadPartnerLinks(this.m_toPartnerCB);
        }
        this.m_nsResolver = NSResolverFactory.getNSResolver((Activity)this.m_assignActivity, (Process)this.m_processModel);
        BPELXmlModel mainModel = this.m_graphPane.getBPELXmlModel();
        VariableDataCallBackImpl dataCallBack = new VariableDataCallBackImpl(mainModel, this.m_assignActivity, this.m_nsResolver);
        this.m_fromExpXPathBuilder.initializeDocument();
        this.m_fromExpXPathBuilder.initializeEditorPane((VariableDataCallBack)dataCallBack, initXPath, this.m_nsResolver);
    }

    protected String loadCopyRule() {
        String initXPath = null;
        From from = ((Copy)this.m_copyRule).getFrom();
        if (from != null) {
            initXPath = from.getExpression();
        }
        this.loadFrom(from);
        this.loadTo(((Copy)this.m_copyRule).getTo());
        return initXPath;
    }

    protected void loadFrom(final From from) {
        String plName = null;
        String endPoint = null;
        if (from != null) {
            if (from.getExpression() != null) {
                this.m_fromTypeCB.setSelectedIndex(1);
                this.m_focusComponent = this.m_fromExpXPathBuilder;
            } else if (from.getVariable() != null) {
                String varName = from.getVariable();
                String partName = from.getPart();
                String query = from.getQuery();
                boolean bSucceeded = false;
                if (varName != null && partName != null) {
                    bSucceeded = this.m_fromXPathBuilderPnl.selectVariablePart(varName, partName, this.m_assignActivity, from.getQuery());
                }
                if (!bSucceeded && varName != null && query != null) {
                    List qnames = this.parseToQNames(query);
                    bSucceeded = this.m_fromXPathBuilderPnl.selectVariableXPathNode(varName, qnames, this.m_assignActivity);
                }
                if (!bSucceeded && varName != null) {
                    this.m_fromXPathBuilderPnl.selectVariable(varName, this.m_assignActivity);
                }
                if (SwingUtilities.isEventDispatchThread()) {
                    this.m_fromXPathBuilderPnl.setXPath(from.getQuery());
                } else {
                    Runnable r = new Runnable(){

                        @Override
                        public void run() {
                            CopyDialogEditPage.this.m_fromXPathBuilderPnl.setXPath(from.getQuery());
                        }
                    };
                    SwingUtilities.invokeLater(r);
                }
            } else if (from.getLiteral() != null) {
                this.m_fromLiteral.setText(from.getLiteral());
                this.m_fromTypeCB.setSelectedIndex(2);
                this.m_focusComponent = this.m_fromLiteral;
            } else if (from.getPartnerLink() != null) {
                this.m_fromTypeCB.setSelectedIndex(3);
                this.m_focusComponent = this.m_fromPartnerCB;
                plName = from.getPartnerLink();
                endPoint = from.getEndpointReference();
            }
        }
        this.loadPartnerLinksAndEndPoint(this.m_fromPartnerCB, plName, this.m_fromEndpointCB, endPoint);
    }

    protected List parseToQNames(String query) {
        Process process = this.m_graphModel.getProcess();
        StringTokenizer st = new StringTokenizer(query, "/");
        ArrayList<QName> l = new ArrayList<QName>();
        while (st.hasMoreTokens()) {
            String tok = st.nextToken();
            if (tok != null && tok.startsWith("@")) {
                tok = tok.substring(1);
            }
            String prefix = null;
            String local = null;
            int index = tok.indexOf(":");
            if (index != -1) {
                prefix = tok.substring(0, index);
                local = tok.substring(index + 1);
            } else {
                local = tok;
            }
            QName qname = null;
            if (prefix != null) {
                String ns = process.getNamespaceForPrefix(prefix);
                qname = new QName(ns, local, prefix);
            } else {
                qname = new QName("", local, "");
            }
            if (qname == null) continue;
            l.add(qname);
        }
        return l;
    }

    protected void loadTo(final To to) {
        if (to != null && to.getVariable() != null) {
            this.m_toTypeCB.setSelectedIndex(0);
            String varName = to.getVariable();
            String partName = to.getPart();
            String query = to.getQuery();
            boolean bSucceeded = false;
            if (varName != null && partName != null) {
                bSucceeded = this.m_toXPathBuilderPnl.selectVariablePart(varName, partName, this.m_assignActivity, to.getQuery());
            }
            if (!bSucceeded && varName != null && query != null) {
                List qnames = this.parseToQNames(query);
                bSucceeded = this.m_toXPathBuilderPnl.selectVariableXPathNode(varName, qnames, this.m_assignActivity);
            }
            if (!bSucceeded && varName != null) {
                this.m_toXPathBuilderPnl.selectVariable(varName, this.m_assignActivity);
            }
            Runnable r = new Runnable(){

                @Override
                public void run() {
                    CopyDialogEditPage.this.m_toXPathBuilderPnl.setXPath(to.getQuery());
                }
            };
            SwingUtilities.invokeLater(r);
            this.loadPartnerLinks(this.m_toPartnerCB);
        } else if (to != null && to.getPartnerLink() != null) {
            this.m_toTypeCB.setSelectedIndex(1);
            this.loadPartnerLinksAndEndPoint(this.m_toPartnerCB, to.getPartnerLink(), null, null);
        } else {
            this.loadPartnerLinks(this.m_toPartnerCB);
        }
    }

    protected void loadPartnerLinksAndEndPoint(final JComboBox cb, final String name, final JComboBox endptCombo, final String endPoint) {
        PartnerLinks links = this.m_processModel.getPartnerLinks();
        if (links != null) {
            List lst = links.getPartnerLinks();
            final DefaultComboBoxModel<PartnerLinkListItem> model = new DefaultComboBoxModel<PartnerLinkListItem>();
            for (PartnerLink pl : lst) {
                PartnerLinkListItem item = new PartnerLinkListItem(pl);
                model.addElement(item);
                if (name == null || pl.getName() == null || !name.equals(pl.getName())) continue;
                model.setSelectedItem(item);
            }
            Runnable r = new Runnable(){

                @Override
                public void run() {
                    cb.setModel(model);
                    if ((name == null || cb.getSelectedIndex() == -1) && model.getSize() > 0) {
                        cb.setSelectedIndex(0);
                    }
                    if (endptCombo != null) {
                        CopyDialogEditPage.this.handleEndPointReference(cb, endptCombo, endPoint);
                    }
                }
            };
            if (SwingUtilities.isEventDispatchThread()) {
                r.run();
            } else {
                SwingUtilities.invokeLater(r);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void enableUserInput(boolean bEnable) {
        CopyDialogEditPage copyDialogEditPage = this;
        synchronized (copyDialogEditPage) {
            if (bEnable) {
                if (--this.m_counter == 0) {
                    super.enableUserInput(bEnable);
                }
            } else if (++this.m_counter == 1) {
                super.enableUserInput(bEnable);
            }
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Object src = e.getSource();
        if (src == this.m_cutMenu) {
            this.m_fromLiteral.cut();
        } else if (src == this.m_copyMenu) {
            this.m_fromLiteral.copy();
        } else if (src == this.m_pasteMenu) {
            this.m_fromLiteral.paste();
        } else if (src == this.m_delMenu) {
            int start = this.m_fromLiteral.getSelectionStart();
            int end = this.m_fromLiteral.getSelectionEnd();
            String text = null;
            try {
                text = this.m_fromLiteral.getText();
            }
            catch (NullPointerException ex) {
                // empty catch block
            }
            if (text != null) {
                text = start == 0 && end == text.length() ? "" : text.substring(0, start) + text.substring(end, text.length());
                this.m_fromLiteral.setText(text);
            }
        } else if (src == this.m_selAllMenu) {
            this.m_fromLiteral.requestFocus();
            this.m_fromLiteral.selectAll();
        } else if (src == this.m_newFromPartnerLinkBtn || src == this.m_newToPartnerLinkBtn) {
            this.handleNewPartnerLink(src);
        } else if (src == this.m_fromPartnerCB) {
            this.handleEndPointReference(this.m_fromPartnerCB, this.m_fromEndpointCB, null);
        } else if (src == this.m_fromTypeCB) {
            this.swapFromPanels();
        } else if (src == this.m_expressionBuilderBtn) {
            this.invokeGraphicalXPathBuilder(this.m_fromExpXPathBuilder, this.m_assignActivity);
        } else if (src == this.m_toPartnerLinkRadioBtn) {
            this.m_toCardPnl.show(TO_PARTNERLINK_PANEL);
        } else if (src == this.m_toTypeCB) {
            this.swapToPanels();
        }
    }

    protected void handleNewPartnerLink(Object btn) {
        PartnerLink link = this.m_graphPane.createPartnerLink(null);
        if (link != null) {
            PartnerLinkListItem item = new PartnerLinkListItem(link);
            DefaultComboBoxModel m1 = (DefaultComboBoxModel)this.m_fromPartnerCB.getModel();
            DefaultComboBoxModel m2 = (DefaultComboBoxModel)this.m_toPartnerCB.getModel();
            m1.addElement(item);
            m2.addElement(item);
            if (btn == this.m_newFromPartnerLinkBtn) {
                m1.setSelectedItem(item);
                this.handleEndPointReference(this.m_fromPartnerCB, this.m_fromEndpointCB, null);
            } else {
                m2.setSelectedItem(item);
            }
        }
    }

    protected void handleEndPointReference(JComboBox plCombo, JComboBox endptCombo, String endPoint) {
        PartnerLinkListItem item = (PartnerLinkListItem)plCombo.getSelectedItem();
        if (item != null) {
            PMGeneralItem pmItem;
            DefaultComboBoxModel m = (DefaultComboBoxModel)endptCombo.getModel();
            m.removeAllElements();
            if (item.getPartnerLink().getMyRole() != null) {
                pmItem = new PMGeneralItem(ENDPOINT_REF_MY_ROLE, "EDITOR_CPY_EDIT_FROM_MYROLE");
                m.addElement(pmItem);
                if (endPoint != null && ENDPOINT_REF_MY_ROLE.equals(endPoint)) {
                    m.setSelectedItem(pmItem);
                }
            }
            if (item.getPartnerLink().getPartnerRole() != null) {
                pmItem = new PMGeneralItem(ENDPOINT_REF_PARTNER_ROLE, "EDITOR_CPY_EDIT_FROM_PLROLE");
                m.addElement(pmItem);
                if (endPoint != null && ENDPOINT_REF_PARTNER_ROLE.equals(endPoint)) {
                    m.setSelectedItem(pmItem);
                }
            }
            if (endPoint == null && endptCombo.getItemCount() != 0) {
                endptCombo.setSelectedIndex(0);
            }
        } else {
            endptCombo.removeAllItems();
        }
    }

    protected void handlePopupMenu(MouseEvent e) {
        if (!this.m_fromLiteral.isEnabled()) {
            return;
        }
        if (e.isPopupTrigger()) {
            if (this.m_popup == null) {
                this.m_popup = new JPopupMenu();
                this.m_cutMenu = new JMenuItem(BPELStringTranslator.getString("EDIT_CUT_TEXT"));
                this.m_cutMenu.addActionListener(this);
                this.m_popup.add(this.m_cutMenu);
                this.m_copyMenu = new JMenuItem(BPELStringTranslator.getString("EDIT_COPY_TEXT"));
                this.m_copyMenu.addActionListener(this);
                this.m_popup.add(this.m_copyMenu);
                this.m_pasteMenu = new JMenuItem(BPELStringTranslator.getString("EDIT_PASTE_TEXT"));
                this.m_pasteMenu.addActionListener(this);
                this.m_popup.add(this.m_pasteMenu);
                this.m_delMenu = new JMenuItem(BPELStringTranslator.getString("DEL_BUTTON_TEXT"));
                this.m_delMenu.addActionListener(this);
                this.m_popup.add(this.m_delMenu);
                this.m_popup.addSeparator();
                this.m_selAllMenu = new JMenuItem(BPELStringTranslator.getString("EDIT_SELECT_ALL_TEXT"));
                this.m_selAllMenu.addActionListener(this);
                this.m_popup.add(this.m_selAllMenu);
            }
            if (this.m_fromLiteral.getSelectedText() != null) {
                this.m_cutMenu.setEnabled(true);
                this.m_copyMenu.setEnabled(true);
                this.m_delMenu.setEnabled(true);
            } else {
                this.m_cutMenu.setEnabled(false);
                this.m_copyMenu.setEnabled(false);
                this.m_delMenu.setEnabled(false);
            }
            this.m_pasteMenu.setEnabled(this.isTextAvailable());
            this.m_popup.show(e.getComponent(), e.getX(), e.getY());
        }
    }

    protected void swapToPanels() {
        int sel = this.m_toTypeCB.getSelectedIndex();
        switch (sel) {
            case 1: {
                this.m_toCardPnl.show(TO_PARTNERLINK_PANEL);
                break;
            }
            default: {
                this.m_toCardPnl.show(TO_VARIABLE_PANEL);
            }
        }
    }

    protected void swapFromPanels() {
        int sel = this.m_fromTypeCB.getSelectedIndex();
        switch (sel) {
            case 1: {
                this.m_fromCardPnl.show(FROM_EXPRESSION_PANEL);
                break;
            }
            case 2: {
                this.m_fromCardPnl.show(FROM_LITERAL_PANEL);
                break;
            }
            case 3: {
                this.m_fromCardPnl.show(FROM_PARTNERLINK_PANEL);
                break;
            }
            default: {
                this.m_fromCardPnl.show(FROM_VARIABLE_PANEL);
            }
        }
    }

    protected boolean isTextAvailable() {
        boolean bAvail = false;
        try {
            Toolkit tk = Toolkit.getDefaultToolkit();
            Clipboard cp = tk.getSystemClipboard();
            Transferable tf = cp.getContents(this.m_fromLiteral);
            DataFlavor[] df = tf.getTransferDataFlavors();
            if (df != null && df.length > 0) {
                for (int i = 0; i < df.length && !bAvail; ++i) {
                    if (!df[i].isFlavorTextType()) continue;
                    bAvail = true;
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return bAvail;
    }

    public void setHelpTopicId(String id) {
        this.helpTopicId = id;
    }

    @Override
    protected String getHelpTopicID() {
        if (this.helpTopicId != null && !this.helpTopicId.equals("")) {
            return this.helpTopicId;
        }
        String appendToTopicLookup = this.inEditMode ? EDIT : CREATE;
        return this.getClass().getName() + "." + appendToTopicLookup;
    }

    public class MyListCellRenderer
    extends DefaultListCellRenderer {
        private JComboBox m_combo;
        private Icon EXPRESSION_ICON;
        private Icon VARIABLE_ICON;
        private Icon XML_ICON;

        public MyListCellRenderer(JComboBox cb) {
            this.setOpaque(true);
            this.m_combo = cb;
            this.EXPRESSION_ICON = ImageCache.getIcon("expressionbuilder");
            this.VARIABLE_ICON = ImageCache.getIcon("variable16");
            this.XML_ICON = ImageCache.getIcon("application/bpel/fragment16.png");
            this.setIcon(this.XML_ICON);
        }

        @Override
        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
            if (this.m_combo == CopyDialogEditPage.this.m_fromTypeCB) {
                switch (index) {
                    case 0: {
                        this.setIcon(this.VARIABLE_ICON);
                        break;
                    }
                    case 1: {
                        this.setIcon(this.EXPRESSION_ICON);
                        break;
                    }
                    case 2: {
                        this.setIcon(this.XML_ICON);
                        break;
                    }
                    case 3: {
                        this.setIcon(ImageCache.getIcon("partner_link_node"));
                        break;
                    }
                    default: {
                        this.setIcon(null);
                        break;
                    }
                }
            } else if (this.m_combo == CopyDialogEditPage.this.m_toTypeCB) {
                switch (index) {
                    case 0: {
                        this.setIcon(ImageCache.getIcon("variable16"));
                        break;
                    }
                    case 1: {
                        this.setIcon(ImageCache.getIcon("partner_link_node"));
                        break;
                    }
                    default: {
                        this.setIcon(null);
                    }
                }
            }
            return this;
        }
    }

    class PopupListener
    extends MouseAdapter {
        PopupListener() {
        }

        @Override
        public void mousePressed(MouseEvent e) {
            CopyDialogEditPage.this.handlePopupMenu(e);
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            CopyDialogEditPage.this.handlePopupMenu(e);
        }
    }
}

