/*
 * Decompiled with CFR 0.152.
 */
package oracle.tip.tools.ide.pm.bpelgraph.editors;

import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import oracle.tip.tools.ide.common.bpelparser.iface.Activity;
import oracle.tip.tools.ide.common.bpelparser.iface.Catch;
import oracle.tip.tools.ide.common.bpelparser.iface.CatchAll;
import oracle.tip.tools.ide.common.bpelparser.iface.Compensate;
import oracle.tip.tools.ide.common.bpelparser.iface.CompensationHandler;
import oracle.tip.tools.ide.common.bpelparser.iface.ContainerActivity;
import oracle.tip.tools.ide.common.bpelparser.iface.Handler;
import oracle.tip.tools.ide.common.bpelparser.iface.OnAlarm;
import oracle.tip.tools.ide.common.bpelparser.iface.OnMessage;
import oracle.tip.tools.ide.common.bpelparser.iface.Scope;
import oracle.tip.tools.ide.common.graph.GraphUtils;
import oracle.tip.tools.ide.pm.bpelgraph.editors.ScopeListItem;
import oracle.tip.tools.ide.pm.bpelgraph.views.BPELGraphPane;
import oracle.tip.tools.ide.pm.gui.generalpurpose.BPELBaseDialog;
import oracle.tip.tools.ide.pm.gui.generalpurpose.GenericListCellRenderer;
import oracle.tip.tools.ide.pm.i18n.BPELStringTranslator;
import oracle.tip.tools.ide.pm.resources.images.ImageCache;

public class CompensateScopeChooser
extends BPELBaseDialog
implements ActionListener,
ListSelectionListener {
    public static final int OK = 0;
    public static final int CANCEL = 1;
    protected JButton m_okBtn;
    protected JButton m_cancelBtn;
    protected JButton m_helpBtn;
    protected JList m_scopeList;
    protected int m_retVal = 0;
    protected Activity m_compensate;
    protected BPELGraphPane m_graph;

    public CompensateScopeChooser(JFrame f, BPELGraphPane graph, Compensate a) {
        super(f, BPELStringTranslator.getString("EDITOR_SCOPE_CHOOSER"), true);
        this.m_compensate = a;
        this.m_graph = graph;
        this.createControls();
        this.layoutControls();
    }

    protected List findFirstLevelScopes(Activity a) {
        ArrayList<Activity> l = new ArrayList<Activity>();
        if (a instanceof ContainerActivity) {
            ContainerActivity con = (ContainerActivity)a;
            Iterator it = con.getActivities();
            while (it.hasNext()) {
                Activity child = (Activity)it.next();
                if (child instanceof Scope) {
                    l.add(child);
                    continue;
                }
                List lst = this.findFirstLevelScopes(child);
                if (lst.size() <= 0) continue;
                l.addAll(lst);
            }
        }
        return l;
    }

    public Scope getSelectedScope() {
        ScopeListItem item = (ScopeListItem)this.m_scopeList.getSelectedValue();
        if (item != null) {
            return item.getScope();
        }
        return null;
    }

    protected void createControls() {
        this.m_scopeList = new JList();
        this.m_scopeList.setCellRenderer(new GenericListCellRenderer(ImageCache.getIcon("scope_node")));
        this.m_scopeList.setSelectionMode(0);
        this.m_scopeList.addListSelectionListener(this);
        this.m_scopeList.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() > 1 && CompensateScopeChooser.this.m_scopeList.getSelectedIndex() != -1) {
                    CompensateScopeChooser.this.handleOK();
                }
            }
        });
        this.m_okBtn = new JButton();
        this.m_okBtn.setEnabled(false);
        BPELStringTranslator.setButton(this.m_okBtn, BPELStringTranslator.getString("OK_BUTTON_TEXT_RES"));
        this.m_okBtn.addActionListener(this);
        this.m_cancelBtn = new JButton();
        BPELStringTranslator.setButton(this.m_cancelBtn, BPELStringTranslator.getString("CANCEL_BUTTON_TEXT_RES"));
        this.m_cancelBtn.addActionListener(this);
        this.m_helpBtn = new JButton();
        BPELStringTranslator.setButton(this.m_helpBtn, BPELStringTranslator.getString("HELP_BUTTON_TEXT_RES"));
        this.m_helpBtn.addActionListener(this);
    }

    protected void updateButtons() {
        this.m_okBtn.setEnabled(this.getSelectedScope() != null);
    }

    protected void layoutControls() {
        JPanel btnPnl = new JPanel(new GridLayout(1, 2, 5, 0));
        btnPnl.add(this.m_okBtn);
        btnPnl.add(this.m_cancelBtn);
        Container c = this.getContentPane();
        c.setLayout(new GridBagLayout());
        JLabel l = new JLabel();
        BPELStringTranslator.setLabel(l, this.m_scopeList, BPELStringTranslator.getString("SCOPES_LBL"));
        int row = 0;
        GraphUtils.addComponent((Container)c, (Component)l, (int)0, (int)row++, (int)1, (int)1, (int)17, (int)2, (Insets)new Insets(10, 10, 0, 10), (int)0, (int)0, (double)1.0, (double)0.0);
        GraphUtils.addComponent((Container)c, (Component)new JScrollPane(this.m_scopeList), (int)0, (int)row++, (int)1, (int)1, (int)17, (int)1, (Insets)new Insets(2, 10, 0, 10), (int)0, (int)0, (double)1.0, (double)1.0);
        GraphUtils.addComponent((Container)c, (Component)this.m_helpBtn, (int)0, (int)row, (int)1, (int)1, (int)17, (int)0, (Insets)new Insets(5, 10, 10, 10), (int)0, (int)0, (double)1.0, (double)0.0);
        GraphUtils.addComponent((Container)c, (Component)btnPnl, (int)0, (int)row++, (int)1, (int)1, (int)13, (int)0, (Insets)new Insets(5, 10, 10, 10), (int)0, (int)0, (double)1.0, (double)0.0);
        this.setSize(380, 280);
        this.setLocationRelativeTo(this.getParent());
    }

    public int display() {
        this.enableUserInput(false);
        Runnable r = new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                try {
                    CompensateScopeChooser.this.loadControls();
                }
                finally {
                    CompensateScopeChooser.this.enableUserInput(true);
                }
            }
        };
        new Thread(r).start();
        this.setVisible(true);
        return this.m_retVal;
    }

    protected void loadControls() {
        final DefaultListModel<ScopeListItem> model = new DefaultListModel<ScopeListItem>();
        Activity enclosingScope = null;
        for (Activity currActivity = this.m_compensate.getParentActivity(); currActivity != null; currActivity = currActivity.getParentActivity()) {
            Handler handler;
            if (currActivity instanceof CompensationHandler) {
                enclosingScope = ((CompensationHandler)currActivity).getHandlerParentActivity();
            } else if ((currActivity instanceof Catch || currActivity instanceof CatchAll || currActivity instanceof OnMessage || currActivity instanceof OnAlarm) && (handler = currActivity.getParentHandler()) != null) {
                enclosingScope = handler.getHandlerParentActivity();
            }
            if (enclosingScope != null) break;
        }
        if (enclosingScope != null) {
            List l = this.findFirstLevelScopes(enclosingScope);
            for (Scope s : l) {
                model.addElement(new ScopeListItem(s));
            }
        }
        Runnable r = new Runnable(){

            @Override
            public void run() {
                CompensateScopeChooser.this.m_scopeList.setModel(model);
            }
        };
        SwingUtilities.invokeLater(r);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Object src = e.getSource();
        if (src == this.m_okBtn) {
            this.handleOK();
        } else if (src == this.m_cancelBtn) {
            this.handleCancel();
        } else if (src == this.m_helpBtn) {
            this.helpInvoked();
        }
    }

    protected void handleOK() {
        this.m_retVal = 0;
        this.dispose();
    }

    protected void handleCancel() {
        this.m_retVal = 1;
        this.dispose();
    }

    @Override
    public void valueChanged(ListSelectionEvent e) {
        this.m_okBtn.setEnabled(this.m_scopeList.getSelectedIndex() != -1);
    }

    protected void helpInvoked() {
        this.handleHelp((Component)((Object)this));
    }
}

