/*
 * Decompiled with CFR 0.152.
 */
package oracle.tip.tools.ide.pm.bpelgraph.editors;

import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.JToolBar;
import oracle.tip.tools.ide.common.bpeldesigner.util.Helper;
import oracle.tip.tools.ide.common.bpelparser.iface.Compensate;
import oracle.tip.tools.ide.common.bpelparser.iface.Scope;
import oracle.tip.tools.ide.common.graph.GraphUtils;
import oracle.tip.tools.ide.common.ui.GlobalImageCache;
import oracle.tip.tools.ide.pm.bpelgraph.editors.BaseEditingPage;
import oracle.tip.tools.ide.pm.bpelgraph.editors.CompensateScopeChooser;
import oracle.tip.tools.ide.pm.bpelgraph.views.BPELGraphPane;
import oracle.tip.tools.ide.pm.i18n.BPELStringTranslator;

public class CompensateGenEditPage
extends BaseEditingPage
implements ActionListener {
    protected JTextField m_nameField;
    protected JTextField m_scopeField;
    protected JButton m_scopeBrowseBtn;
    protected Compensate m_activity;

    public CompensateGenEditPage(BPELGraphPane pane) {
        super(pane);
        this.createControls();
        this.layoutControls();
    }

    @Override
    public void loadData() {
    }

    protected void createControls() {
        this.m_nameField = new JTextField();
        this.m_scopeField = new JTextField();
        this.m_scopeBrowseBtn = new JButton(GlobalImageCache.getIcon((String)"browse16"));
        this.m_scopeBrowseBtn.setToolTipText(BPELStringTranslator.getString("GENERAL_BROWSE_PS_SCOPE") + "...");
        this.m_scopeBrowseBtn.addActionListener(this);
    }

    protected void layoutControls() {
        JLabel nameLbl = new JLabel();
        BPELStringTranslator.setLabel(nameLbl, this.m_nameField, BPELStringTranslator.getString("GENERAL_EDITOR_NAME"));
        JLabel scopeLbl = new JLabel();
        BPELStringTranslator.setLabel(scopeLbl, this.m_scopeField, BPELStringTranslator.getString("EDITOR_CMP_EDIT_SCOPE"));
        JToolBar tb = new JToolBar();
        tb.setBorderPainted(false);
        tb.add(this.m_scopeBrowseBtn);
        this.setLayout(new GridBagLayout());
        int row = 0;
        GraphUtils.addComponent((Container)this, (Component)nameLbl, (int)0, (int)row, (int)1, (int)1, (int)17, (int)0, (Insets)new Insets(10, 10, 0, 5), (int)0, (int)0, (double)0.0, (double)0.0);
        GraphUtils.addComponent((Container)this, (Component)this.m_nameField, (int)1, (int)row++, (int)1, (int)1, (int)17, (int)2, (Insets)new Insets(10, 0, 0, 5), (int)0, (int)0, (double)1.0, (double)0.0);
        GraphUtils.addComponent((Container)this, (Component)scopeLbl, (int)0, (int)row, (int)1, (int)1, (int)17, (int)0, (Insets)new Insets(5, 10, 0, 5), (int)0, (int)0, (double)0.0, (double)0.0);
        GraphUtils.addComponent((Container)this, (Component)this.m_scopeField, (int)1, (int)row, (int)1, (int)1, (int)17, (int)2, (Insets)new Insets(5, 0, 0, 5), (int)0, (int)0, (double)1.0, (double)0.0);
        GraphUtils.addComponent((Container)this, (Component)tb, (int)2, (int)row++, (int)1, (int)1, (int)17, (int)0, (Insets)new Insets(5, 0, 0, 10), (int)0, (int)0, (double)0.0, (double)0.0);
        GraphUtils.addComponent((Container)this, (Component)new JPanel(), (int)0, (int)row++, (int)3, (int)1, (int)17, (int)1, (Insets)new Insets(0, 0, 10, 0), (int)0, (int)0, (double)1.0, (double)1.0);
    }

    @Override
    public void setUserObject(Object model) {
        super.setUserObject(model);
        this.m_activity = (Compensate)model;
        this.loadControls();
    }

    protected void loadControls() {
        if (this.m_activity == null) {
            return;
        }
        if (this.m_activity.getName() != null) {
            this.m_nameField.setText(this.m_activity.getName());
        }
        this.m_scopeField.setText(this.m_activity.getScope());
    }

    @Override
    public boolean validateEditorChanges() {
        String name = this.m_nameField.getText();
        if (!Helper.isValidName((String)name, (boolean)true)) {
            GraphUtils.displayMessage((Component)GraphUtils.getFrame((Component)this), (String)BPELStringTranslator.getString("GENERAL_EDITOR_NAME_INVALID"), (String)BPELStringTranslator.getString("GENERAL_EDITOR_ERROR"), (int)2);
            return false;
        }
        return true;
    }

    @Override
    public void saveChanges() {
        if (this.m_activity == null) {
            return;
        }
        this.m_activity.setName(this.m_nameField.getText());
        this.m_activity.setScope(this.m_scopeField.getText());
        this.fireProcessChangedEvent(28);
    }

    protected void handleBrowseScopes() {
        CompensateScopeChooser dlg = new CompensateScopeChooser(GraphUtils.getFrame((Component)this), this.m_graphPane, this.m_activity);
        if (dlg.display() == 0) {
            Scope s = dlg.getSelectedScope();
            this.m_scopeField.setText(s.getName());
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Object src = e.getSource();
        if (src == this.m_scopeBrowseBtn) {
            this.handleBrowseScopes();
        }
    }
}

