/*
 * Decompiled with CFR 0.152.
 */
package oracle.tip.tools.ide.pm.bpelgraph.editors;

import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Window;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseMotionAdapter;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.text.MessageFormat;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JRootPane;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.event.EventListenerList;
import javax.swing.text.BadLocationException;
import javax.swing.text.JTextComponent;
import javax.wsdl.Definition;
import javax.wsdl.Operation;
import javax.wsdl.PortType;
import javax.xml.namespace.QName;
import oracle.ide.net.URLFactory;
import oracle.ide.net.URLFileSystem;
import oracle.tip.tools.ide.common.bpeldesigner.models.bpel.PartnerLinkType;
import oracle.tip.tools.ide.common.bpeldesigner.models.bpel.Role;
import oracle.tip.tools.ide.common.bpeldesigner.models.schema.BpelNSResolver;
import oracle.tip.tools.ide.common.bpeldesigner.models.schema.NSResolverFactory;
import oracle.tip.tools.ide.common.bpeldesigner.util.Helper;
import oracle.tip.tools.ide.common.bpeldesigner.util.PartnerLinkWSDLUtil;
import oracle.tip.tools.ide.common.bpelparser.BPELParser;
import oracle.tip.tools.ide.common.bpelparser.iface.Activity;
import oracle.tip.tools.ide.common.bpelparser.iface.PartnerLink;
import oracle.tip.tools.ide.common.bpelparser.iface.PartnerLinks;
import oracle.tip.tools.ide.common.bpelparser.iface.Process;
import oracle.tip.tools.ide.common.bpelparser.iface.Scope;
import oracle.tip.tools.ide.common.bpelparser.iface.Variable;
import oracle.tip.tools.ide.common.bpelparser.iface.Variables;
import oracle.tip.tools.ide.common.bpelparser.util.BPELModelUtil;
import oracle.tip.tools.ide.common.expressionbuilder.BpelExpressionBuilder;
import oracle.tip.tools.ide.common.expressionbuilder.ExpressionBuilderPicker;
import oracle.tip.tools.ide.common.expressionbuilders.ExpressionBuilderUsecases;
import oracle.tip.tools.ide.common.graph.GraphUtils;
import oracle.tip.tools.ide.common.graph.model.Node;
import oracle.tip.tools.ide.common.graph.view.NodeRenderer;
import oracle.tip.tools.ide.common.ide.bpel.BPELProject;
import oracle.tip.tools.ide.common.ui.UIHelper;
import oracle.tip.tools.ide.common.utils.NamespaceResolver;
import oracle.tip.tools.ide.common.utils.URIUtil;
import oracle.tip.tools.ide.common.utils.WSDLUtil;
import oracle.tip.tools.ide.common.xpath.editor.XPathEditorPane;
import oracle.tip.tools.ide.common.xpath.editor.util.VariableDataCallBack;
import oracle.tip.tools.ide.common.xsdgrammar.MapperNSResolver;
import oracle.tip.tools.ide.pm.addin.model.BPELXmlModel;
import oracle.tip.tools.ide.pm.bpelgraph.editors.PartnerLinkListItem;
import oracle.tip.tools.ide.pm.bpelgraph.editors.RoleListItem;
import oracle.tip.tools.ide.pm.bpelgraph.editors.VarNameCreationManager;
import oracle.tip.tools.ide.pm.bpelgraph.editors.VariableDataCallBackImpl;
import oracle.tip.tools.ide.pm.bpelgraph.editors.VariableExpressionBuilderPicker;
import oracle.tip.tools.ide.pm.bpelgraph.editors.VariableListItem;
import oracle.tip.tools.ide.pm.bpelgraph.editors.VariablePickerPanel;
import oracle.tip.tools.ide.pm.bpelgraph.editors.WSDLOperationListItem;
import oracle.tip.tools.ide.pm.bpelgraph.editors.WSDLPortTypeListItem;
import oracle.tip.tools.ide.pm.bpelgraph.model.BPELGraphModel;
import oracle.tip.tools.ide.pm.bpelgraph.views.BPELGraphPane;
import oracle.tip.tools.ide.pm.bpelgraph.views.PartnerLinkConnectable;
import oracle.tip.tools.ide.pm.bpelgraph.views.nodeeditors.ApplyCancelPanel;
import oracle.tip.tools.ide.pm.bpelgraph.views.nodeeditors.EditorPage;
import oracle.tip.tools.ide.pm.bpelgraph.views.nodeeditors.EditorPageChangeListener;
import oracle.tip.tools.ide.pm.bpelgraph.views.nodeeditors.EditorPageManager;
import oracle.tip.tools.ide.pm.i18n.BPELStringTranslator;
import oracle.tip.tools.ide.pm.modules.help.HelpSystem;

public abstract class BaseEditingPage
extends JPanel
implements EditorPage {
    public static final String INPUT_VARIABLE = "_InputVariable";
    public static final String OUTPUT_VARIABLE = "_OutputVariable";
    protected static final String NO_SELECTION_ITEM = BPELStringTranslator.getString("NO_SELECTION_ITEM", "---- No Item Selected ----");
    protected BPELGraphPane m_graphPane;
    protected Process m_processModel;
    protected BPELGraphModel m_graphModel;
    protected JPanel m_myGlassPane;
    protected Component m_jdevGlassPane;
    protected NamespaceResolver m_nsResolver = null;
    protected Object m_userObject;
    private EventListenerList m_editorPageChangeListenerList = new EventListenerList();
    protected boolean m_bModified = false;

    public BaseEditingPage(BPELGraphPane graphPane) {
        this.m_myGlassPane = new JPanel();
        this.m_myGlassPane.setOpaque(false);
        this.m_myGlassPane.addMouseListener(new MouseAdapter(){});
        this.m_myGlassPane.addMouseMotionListener(new MouseMotionAdapter(){});
        this.m_graphPane = graphPane;
        this.m_graphModel = (BPELGraphModel)this.m_graphPane.getModel();
        this.m_processModel = this.m_graphModel.getProcess();
    }

    @Override
    public void onCancel() {
    }

    @Override
    public void onDeselection() {
    }

    @Override
    public void onSelection() {
    }

    public EditorPageManager getEditorPageManager() {
        ApplyCancelPanel p = this.getApplyCancelPanel();
        if (p != null) {
            return p.getEditorPageManager();
        }
        return null;
    }

    public void cancelEditing() {
        ApplyCancelPanel p = this.getApplyCancelPanel();
        if (p != null) {
            p.handleCancel();
        }
    }

    public void stopEditing() {
        ApplyCancelPanel p = this.getApplyCancelPanel();
        if (p != null) {
            p.handleOK();
        }
    }

    @Override
    public void addEditorPageChangeListener(EditorPageChangeListener l) {
        this.m_editorPageChangeListenerList.add(EditorPageChangeListener.class, l);
    }

    @Override
    public void removeEditorPageChangeListener(EditorPageChangeListener l) {
        this.m_editorPageChangeListenerList.remove(EditorPageChangeListener.class, l);
    }

    public void fireProcessChangedEvent(int id) {
        if (this.m_processModel != null) {
            this.m_processModel.fireModelChanged((Object)this, id, (Object)this.m_processModel);
        }
    }

    @Override
    public void loadData() {
        this.setModified(true);
    }

    @Override
    public boolean isModified() {
        return this.m_bModified;
    }

    @Override
    public void setModified(boolean bModified) {
        this.m_bModified = bModified;
        this.fireEditorPageChangeEvent(this);
    }

    protected BPELProject getBPELProject() {
        if (this.m_graphPane != null) {
            return this.m_graphPane.getBPELProject();
        }
        return null;
    }

    protected void fireEditorPageChangeEvent(EditorPage page) {
        Object[] listeners = this.m_editorPageChangeListenerList.getListenerList();
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != EditorPageChangeListener.class) continue;
            ((EditorPageChangeListener)listeners[i + 1]).pageChanged(page);
        }
    }

    protected void updateGraphPartnerLinkConnections(Node n) {
        NodeRenderer r = this.m_graphPane.getNodeRendererForNode(n);
        if (r instanceof PartnerLinkConnectable) {
            ((PartnerLinkConnectable)r).updatePartnerLinkGUIConnections();
        }
    }

    protected void enableUserInput(final boolean bEnable) {
        Container p;
        for (p = this.getParent(); p != null && !(p instanceof JRootPane); p = p.getParent()) {
        }
        final Container pane = p;
        Runnable r = new Runnable(){

            @Override
            public void run() {
                if (pane instanceof JRootPane) {
                    JRootPane rootPane = (JRootPane)pane;
                    if (bEnable) {
                        BaseEditingPage.this.m_myGlassPane.setVisible(false);
                        if (BaseEditingPage.this.m_jdevGlassPane != null) {
                            rootPane.setGlassPane(BaseEditingPage.this.m_jdevGlassPane);
                            rootPane.getGlassPane().setVisible(false);
                        }
                    } else {
                        BaseEditingPage.this.m_jdevGlassPane = rootPane.getGlassPane();
                        rootPane.setGlassPane(BaseEditingPage.this.m_myGlassPane);
                        BaseEditingPage.this.m_myGlassPane.setVisible(true);
                        BaseEditingPage.this.m_myGlassPane.setCursor(Cursor.getPredefinedCursor(3));
                    }
                }
            }
        };
        if (SwingUtilities.isEventDispatchThread()) {
            r.run();
        } else {
            SwingUtilities.invokeLater(r);
        }
    }

    protected PartnerLink getPartnerLink(String name) {
        List links = BPELModelUtil.getAllPartnerLinks((Process)this.m_processModel);
        if (links != null) {
            for (PartnerLink plink : links) {
                if (!plink.getName().equalsIgnoreCase(name)) continue;
                return plink;
            }
        }
        return null;
    }

    protected boolean selectRoleListItem(String role, JComboBox cb) {
        if (role == null) {
            return false;
        }
        DefaultComboBoxModel model = (DefaultComboBoxModel)cb.getModel();
        int sz = model.getSize();
        for (int i = 0; i < sz; ++i) {
            RoleListItem item;
            Role r;
            Object obj = model.getElementAt(i);
            if (!(obj instanceof RoleListItem) || !(r = (item = (RoleListItem)obj).getRole()).getName().equalsIgnoreCase(role)) continue;
            cb.setSelectedItem(item);
            return true;
        }
        return false;
    }

    protected URL getProjectURL() {
        BPELProject prj = this.m_graphPane.getBPELProject();
        if (prj != null) {
            return prj.getProjectURL();
        }
        return null;
    }

    protected boolean selectPartnerLink(String partnerLink, JComboBox cb) {
        if (partnerLink == null) {
            return false;
        }
        DefaultComboBoxModel model = (DefaultComboBoxModel)cb.getModel();
        int sz = model.getSize();
        for (int i = 0; i < sz; ++i) {
            PartnerLinkListItem item;
            PartnerLink link;
            Object obj = model.getElementAt(i);
            if (!(obj instanceof PartnerLinkListItem) || !(link = (item = (PartnerLinkListItem)obj).getPartnerLink()).getName().equalsIgnoreCase(partnerLink)) continue;
            this.selectComboItem(item, cb);
            return true;
        }
        return false;
    }

    protected void selectComboItem(final Object item, final JComboBox cb) {
        if (SwingUtilities.isEventDispatchThread()) {
            cb.setSelectedItem(item);
        } else {
            Runnable r = new Runnable(){

                @Override
                public void run() {
                    cb.setSelectedItem(item);
                }
            };
            SwingUtilities.invokeLater(r);
        }
    }

    protected void loadPartnerLinks(final JComboBox cb) {
        PartnerLinks links = this.m_processModel.getPartnerLinks();
        if (links != null) {
            final DefaultComboBoxModel<PartnerLinkListItem> model = new DefaultComboBoxModel<PartnerLinkListItem>();
            for (PartnerLink link : links.getPartnerLinks()) {
                model.addElement(new PartnerLinkListItem(link));
            }
            if (SwingUtilities.isEventDispatchThread()) {
                cb.setModel(model);
                cb.setSelectedIndex(-1);
            } else {
                Runnable r = new Runnable(){

                    @Override
                    public void run() {
                        cb.setModel(model);
                        cb.setSelectedIndex(-1);
                    }
                };
                SwingUtilities.invokeLater(r);
            }
        }
    }

    protected void loadVariables(JComboBox cb, boolean bAddNoSelectionItem) {
        Variables variables = this.m_processModel.getVariables();
        if (variables != null) {
            List vars = variables.getVariables();
            DefaultComboBoxModel<Object> model1 = new DefaultComboBoxModel<Object>();
            if (bAddNoSelectionItem) {
                model1.addElement(NO_SELECTION_ITEM);
            }
            for (Variable v : vars) {
                model1.addElement(new VariableListItem(v));
            }
            cb.setModel(model1);
        }
    }

    protected void loadVariables(JComboBox cb, Activity activity, boolean bAddNoSelectionItem) {
        DefaultComboBoxModel<Object> model1 = null;
        List scopes = BPELModelUtil.findAllParentScopes((Activity)activity);
        for (Scope scope : scopes) {
            Variables scopeVariables = scope.getVariables();
            if (scopeVariables == null) continue;
            if (model1 == null) {
                model1 = new DefaultComboBoxModel<Object>();
                if (bAddNoSelectionItem) {
                    model1.addElement(NO_SELECTION_ITEM);
                }
                cb.setModel(model1);
            }
            for (Variable v : scopeVariables.getVariables()) {
                model1.addElement(new VariableListItem(v));
            }
        }
    }

    protected String getSelectedPartnerLink(JComboBox cb) {
        Object obj = cb.getSelectedItem();
        if (obj == NO_SELECTION_ITEM) {
            return null;
        }
        if (obj instanceof PartnerLinkListItem) {
            PartnerLinkListItem item = (PartnerLinkListItem)obj;
            return item.getPartnerLink().getName();
        }
        return null;
    }

    protected Object getSelectedComboBoxValue(JComboBox cb) {
        Object obj = cb.getSelectedItem();
        if (obj == NO_SELECTION_ITEM) {
            return null;
        }
        return obj;
    }

    protected String getSelectedVariable(JComboBox cb) {
        Object obj = cb.getSelectedItem();
        if (obj == NO_SELECTION_ITEM) {
            return null;
        }
        if (obj instanceof VariableListItem) {
            VariableListItem item = (VariableListItem)obj;
            return item.getVariable().getName();
        }
        return null;
    }

    protected boolean isVariableInModel(String varName, DefaultComboBoxModel model) {
        int sz = model.getSize();
        for (int i = 0; i < sz; ++i) {
            VariableListItem item;
            Variable v;
            Object obj = model.getElementAt(i);
            if (!(obj instanceof VariableListItem) || !(v = (item = (VariableListItem)model.getElementAt(i)).getVariable()).getName().equals(varName)) continue;
            return true;
        }
        return false;
    }

    protected void selectVariable(String varName, JComboBox cb) {
        if (varName == null) {
            return;
        }
        DefaultComboBoxModel model = (DefaultComboBoxModel)cb.getModel();
        int sz = model.getSize();
        for (int i = 0; i < sz; ++i) {
            VariableListItem item;
            Variable v;
            Object obj = model.getElementAt(i);
            if (!(obj instanceof VariableListItem) || !(v = (item = (VariableListItem)obj).getVariable()).getName().equalsIgnoreCase(varName)) continue;
            cb.setSelectedItem(item);
            return;
        }
    }

    protected Definition parseWSDL(URI uri) {
        Definition def = null;
        try {
            def = WSDLUtil.parseWSDLDocument((URI)uri);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return def;
    }

    protected void asyncPopulateRoles(final PartnerLink link, final JComboBox roleCB, final String defaultRoleSelection) {
        this.enableUserInput(false);
        Runnable r = new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                try {
                    BaseEditingPage.this.populateRoles(link, roleCB, defaultRoleSelection);
                    BaseEditingPage.this.setModified(false);
                }
                finally {
                    BaseEditingPage.this.enableUserInput(true);
                }
            }
        };
        new Thread(r).start();
    }

    protected Role getRoleForPartnerLinkRoleName(PartnerLink link, String roleName) {
        if (roleName == null || link == null) {
            return null;
        }
        for (Role r : this.getRolesForPartnerLink(link)) {
            if (!r.getName().equalsIgnoreCase(roleName)) continue;
            return r;
        }
        return null;
    }

    protected List<Role> getRolesForPartnerLink(PartnerLink link) {
        URI uri;
        ArrayList<Role> lst = new ArrayList<Role>();
        String wsdlLoc = link.getWSDLLocation();
        if (wsdlLoc == null || wsdlLoc.length() == 0) {
            UIHelper.displayErrorMessage((Component)this, (String)BPELStringTranslator.formatString("EDITOR_BE_NO_WSDL_LOCATION_ERROR", new Object[]{link.getName()}));
            return lst;
        }
        try {
            uri = new URI(URIUtil.escapeURIString((String)wsdlLoc));
        }
        catch (Exception e) {
            UIHelper.displayErrorMessage((Component)this, (String)BPELStringTranslator.getString("EDITOR_BE_INVALID_WSDL_ERROR"));
            return lst;
        }
        QName partnerLinkType = link.getPartnerLinkType();
        Definition def = this.parseWSDL(uri);
        if (def == null) {
            UIHelper.displayErrorMessage((Component)this, (String)BPELStringTranslator.formatString("EDITOR_BE_UNABLE_PARSE_WSDL_ERROR", new Object[]{uri.toString()}));
            return lst;
        }
        Map map = PartnerLinkWSDLUtil.getPartnerLinkTypes((Definition)def);
        if (map != null && map.size() > 0) {
            String modelNamespace = partnerLinkType.getNamespaceURI();
            String modelLocalPart = partnerLinkType.getLocalPart();
            Iterator it = map.keySet().iterator();
            PartnerLinkType wsdlPartnerLinkType = null;
            while (it.hasNext()) {
                QName qName = (QName)it.next();
                String wsdlNamespace = qName.getNamespaceURI();
                String wsdlLocalPart = qName.getLocalPart();
                if (!wsdlNamespace.equalsIgnoreCase(modelNamespace) || !wsdlLocalPart.equalsIgnoreCase(modelLocalPart)) continue;
                wsdlPartnerLinkType = (PartnerLinkType)map.get(qName);
                break;
            }
            if (wsdlPartnerLinkType == null) {
                UIHelper.displayErrorMessage((Component)this, (String)BPELStringTranslator.formatString("EDITOR_BE_PARTNERLINK_NOT_FOUND_ERROR", new Object[]{partnerLinkType.toString()}));
                return lst;
            }
            Map rolesMap = wsdlPartnerLinkType.getRoles();
            for (Role r : rolesMap.values()) {
                lst.add(r);
            }
        }
        return lst;
    }

    protected void populateRoles(PartnerLink link, JComboBox roleCB) {
        this.populateRoles(link, roleCB, null);
    }

    protected void populateRoles(PartnerLink link, final JComboBox roleCB, final String defaultRoleSelection) {
        URI uri;
        String wsdlLoc = link.getWSDLLocation();
        if (wsdlLoc == null || wsdlLoc.length() == 0) {
            UIHelper.displayErrorMessage((Component)this, (String)BPELStringTranslator.formatString("EDITOR_BE_NO_WSDL_LOCATION_ERROR", new Object[]{link.getName()}));
            return;
        }
        try {
            uri = new URI(URIUtil.escapeURIString((String)wsdlLoc));
        }
        catch (Exception e) {
            UIHelper.displayErrorMessage((Component)this, (String)BPELStringTranslator.getString("EDITOR_BE_INVALID_WSDL_ERROR"));
            return;
        }
        QName partnerLinkType = link.getPartnerLinkType();
        Definition def = this.parseWSDL(uri);
        if (def == null) {
            UIHelper.displayErrorMessage((Component)this, (String)BPELStringTranslator.formatString("EDITOR_BE_UNABLE_PARSE_WSDL_ERROR", new Object[]{uri.toString()}));
            return;
        }
        Map map = PartnerLinkWSDLUtil.getPartnerLinkTypes((Definition)def);
        if (map != null && map.size() > 0) {
            String modelNamespace = partnerLinkType.getNamespaceURI();
            String modelLocalPart = partnerLinkType.getLocalPart();
            Iterator it = map.keySet().iterator();
            PartnerLinkType wsdlPartnerLinkType = null;
            while (it.hasNext()) {
                QName qName = (QName)it.next();
                String wsdlNamespace = qName.getNamespaceURI();
                String wsdlLocalPart = qName.getLocalPart();
                if (!wsdlNamespace.equalsIgnoreCase(modelNamespace) || !wsdlLocalPart.equalsIgnoreCase(modelLocalPart)) continue;
                wsdlPartnerLinkType = (PartnerLinkType)map.get(qName);
                break;
            }
            if (wsdlPartnerLinkType == null) {
                UIHelper.displayErrorMessage((Component)this, (String)BPELStringTranslator.formatString("EDITOR_BE_PARTNERLINK_NOT_FOUND_ERROR", new Object[]{partnerLinkType.toString()}));
                return;
            }
            final DefaultComboBoxModel<RoleListItem> model = new DefaultComboBoxModel<RoleListItem>();
            Map rolesMap = wsdlPartnerLinkType.getRoles();
            for (Object r : rolesMap.values()) {
                RoleListItem listItem = new RoleListItem((Role)r);
                model.addElement(listItem);
            }
            if (SwingUtilities.isEventDispatchThread()) {
                roleCB.setModel(model);
                if (defaultRoleSelection != null) {
                    this.selectRoleListItem(defaultRoleSelection, roleCB);
                }
            } else {
                Object r;
                r = new Runnable(){

                    @Override
                    public void run() {
                        roleCB.setModel(model);
                        if (defaultRoleSelection != null) {
                            BaseEditingPage.this.selectRoleListItem(defaultRoleSelection, roleCB);
                        }
                    }
                };
                SwingUtilities.invokeLater((Runnable)r);
            }
        }
    }

    protected void populatePortTypes(PortType wsdlPortType, JComboBox cb) {
        DefaultComboBoxModel<WSDLPortTypeListItem> model = new DefaultComboBoxModel<WSDLPortTypeListItem>();
        model.addElement(new WSDLPortTypeListItem(wsdlPortType));
        cb.setModel(model);
        if (model.getSize() > 0) {
            cb.setSelectedIndex(0);
        }
    }

    protected void populateOperations(PortType portType, JComboBox cb) {
        DefaultComboBoxModel<WSDLOperationListItem> model = new DefaultComboBoxModel<WSDLOperationListItem>();
        for (Operation op : portType.getOperations()) {
            model.addElement(new WSDLOperationListItem(op));
        }
        cb.setModel(model);
        if (model.getSize() > 0) {
            cb.setSelectedIndex(0);
        }
    }

    protected final NamespaceResolver getNSResolver(Activity activity) {
        return NSResolverFactory.getPMNSResolver((Activity)activity, (Process)this.m_processModel);
    }

    protected ApplyCancelPanel getApplyCancelPanel() {
        Container p;
        for (p = this.getParent(); p != null && !(p instanceof ApplyCancelPanel); p = p.getParent()) {
        }
        if (p instanceof ApplyCancelPanel) {
            return (ApplyCancelPanel)p;
        }
        return null;
    }

    @Override
    public void setUserObject(Object obj) {
        this.m_userObject = obj;
    }

    @Override
    public Object getUserObject() {
        return this.m_userObject;
    }

    @Override
    public String getTitle() {
        return BPELStringTranslator.getString("GENERAL_EDITOR_TITLE");
    }

    @Override
    public JComponent getPagePanel() {
        return this;
    }

    @Override
    public void showHelp() {
        Container p;
        String topicId = this.getHelpTopicID();
        for (p = this.getParent(); p != null && !(p instanceof Window); p = p.getParent()) {
        }
        if (p != null) {
            HelpSystem.showHelp((Window)p, this.getPagePanel(), topicId);
        } else {
            HelpSystem.showHelp(this.getPagePanel(), topicId);
        }
    }

    protected String getHelpTopicID() {
        return HelpSystem.getHelpTopicId(this.getClass().getName());
    }

    @Override
    public void saveChanges() {
        if (this.m_nsResolver != null && this.m_nsResolver instanceof BpelNSResolver) {
            ((BpelNSResolver)this.m_nsResolver).saveCachedNamespacesToProcess();
        }
    }

    @Override
    public boolean validateEditorChanges() {
        return true;
    }

    public static QName getVariableQName(PartnerLink link, QName portType, String operation, boolean isInput) {
        QName qname;
        block3: {
            qname = null;
            try {
                if (link != null) {
                    String wsdl = link.getWSDLLocation();
                    qname = isInput ? WSDLUtil.getOperationInput((String)wsdl, (QName)portType, (String)operation) : WSDLUtil.getOperationOutput((String)wsdl, (QName)portType, (String)operation);
                }
            }
            catch (Exception e) {
                if (!(e instanceof URISyntaxException)) break block3;
                GraphUtils.displayMessage(null, (String)((URISyntaxException)e).getReason(), (int)0);
            }
        }
        return qname;
    }

    protected Variable createVariable(PartnerLink link, QName portType, String operation, String name, boolean isInput) {
        return this.createVariable(this.m_processModel, null, link, portType, operation, name, isInput);
    }

    protected Variable createVariable(Process process, Activity act, PartnerLink link, QName portType, String operation, String name, boolean isInput) {
        QName qname;
        Variable variable = null;
        if (isInput) {
            name = name + INPUT_VARIABLE;
            name = this.getNewVariableName(process, act, link, portType, operation, name, isInput);
            qname = BaseEditingPage.getVariableQName(link, portType, operation, true);
        } else {
            name = name + OUTPUT_VARIABLE;
            name = this.getNewVariableName(process, act, link, portType, operation, name, isInput);
            qname = BaseEditingPage.getVariableQName(link, portType, operation, false);
        }
        String vName = BPELModelUtil.getUniqueVariableName((Process)this.m_processModel, (String)name);
        if (qname != null) {
            String nsURI = qname.getNamespaceURI();
            String prefix = this.m_processModel.addNamespace(nsURI);
            QName qname2 = new QName(nsURI, qname.getLocalPart(), prefix);
            variable = (Variable)BPELParser.createImplementation(Variable.class);
            variable.setName(vName);
            variable.setMessageType(qname2);
            variable.setType(null);
            variable.setElement(null);
        } else if (isInput) {
            GraphUtils.displayMessage((Component)this, (String)BPELStringTranslator.getString("EDITOR_BE_CANT_CREATE_IN_VAR"), (int)0);
        } else {
            GraphUtils.displayMessage((Component)this, (String)BPELStringTranslator.getString("EDITOR_BE_CANT_CREATE_OUT_VAR"), (int)0);
        }
        return variable;
    }

    protected String getNewVariableName(Process process, Activity act, PartnerLink link, QName portType, String operation, String name, boolean isInput) {
        return VarNameCreationManager.getInstance().getVariableName(process, act, link, portType, operation, name, isInput);
    }

    protected void invokeGraphicalXPathBuilder(XPathEditorPane editorPane, Activity activity) {
        BPELXmlModel mainModel = this.m_graphPane.getBPELXmlModel();
        MapperNSResolver nsResolver = NSResolverFactory.getNSResolver((Activity)activity, (Process)this.m_processModel);
        VariableDataCallBackImpl dataCallBack = new VariableDataCallBackImpl(mainModel, activity, (NamespaceResolver)nsResolver);
        VariablePickerPanel p = new VariablePickerPanel(this.m_graphPane, dataCallBack, (NamespaceResolver)nsResolver);
        VariableExpressionBuilderPicker picker = new VariableExpressionBuilderPicker(p, activity);
        ExpressionBuilderPicker[] pickers = new ExpressionBuilderPicker[]{picker, ExpressionBuilderUsecases.createFunctionsExpressionBuilderPicker((NamespaceResolver)nsResolver, (int)2)};
        XPathEditorPane pane = new XPathEditorPane();
        pane.initializeDocument();
        pane.initializeEditorPane((VariableDataCallBack)dataCallBack, editorPane.getText(), (NamespaceResolver)nsResolver, false);
        BpelExpressionBuilder dlg = new BpelExpressionBuilder(GraphUtils.getFrame((Component)((Object)this.m_graphPane)), (JTextComponent)pane, pickers);
        if (dlg.display() == 0) {
            editorPane.setText(dlg.getExpressionText());
        }
    }

    protected String getText(JTextField textField, String initStr, String targetText) {
        String text;
        block7: {
            text = textField.getText();
            int textLength = textField.getDocument().getLength();
            if (text != null) {
                int caretPos = textField.getCaretPosition();
                if (caretPos > 0 && caretPos < textLength) {
                    try {
                        if (initStr != null) {
                            String subStr = textField.getDocument().getText(0, caretPos + 2);
                            int startIndex = subStr.lastIndexOf("<%");
                            int endIndex = text.indexOf("%>", caretPos);
                            text = startIndex == -1 || endIndex == -1 ? text + targetText : text.substring(0, startIndex) + targetText + text.substring(endIndex + 2, textLength);
                            break block7;
                        }
                        String startText = textField.getDocument().getText(0, caretPos);
                        int length = textLength - caretPos;
                        String endText = textField.getDocument().getText(caretPos, length);
                        text = startText + targetText + endText;
                    }
                    catch (BadLocationException bae) {
                        text = text + targetText;
                    }
                } else {
                    text = caretPos == 0 ? targetText + text : text + targetText;
                }
            } else {
                text = targetText;
            }
        }
        return text;
    }

    protected String getDelimiterString(JTextField textField) {
        int caretPos = textField.getCaretPosition();
        String retStr = null;
        try {
            String text = textField.getText();
            int indexOfStartingDelimiter = text.lastIndexOf("<%", caretPos);
            int indexOfPrecedingEndingDelimiter = text.lastIndexOf("%>", caretPos - 1);
            int indexOfFollowingEndingDelimiter = text.indexOf("%>", caretPos);
            if (indexOfStartingDelimiter != -1 && indexOfStartingDelimiter > indexOfPrecedingEndingDelimiter) {
                retStr = indexOfFollowingEndingDelimiter == -1 ? text.substring(indexOfStartingDelimiter + 2) : text.substring(indexOfStartingDelimiter + 2, indexOfFollowingEndingDelimiter);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return retStr;
    }

    protected String parseConcatExp(String exp) {
        if (!exp.startsWith("concat(") || !exp.endsWith(")")) {
            return exp;
        }
        String str = exp.substring(7, exp.length() - 1);
        ArrayList<String> strList = new ArrayList<String>();
        char[] chArray = str.toCharArray();
        boolean bEscape = false;
        int beginIdx = 0;
        for (int i = 0; i < chArray.length; ++i) {
            if (chArray[i] == ',') {
                if (!bEscape) {
                    strList.add(str.substring(beginIdx, i));
                    beginIdx = i + 1;
                }
            } else if (chArray[i] == '(') {
                bEscape = true;
            } else if (chArray[i] == ')') {
                bEscape = false;
            }
            if (i != chArray.length - 1 || beginIdx == chArray.length) continue;
            strList.add(str.substring(beginIdx, chArray.length));
        }
        StringBuffer strBuf = new StringBuffer();
        for (int i = 0; i < strList.size(); ++i) {
            String s = (String)strList.get(i);
            if ((s = s.trim()).startsWith("string(")) {
                MessageFormat fmt = new MessageFormat("string(''{0}'')");
                try {
                    Object[] obj = fmt.parse(s);
                    strBuf.append((String)obj[0]);
                }
                catch (ParseException ex) {
                    ex.printStackTrace();
                }
                continue;
            }
            strBuf.append("<%");
            strBuf.append(s);
            strBuf.append("%>");
        }
        return strBuf.toString();
    }

    protected void handleGraphicBuilderForTextField(JTextField textField, Activity activity) {
        XPathEditorPane x = new XPathEditorPane();
        String inStr = this.getDelimiterString(textField);
        x.setText(inStr);
        this.invokeGraphicalXPathBuilder(x, activity);
        String s = x.getText();
        if (Helper.hasValue((String)s)) {
            textField.setText(this.getText(textField, inStr, "<%" + s + "%>"));
        }
    }

    protected void selectOperation(String op, JComboBox cb) {
        if (op != null) {
            DefaultComboBoxModel model = (DefaultComboBoxModel)cb.getModel();
            boolean bSelected = false;
            for (int i = 0; i < model.getSize() && !bSelected; ++i) {
                WSDLOperationListItem item = (WSDLOperationListItem)model.getElementAt(i);
                if (!item.toString().equals(op)) continue;
                model.setSelectedItem(item);
                bSelected = true;
            }
        } else {
            DefaultComboBoxModel model = (DefaultComboBoxModel)cb.getModel();
            if (model.getSize() > 0) {
                cb.setSelectedIndex(0);
            }
        }
    }

    public BPELGraphPane getGraphPane() {
        return this.m_graphPane;
    }

    public Variable createElementVariable(Process process, Activity act, QName qname, String name, List<URL> xsdURLs) {
        Variable variable = null;
        name = VarNameCreationManager.getInstance().getVariableName(process, act, name);
        String vName = BPELModelUtil.getUniqueVariableName((Process)process, (String)name);
        if (qname != null) {
            String nsURI = qname.getNamespaceURI();
            String prefix = process.addNamespace(nsURI);
            QName qname2 = new QName(nsURI, qname.getLocalPart(), prefix);
            variable = (Variable)BPELParser.createImplementation(Variable.class);
            variable.setName(vName);
            variable.setElement(qname2);
            try {
                for (URL xsdUrl : xsdURLs) {
                    if (xsdUrl.getProtocol().indexOf("file") >= 0 && !URLFileSystem.exists((URL)xsdUrl)) {
                        xsdUrl = URLFactory.newURL((URL)this.m_graphPane.getBPELProject().getProjectURL(), (String)xsdUrl.getPath());
                    }
                    WSDLUtil.addImportToWSDL((BPELProject)this.m_graphPane.getBPELProject(), (URL)xsdUrl, (String)qname.getNamespaceURI());
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        } else {
            GraphUtils.displayMessage((Component)this, (String)BPELStringTranslator.getString("EDITOR_BE_CANT_CREATE_IN_VAR"), (int)0);
        }
        return variable;
    }
}

