/*
 * Decompiled with CFR 0.152.
 */
package oracle.tip.tools.ide.pm.bpelgraph.editors;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.JToolBar;
import javax.swing.ListSelectionModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;
import oracle.tip.tools.ide.common.bpeldesigner.util.AnnotationUtil;
import oracle.tip.tools.ide.common.bpeldesigner.util.Helper;
import oracle.tip.tools.ide.common.bpelparser.BPELParser;
import oracle.tip.tools.ide.common.bpelparser.extension.annotation.iface.Analysis;
import oracle.tip.tools.ide.common.bpelparser.extension.annotation.iface.Annotation;
import oracle.tip.tools.ide.common.bpelparser.extension.annotation.iface.Documentation;
import oracle.tip.tools.ide.common.bpelparser.extension.annotation.iface.General;
import oracle.tip.tools.ide.common.bpelparser.extension.annotation.iface.Property;
import oracle.tip.tools.ide.common.bpelparser.iface.Activity;
import oracle.tip.tools.ide.common.graph.GraphUtils;
import oracle.tip.tools.ide.common.ui.GlobalImageCache;
import oracle.tip.tools.ide.common.ui.UIHelper;
import oracle.tip.tools.ide.pm.bpelgraph.editors.AnnotationDialog;
import oracle.tip.tools.ide.pm.bpelgraph.editors.AnnotationTableModel;
import oracle.tip.tools.ide.pm.bpelgraph.views.BPELGraphPane;
import oracle.tip.tools.ide.pm.i18n.BPELStringTranslator;

public class BPELXAnnotationPanel
extends JPanel
implements ActionListener,
ListSelectionListener {
    protected BPELGraphPane m_graph;
    protected JTable m_generalTable;
    protected JTable m_analysisTable;
    protected JButton m_addGeneralAnotationBtn;
    protected JButton m_removeGeneralAnotationBtn;
    protected JButton m_editGeneralAnotationBtn;
    protected JButton m_addAnalysisAnotationBtn;
    protected JButton m_removeAnalysisAnotationBtn;
    protected JButton m_editAnalysisAnotationBtn;
    protected JTextArea m_documentArea;
    protected JCheckBox m_annotationCB;
    protected JTabbedPane m_tabPanel;
    protected Activity m_activity;

    public BPELXAnnotationPanel(BPELGraphPane graph, Activity activity) {
        this.m_activity = activity;
        this.m_graph = graph;
        this.createControls();
        this.layoutControls();
        this.updateButtons();
    }

    public String getDocumentAnnotation() {
        return this.m_documentArea.getText().trim();
    }

    public List<Property> getGeneralAnnotations() {
        AnnotationTableModel model = (AnnotationTableModel)((Object)this.m_generalTable.getModel());
        return new ArrayList<Property>(model.getData());
    }

    public List<Property> getAnalysisAnnotations() {
        AnnotationTableModel model = (AnnotationTableModel)((Object)this.m_analysisTable.getModel());
        return new ArrayList<Property>(model.getData());
    }

    public void load(Activity a) {
        this.m_activity = a;
        if (a == null) {
            AnnotationTableModel gmodel = (AnnotationTableModel)((Object)this.m_generalTable.getModel());
            gmodel.getData().clear();
            gmodel.refresh();
            AnnotationTableModel amodel = (AnnotationTableModel)((Object)this.m_analysisTable.getModel());
            amodel.getData().clear();
            amodel.refresh();
            return;
        }
        List generalProperties = null;
        List analysisProperties = null;
        Annotation obj = this.m_activity.getAnnotation();
        String document = null;
        if (obj != null) {
            if (obj.getDocumentation() != null) {
                document = obj.getDocumentation().getValue();
            }
            if (obj.getGeneral() != null) {
                generalProperties = obj.getGeneral().getProperties();
            }
            if (obj.getAnalysis() != null) {
                analysisProperties = obj.getAnalysis().getProperties();
            }
        }
        if (!(document != null || generalProperties != null && generalProperties.size() != 0 || analysisProperties != null && analysisProperties.size() != 0)) {
            String url = this.m_graph.getSettings().m_annotationFileLocation;
            AnnotationUtil instance = new AnnotationUtil(url);
            try {
                obj = instance.getAnnotationObject(this.m_activity);
            }
            catch (Exception e) {
                ByteArrayOutputStream os = new ByteArrayOutputStream();
                PrintStream ps = new PrintStream(os);
                e.printStackTrace(ps);
                GraphUtils.displayMessage((Component)this, (String)"Failed to load annotation! View message log for exception trace");
            }
            if (obj != null) {
                document = obj.getDocumentation().getValue();
                generalProperties = obj.getGeneral().getProperties();
                analysisProperties = obj.getAnalysis().getProperties();
            }
            this.m_annotationCB.setSelected(false);
        } else {
            this.m_annotationCB.setSelected(true);
        }
        this.setAnnotationValue(document, generalProperties, analysisProperties);
        this.updateButtons();
        this.handleAnnotationCB();
    }

    private void setAnnotationValue(String document, List<Property> generalLst, List<Property> analysisLst) {
        if (document != null) {
            this.m_documentArea.setText(document);
        }
        if (generalLst != null) {
            Vector<Property> gdata = new Vector<Property>();
            AnnotationTableModel gmodel = (AnnotationTableModel)((Object)this.m_generalTable.getModel());
            for (Property annotation : generalLst) {
                gdata.addElement(annotation);
            }
            gmodel.setData(gdata);
        }
        if (analysisLst != null) {
            Vector<Property> adata = new Vector<Property>();
            AnnotationTableModel amodel = (AnnotationTableModel)((Object)this.m_analysisTable.getModel());
            for (Property annotation : analysisLst) {
                adata.addElement(annotation);
            }
            amodel.setData(adata);
        }
    }

    public void saveToModel() {
        Annotation ann = this.m_activity.getAnnotation();
        if (this.m_annotationCB.isSelected()) {
            List<Property> list;
            String doc;
            if (ann == null) {
                ann = (Annotation)BPELParser.createImplementation(Annotation.class);
                this.m_activity.setAnnotation(ann);
            }
            if (Helper.hasValue((String)(doc = this.getDocumentAnnotation()))) {
                Documentation docu = ann.getDocumentation();
                if (docu == null) {
                    ann.setDocumentation((Documentation)BPELParser.createImplementation(Documentation.class));
                }
                ann.getDocumentation().setValue(doc);
            }
            if ((list = this.getGeneralAnnotations()).size() > 0) {
                General g = ann.getGeneral();
                if (g == null) {
                    ann.setGeneral((General)BPELParser.createImplementation(General.class));
                }
                ann.getGeneral().setProperties(list);
            } else {
                ann.setGeneral(null);
            }
            list = this.getAnalysisAnnotations();
            if (list.size() > 0) {
                Analysis a = ann.getAnalysis();
                if (a == null) {
                    ann.setAnalysis((Analysis)BPELParser.createImplementation(Analysis.class));
                }
                ann.getAnalysis().setProperties(list);
            } else {
                ann.setAnalysis(null);
            }
        } else if (ann != null && ann.getPattern() == null) {
            this.m_activity.setAnnotation(null);
        } else if (ann != null && ann.getPattern() != null) {
            ann.setDocumentation(null);
            ann.setAnalysis(null);
            ann.setGeneral(null);
        }
    }

    protected boolean validateData() {
        return true;
    }

    protected void createControls() {
        this.m_generalTable = new JTable((TableModel)((Object)new AnnotationTableModel()));
        GrayCellRenderer r = new GrayCellRenderer();
        this.m_generalTable.getSelectionModel().addListSelectionListener(this);
        TableColumnModel colModel = this.m_generalTable.getColumnModel();
        for (int i = 0; i < colModel.getColumnCount(); ++i) {
            TableColumn col = colModel.getColumn(i);
            col.setCellRenderer(r);
            col.setPreferredWidth(120);
        }
        this.m_generalTable.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                Point origin = e.getPoint();
                int row = BPELXAnnotationPanel.this.m_generalTable.rowAtPoint(origin);
                int column = BPELXAnnotationPanel.this.m_generalTable.columnAtPoint(origin);
                if (row == -1 || column == -1) {
                    return;
                }
                if (e.getClickCount() == 2) {
                    BPELXAnnotationPanel.this.handleEditGeneralAnnotation();
                }
            }

            @Override
            public void mouseReleased(MouseEvent e) {
            }
        });
        this.m_analysisTable = new JTable((TableModel)((Object)new AnnotationTableModel()));
        r = new GrayCellRenderer();
        this.m_analysisTable.getSelectionModel().addListSelectionListener(this);
        TableColumnModel colModel2 = this.m_analysisTable.getColumnModel();
        for (int i = 0; i < colModel2.getColumnCount(); ++i) {
            TableColumn col = colModel2.getColumn(i);
            col.setCellRenderer(r);
            col.setPreferredWidth(120);
        }
        this.m_analysisTable.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                Point origin = e.getPoint();
                int row = BPELXAnnotationPanel.this.m_analysisTable.rowAtPoint(origin);
                int column = BPELXAnnotationPanel.this.m_analysisTable.columnAtPoint(origin);
                if (row == -1 || column == -1) {
                    return;
                }
                if (e.getClickCount() == 2) {
                    BPELXAnnotationPanel.this.handleEditAnalysisAnnotation();
                }
            }

            @Override
            public void mouseReleased(MouseEvent e) {
            }
        });
        this.m_addGeneralAnotationBtn = new JButton(GlobalImageCache.getIcon((String)"create16"));
        this.m_addGeneralAnotationBtn.addActionListener(this);
        this.m_removeGeneralAnotationBtn = new JButton(GlobalImageCache.getIcon((String)"delete16"));
        this.m_removeGeneralAnotationBtn.addActionListener(this);
        this.m_editGeneralAnotationBtn = new JButton(GlobalImageCache.getIcon((String)"edit16"));
        this.m_editGeneralAnotationBtn.addActionListener(this);
        this.m_addAnalysisAnotationBtn = new JButton(GlobalImageCache.getIcon((String)"create16"));
        this.m_addAnalysisAnotationBtn.addActionListener(this);
        this.m_removeAnalysisAnotationBtn = new JButton(GlobalImageCache.getIcon((String)"delete16"));
        this.m_removeAnalysisAnotationBtn.addActionListener(this);
        this.m_editAnalysisAnotationBtn = new JButton(GlobalImageCache.getIcon((String)"edit16"));
        this.m_editAnalysisAnotationBtn.addActionListener(this);
        this.m_documentArea = new JTextArea();
        this.m_documentArea.setWrapStyleWord(true);
        this.m_annotationCB = new JCheckBox("", false);
        BPELStringTranslator.setButton(this.m_annotationCB, BPELStringTranslator.getString("EDITOR_ANNOTATIONS_PNL_ENABLE_ANNOTATION"));
        this.m_annotationCB.addActionListener(this);
    }

    protected void layoutControls() {
        this.m_tabPanel = new JTabbedPane();
        this.m_tabPanel.addTab(BPELStringTranslator.getString("EDITOR_ANNOTATIONS_PNL_GENERAL"), this.createGeneralPanel());
        this.m_tabPanel.setSelectedIndex(0);
        this.m_tabPanel.addTab(BPELStringTranslator.getString("EDITOR_ANNOTATIONS_PNL_ANALYSIS"), this.createAnalysisPanel());
        this.setLayout(new GridBagLayout());
        int row = 0;
        GraphUtils.addComponent((Container)this, (Component)this.m_annotationCB, (int)0, (int)row++, (int)1, (int)1, (int)17, (int)0, (Insets)new Insets(0, 0, 0, 5), (int)0, (int)0, (double)1.0, (double)0.0);
        GraphUtils.addComponent((Container)this, (Component)this.createDocumentPanel(), (int)0, (int)row++, (int)1, (int)1, (int)17, (int)1, (Insets)new Insets(0, 0, 0, 0), (int)0, (int)0, (double)1.0, (double)0.5);
        GraphUtils.addComponent((Container)this, (Component)this.m_tabPanel, (int)0, (int)row, (int)1, (int)1, (int)17, (int)1, (Insets)new Insets(5, 0, 0, 5), (int)0, (int)0, (double)1.0, (double)1.0);
    }

    protected JPanel createDocumentPanel() {
        JLabel doclabel = new JLabel();
        BPELStringTranslator.setLabel(doclabel, this.m_documentArea, BPELStringTranslator.getString("EDITOR_ANNOTATIONS_PNL_DOCUMENTATION"));
        JPanel p = new JPanel(new GridBagLayout());
        GraphUtils.addComponent((Container)p, (Component)doclabel, (int)0, (int)0, (int)1, (int)1, (int)16, (int)0, (Insets)new Insets(5, 5, 0, 5), (int)0, (int)0, (double)0.0, (double)0.0);
        GraphUtils.addComponent((Container)p, (Component)new JScrollPane(this.m_documentArea), (int)0, (int)1, (int)1, (int)1, (int)17, (int)1, (Insets)new Insets(2, 5, 5, 5), (int)0, (int)0, (double)1.0, (double)1.0);
        return p;
    }

    protected JPanel createGeneralPanel() {
        JToolBar tb = UIHelper.createToolBar();
        tb.add(this.m_addGeneralAnotationBtn);
        tb.add(this.m_editGeneralAnotationBtn);
        tb.add(this.m_removeGeneralAnotationBtn);
        JPanel panel = new JPanel(new GridBagLayout());
        JScrollPane sp = new JScrollPane(this.m_generalTable);
        sp.getViewport().setBackground(Color.white);
        int row = 0;
        GraphUtils.addComponent((Container)panel, (Component)tb, (int)0, (int)row++, (int)1, (int)1, (int)13, (int)0, (Insets)new Insets(5, 5, 0, 5), (int)0, (int)0, (double)1.0, (double)0.0);
        GraphUtils.addComponent((Container)panel, (Component)sp, (int)0, (int)row++, (int)1, (int)1, (int)17, (int)1, (Insets)new Insets(0, 5, 5, 5), (int)0, (int)0, (double)1.0, (double)1.0);
        return panel;
    }

    protected JPanel createAnalysisPanel() {
        JToolBar tb = UIHelper.createToolBar();
        tb.add(this.m_addAnalysisAnotationBtn);
        tb.add(this.m_editAnalysisAnotationBtn);
        tb.add(this.m_removeAnalysisAnotationBtn);
        JPanel panel = new JPanel(new GridBagLayout());
        JScrollPane sp = new JScrollPane(this.m_analysisTable);
        sp.getViewport().setBackground(Color.white);
        int row = 0;
        GraphUtils.addComponent((Container)panel, (Component)tb, (int)0, (int)row++, (int)1, (int)1, (int)13, (int)0, (Insets)new Insets(5, 5, 0, 5), (int)0, (int)0, (double)1.0, (double)0.0);
        GraphUtils.addComponent((Container)panel, (Component)sp, (int)0, (int)row++, (int)1, (int)1, (int)17, (int)1, (Insets)new Insets(0, 5, 5, 5), (int)0, (int)0, (double)1.0, (double)1.0);
        return panel;
    }

    protected void handleAddGeneralAnnotation() {
        ArrayList<Property> list = new ArrayList<Property>();
        AnnotationDialog dlg = new AnnotationDialog(GraphUtils.getFrame((Component)this), this.m_graph);
        AnnotationTableModel model = (AnnotationTableModel)((Object)this.m_generalTable.getModel());
        List data = model.getData();
        for (Property annotation : data) {
            list.add(annotation);
        }
        if (dlg.create(list) != 0) {
            return;
        }
        Property newRow = dlg.getAnnotationData();
        model.getData().add(newRow);
        model.refresh();
        this.updateButtons();
    }

    protected void handleRemoveGeneralAnnotation() {
        TableModel model = this.m_generalTable.getModel();
        if (model instanceof AnnotationTableModel) {
            AnnotationTableModel tabModel = (AnnotationTableModel)((Object)model);
            int[] rows = this.m_generalTable.getSelectedRows();
            tabModel.removeRows(rows);
            this.updateButtons();
        }
    }

    protected void handleEditGeneralAnnotation() {
        ListSelectionModel model = this.m_generalTable.getSelectionModel();
        if (model.isSelectionEmpty()) {
            return;
        }
        int row = model.getLeadSelectionIndex();
        AnnotationTableModel tableModel = (AnnotationTableModel)((Object)this.m_generalTable.getModel());
        Property data = (Property)tableModel.getRowData(row);
        AnnotationDialog dlg = new AnnotationDialog(GraphUtils.getFrame((Component)this), this.m_graph);
        List v = tableModel.getData();
        ArrayList<Property> list = new ArrayList<Property>();
        for (Property annotation : v) {
            list.add(annotation);
        }
        if (dlg.edit(list, data) == 0) {
            tableModel.refresh();
        }
    }

    protected void updateButtons() {
        ListSelectionModel model = this.m_generalTable.getSelectionModel();
        this.m_removeGeneralAnotationBtn.setEnabled(!model.isSelectionEmpty());
        this.m_editGeneralAnotationBtn.setEnabled(!model.isSelectionEmpty());
        model = this.m_analysisTable.getSelectionModel();
        this.m_removeAnalysisAnotationBtn.setEnabled(!model.isSelectionEmpty());
        this.m_editAnalysisAnotationBtn.setEnabled(!model.isSelectionEmpty());
    }

    protected void handleAddAnalysisAnnotation() {
        ArrayList<Property> list = new ArrayList<Property>();
        AnnotationDialog dlg = new AnnotationDialog(GraphUtils.getFrame((Component)this), this.m_graph);
        AnnotationTableModel model = (AnnotationTableModel)((Object)this.m_analysisTable.getModel());
        List data = model.getData();
        for (Property annotation : data) {
            list.add(annotation);
        }
        if (dlg.create(list) != 0) {
            return;
        }
        Property newRow = dlg.getAnnotationData();
        model.getData().add(newRow);
        model.refresh();
        this.updateButtons();
    }

    protected void handleRemoveAnalysisAnnotation() {
        TableModel model = this.m_analysisTable.getModel();
        if (model instanceof AnnotationTableModel) {
            AnnotationTableModel tabModel = (AnnotationTableModel)((Object)model);
            int[] rows = this.m_analysisTable.getSelectedRows();
            tabModel.removeRows(rows);
            this.updateButtons();
        }
    }

    protected void handleEditAnalysisAnnotation() {
        ListSelectionModel model = this.m_analysisTable.getSelectionModel();
        if (model.isSelectionEmpty()) {
            return;
        }
        int row = model.getLeadSelectionIndex();
        AnnotationTableModel tableModel = (AnnotationTableModel)((Object)this.m_analysisTable.getModel());
        Property data = (Property)tableModel.getRowData(row);
        AnnotationDialog dlg = new AnnotationDialog(GraphUtils.getFrame((Component)this), this.m_graph);
        List v = tableModel.getData();
        ArrayList<Property> list = new ArrayList<Property>();
        for (Property annotation : v) {
            list.add(annotation);
        }
        if (dlg.edit(list, data) == 0) {
            tableModel.refresh();
        }
    }

    protected void handleAnnotationCB() {
        boolean b = this.m_annotationCB.isSelected();
        this.m_documentArea.setEnabled(b);
        this.m_tabPanel.setEnabled(b);
        this.m_generalTable.setEnabled(b);
        this.m_analysisTable.setEnabled(b);
        this.m_addGeneralAnotationBtn.setEnabled(b);
        this.m_addAnalysisAnotationBtn.setEnabled(b);
        ListSelectionModel gmodel = this.m_generalTable.getSelectionModel();
        ListSelectionModel amodel = this.m_analysisTable.getSelectionModel();
        if (!b) {
            gmodel.clearSelection();
            amodel.clearSelection();
        }
    }

    @Override
    public void valueChanged(ListSelectionEvent e) {
        this.updateButtons();
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Object src = e.getSource();
        if (src == this.m_addGeneralAnotationBtn) {
            this.handleAddGeneralAnnotation();
        } else if (src == this.m_removeGeneralAnotationBtn) {
            this.handleRemoveGeneralAnnotation();
        } else if (src == this.m_editGeneralAnotationBtn) {
            this.handleEditGeneralAnnotation();
        } else if (src == this.m_addAnalysisAnotationBtn) {
            this.handleAddAnalysisAnnotation();
        } else if (src == this.m_removeAnalysisAnotationBtn) {
            this.handleRemoveAnalysisAnnotation();
        } else if (src == this.m_editAnalysisAnotationBtn) {
            this.handleEditAnalysisAnnotation();
        } else if (src == this.m_annotationCB) {
            this.handleAnnotationCB();
        }
    }

    class GrayCellRenderer
    extends DefaultTableCellRenderer {
        GrayCellRenderer() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            Component c = super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
            if (!table.isEnabled()) {
                this.setForeground(Color.gray);
            } else {
                this.setForeground(Color.black);
            }
            return c;
        }
    }
}

