/*
 * Decompiled with CFR 0.152.
 */
package oracle.tip.tools.ide.pm.bpelgraph.editors;

import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JPanel;
import oracle.tip.tools.ide.common.bpelparser.extension.annotation.iface.Property;
import oracle.tip.tools.ide.common.bpelparser.util.BPELModelUtil;
import oracle.tip.tools.ide.common.graph.GraphUtils;
import oracle.tip.tools.ide.pm.bpelgraph.editors.AnnotationDataPanel;
import oracle.tip.tools.ide.pm.bpelgraph.views.BPELGraphPane;
import oracle.tip.tools.ide.pm.gui.generalpurpose.BPELBaseDialog;
import oracle.tip.tools.ide.pm.i18n.BPELStringTranslator;

public class AnnotationDialog
extends BPELBaseDialog
implements ActionListener,
PropertyChangeListener {
    public static final int OK = 0;
    public static final int CANCEL = 1;
    private JButton m_okBtn;
    private JButton m_cancelBtn;
    protected JButton m_helpBtn;
    protected AnnotationDataPanel m_annotationPanel;
    protected BPELGraphPane m_graph;
    protected int m_retVal = 1;
    protected boolean m_bEditing = false;
    protected List<Property> m_annotationNameFilter;

    public AnnotationDialog(JFrame f, BPELGraphPane graph) {
        super(f, "Annotation", true);
        this.m_graph = graph;
        this.createAndLayoutControls();
        this.updateButtons();
    }

    public void setAnnotationData(Property data) {
        this.m_annotationPanel.setProperty(data);
    }

    public Property getAnnotationData() {
        return this.m_annotationPanel.getProperty();
    }

    public void saveToModel() {
        this.m_annotationPanel.saveToModel();
    }

    public int create(List<Property> annotationNameFilter) {
        this.m_bEditing = false;
        this.m_annotationNameFilter = annotationNameFilter;
        this.setTitle(BPELStringTranslator.getString("EDITOR_ANNOTATION_DLG_CREATE"));
        return this.display();
    }

    public int edit(List<Property> annotationNameFilter, Property data) {
        this.m_bEditing = true;
        this.m_annotationNameFilter = annotationNameFilter;
        this.setAnnotationData(data);
        this.setTitle(BPELStringTranslator.getString("EDITOR_ANNOTATION_DLG_EDIT") + data.getName());
        return this.display();
    }

    private int display() {
        this.setVisible(true);
        return this.m_retVal;
    }

    protected void createAndLayoutControls() {
        this.m_annotationPanel = new AnnotationDataPanel(this.m_graph);
        this.m_annotationPanel.addPropertyChangeListener(this);
        this.m_okBtn = new JButton();
        BPELStringTranslator.setButton(this.m_okBtn, BPELStringTranslator.getString("OK_BUTTON_TEXT_RES"));
        this.m_okBtn.addActionListener(this);
        this.m_cancelBtn = new JButton();
        BPELStringTranslator.setButton(this.m_cancelBtn, BPELStringTranslator.getString("CANCEL_BUTTON_TEXT_RES"));
        this.m_cancelBtn.addActionListener(this);
        this.m_helpBtn = new JButton();
        BPELStringTranslator.setButton(this.m_helpBtn, BPELStringTranslator.getString("HELP_BUTTON_TEXT_RES"));
        this.m_helpBtn.addActionListener(this);
        JPanel btnPnl = new JPanel(new GridLayout(1, 2, 5, 0));
        btnPnl.add(this.m_okBtn);
        btnPnl.add(this.m_cancelBtn);
        Container c = this.getContentPane();
        c.setLayout(new GridBagLayout());
        int row = 0;
        GraphUtils.addComponent((Container)c, (Component)this.m_annotationPanel, (int)0, (int)row++, (int)2, (int)1, (int)17, (int)2, (Insets)new Insets(5, 5, 0, 5), (int)0, (int)0, (double)1.0, (double)0.0);
        GraphUtils.addComponent((Container)c, (Component)new JPanel(), (int)0, (int)row++, (int)2, (int)1, (int)17, (int)1, (Insets)new Insets(0, 0, 0, 0), (int)0, (int)0, (double)1.0, (double)1.0);
        GraphUtils.addComponent((Container)c, (Component)this.m_helpBtn, (int)0, (int)row, (int)1, (int)1, (int)17, (int)0, (Insets)new Insets(0, 10, 5, 5), (int)0, (int)0, (double)1.0, (double)0.0);
        GraphUtils.addComponent((Container)c, (Component)btnPnl, (int)1, (int)row++, (int)1, (int)1, (int)13, (int)0, (Insets)new Insets(0, 5, 5, 10), (int)0, (int)0, (double)1.0, (double)0.0);
        this.setSize(330, 150);
        this.setLocationRelativeTo(this.getParent());
    }

    protected void updateButtons() {
        this.m_okBtn.setEnabled(this.m_annotationPanel.isDataValid());
    }

    protected boolean isValidData() {
        if (!this.m_bEditing) {
            if (!BPELModelUtil.isUniqueAnnotationName(this.m_annotationNameFilter, (String)this.m_annotationPanel.getAnnotationDataName())) {
                GraphUtils.displayMessage((Component)GraphUtils.getFrame((Component)((Object)this)), (String)BPELStringTranslator.getString("EDITOR_ANNOTATION_CRE_DLG_ANNOTATION_EXIST"));
                return false;
            }
        } else {
            String origName = this.m_annotationPanel.getProperty().getName();
            String newName = this.m_annotationPanel.getAnnotationDataName();
            if (newName == null || newName.length() == 0) {
                return false;
            }
            if (newName.equalsIgnoreCase(origName)) {
                return true;
            }
            if (!BPELModelUtil.isUniqueAnnotationName(this.m_annotationNameFilter, (String)newName)) {
                GraphUtils.displayMessage((Component)GraphUtils.getFrame((Component)((Object)this)), (String)BPELStringTranslator.getString("EDITOR_ANNOTATION_CRE_DLG_ANNOTATION_EXIST"));
                return false;
            }
        }
        return true;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Object src = e.getSource();
        if (src == this.m_okBtn) {
            this.handleOk();
        } else if (src == this.m_cancelBtn) {
            this.handleCancel();
        } else if (src == this.m_helpBtn) {
            this.helpInvoked();
        }
    }

    protected void handleOk() {
        if (!this.isValidData()) {
            return;
        }
        this.saveToModel();
        this.m_retVal = 0;
        this.dispose();
    }

    protected void handleCancel() {
        this.m_retVal = 1;
        this.dispose();
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        Object src = evt.getSource();
        if (src == this.m_annotationPanel) {
            this.updateButtons();
        }
    }

    protected void handleEnterKey() {
        if (this.m_annotationPanel.isDataValid()) {
            this.handleOk();
        } else {
            GraphUtils.displayMessage((Component)GraphUtils.getFrame((Component)((Object)this)), (String)BPELStringTranslator.getString("EDITOR_ANNOTATION_CRE_DLG_INVALID_DATA"));
        }
    }

    protected void helpInvoked() {
        this.handleHelp(this.m_annotationPanel);
    }
}

