/*
 * Decompiled with CFR 0.152.
 */
package oracle.tip.tools.ide.pm.bpelgraph.editors;

import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import oracle.tip.tools.ide.common.bpelparser.BPELParser;
import oracle.tip.tools.ide.common.bpelparser.extension.annotation.iface.Property;
import oracle.tip.tools.ide.common.bpelparser.iface.ParserContext;
import oracle.tip.tools.ide.common.bpelparser.iface.Process;
import oracle.tip.tools.ide.common.graph.GraphUtils;
import oracle.tip.tools.ide.common.typeexplorer.TypeObject;
import oracle.tip.tools.ide.pm.bpelgraph.views.BPELGraphPane;
import oracle.tip.tools.ide.pm.i18n.BPELStringTranslator;

public class AnnotationDataPanel
extends JPanel {
    public static final String NAME_CHANGED = "NAME_CHANGED";
    public static final String VALUE_CHANGED = "VALUE_CHANGED";
    protected JTextField m_nameField;
    protected JTextField m_valueField;
    protected TypeObject m_typeObj;
    protected BPELGraphPane m_graph;
    protected Property m_property;

    public AnnotationDataPanel(BPELGraphPane graph) {
        this.m_graph = graph;
        this.createControls();
        this.layoutControls();
    }

    public boolean isDataValid() {
        String name = this.m_nameField.getText().trim();
        String value = this.m_valueField.getText().trim();
        if (name == null || name.length() == 0) {
            return false;
        }
        return value != null && value.length() != 0;
    }

    public void setProperty(Property property) {
        this.m_property = property;
        if (this.m_property != null) {
            this.m_nameField.setText(this.m_property.getName());
            this.m_valueField.setText(this.m_property.getValue());
        }
    }

    public Property getProperty() {
        return this.m_property;
    }

    public String getAnnotationDataName() {
        return this.m_nameField.getText().trim();
    }

    public Property saveToModel() {
        String value;
        String name;
        if (this.m_property == null) {
            this.m_property = (Property)BPELParser.createImplementation(Property.class);
            Process process = this.m_graph.getBPELXmlModel().getProcess();
            ParserContext ct = new ParserContext();
            ct.setProcess(process);
            this.m_property.setParserContext(ct);
        }
        if ((name = this.m_nameField.getText()) != null) {
            this.m_property.setName(name.trim());
        }
        if ((value = this.m_valueField.getText()) != null) {
            this.m_property.setValue(value.trim());
        }
        return this.m_property;
    }

    protected void createControls() {
        this.m_nameField = new JTextField();
        this.m_nameField.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent e) {
                AnnotationDataPanel.this.firePropertyChange(AnnotationDataPanel.NAME_CHANGED, null, AnnotationDataPanel.this.m_nameField.getText());
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                AnnotationDataPanel.this.firePropertyChange(AnnotationDataPanel.NAME_CHANGED, null, AnnotationDataPanel.this.m_nameField.getText());
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                AnnotationDataPanel.this.firePropertyChange(AnnotationDataPanel.NAME_CHANGED, null, AnnotationDataPanel.this.m_nameField.getText());
            }
        });
        this.m_valueField = new JTextField();
        this.m_valueField.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent e) {
                AnnotationDataPanel.this.firePropertyChange(AnnotationDataPanel.VALUE_CHANGED, null, AnnotationDataPanel.this.m_valueField.getText());
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                AnnotationDataPanel.this.firePropertyChange(AnnotationDataPanel.VALUE_CHANGED, null, AnnotationDataPanel.this.m_valueField.getText());
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                AnnotationDataPanel.this.firePropertyChange(AnnotationDataPanel.VALUE_CHANGED, null, AnnotationDataPanel.this.m_valueField.getText());
            }
        });
    }

    protected void layoutControls() {
        this.setLayout(new GridBagLayout());
        JLabel nameLbl = new JLabel();
        BPELStringTranslator.setLabel(nameLbl, this.m_nameField, BPELStringTranslator.getString("GENERAL_EDITOR_NAME"));
        JLabel valueLbl = new JLabel();
        BPELStringTranslator.setLabel(valueLbl, this.m_valueField, BPELStringTranslator.getString("VALUE_LBL"));
        int row = 0;
        GraphUtils.addComponent((Container)this, (Component)nameLbl, (int)0, (int)row, (int)1, (int)1, (int)17, (int)0, (Insets)new Insets(5, 5, 0, 0), (int)0, (int)0, (double)0.0, (double)0.0);
        GraphUtils.addComponent((Container)this, (Component)this.m_nameField, (int)1, (int)row++, (int)1, (int)1, (int)17, (int)2, (Insets)new Insets(5, 5, 0, 5), (int)0, (int)0, (double)1.0, (double)0.0);
        GraphUtils.addComponent((Container)this, (Component)valueLbl, (int)0, (int)row, (int)1, (int)1, (int)17, (int)0, (Insets)new Insets(5, 5, 0, 0), (int)0, (int)0, (double)0.0, (double)0.0);
        GraphUtils.addComponent((Container)this, (Component)this.m_valueField, (int)1, (int)row, (int)1, (int)1, (int)17, (int)2, (Insets)new Insets(5, 5, 0, 5), (int)0, (int)0, (double)1.0, (double)0.0);
    }
}

