/*
 * Decompiled with CFR 0.152.
 */
package oracle.tip.tools.ide.pm.bpelgraph.editors;

import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.HashMap;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import oracle.tip.tools.ide.common.bpeldesigner.util.Helper;
import oracle.tip.tools.ide.common.bpelparser.iface.Activity;
import oracle.tip.tools.ide.common.graph.GraphUtils;
import oracle.tip.tools.ide.common.ui.CardPanel;
import oracle.tip.tools.ide.common.ui.UIHelper;
import oracle.tip.tools.ide.common.utils.MessagePart;
import oracle.tip.tools.ide.pm.bpelgraph.editors.AdapterPropertyNode;
import oracle.tip.tools.ide.pm.bpelgraph.views.BPELGraphPane;
import oracle.tip.tools.ide.pm.gui.dialogs.variablexpathbuilder.VariableXPathBuilder;
import oracle.tip.tools.ide.pm.i18n.BPELStringTranslator;

public class AdapterValuePanel
extends JPanel
implements ActionListener {
    private static final String VARIABLE_PANEL = "VARIABLE_PANEL";
    private static final String EXPRESSION_PANEL = "EXPRESSION_PANEL";
    public static final int VARIABLE_TYPE = 0;
    public static final int EXPRESSION_TYPE = 1;
    protected JRadioButton m_varButton;
    protected JRadioButton m_exprButton;
    protected JPanel m_varPnl;
    protected JPanel m_exprPnl;
    protected JTextField m_varField;
    protected JTextField m_exprField;
    protected JButton m_varBrowseBtn;
    protected CardPanel m_cardPnl;
    protected Activity m_activity;
    protected BPELGraphPane m_graph;
    protected AdapterPropertyNode m_value;

    public AdapterValuePanel(Activity a, BPELGraphPane graph, AdapterPropertyNode node) {
        this.m_value = node;
        this.m_activity = a;
        this.m_graph = graph;
        this.createControls();
        this.layoutControls();
        this.loadUI();
    }

    protected void loadUI() {
        if (this.m_value.isExpression()) {
            this.m_exprButton.doClick();
            this.m_exprField.setText(this.m_value.getExpression());
        } else {
            this.m_varButton.doClick();
            this.m_varField.setText(this.m_value.toString());
        }
    }

    public int getSelectedType() {
        if (this.m_varButton.isSelected()) {
            return 0;
        }
        return 1;
    }

    public AdapterPropertyNode getValue() {
        AdapterPropertyNode n = new AdapterPropertyNode(null);
        if (this.m_varButton.isSelected()) {
            String s = this.m_varField.getText();
            HashMap<String, String> map = AdapterPropertyNode.parseVariable(s);
            String var = map.get("variable");
            String part = map.get("part");
            String query = map.get("query");
            n.setVariable(var);
            n.setPart(part);
            n.setQuery(query);
            n.setExpression(null);
        } else {
            String s = this.m_exprField.getText();
            n.setExpression(s);
            n.setVariable(null);
            n.setPart(null);
            n.setQuery(null);
        }
        return n;
    }

    protected void createControls() {
        this.m_varButton = new JRadioButton("Variable", true);
        BPELStringTranslator.setButton(this.m_varButton, BPELStringTranslator.getString("VAR_BUTTON"));
        this.m_varButton.addActionListener(this);
        this.m_exprButton = new JRadioButton("Expression");
        BPELStringTranslator.setButton(this.m_exprButton, BPELStringTranslator.getString("EXPR_BUTTON"));
        this.m_exprButton.addActionListener(this);
        ButtonGroup g = new ButtonGroup();
        g.add(this.m_varButton);
        g.add(this.m_exprButton);
        this.m_varPnl = this.createVariablePanel();
        this.m_exprPnl = this.createExpressionPanel();
        this.m_cardPnl = new CardPanel();
        this.m_cardPnl.add(VARIABLE_PANEL, (Component)this.createVariablePanel());
        this.m_cardPnl.add(EXPRESSION_PANEL, (Component)this.createExpressionPanel());
    }

    protected JPanel createVariablePanel() {
        this.m_varField = new JTextField();
        this.m_varBrowseBtn = UIHelper.createBrowseButton((String)BPELStringTranslator.getString("GENERAL_BROWSE_VARS"));
        this.m_varBrowseBtn.addActionListener(this);
        JPanel p = new JPanel(new GridBagLayout());
        GraphUtils.addComponent((Container)p, (Component)this.m_varField, (int)0, (int)0, (int)1, (int)1, (int)17, (int)2, (Insets)new Insets(5, 5, 5, 5), (int)0, (int)0, (double)1.0, (double)0.0);
        GraphUtils.addComponent((Container)p, (Component)this.m_varBrowseBtn, (int)1, (int)0, (int)1, (int)1, (int)17, (int)0, (Insets)new Insets(5, 0, 5, 5), (int)0, (int)0, (double)0.0, (double)0.0);
        GraphUtils.addComponent((Container)p, (Component)new JPanel(), (int)0, (int)1, (int)2, (int)1, (int)17, (int)1, (Insets)new Insets(5, 5, 5, 5), (int)0, (int)0, (double)1.0, (double)1.0);
        return p;
    }

    protected JPanel createExpressionPanel() {
        this.m_exprField = new JTextField();
        JPanel p = new JPanel(new GridBagLayout());
        GraphUtils.addComponent((Container)p, (Component)this.m_exprField, (int)0, (int)0, (int)1, (int)1, (int)17, (int)2, (Insets)new Insets(5, 5, 5, 5), (int)0, (int)0, (double)1.0, (double)0.0);
        GraphUtils.addComponent((Container)p, (Component)new JPanel(), (int)0, (int)1, (int)1, (int)1, (int)17, (int)1, (Insets)new Insets(5, 5, 5, 5), (int)0, (int)0, (double)1.0, (double)1.0);
        return p;
    }

    protected void layoutControls() {
        JPanel btnPnl = new JPanel(new GridLayout(1, 2, 5, 0));
        btnPnl.add(this.m_varButton);
        btnPnl.add(this.m_exprButton);
        this.setLayout(new GridBagLayout());
        GraphUtils.addComponent((Container)this, (Component)btnPnl, (int)0, (int)0, (int)1, (int)1, (int)10, (int)0, (Insets)new Insets(10, 5, 5, 5), (int)0, (int)0, (double)0.0, (double)0.0);
        GraphUtils.addComponent((Container)this, (Component)this.m_cardPnl, (int)0, (int)1, (int)1, (int)1, (int)17, (int)1, (Insets)new Insets(5, 5, 5, 5), (int)0, (int)0, (double)1.0, (double)1.0);
    }

    protected String showVariableXPathBuilder(String value) {
        String[] vals;
        String var = null;
        String part = null;
        String query = null;
        if (value != null && (vals = value.split(",")) != null) {
            int count = 0;
            block5: for (String tok : vals) {
                switch (count++) {
                    case 0: {
                        var = tok;
                        continue block5;
                    }
                    case 1: {
                        part = tok;
                        continue block5;
                    }
                    case 2: {
                        query = tok;
                        continue block5;
                    }
                }
            }
        }
        final VariableXPathBuilder dlg = new VariableXPathBuilder(GraphUtils.getFrame((Component)this), this.m_graph);
        if (var != null) {
            final String theVar = var;
            final String thePart = part;
            final String theQuery = query;
            dlg.getBuilderPanel().getProcessExplorer().getExplorerTree().getTree().addPropertyChangeListener(new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent evt) {
                    String prop = evt.getPropertyName();
                    if (prop != null && prop.equals("model")) {
                        if (Helper.hasValue((String)theVar) && Helper.hasValue((String)thePart)) {
                            dlg.getBuilderPanel().selectVariablePart(theVar, thePart, AdapterValuePanel.this.m_activity, theQuery);
                        } else {
                            dlg.getBuilderPanel().selectVariable(theVar, AdapterValuePanel.this.m_activity);
                        }
                    }
                }
            });
        }
        if (dlg.display(this.m_activity) == 0) {
            var = dlg.getVariable().getName();
            MessagePart msgPart = dlg.getPart();
            String text = var;
            if (msgPart != null && Helper.hasValue((String)msgPart.getName())) {
                text = text + "," + msgPart.getName();
                query = dlg.getXPath();
                if (Helper.hasValue((String)query)) {
                    text = text + "," + query;
                }
            }
            return text;
        }
        return null;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        String val;
        Object src = e.getSource();
        if (src == this.m_varButton) {
            this.m_cardPnl.show(VARIABLE_PANEL);
        } else if (src == this.m_exprButton) {
            this.m_cardPnl.show(EXPRESSION_PANEL);
        } else if (src == this.m_varBrowseBtn && (val = this.showVariableXPathBuilder(null)) != null) {
            this.m_varField.setText(val);
        }
    }
}

