/*
 * Decompiled with CFR 0.152.
 */
package oracle.tip.tools.ide.pm.bpelgraph.editors;

import oracle.tip.tools.ide.common.ui.BaseTableModel;
import oracle.tip.tools.ide.pm.bpelgraph.editors.AdapterPropertyNode;
import oracle.tip.tools.ide.pm.i18n.BPELStringTranslator;

public class AdapterPropertyTableModel
extends BaseTableModel<AdapterPropertyNode> {
    public static final int NAME_COLUMN = 0;
    public static final int VALUE_COLUMN = 1;
    public static final int TYPE_COLUMN = 2;
    public static final String INPUT_TEXT = "input";
    public static final String OUTPUT_TEXT = "output";
    public static final String DELIMITER = ",";
    protected boolean m_bShowType;

    public AdapterPropertyTableModel(boolean bShowType) {
        this.m_bShowType = bShowType;
    }

    public void setValueAt(Object value, int row, int col) {
        AdapterPropertyNode p = (AdapterPropertyNode)this.getRowData(row);
        if (col == 1) {
            AdapterPropertyNode newValue = (AdapterPropertyNode)value;
            p.clearData();
            if (value == null) {
                return;
            }
            if (newValue.isExpression()) {
                p.setExpression(newValue.getExpression());
            } else {
                p.setVariable(newValue.getVariable());
                p.setPart(newValue.getPart());
                p.setQuery(newValue.getQuery());
            }
            if (this.m_bShowType && p.getType() == -1) {
                p.setType(0);
            }
        } else if (col == 2) {
            String s = (String)value;
            if (s.equals(INPUT_TEXT)) {
                p.setType(0);
            } else if (s.equals(OUTPUT_TEXT)) {
                p.setType(1);
            }
        }
    }

    public boolean isCellEditable(int row, int col) {
        switch (col) {
            case 2: {
                return this.m_bShowType;
            }
            case 1: {
                return true;
            }
        }
        return false;
    }

    public Object getValueAt(int row, int col) {
        AdapterPropertyNode data = (AdapterPropertyNode)this.getRowData(row);
        switch (col) {
            case 0: {
                return data.getName();
            }
            case 1: {
                return data;
            }
            case 2: {
                switch (data.getType()) {
                    case 0: {
                        return INPUT_TEXT;
                    }
                    case 1: {
                        return OUTPUT_TEXT;
                    }
                }
                return "";
            }
        }
        return null;
    }

    public String getColumnName(int col) {
        switch (col) {
            case 0: {
                return BPELStringTranslator.getString("NAME");
            }
            case 1: {
                return BPELStringTranslator.getString("VALUE");
            }
            case 2: {
                return BPELStringTranslator.getString("TYPE");
            }
        }
        return " ";
    }

    public int getColumnCount() {
        return this.m_bShowType ? 3 : 2;
    }
}

