/*
 * Decompiled with CFR 0.152.
 */
package oracle.tip.tools.ide.pm.bpelgraph.editors;

import java.util.HashMap;
import oracle.tip.tools.ide.common.bpeldesigner.util.Helper;
import oracle.tip.tools.ide.common.bpelparser.extension.iface.MessageProperty;

public class AdapterPropertyNode {
    public static final String DELIMITER = ",";
    public static final int INPUT = 0;
    public static final int OUTPUT = 1;
    private String m_name;
    private String m_variable;
    private String m_part;
    private String m_query;
    private int m_type = -1;
    private String m_expression;

    public AdapterPropertyNode(String name) {
        this.m_name = name;
    }

    public AdapterPropertyNode createCopy() {
        AdapterPropertyNode copy = new AdapterPropertyNode(this.m_name);
        copy.m_expression = this.m_expression;
        copy.m_variable = this.m_variable;
        copy.m_part = this.m_part;
        copy.m_query = this.m_query;
        copy.m_type = this.m_type;
        return copy;
    }

    public static HashMap<String, String> parseVariable(String s) {
        HashMap<String, String> map = new HashMap<String, String>();
        String[] vals = s.split(DELIMITER);
        if (vals != null) {
            int count = 0;
            block5: for (String tok : vals) {
                switch (count++) {
                    case 0: {
                        map.put("variable", tok);
                        continue block5;
                    }
                    case 1: {
                        map.put("part", tok);
                        continue block5;
                    }
                    case 2: {
                        map.put("query", tok);
                        continue block5;
                    }
                }
            }
        }
        return map;
    }

    public boolean isExpression() {
        return Helper.hasValue((String)this.getExpression());
    }

    public void read(MessageProperty p) {
        if (p != null) {
            this.setVariable(p.getVariable());
            this.setPart(p.getPart());
            this.setQuery(p.getQuery());
            this.setExpression(p.getExpression());
        }
    }

    public String getExpression() {
        return this.m_expression;
    }

    public void setExpression(String expression) {
        this.m_expression = expression;
    }

    public String getPart() {
        return this.m_part;
    }

    public void setPart(String part) {
        this.m_part = part;
    }

    public String getQuery() {
        return this.m_query;
    }

    public void setQuery(String query) {
        this.m_query = query;
    }

    public String getVariable() {
        return this.m_variable;
    }

    public void setVariable(String variable) {
        this.m_variable = variable;
    }

    public int getType() {
        return this.m_type;
    }

    public void setType(int type) {
        this.m_type = type;
    }

    public String getName() {
        return this.m_name;
    }

    public void setName(String name) {
        this.m_name = name;
    }

    public String toString() {
        String var = this.getVariable();
        String part = this.getPart();
        String query = this.getQuery();
        String expression = this.getExpression();
        String s = var;
        if (Helper.hasValue((String)expression)) {
            s = expression;
        } else {
            if (Helper.hasValue((String)part)) {
                s = s + DELIMITER + part;
            }
            if (Helper.hasValue((String)query)) {
                s = s + DELIMITER + query;
            }
        }
        if (s == null) {
            s = "";
        }
        return s;
    }

    public boolean hasData() {
        return Helper.hasValue((String)this.getVariable()) || Helper.hasValue((String)this.getExpression());
    }

    public void clearData() {
        this.setVariable("");
        this.setPart("");
        this.setQuery("");
        this.setExpression("");
    }
}

