/*
 * Decompiled with CFR 0.152.
 */
package oracle.tip.tools.ide.pm.bpelgraph.editors;

import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.swing.DefaultCellEditor;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;
import javax.swing.text.JTextComponent;
import oracle.integration.platform.common.NMUtil;
import oracle.tip.tools.ide.common.bpeldesigner.models.schema.NSResolverFactory;
import oracle.tip.tools.ide.common.bpeldesigner.util.Helper;
import oracle.tip.tools.ide.common.bpelparser.extension.iface.InputProperty;
import oracle.tip.tools.ide.common.bpelparser.extension.iface.MessageProperty;
import oracle.tip.tools.ide.common.bpelparser.extension.iface.MessagePropertySource;
import oracle.tip.tools.ide.common.bpelparser.extension.iface.OutputProperty;
import oracle.tip.tools.ide.common.bpelparser.iface.Activity;
import oracle.tip.tools.ide.common.bpelparser.iface.Invoke;
import oracle.tip.tools.ide.common.bpelparser.iface.PartnerLink;
import oracle.tip.tools.ide.common.bpelparser.iface.Process;
import oracle.tip.tools.ide.common.bpelparser.iface.Receive;
import oracle.tip.tools.ide.common.expressionbuilder.BpelExpressionBuilder;
import oracle.tip.tools.ide.common.expressionbuilder.ExpressionBuilderPicker;
import oracle.tip.tools.ide.common.expressionbuilders.FunctionsExpressionBuilderPicker;
import oracle.tip.tools.ide.common.graph.GraphUtils;
import oracle.tip.tools.ide.common.ide.IDEResolver;
import oracle.tip.tools.ide.common.ui.BrowsableTableCellEditorCallback;
import oracle.tip.tools.ide.common.ui.SortableTable;
import oracle.tip.tools.ide.common.ui.SortedTableHeaderRenderer;
import oracle.tip.tools.ide.common.ui.TableLabelCellRenderer;
import oracle.tip.tools.ide.common.utils.MessagePart;
import oracle.tip.tools.ide.common.utils.NamespaceResolver;
import oracle.tip.tools.ide.common.xpath.editor.XPathEditorPane;
import oracle.tip.tools.ide.common.xpath.editor.util.VariableDataCallBack;
import oracle.tip.tools.ide.common.xsdgrammar.MapperNSResolver;
import oracle.tip.tools.ide.pm.addin.model.BPELXmlModel;
import oracle.tip.tools.ide.pm.bpelgraph.editors.AdapterObjectTableCellEditor;
import oracle.tip.tools.ide.pm.bpelgraph.editors.AdapterPropertyNode;
import oracle.tip.tools.ide.pm.bpelgraph.editors.AdapterPropertyTableModel;
import oracle.tip.tools.ide.pm.bpelgraph.editors.AdapterValueDialog;
import oracle.tip.tools.ide.pm.bpelgraph.editors.BaseEditingPage;
import oracle.tip.tools.ide.pm.bpelgraph.editors.VariableDataCallBackImpl;
import oracle.tip.tools.ide.pm.bpelgraph.editors.VariableExpressionBuilderPicker;
import oracle.tip.tools.ide.pm.bpelgraph.editors.VariablePickerPanel;
import oracle.tip.tools.ide.pm.bpelgraph.model.BPELGraphModel;
import oracle.tip.tools.ide.pm.bpelgraph.views.BPELGraphPane;
import oracle.tip.tools.ide.pm.gui.dialogs.variablexpathbuilder.VariableXPathBuilder;
import oracle.tip.tools.ide.pm.i18n.BPELStringTranslator;
import oracle.xml.parser.v2.DOMParser;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.ProcessingInstruction;

public class AdapterEditPage
extends BaseEditingPage
implements ActionListener {
    protected Activity m_activity;
    protected JTable m_propsTable;
    protected JCheckBox m_fitToWidthCB;

    public AdapterEditPage(BPELGraphPane graphPane) {
        super(graphPane);
    }

    protected String showVariableXPathBuilder(String value) {
        String[] vals;
        String var = null;
        String part = null;
        String query = null;
        if (value != null && (vals = value.split(",")) != null) {
            int count = 0;
            block5: for (String tok : vals) {
                switch (count++) {
                    case 0: {
                        var = tok;
                        continue block5;
                    }
                    case 1: {
                        part = tok;
                        continue block5;
                    }
                    case 2: {
                        query = tok;
                        continue block5;
                    }
                }
            }
        }
        final VariableXPathBuilder dlg = new VariableXPathBuilder(GraphUtils.getFrame((Component)this), this.m_graphPane);
        if (var != null) {
            final String theVar = var;
            final String thePart = part;
            final String theQuery = query;
            dlg.getBuilderPanel().getProcessExplorer().getExplorerTree().getTree().addPropertyChangeListener(new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent evt) {
                    String prop = evt.getPropertyName();
                    if (prop != null && prop.equals("model")) {
                        if (Helper.hasValue((String)theVar) && Helper.hasValue((String)thePart)) {
                            dlg.getBuilderPanel().selectVariablePart(theVar, thePart, AdapterEditPage.this.m_activity, theQuery);
                        } else {
                            dlg.getBuilderPanel().selectVariable(theVar, AdapterEditPage.this.m_activity);
                        }
                    }
                }
            });
        }
        if (dlg.display(this.m_activity) == 0) {
            var = dlg.getVariable().getName();
            MessagePart msgPart = dlg.getPart();
            String text = var;
            if (msgPart != null && Helper.hasValue((String)msgPart.getName())) {
                text = text + "," + msgPart.getName();
                query = dlg.getXPath();
                if (Helper.hasValue((String)query)) {
                    text = text + "," + query;
                }
            }
            return text;
        }
        return null;
    }

    protected String showExpressionBuilder(String text) {
        MapperNSResolver nsResolver = NSResolverFactory.getNSResolver((Activity)this.m_activity, (Process)this.m_processModel);
        BPELGraphModel graphModel = (BPELGraphModel)this.m_graphPane.getModel();
        BPELXmlModel mainModel = graphModel.getBPELXmlModel();
        VariableDataCallBackImpl dataCallBack = new VariableDataCallBackImpl(mainModel, this.m_activity, (NamespaceResolver)nsResolver);
        VariablePickerPanel p = new VariablePickerPanel(this.m_graphPane, dataCallBack, (NamespaceResolver)nsResolver);
        VariableExpressionBuilderPicker picker = new VariableExpressionBuilderPicker(p, this.m_activity);
        ExpressionBuilderPicker[] pickers = new ExpressionBuilderPicker[]{picker, new FunctionsExpressionBuilderPicker((NamespaceResolver)nsResolver)};
        XPathEditorPane editorPane = new XPathEditorPane();
        editorPane.initializeDocument();
        editorPane.initializeEditorPane((VariableDataCallBack)dataCallBack, text, (NamespaceResolver)nsResolver, false);
        BpelExpressionBuilder dlg = new BpelExpressionBuilder(GraphUtils.getFrame((Component)((Object)this.m_graphPane)), (JTextComponent)editorPane, pickers);
        if (dlg.display() == 0) {
            return dlg.getExpressionText();
        }
        return null;
    }

    protected void sortTable(int col, final boolean bAscending) {
        if (col == 0) {
            AdapterPropertyTableModel model = (AdapterPropertyTableModel)((Object)this.m_propsTable.getModel());
            Comparator<AdapterPropertyNode> c = new Comparator<AdapterPropertyNode>(){

                @Override
                public int compare(AdapterPropertyNode d1, AdapterPropertyNode d2) {
                    String s1 = d1.getName();
                    String s2 = d2.getName();
                    if (bAscending) {
                        return s1.compareTo(s2);
                    }
                    return s2.compareTo(s1);
                }

                @Override
                public boolean equals(Object obj) {
                    return obj.equals(this);
                }
            };
            Collections.sort(model.getData(), c);
            model.refresh();
        } else if (col == 1) {
            AdapterPropertyTableModel model = (AdapterPropertyTableModel)((Object)this.m_propsTable.getModel());
            Comparator c = new Comparator(){

                public int compare(Object o1, Object o2) {
                    AdapterPropertyNode d1 = (AdapterPropertyNode)o1;
                    AdapterPropertyNode d2 = (AdapterPropertyNode)o2;
                    String s1 = d1.toString();
                    String s2 = d2.toString();
                    if (bAscending) {
                        return s1.compareTo(s2);
                    }
                    return s2.compareTo(s1);
                }

                @Override
                public boolean equals(Object obj) {
                    return obj.equals(this);
                }
            };
            Collections.sort(model.getData(), c);
            model.refresh();
        } else if (col == 2) {
            AdapterPropertyTableModel model = (AdapterPropertyTableModel)((Object)this.m_propsTable.getModel());
            Comparator<AdapterPropertyNode> c = new Comparator<AdapterPropertyNode>(){

                @Override
                public int compare(AdapterPropertyNode d1, AdapterPropertyNode d2) {
                    String s1 = "";
                    if (d1.getType() == 0) {
                        s1 = "input";
                    } else if (d1.getType() == 1) {
                        s1 = "output";
                    }
                    String s2 = "";
                    if (d2.getType() == 0) {
                        s2 = "input";
                    } else if (d2.getType() == 1) {
                        s2 = "output";
                    }
                    if (bAscending) {
                        return s1.compareTo(s2);
                    }
                    return s2.compareTo(s1);
                }

                @Override
                public boolean equals(Object obj) {
                    return obj.equals(this);
                }
            };
            Collections.sort(model.getData(), c);
            model.refresh();
        }
    }

    protected void createPropertiesTable() {
        boolean bShowType = this.m_activity instanceof Invoke;
        AdapterPropertyTableModel m = new AdapterPropertyTableModel(bShowType);
        this.m_propsTable = new JTable((TableModel)((Object)m));
        SortableTable st = new SortableTable(){

            public void sortColumn(int col, boolean bAscending) {
                AdapterEditPage.this.sortTable(col, bAscending);
            }

            public JTable getJTable() {
                return AdapterEditPage.this.m_propsTable;
            }

            public int getSortingColumn() {
                return 1;
            }

            public boolean getSortAscending() {
                return true;
            }
        };
        SortedTableHeaderRenderer header = new SortedTableHeaderRenderer(st);
        TableLabelCellRenderer r = new TableLabelCellRenderer();
        r.setHorizontalAlignment(0);
        TableColumnModel colModel = this.m_propsTable.getColumnModel();
        for (int i = 0; i < colModel.getColumnCount(); ++i) {
            TableColumn col = colModel.getColumn(i);
            col.setHeaderRenderer((TableCellRenderer)header);
        }
        BrowsableTableCellEditorCallback callback = new BrowsableTableCellEditorCallback(){

            public Object showChooser(JTable table, int row, int col) {
                Object value = table.getModel().getValueAt(row, col);
                if (value instanceof AdapterPropertyNode) {
                    AdapterPropertyNode node = (AdapterPropertyNode)value;
                    AdapterValueDialog dlg = new AdapterValueDialog(IDEResolver.getIDE().getFrame(), AdapterEditPage.this.m_activity, AdapterEditPage.this.m_graphPane, node);
                    if (dlg.display() == 1) {
                        return dlg.getAdapterValuePanel().getValue();
                    }
                }
                return null;
            }
        };
        AdapterObjectTableCellEditor cellEditor = new AdapterObjectTableCellEditor(callback);
        TableColumn col = colModel.getColumn(1);
        col.setCellEditor((TableCellEditor)((Object)cellEditor));
        if (bShowType) {
            col = colModel.getColumn(2);
            DefaultComboBoxModel<String> cbm = new DefaultComboBoxModel<String>();
            cbm.addElement("input");
            cbm.addElement("output");
            JComboBox cb = new JComboBox(cbm);
            DefaultCellEditor de = new DefaultCellEditor(cb){

                @Override
                public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
                    Component c = super.getTableCellEditorComponent(table, value, isSelected, row, column);
                    JComboBox cb = (JComboBox)c;
                    if (value.equals("input")) {
                        cb.setSelectedIndex(0);
                    } else if (value.equals("output")) {
                        cb.setSelectedIndex(1);
                    }
                    return cb;
                }
            };
            col.setCellEditor(de);
        }
        Set<String> props = this.getProperties();
        for (String prop : props) {
            AdapterPropertyNode n = new AdapterPropertyNode(prop);
            m.getData().add(n);
        }
        m.refresh();
    }

    private Set<String> getProperties() {
        PartnerLink partnerLink = null;
        String partnerLinkName = null;
        if (this.m_activity instanceof Receive) {
            partnerLinkName = ((Receive)this.m_activity).getPartnerLink();
        } else if (this.m_activity instanceof Invoke) {
            partnerLinkName = ((Invoke)this.m_activity).getPartnerLink();
        }
        if (partnerLinkName != null && partnerLinkName.trim().length() > 0) {
            partnerLink = this.getPartnerLink(partnerLinkName);
        }
        if (partnerLink != null) {
            String wsdlFile = partnerLink.getWSDLLocation();
            DOMParser parser = new DOMParser();
            Node wsdlDoc = null;
            try {
                parser.parse(new URL(wsdlFile));
                wsdlDoc = parser.getDocument();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            if (wsdlDoc != null) {
                NodeList nodes = wsdlDoc.getChildNodes();
                for (int i = 0; i < nodes.getLength(); ++i) {
                    Node node = nodes.item(i);
                    if (node.getNodeType() != 7) continue;
                    ProcessingInstruction pi = (ProcessingInstruction)node;
                    String piTarget = pi.getTarget();
                    String piData = pi.getData();
                    if (!piTarget.equals("binding.jca")) continue;
                    String bindingType = "jca";
                    String bindingSubType = piData.substring(piData.lastIndexOf("_") + 1, piData.lastIndexOf("."));
                    return NMUtil.getPropertiesForBinding((String)bindingType, (String)bindingSubType);
                }
            }
        }
        return NMUtil.getProperties();
    }

    protected void createControls() {
        this.createPropertiesTable();
        this.m_fitToWidthCB = new JCheckBox("", true);
        this.m_fitToWidthCB.addActionListener(this);
        BPELStringTranslator.setButton(this.m_fitToWidthCB, BPELStringTranslator.getString("FIT_TO_WIDTH"));
    }

    protected void layoutControls() {
        JLabel lbl = new JLabel();
        BPELStringTranslator.setLabel(lbl, this.m_propsTable, BPELStringTranslator.getString("PROPERTIES_LBL"));
        this.setLayout(new GridBagLayout());
        int row = 0;
        GraphUtils.addComponent((Container)this, (Component)lbl, (int)0, (int)row++, (int)1, (int)1, (int)16, (int)2, (Insets)new Insets(10, 10, 2, 10), (int)0, (int)0, (double)1.0, (double)0.0);
        GraphUtils.addComponent((Container)this, (Component)GraphUtils.getScrollPane((Component)this.m_propsTable), (int)0, (int)row++, (int)1, (int)1, (int)17, (int)1, (Insets)new Insets(0, 10, 0, 10), (int)0, (int)0, (double)1.0, (double)1.0);
        GraphUtils.addComponent((Container)this, (Component)this.m_fitToWidthCB, (int)0, (int)row++, (int)1, (int)1, (int)18, (int)2, (Insets)new Insets(2, 10, 10, 10), (int)0, (int)0, (double)1.0, (double)0.0);
    }

    @Override
    public void setUserObject(Object obj) {
        super.setUserObject(obj);
        this.m_activity = (Activity)obj;
        this.createControls();
        this.layoutControls();
        this.loadControls();
    }

    @Override
    public String getTitle() {
        return BPELStringTranslator.getString("EDITOR_PROPS_LABEL", "Properties");
    }

    @Override
    public void saveChanges() {
        if (!(this.m_activity instanceof MessagePropertySource)) {
            return;
        }
        MessagePropertySource mps = (MessagePropertySource)this.m_activity;
        List modelInputProperties = new ArrayList();
        List modelOutputProperties = new ArrayList();
        List modelProperties = new ArrayList();
        modelInputProperties = mps.getInputProperties();
        modelOutputProperties = mps.getOutputProperties();
        modelProperties = mps.getMessageProperties();
        ArrayList modelMsgProps = new ArrayList();
        modelMsgProps.addAll(modelInputProperties);
        modelMsgProps.addAll(modelOutputProperties);
        modelMsgProps.addAll(modelProperties);
        AdapterPropertyTableModel m = (AdapterPropertyTableModel)((Object)this.m_propsTable.getModel());
        Iterator i$ = m.getData().iterator();
        while (i$.hasNext()) {
            AdapterPropertyNode o;
            AdapterPropertyNode uiPropertyNode = o = (AdapterPropertyNode)i$.next();
            String uiPropertyName = uiPropertyNode.getName();
            int uiType = uiPropertyNode.getType();
            MessageProperty targetModelProp = null;
            for (MessageProperty modelProp : modelMsgProps) {
                String modelName = modelProp.getName();
                if (!uiPropertyName.equals(modelName)) continue;
                targetModelProp = modelProp;
                break;
            }
            if (!uiPropertyNode.hasData()) {
                if (targetModelProp == null) continue;
                this.removeMessagePropertyOnActivity(targetModelProp);
                continue;
            }
            if (uiType == 0 && targetModelProp instanceof OutputProperty || uiType == 1 && targetModelProp instanceof InputProperty) {
                this.removeMessagePropertyOnActivity(targetModelProp);
                targetModelProp = null;
            }
            if (targetModelProp == null) {
                targetModelProp = this.createMessagePropertyOnActivity(uiPropertyName, uiPropertyNode, uiType);
            }
            this.copyFromUIModelToBPELModel(uiPropertyNode, targetModelProp);
        }
    }

    protected void copyFromUIModelToBPELModel(AdapterPropertyNode uiModel, MessageProperty bpelModel) {
        bpelModel.setVariable(uiModel.getVariable());
        bpelModel.setPart(uiModel.getPart());
        bpelModel.setQuery(uiModel.getQuery());
        bpelModel.setExpression(uiModel.getExpression());
    }

    protected void removeMessagePropertyOnActivity(MessageProperty p) {
        if (this.m_activity instanceof MessagePropertySource) {
            MessagePropertySource mps = (MessagePropertySource)this.m_activity;
            mps.removeMessageProperty(p);
        }
    }

    protected MessageProperty createMessagePropertyOnActivity(String name, AdapterPropertyNode uiProperty, int type) {
        if (this.m_activity instanceof MessagePropertySource) {
            String var = uiProperty.getVariable();
            String part = uiProperty.getPart();
            String query = uiProperty.getQuery();
            MessagePropertySource mps = (MessagePropertySource)this.m_activity;
            if (type == 1) {
                return mps.createOutputProperty(name, var, part, query);
            }
            if (type == 0) {
                return mps.createInputProperty(name, var, part, query);
            }
            return mps.createMessageProperty(name, var, part, query);
        }
        return null;
    }

    @Override
    public boolean validateEditorChanges() {
        return true;
    }

    protected void loadControls() {
        if (this.m_activity == null) {
            return;
        }
        if (this.m_activity instanceof MessagePropertySource) {
            MessagePropertySource mps = (MessagePropertySource)this.m_activity;
            this.loadPropertiesTableModel(mps);
        }
    }

    protected void loadPropertiesTableModel(MessagePropertySource mps) {
        AdapterPropertyNode propNode;
        List props = mps.getMessageProperties();
        List inputs = mps.getInputProperties();
        List outputs = mps.getOutputProperties();
        for (MessageProperty p : props) {
            propNode = this.getNodeForName(p.getName());
            if (propNode == null) continue;
            propNode.read(p);
            propNode.setType(-1);
        }
        for (MessageProperty p : inputs) {
            propNode = this.getNodeForName(p.getName());
            if (propNode == null) continue;
            propNode.read(p);
            propNode.setType(0);
        }
        for (MessageProperty p : outputs) {
            propNode = this.getNodeForName(p.getName());
            if (propNode == null) continue;
            propNode.read(p);
            propNode.setType(1);
        }
        AdapterPropertyTableModel m = (AdapterPropertyTableModel)((Object)this.m_propsTable.getModel());
        m.refresh();
    }

    protected AdapterPropertyNode getNodeForName(String name) {
        AdapterPropertyTableModel m = (AdapterPropertyTableModel)((Object)this.m_propsTable.getModel());
        List data = m.getData();
        for (AdapterPropertyNode n : data) {
            if (!Helper.isEqual((String)n.getName(), (String)name)) continue;
            return n;
        }
        return null;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Object src = e.getSource();
        if (src == this.m_fitToWidthCB) {
            if (this.m_fitToWidthCB.isSelected()) {
                this.m_propsTable.setAutoResizeMode(3);
            } else {
                this.m_propsTable.setAutoResizeMode(0);
            }
        }
    }
}

