/*
 * Decompiled with CFR 0.152.
 */
package oracle.tip.tools.ide.pm.bpelgraph.bookmarks;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.List;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import oracle.tip.tools.ide.common.graph.GraphUtils;
import oracle.tip.tools.ide.pm.bpelgraph.bookmarks.BookmarkCategory;
import oracle.tip.tools.ide.pm.bpelgraph.bookmarks.BookmarkNode;
import oracle.tip.tools.ide.pm.bpelgraph.bookmarks.BookmarkNodeTypes;
import oracle.tip.tools.ide.pm.gui.generalpurpose.BPELBaseDialog;
import oracle.tip.tools.ide.pm.gui.generalpurpose.GenericListCellRenderer;
import oracle.tip.tools.ide.pm.i18n.BPELStringTranslator;
import oracle.tip.tools.ide.pm.resources.images.ImageCache;

public class MoveToFolderDialog
extends BPELBaseDialog
implements ActionListener,
ListSelectionListener,
BookmarkNodeTypes {
    public static final int OK = 0;
    public static final int CANCEL = 1;
    protected JButton m_okBtn;
    protected JButton m_cancelBtn;
    protected JButton m_helpBtn;
    protected JList m_list;
    protected int m_retVal = 1;

    public MoveToFolderDialog(JFrame f) {
        super(f, BPELStringTranslator.getString("COLLAXALAF_BOOKMARKS_MOVE_TO_FOLDER"), true);
        this.createControls();
        this.layoutControls();
    }

    public int display(List folders) {
        this.loadControls(folders);
        this.updateButtons();
        this.setVisible(true);
        return this.m_retVal;
    }

    public BookmarkNode getSelectedFolder() {
        FolderItem item = (FolderItem)this.m_list.getSelectedValue();
        return item.m_folder;
    }

    protected void handleEnterKey() {
        this.handleOK();
    }

    protected void createControls() {
        this.m_list = new JList();
        this.m_list.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() > 1 && MoveToFolderDialog.this.m_list.getSelectedIndex() != -1) {
                    MoveToFolderDialog.this.handleOK();
                }
            }
        });
        this.m_list.addListSelectionListener(this);
        this.m_list.setCellRenderer(new GenericListCellRenderer(ImageCache.getIcon("folder_close_node")));
        this.m_okBtn = new JButton(BPELStringTranslator.getString("OK_BUTTON_TEXT"));
        BPELStringTranslator.setButton(this.m_okBtn, BPELStringTranslator.getString("OK_BUTTON_TEXT_RES"));
        this.m_okBtn.addActionListener(this);
        this.m_helpBtn = new JButton();
        BPELStringTranslator.setButton(this.m_helpBtn, BPELStringTranslator.getString("HELP_BUTTON_TEXT_RES"));
        this.m_helpBtn.addActionListener(this);
        this.m_cancelBtn = new JButton(BPELStringTranslator.getString("CANCEL_BUTTON_TEXT"));
        BPELStringTranslator.setButton(this.m_cancelBtn, BPELStringTranslator.getString("CANCEL_BUTTON_TEXT_RES"));
        this.m_cancelBtn.addActionListener(this);
    }

    protected void loadControls(List folders) {
        DefaultListModel<FolderItem> model = new DefaultListModel<FolderItem>();
        for (BookmarkNode bn : folders) {
            model.addElement(new FolderItem(bn));
        }
        this.m_list.setModel(model);
    }

    protected void layoutControls() {
        JPanel btnPnl = new JPanel(new GridLayout(1, 2, 5, 0));
        btnPnl.add(this.m_okBtn);
        btnPnl.add(this.m_cancelBtn);
        Container c = this.getContentPane();
        c.setLayout(new GridBagLayout());
        int row = 0;
        GraphUtils.addComponent((Container)c, (Component)GraphUtils.getScrollPane((Component)this.m_list), (int)0, (int)row++, (int)2, (int)1, (int)17, (int)1, (Insets)new Insets(10, 10, 0, 10), (int)0, (int)0, (double)1.0, (double)1.0);
        GraphUtils.addComponent((Container)c, (Component)this.m_helpBtn, (int)0, (int)row, (int)1, (int)1, (int)17, (int)0, (Insets)new Insets(10, 10, 10, 0), (int)0, (int)0, (double)1.0, (double)0.0);
        GraphUtils.addComponent((Container)c, (Component)btnPnl, (int)0, (int)row++, (int)1, (int)1, (int)13, (int)0, (Insets)new Insets(10, 0, 10, 10), (int)0, (int)0, (double)1.0, (double)0.0);
        this.setSize(new Dimension(280, 250));
        this.setLocationRelativeTo(this.getParent());
    }

    public void handleCancel() {
        this.m_retVal = 1;
        this.dispose();
    }

    public void handleOK() {
        if (this.m_list.getSelectedIndex() == -1) {
            return;
        }
        this.m_retVal = 0;
        this.dispose();
    }

    protected void updateButtons() {
        this.m_okBtn.setEnabled(this.m_list.getSelectedIndex() != -1);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Object src = e.getSource();
        if (src == this.m_okBtn) {
            this.handleOK();
        } else if (src == this.m_cancelBtn) {
            this.handleCancel();
        } else if (src == this.m_helpBtn) {
            this.helpInvoked();
        }
    }

    protected void helpInvoked() {
        this.handleHelp((Component)((Object)this));
    }

    @Override
    public void valueChanged(ListSelectionEvent e) {
        this.updateButtons();
    }

    class FolderItem {
        BookmarkNode m_folder;

        public FolderItem(BookmarkNode folder) {
            this.m_folder = folder;
        }

        public String toString() {
            BookmarkCategory cat = (BookmarkCategory)this.m_folder.getData();
            return cat.getName();
        }
    }
}

