/*
 * Decompiled with CFR 0.152.
 */
package oracle.tip.tools.ide.pm.bpelgraph.bookmarks;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.net.URL;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import javax.swing.tree.DefaultMutableTreeNode;
import oracle.ide.controls.TreeTableModel;
import oracle.tip.tools.ide.common.bpelparser.iface.Activity;
import oracle.tip.tools.ide.common.bpelparser.iface.Process;
import oracle.tip.tools.ide.common.bpelparser.util.BPELModelUtil;
import oracle.tip.tools.ide.common.graph.GraphUtils;
import oracle.tip.tools.ide.common.ui.ToolBar;
import oracle.tip.tools.ide.common.ui.UIHelper;
import oracle.tip.tools.ide.pm.bpelgraph.bookmarks.Bookmark;
import oracle.tip.tools.ide.pm.bpelgraph.bookmarks.BookmarkCategory;
import oracle.tip.tools.ide.pm.bpelgraph.bookmarks.BookmarkDataStore;
import oracle.tip.tools.ide.pm.bpelgraph.bookmarks.BookmarkNode;
import oracle.tip.tools.ide.pm.bpelgraph.bookmarks.BookmarkNodeTypes;
import oracle.tip.tools.ide.pm.bpelgraph.bookmarks.BookmarkTreeTable;
import oracle.tip.tools.ide.pm.bpelgraph.bookmarks.BookmarkTreeTableModel;
import oracle.tip.tools.ide.pm.bpelgraph.model.BPELGraphModel;
import oracle.tip.tools.ide.pm.bpelgraph.settings.GraphicsFileUtil;
import oracle.tip.tools.ide.pm.bpelgraph.views.BPELGraphPane;
import oracle.tip.tools.ide.pm.gui.generalpurpose.BPELBaseDialog;
import oracle.tip.tools.ide.pm.i18n.BPELStringTranslator;
import oracle.tip.tools.ide.pm.resources.images.ImageCache;

public class BookmarksDialog
extends BPELBaseDialog
implements ActionListener,
ListSelectionListener,
BookmarkNodeTypes {
    public static final int OK = 0;
    public static final int CANCEL = 1;
    protected JButton m_okBtn;
    protected JButton m_cancelBtn;
    protected JButton m_helpBtn;
    protected JButton m_createBtn;
    protected JButton m_moveToFolderBtn;
    protected JButton m_deleteBtn;
    protected JButton m_editBtn;
    protected BPELGraphPane m_graph;
    protected BookmarkTreeTable m_treeTable;
    protected int m_retVal = 1;

    public BookmarksDialog(JFrame f, BPELGraphPane graph) {
        super(f, BPELStringTranslator.getString("COLLAXALAF_BOOKMARKS", "Bookmarks"), true);
        this.m_graph = graph;
        this.createControls();
        this.layoutControls();
    }

    public int display() {
        this.loadControls();
        this.updateButtons();
        this.show();
        return this.m_retVal;
    }

    protected void createControls() {
        this.m_moveToFolderBtn = UIHelper.createModelerButton((Icon)ImageCache.getIcon("application/bpel/folder_into.png"));
        this.m_moveToFolderBtn.setToolTipText(BPELStringTranslator.getString("COLLAXALAF_BOOKMARKS_MOVE_TO_FOLDER_D", "Move To Folder..."));
        this.m_moveToFolderBtn.setMnemonic('M');
        this.m_moveToFolderBtn.addActionListener(this);
        this.m_createBtn = UIHelper.createModelerButton((Icon)ImageCache.getIcon("application/bpel/folder_new.png"));
        this.m_createBtn.setToolTipText(BPELStringTranslator.getString("COLLAXALAF_BOOKMARKS_CREATE_FOLDER", "Create Folder..."));
        this.m_createBtn.setMnemonic(BPELStringTranslator.getMnemonic("CREATE_BUTTON_TEXT_Mnemonic"));
        this.m_createBtn.addActionListener(this);
        this.m_deleteBtn = UIHelper.createModelerButton((Icon)ImageCache.getIcon("delete2.png"));
        this.m_deleteBtn.addActionListener(this);
        this.m_deleteBtn.setToolTipText(BPELStringTranslator.getString("COLLAXALAF_BOOKMARKS_DELETE", "Delete"));
        this.m_deleteBtn.setMnemonic(BPELStringTranslator.getMnemonic("DEL_BUTTON_TEXT_Mnemonic"));
        this.m_editBtn = UIHelper.createModelerButton((Icon)ImageCache.getIcon("edit16"));
        this.m_editBtn.addActionListener(this);
        this.m_editBtn.setToolTipText(BPELStringTranslator.getString("COLLAXALAF_BOOKMARKS_EDIT_D", "Edit..."));
        this.m_editBtn.setMnemonic(BPELStringTranslator.getMnemonic("EDIT_BUTTON_TEXT_Mnemonic"));
        this.m_okBtn = new JButton(BPELStringTranslator.getString("OK_BUTTON_TEXT"));
        BPELStringTranslator.setButton(this.m_okBtn, BPELStringTranslator.getString("OK_BUTTON_TEXT_RES"));
        this.m_okBtn.addActionListener(this);
        this.m_cancelBtn = new JButton(BPELStringTranslator.getString("CANCEL_BUTTON_TEXT"));
        BPELStringTranslator.setButton(this.m_cancelBtn, BPELStringTranslator.getString("CANCEL_BUTTON_TEXT_RES"));
        this.m_cancelBtn.addActionListener(this);
        this.m_helpBtn = new JButton(BPELStringTranslator.getString("HELP_BUTTON_TEXT"));
        BPELStringTranslator.setButton(this.m_helpBtn, BPELStringTranslator.getString("HELP_BUTTON_TEXT_RES"));
        this.m_helpBtn.addActionListener(this);
        BPELGraphModel model = (BPELGraphModel)this.m_graph.getModel();
        Process p = model.getProcess();
        this.m_treeTable = new BookmarkTreeTable(this.m_graph.getBookmarks(), (TreeTableModel)new BookmarkTreeTableModel(this.buildTree()), p);
        this.m_treeTable.getSelectionModel().addListSelectionListener(this);
        TableColumnModel colModel = this.m_treeTable.getColumnModel();
        for (int i = 0; i < colModel.getColumnCount(); ++i) {
            TableColumn col = colModel.getColumn(i);
            if (i != 1) continue;
            col.setCellRenderer(new DefaultTableCellRenderer(){

                @Override
                public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
                    Component c = super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
                    this.setToolTipText("<html><body bgcolor=white><table width=400><tr><td align=center>" + value.toString() + "</td></tr></table></body></html>");
                    return c;
                }
            });
        }
    }

    protected void loadControls() {
    }

    protected void updateButtons() {
        this.m_createBtn.setEnabled(false);
        this.m_deleteBtn.setEnabled(false);
        this.m_editBtn.setEnabled(false);
        this.m_moveToFolderBtn.setEnabled(false);
        int numSelectedRows = this.m_treeTable.getSelectedRowCount();
        if (numSelectedRows == 0) {
            return;
        }
        BookmarkNode bn = this.m_treeTable.getSelectedBookmarkNode();
        if (bn != null) {
            switch (bn.getType()) {
                case 2: {
                    this.m_createBtn.setEnabled(true);
                    break;
                }
                case 1: {
                    this.m_deleteBtn.setEnabled(true);
                    this.m_moveToFolderBtn.setEnabled(true);
                    this.m_editBtn.setEnabled(true);
                    break;
                }
                case 0: {
                    this.m_deleteBtn.setEnabled(true);
                    break;
                }
            }
        }
    }

    protected DefaultMutableTreeNode buildTree() {
        BookmarkNode bn = new BookmarkNode(2, "Bookmarks");
        DefaultMutableTreeNode root = new DefaultMutableTreeNode(bn);
        BookmarkDataStore ds = this.m_graph.getBookmarks();
        if (ds == null) {
            return root;
        }
        for (Object o : ds.getData()) {
            if (o instanceof BookmarkCategory) {
                BookmarkCategory category = (BookmarkCategory)o;
                BookmarkNode n = new BookmarkNode(0, null);
                n.setData(category);
                DefaultMutableTreeNode catNode = new DefaultMutableTreeNode(n);
                root.add(catNode);
                for (Bookmark bookmark : category.getBookmarks()) {
                    BookmarkNode n2 = new BookmarkNode(1, null);
                    n2.setData(bookmark);
                    catNode.add(new DefaultMutableTreeNode(n2));
                }
                continue;
            }
            if (!(o instanceof Bookmark)) continue;
            Bookmark b = (Bookmark)o;
            BPELGraphModel model = (BPELGraphModel)this.m_graph.getModel();
            Activity a = BPELModelUtil.getActivityForID((int)b.getID(), (Process)model.getProcess());
            if (a != null) {
                b.setXPath(BPELModelUtil.getXPathForActivity((Activity)a));
            } else {
                b.setXPath("");
            }
            BookmarkNode n = new BookmarkNode(1, null);
            n.setData(b);
            root.add(new DefaultMutableTreeNode(n));
        }
        return root;
    }

    protected void layoutControls() {
        JPanel btnPnl = new JPanel(new GridLayout(1, 2, 5, 0));
        btnPnl.add(this.m_okBtn);
        btnPnl.add(this.m_cancelBtn);
        ToolBar tb = new ToolBar();
        tb.setBorderInsets(new Insets(0, 0, 0, 0));
        tb.add((Component)this.m_createBtn);
        tb.add((Component)this.m_moveToFolderBtn);
        tb.add((Component)this.m_editBtn);
        tb.add((Component)this.m_deleteBtn);
        Container c = this.getContentPane();
        c.setLayout(new GridBagLayout());
        int row = 0;
        GraphUtils.addComponent((Container)c, (Component)new JLabel(BPELStringTranslator.getString("COLLAXALAF_BOOKMARKS_C", "Bookmarks:")), (int)0, (int)row, (int)1, (int)1, (int)16, (int)0, (Insets)new Insets(10, 10, 0, 10), (int)0, (int)0, (double)1.0, (double)0.0);
        GraphUtils.addComponent((Container)c, (Component)tb, (int)1, (int)row++, (int)1, (int)1, (int)13, (int)0, (Insets)new Insets(10, 10, 0, 10), (int)0, (int)0, (double)1.0, (double)0.0);
        GraphUtils.addComponent((Container)c, (Component)GraphUtils.getScrollPane((Component)((Object)this.m_treeTable)), (int)0, (int)row++, (int)2, (int)1, (int)17, (int)1, (Insets)new Insets(2, 10, 10, 10), (int)0, (int)0, (double)1.0, (double)1.0);
        GraphUtils.addComponent((Container)c, (Component)this.m_helpBtn, (int)0, (int)row, (int)1, (int)1, (int)17, (int)0, (Insets)new Insets(0, 10, 10, 0), (int)0, (int)0, (double)1.0, (double)0.0);
        GraphUtils.addComponent((Container)c, (Component)btnPnl, (int)0, (int)row++, (int)2, (int)1, (int)13, (int)0, (Insets)new Insets(0, 0, 10, 10), (int)0, (int)0, (double)1.0, (double)0.0);
        this.setSize(new Dimension(470, 325));
        this.setLocationRelativeTo(this.getParent());
    }

    public void handleCancel() {
        this.m_retVal = 1;
        this.dispose();
    }

    public void handleOK() {
        this.m_treeTable.save();
        this.saveGraphicsFile();
        this.m_retVal = 0;
        this.dispose();
    }

    protected synchronized void saveGraphicsFile() {
        if (this.m_graph != null) {
            URL url = this.m_graph.getBPELProject().getGraphicsFileURL();
            try {
                GraphicsFileUtil.saveGraphicsFile(url, this.m_graph);
            }
            catch (Exception e) {
                GraphUtils.displayMessage((Component)((Object)this), (String)BPELStringTranslator.getString("FAILED_SAVE_GRAPHICS_FILE"), (int)0);
            }
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Object src = e.getSource();
        if (src == this.m_okBtn) {
            this.handleOK();
        } else if (src == this.m_cancelBtn) {
            this.handleCancel();
        } else if (src == this.m_helpBtn) {
            this.handleHelp((Component)((Object)this));
        } else if (src == this.m_deleteBtn) {
            this.m_treeTable.deleteSelectedRow();
        } else if (src == this.m_createBtn) {
            this.m_treeTable.handleCreateFolder();
        } else if (src == this.m_moveToFolderBtn) {
            this.m_treeTable.moveToFolder();
        } else if (src == this.m_editBtn) {
            this.m_treeTable.handleEdit();
        }
    }

    @Override
    public void valueChanged(ListSelectionEvent e) {
        this.updateButtons();
    }

    protected void helpInvoked() {
        this.handleHelp((Component)((Object)this));
    }
}

