/*
 * Decompiled with CFR 0.152.
 */
package oracle.tip.tools.ide.pm.bpelgraph.bookmarks;

import java.awt.Component;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.ImageIcon;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import oracle.ide.controls.JTreeTable;
import oracle.ide.controls.TreeTableModel;
import oracle.tip.tools.ide.common.bpelparser.iface.Process;
import oracle.tip.tools.ide.common.graph.GraphUtils;
import oracle.tip.tools.ide.common.graph.view.GraphImageResource;
import oracle.tip.tools.ide.common.ui.InputDialog;
import oracle.tip.tools.ide.common.ui.UIHelper;
import oracle.tip.tools.ide.pm.bpelgraph.bookmarks.Bookmark;
import oracle.tip.tools.ide.pm.bpelgraph.bookmarks.BookmarkCategory;
import oracle.tip.tools.ide.pm.bpelgraph.bookmarks.BookmarkDataStore;
import oracle.tip.tools.ide.pm.bpelgraph.bookmarks.BookmarkDialog;
import oracle.tip.tools.ide.pm.bpelgraph.bookmarks.BookmarkNode;
import oracle.tip.tools.ide.pm.bpelgraph.bookmarks.BookmarkTreeCellRenderer;
import oracle.tip.tools.ide.pm.bpelgraph.bookmarks.BookmarkTreeTableModel;
import oracle.tip.tools.ide.pm.bpelgraph.bookmarks.MoveToFolderDialog;
import oracle.tip.tools.ide.pm.i18n.BPELStringTranslator;
import oracle.tip.tools.ide.pm.resources.images.ImageCache;

public class BookmarkTreeTable
extends JTreeTable
implements MouseListener,
ActionListener {
    JPopupMenu m_popup;
    JMenuItem m_deleteFolderItem;
    JMenuItem m_createFolderItem;
    JMenuItem m_createBookmarkItem;
    JMenuItem m_deleteBookmarkItem;
    JMenuItem m_editBookmarkItem;
    JMenuItem m_expandItem;
    JMenuItem m_collapseItem;
    JMenuItem m_moveToFolderItem;
    BookmarkDataStore m_bookmarks;
    Process m_process;

    public BookmarkTreeTable(BookmarkDataStore bookmarks, TreeTableModel model, Process process) {
        super(model);
        this.m_process = process;
        this.m_bookmarks = bookmarks;
        this.addMouseListener(this);
        this.m_popup = new JPopupMenu();
        this.m_moveToFolderItem = new JMenuItem(BPELStringTranslator.getString("COLLAXALAF_BOOKMARKS_MOVE_TO_FOLDER_D", "Move To Folder..."), ImageCache.getIcon("application/bpel/folder_into.png"));
        this.m_moveToFolderItem.addActionListener(this);
        this.m_deleteFolderItem = new JMenuItem(BPELStringTranslator.getString("COLLAXALAF_BOOKMARKS_DELETE_FOLDER", "Delete Folder"), ImageCache.getIcon("application/bpel/folder_delete.png"));
        this.m_deleteFolderItem.addActionListener(this);
        this.m_deleteBookmarkItem = new JMenuItem(BPELStringTranslator.getString("COLLAXALAF_BOOKMARKS_DELETE_BOOKMARK", "Delete Bookmark"), ImageCache.getIcon("application/bpel/bookmark_delete.png"));
        this.m_deleteBookmarkItem.addActionListener(this);
        this.m_createFolderItem = new JMenuItem(BPELStringTranslator.getString("COLLAXALAF_BOOKMARKS_CREATE_FOLDER_D", "Create Folder..."), ImageCache.getIcon("application/bpel/folder_new.png"));
        this.m_createFolderItem.addActionListener(this);
        this.m_createBookmarkItem = new JMenuItem(BPELStringTranslator.getString("COLLAXALAF_BOOKMARKS_CREATE_BOOKBARK", "Create Bookmark..."), ImageCache.getIcon("application/bpel/bookmarks.png"));
        this.m_createBookmarkItem.addActionListener(this);
        this.m_editBookmarkItem = new JMenuItem(BPELStringTranslator.getString("COLLAXALAF_BOOKMARKS_EDIT_BOOKMARK", "Edit Bookmark..."), ImageCache.getIcon("edit16"));
        this.m_editBookmarkItem.addActionListener(this);
        this.m_expandItem = new JMenuItem(BPELStringTranslator.getString("COLLAXALAF_BOOKMARKS_EXPAND", "Expand"), new ImageIcon(GraphImageResource.COLLAPSE_ICON));
        this.m_expandItem.addActionListener(this);
        this.m_collapseItem = new JMenuItem(BPELStringTranslator.getString("COLLAXALAF_BOOKMARKS_COLLAPSE", "Collapse"), new ImageIcon(GraphImageResource.EXPAND_ICON));
        this.m_collapseItem.addActionListener(this);
        this.m_popup.add(this.m_createFolderItem);
        this.m_popup.add(this.m_deleteFolderItem);
        this.m_popup.add(this.m_deleteBookmarkItem);
        this.tree.add((Component)this.m_popup);
        this.setSelectionMode(0);
        this.tree.putClientProperty((Object)"JTree.lineStyle", (Object)"Angled");
        this.tree.setCellRenderer((TreeCellRenderer)new BookmarkTreeCellRenderer());
        this.getTableHeader().setReorderingAllowed(false);
    }

    private void expandEntireTree() {
        UIHelper.expandTree((JTree)this.tree);
    }

    private void expandSelectedPath() {
        TreePath path = this.getSelectedPath();
        if (path != null) {
            this.tree.expandPath(path);
        }
    }

    private void collapseSelectedPath() {
        TreePath path = this.getSelectedPath();
        if (path != null) {
            this.tree.collapsePath(path);
        }
    }

    public TreePath getSelectedPath() {
        int row = this.getSelectedRow();
        if (row != -1) {
            return this.tree.getPathForRow(row);
        }
        return null;
    }

    @Override
    public void mouseClicked(MouseEvent e) {
    }

    @Override
    public void mousePressed(MouseEvent e) {
        if (e.isPopupTrigger()) {
            this.handlePopupTrigger(e);
        }
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        if (e.isPopupTrigger()) {
            this.handlePopupTrigger(e);
        }
    }

    protected void handlePopupTrigger(MouseEvent e) {
        BookmarkNode node;
        Point pt = new Point(e.getX(), e.getY());
        int col = this.columnAtPoint(pt);
        if (col == 0 && (node = this.getSelectedBookmarkNode()) != null) {
            this.showPopup(node.getType(), e);
        }
    }

    public BookmarkNode getSelectedBookmarkNode() {
        Object userObj;
        Object obj;
        TreePath path;
        int row = this.getSelectedRow();
        if (row != -1 && (path = this.tree.getPathForRow(row)) != null && (obj = path.getLastPathComponent()) instanceof DefaultMutableTreeNode && (userObj = ((DefaultMutableTreeNode)obj).getUserObject()) instanceof BookmarkNode) {
            return (BookmarkNode)userObj;
        }
        return null;
    }

    public DefaultMutableTreeNode getSelectedTreeNode() {
        Object obj;
        TreePath path;
        int row = this.getSelectedRow();
        if (row != -1 && (path = this.tree.getPathForRow(row)) != null && (obj = path.getLastPathComponent()) instanceof DefaultMutableTreeNode) {
            return (DefaultMutableTreeNode)obj;
        }
        return null;
    }

    protected void handleEdit() {
        DefaultMutableTreeNode node = this.getSelectedTreeNode();
        BookmarkNode bn = (BookmarkNode)node.getUserObject();
        Bookmark mark = (Bookmark)bn.getData();
        BookmarkDialog dlg = new BookmarkDialog(GraphUtils.getFrame((Component)((Object)this)));
        if (dlg.display(mark) == 0) {
            BookmarkTreeTableModel model = (BookmarkTreeTableModel)((Object)this.tree.getModel());
            TreePath treePath = this.tree.getPathForRow(this.getSelectedRow());
            Object[] paths = new Object[]{treePath};
            model.fireTreeStructureChanged(this, paths, null, null);
            this.expandSelectedPath();
        }
    }

    protected void handleCreateFolder() {
        InputDialog dlg = new InputDialog(GraphUtils.getFrame((Component)((Object)this)), BPELStringTranslator.getString("COLLAXALAF_BOOKMARKS_CREATE_FOLDER", "Create Folder"), BPELStringTranslator.getString("COLLAXALAF_BOOKMARKS_NAME", "&Name:"));
        dlg.setHelpId("bpmjdev_create_folder");
        String s = dlg.display();
        if (s != null) {
            DefaultMutableTreeNode root = this.getBookmarksTreeNode();
            BookmarkCategory c = new BookmarkCategory(null, null);
            c.setName(s);
            BookmarkNode newNode = new BookmarkNode(0, c);
            DefaultMutableTreeNode treeNode = new DefaultMutableTreeNode(newNode);
            root.add(treeNode);
            BookmarkTreeTableModel model = (BookmarkTreeTableModel)((Object)this.tree.getModel());
            TreePath treePath = this.tree.getPathForRow(this.getSelectedRow());
            Object[] paths = new Object[]{treePath};
            model.fireTreeStructureChanged(this, paths, null, null);
            TreePath selectionPath = UIHelper.getTreePathForNode((TreeNode)treeNode);
            if (selectionPath != null) {
                this.tree.expandPath(selectionPath);
                this.selectTreePath(selectionPath);
            }
        }
    }

    protected void selectTreePath(TreePath p) {
        int row = this.tree.getRowForPath(p);
        if (row > 0) {
            this.getSelectionModel().setSelectionInterval(row, row);
        }
    }

    protected void save() {
        DefaultMutableTreeNode root = this.getBookmarksTreeNode();
        ArrayList l = new ArrayList();
        this.saveToList(l, root);
        List data = this.m_bookmarks.getData();
        data.clear();
        data.addAll(l);
    }

    protected void saveToList(List l, DefaultMutableTreeNode rootNode) {
        for (int i = 0; i < rootNode.getChildCount(); ++i) {
            DefaultMutableTreeNode rootChildTreeNode = (DefaultMutableTreeNode)rootNode.getChildAt(i);
            Object o = rootChildTreeNode.getUserObject();
            if (!(o instanceof BookmarkNode)) continue;
            BookmarkNode bn = (BookmarkNode)o;
            if (bn.getType() == 0) {
                BookmarkCategory cat = (BookmarkCategory)bn.getData();
                l.add(cat);
                cat.getBookmarks().clear();
                for (int j = 0; j < rootChildTreeNode.getChildCount(); ++j) {
                    DefaultMutableTreeNode childTreeNode = (DefaultMutableTreeNode)rootChildTreeNode.getChildAt(j);
                    BookmarkNode data = (BookmarkNode)childTreeNode.getUserObject();
                    if (data.getType() != 1) continue;
                    Bookmark bkMark = (Bookmark)data.getData();
                    cat.addBookmark(bkMark);
                }
                continue;
            }
            if (bn.getType() != 1) continue;
            l.add(bn.getData());
        }
    }

    protected DefaultMutableTreeNode getBookmarksTreeNode() {
        TreeModel model = this.tree.getModel();
        return (DefaultMutableTreeNode)model.getRoot();
    }

    public void moveToFolder() {
        MoveToFolderDialog dlg;
        ArrayList<BookmarkNode> folders = new ArrayList<BookmarkNode>();
        DefaultMutableTreeNode root = this.getBookmarksTreeNode();
        if (root != null) {
            for (int i = 0; i < root.getChildCount(); ++i) {
                DefaultMutableTreeNode n = (DefaultMutableTreeNode)root.getChildAt(i);
                BookmarkNode bn = (BookmarkNode)n.getUserObject();
                if (bn.getType() != 0) continue;
                folders.add(bn);
            }
        }
        if ((dlg = new MoveToFolderDialog(GraphUtils.getFrame((Component)((Object)this)))).display(folders) == 0) {
            BookmarkNode mark = this.getSelectedBookmarkNode();
            BookmarkNode folder = dlg.getSelectedFolder();
            for (int i = 0; i < root.getChildCount(); ++i) {
                DefaultMutableTreeNode child = (DefaultMutableTreeNode)root.getChildAt(i);
                BookmarkNode obj = (BookmarkNode)child.getUserObject();
                if (obj != mark) continue;
                DefaultMutableTreeNode parent = (DefaultMutableTreeNode)child.getParent();
                parent.remove(child);
                break;
            }
            DefaultMutableTreeNode folderNode = null;
            for (int i = 0; i < root.getChildCount(); ++i) {
                DefaultMutableTreeNode o = (DefaultMutableTreeNode)root.getChildAt(i);
                BookmarkNode bn = (BookmarkNode)o.getUserObject();
                if (bn != folder) continue;
                folderNode = o;
                break;
            }
            DefaultMutableTreeNode markNode = this.getSelectedTreeNode();
            if (folderNode != null) {
                folderNode.add(markNode);
            }
            this.refreshTree();
            this.expandEntireTree();
            TreePath p = UIHelper.getTreePathForNode((TreeNode)markNode);
            if (p != null) {
                this.selectTreePath(p);
            }
        }
    }

    protected void showPopup(int type, MouseEvent e) {
        DefaultMutableTreeNode node;
        Object obj;
        TreePath path;
        this.m_popup.removeAll();
        switch (type) {
            case 0: {
                this.m_popup.add(this.m_deleteFolderItem);
                break;
            }
            case 1: {
                this.m_popup.add(this.m_deleteBookmarkItem);
                this.m_popup.add(this.m_moveToFolderItem);
                this.m_popup.add(this.m_editBookmarkItem);
                break;
            }
            default: {
                this.m_popup.add(this.m_createFolderItem);
            }
        }
        int row = this.getSelectedRow();
        if (row != -1 && (path = this.tree.getPathForRow(row)) != null && (obj = path.getLastPathComponent()) instanceof DefaultMutableTreeNode && !(node = (DefaultMutableTreeNode)obj).isLeaf()) {
            boolean bCollapsed = this.tree.isCollapsed(row);
            this.m_popup.addSeparator();
            if (bCollapsed) {
                this.m_popup.add(this.m_expandItem);
            } else {
                this.m_popup.add(this.m_collapseItem);
            }
        }
        this.m_popup.show((Component)((Object)this), e.getX(), e.getY());
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    protected void deleteSelectedRow() {
        int row = this.getSelectedRow();
        if (row != -1) {
            TreePath path = this.tree.getPathForRow(row);
            if (path != null) {
                DefaultMutableTreeNode childNode;
                DefaultMutableTreeNode parent;
                Object obj = path.getLastPathComponent();
                if (obj instanceof DefaultMutableTreeNode && (parent = (DefaultMutableTreeNode)(childNode = (DefaultMutableTreeNode)obj).getParent()) != null) {
                    parent.remove(childNode);
                }
                this.refreshTree();
                this.expandEntireTree();
            }
            this.revalidate();
        }
    }

    protected void refreshTree() {
        TreePath treePath = this.tree.getPathForRow(0);
        Object[] paths = new Object[]{treePath};
        BookmarkTreeTableModel model = (BookmarkTreeTableModel)((Object)this.tree.getModel());
        model.fireTreeStructureChanged(this, paths, null, null);
        this.tree.repaint();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void actionPerformed(ActionEvent e) {
        Object src = e.getSource();
        if (src == this.m_createBookmarkItem) {
            BookmarkNode node = this.getSelectedBookmarkNode();
            if (node != null && node.getType() != 0) return;
        }
        if (src == this.m_createFolderItem) {
            this.handleCreateFolder();
            return;
        } else if (src == this.m_deleteBookmarkItem || src == this.m_deleteFolderItem) {
            this.deleteSelectedRow();
            return;
        } else if (src == this.m_expandItem) {
            this.expandSelectedPath();
            return;
        } else if (src == this.m_collapseItem) {
            this.collapseSelectedPath();
            return;
        } else if (src == this.m_moveToFolderItem) {
            this.moveToFolder();
            return;
        } else {
            if (src != this.m_editBookmarkItem) return;
            this.handleEdit();
        }
    }
}

