/*
 * Decompiled with CFR 0.152.
 */
package oracle.tip.tools.ide.pm.bpelgraph.bookmarks;

import java.awt.Component;
import javax.swing.JLabel;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import oracle.tip.tools.ide.pm.bpelgraph.bookmarks.Bookmark;
import oracle.tip.tools.ide.pm.bpelgraph.bookmarks.BookmarkCategory;
import oracle.tip.tools.ide.pm.bpelgraph.bookmarks.BookmarkNode;
import oracle.tip.tools.ide.pm.bpelgraph.bookmarks.BookmarkNodeTypes;
import oracle.tip.tools.ide.pm.resources.images.ImageCache;

public class BookmarkTreeCellRenderer
extends DefaultTreeCellRenderer
implements BookmarkNodeTypes {
    @Override
    public Component getTreeCellRendererComponent(JTree tree, Object value, boolean sel, boolean expanded, boolean leaf, int row, boolean hasFocus) {
        Object userObj;
        Component c = super.getTreeCellRendererComponent(tree, value, sel, expanded, leaf, row, hasFocus);
        if (value instanceof DefaultMutableTreeNode && (userObj = ((DefaultMutableTreeNode)value).getUserObject()) instanceof BookmarkNode) {
            JLabel lbl = (JLabel)c;
            BookmarkNode bn = (BookmarkNode)userObj;
            switch (bn.getType()) {
                case 2: {
                    this.setText((String)bn.getData());
                    lbl.setIcon(expanded ? ImageCache.getIcon("folder_open_node") : ImageCache.getIcon("folder_close_node"));
                    break;
                }
                case 0: {
                    BookmarkCategory data = (BookmarkCategory)bn.getData();
                    this.setText(data.getName());
                    lbl.setIcon(expanded ? ImageCache.getIcon("folder_open_node") : ImageCache.getIcon("folder_close_node"));
                    break;
                }
                case 1: {
                    Bookmark data = (Bookmark)bn.getData();
                    lbl.setIcon(ImageCache.getIcon("bookmarks.png"));
                    this.setText(data.getName());
                    break;
                }
                default: {
                    lbl.setIcon(expanded ? ImageCache.getIcon("folder_open_node") : ImageCache.getIcon("folder_close_node"));
                }
            }
        }
        return c;
    }
}

