/*
 * Decompiled with CFR 0.152.
 */
package oracle.tip.tools.ide.pm.bpelgraph.bookmarks;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import oracle.tip.tools.ide.common.graph.GraphUtils;
import oracle.tip.tools.ide.pm.bpelgraph.bookmarks.Bookmark;
import oracle.tip.tools.ide.pm.gui.generalpurpose.BPELBaseDialog;
import oracle.tip.tools.ide.pm.i18n.BPELStringTranslator;

public class BookmarkDialog
extends BPELBaseDialog
implements ActionListener {
    public static final int OK = 0;
    public static final int CANCEL = 1;
    protected JButton m_okBtn;
    protected JButton m_cancelBtn;
    protected JButton m_helpBtn;
    protected JTextField m_nameField;
    protected JTextField m_xpathField;
    protected Bookmark m_mark;
    protected int m_retVal = 1;

    public BookmarkDialog(JFrame f) {
        super(f, "Edit Bookmark", true);
        this.createControls();
        this.layoutControls();
    }

    public int display(Bookmark bk) {
        this.m_mark = bk;
        this.loadControls();
        this.show();
        return this.m_retVal;
    }

    protected void handleEnterKey() {
        this.handleOK();
    }

    protected void loadControls() {
        this.m_nameField.setText(this.m_mark.getName());
        this.m_xpathField.setText(this.m_mark.getXPath());
    }

    protected void createControls() {
        this.m_okBtn = new JButton(BPELStringTranslator.getString("OK_BUTTON_TEXT"));
        BPELStringTranslator.setButton(this.m_okBtn, BPELStringTranslator.getString("OK_BUTTON_TEXT_RES"));
        this.m_okBtn.addActionListener(this);
        this.m_cancelBtn = new JButton(BPELStringTranslator.getString("CANCEL_BUTTON_TEXT"));
        BPELStringTranslator.setButton(this.m_cancelBtn, BPELStringTranslator.getString("CANCEL_BUTTON_TEXT_RES"));
        this.m_cancelBtn.addActionListener(this);
        this.m_helpBtn = new JButton();
        BPELStringTranslator.setButton(this.m_helpBtn, BPELStringTranslator.getString("HELP_BUTTON_TEXT_RES"));
        this.m_helpBtn.addActionListener(this);
        this.m_nameField = new JTextField();
        this.m_xpathField = new JTextField();
        this.m_xpathField.setEditable(false);
    }

    protected void layoutControls() {
        JPanel btnPnl = new JPanel(new GridLayout(1, 2, 5, 0));
        btnPnl.add(this.m_okBtn);
        btnPnl.add(this.m_cancelBtn);
        Container c = this.getContentPane();
        c.setLayout(new GridBagLayout());
        int row = 0;
        JLabel nameLbl = new JLabel("Name:");
        JLabel xpathLbl = new JLabel("XPath:");
        BPELStringTranslator.setLabel(nameLbl, this.m_nameField, BPELStringTranslator.getString("NAME_LBL"));
        BPELStringTranslator.setLabel(xpathLbl, this.m_xpathField, BPELStringTranslator.getString("XPATH_LBL"));
        GraphUtils.addComponent((Container)c, (Component)nameLbl, (int)0, (int)row, (int)1, (int)1, (int)17, (int)0, (Insets)new Insets(10, 10, 0, 0), (int)0, (int)0, (double)0.0, (double)0.0);
        GraphUtils.addComponent((Container)c, (Component)this.m_nameField, (int)1, (int)row++, (int)1, (int)1, (int)17, (int)2, (Insets)new Insets(10, 5, 0, 10), (int)0, (int)0, (double)1.0, (double)0.0);
        GraphUtils.addComponent((Container)c, (Component)xpathLbl, (int)0, (int)row, (int)1, (int)1, (int)17, (int)0, (Insets)new Insets(10, 10, 0, 0), (int)0, (int)0, (double)0.0, (double)0.0);
        GraphUtils.addComponent((Container)c, (Component)this.m_xpathField, (int)1, (int)row++, (int)1, (int)1, (int)17, (int)2, (Insets)new Insets(10, 5, 0, 10), (int)0, (int)0, (double)1.0, (double)0.0);
        GraphUtils.addComponent((Container)c, (Component)this.m_helpBtn, (int)0, (int)row, (int)1, (int)1, (int)17, (int)0, (Insets)new Insets(10, 10, 5, 0), (int)0, (int)0, (double)1.0, (double)0.0);
        GraphUtils.addComponent((Container)c, (Component)btnPnl, (int)1, (int)row++, (int)1, (int)1, (int)13, (int)0, (Insets)new Insets(10, 5, 5, 10), (int)0, (int)0, (double)1.0, (double)0.0);
        this.setSize(new Dimension(300, 140));
        this.setLocationRelativeTo(this.getParent());
    }

    public void handleCancel() {
        this.m_retVal = 1;
        this.dispose();
    }

    public void handleOK() {
        this.m_mark.setName(this.m_nameField.getText());
        this.m_mark.setXPath(this.m_xpathField.getText());
        this.m_retVal = 0;
        this.dispose();
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Object src = e.getSource();
        if (src == this.m_okBtn) {
            this.handleOK();
        } else if (src == this.m_cancelBtn) {
            this.handleCancel();
        } else if (src == this.m_helpBtn) {
            this.helpInvoked();
        }
    }

    protected void helpInvoked() {
        this.handleHelp((Component)((Object)this));
    }
}

