/*
 * Decompiled with CFR 0.152.
 */
package oracle.tip.tools.ide.pm.bpelgraph.bookmarks;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import oracle.tip.tools.ide.common.bpelparser.iface.Activity;
import oracle.tip.tools.ide.common.bpelparser.iface.PartnerLink;
import oracle.tip.tools.ide.common.bpelparser.iface.Process;
import oracle.tip.tools.ide.common.bpelparser.util.BPELModelUtil;
import oracle.tip.tools.ide.common.bpelparser.util.ResolvedXPathObject;
import oracle.tip.tools.ide.common.bpelparser.util.XMLHelper;
import oracle.tip.tools.ide.pm.bpelgraph.bookmarks.Bookmark;
import oracle.tip.tools.ide.pm.bpelgraph.bookmarks.BookmarkCategory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class BookmarkDataStore {
    private List m_data = new ArrayList();

    public List getBookmarks() {
        ArrayList l = new ArrayList();
        for (Object o : this.m_data) {
            if (!(o instanceof Bookmark)) continue;
            l.add(o);
        }
        return l;
    }

    public void addBookmark(Bookmark bm) {
        this.m_data.add(bm);
    }

    public void removeBookmark(Bookmark bm) {
        this.m_data.remove(bm);
    }

    public void addCategory(BookmarkCategory c) {
        this.m_data.add(c);
    }

    public void removeCategory(BookmarkCategory c) {
        this.m_data.remove(c);
    }

    public List getData() {
        return this.m_data;
    }

    public List getBookCategories() {
        ArrayList l = new ArrayList();
        for (Object o : this.m_data) {
            if (!(o instanceof BookmarkCategory)) continue;
            l.add(o);
        }
        return l;
    }

    public void read(Element elem, Process p) {
        Iterator it = XMLHelper.getChildElementIterator((Element)elem);
        while (it.hasNext()) {
            Element e = (Element)it.next();
            if (e.getTagName().equalsIgnoreCase("category")) {
                this.m_data.add(new BookmarkCategory(e, p));
                continue;
            }
            if (!e.getTagName().equalsIgnoreCase("bookmark")) continue;
            Bookmark bm = new Bookmark(e);
            this.m_data.add(bm);
            String xpath = bm.getXPath();
            try {
                ResolvedXPathObject r = BPELModelUtil.getObjectFromXPath((Process)p, (String)xpath);
                if (r.getEvalObjectType() == 2) {
                    Activity a = (Activity)r.getEvalObject();
                    bm.setID(a.getID());
                    continue;
                }
                if (r.getEvalObjectType() != 4) continue;
                PartnerLink pl = (PartnerLink)r.getEvalObject();
                bm.setID(pl.getID());
            }
            catch (Exception e1) {
                e1.printStackTrace();
            }
        }
    }

    public Element createElement(Document doc, Process p) {
        Element bookmarksElem = doc.createElement("bookmarks");
        for (Object o : this.m_data) {
            if (o instanceof Bookmark) {
                Bookmark b = (Bookmark)o;
                int id = b.getID();
                Activity a = BPELModelUtil.getActivityForID((int)id, (Process)p);
                if (a != null) {
                    String xpath = BPELModelUtil.getXPathForActivity((Activity)a);
                    b.setXPath(xpath);
                    b.setBPELType(a.getTypeID());
                    bookmarksElem.appendChild(b.createElement(bookmarksElem.getOwnerDocument()));
                    continue;
                }
                PartnerLink pl = BPELModelUtil.getPartnerLinkForID((int)id, (Process)p);
                if (pl == null) continue;
                String xpath = BPELModelUtil.getXPathForPartnerLink((Process)p, (PartnerLink)pl);
                b.setXPath(xpath);
                b.setBPELType(11);
                bookmarksElem.appendChild(b.createElement(bookmarksElem.getOwnerDocument()));
                continue;
            }
            if (!(o instanceof BookmarkCategory)) continue;
            BookmarkCategory c = (BookmarkCategory)o;
            bookmarksElem.appendChild(c.createElement(bookmarksElem.getOwnerDocument(), p));
        }
        return bookmarksElem;
    }
}

