/*
 * Decompiled with CFR 0.152.
 */
package oracle.tip.tools.ide.pm.bpelgraph.bookmarks;

import java.util.ArrayList;
import java.util.List;
import oracle.tip.tools.ide.common.bpelparser.iface.Activity;
import oracle.tip.tools.ide.common.bpelparser.iface.PartnerLink;
import oracle.tip.tools.ide.common.bpelparser.iface.Process;
import oracle.tip.tools.ide.common.bpelparser.util.BPELModelUtil;
import oracle.tip.tools.ide.common.bpelparser.util.ResolvedXPathObject;
import oracle.tip.tools.ide.common.bpelparser.util.XMLHelper;
import oracle.tip.tools.ide.pm.bpelgraph.bookmarks.Bookmark;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class BookmarkCategory {
    private String m_name;
    private List<Bookmark> m_bookmarks = new ArrayList<Bookmark>();

    public BookmarkCategory(Element elem, Process p) {
        if (elem != null) {
            this.readFromElement(elem, p);
        }
    }

    public String getName() {
        return this.m_name;
    }

    public void setName(String name) {
        this.m_name = name;
    }

    public List<Bookmark> getBookmarks() {
        return this.m_bookmarks;
    }

    public void addBookmark(Bookmark b) {
        this.m_bookmarks.add(b);
    }

    public void setBookmarks(List<Bookmark> bookmarks) {
        this.m_bookmarks = bookmarks;
    }

    public void readFromElement(Element e, Process p) {
        this.m_bookmarks.clear();
        this.m_name = XMLHelper.getAttribute((Element)e, (String)"name");
        List l = XMLHelper.getChildElementsWithTagName((Element)e, (String)"bookmark");
        for (Element elem : l) {
            Bookmark bm = new Bookmark(elem);
            this.m_bookmarks.add(bm);
            String xpath = bm.getXPath();
            try {
                ResolvedXPathObject r = BPELModelUtil.getObjectFromXPath((Process)p, (String)xpath);
                if (r.getEvalObjectType() == 2) {
                    Activity a = (Activity)r.getEvalObject();
                    bm.setID(a.getID());
                    continue;
                }
                if (r.getEvalObjectType() != 4) continue;
                PartnerLink pl = (PartnerLink)r.getEvalObject();
                bm.setID(pl.getID());
            }
            catch (Exception e1) {
                e1.printStackTrace();
            }
        }
    }

    public Element createElement(Document doc, Process p) {
        Element e = doc.createElement("category");
        XMLHelper.setAttribute((Element)e, (String)"name", (Object)this.getName());
        for (Bookmark bookmark : this.m_bookmarks) {
            int id = bookmark.getID();
            Activity a = BPELModelUtil.getActivityForID((int)id, (Process)p);
            if (a != null) {
                String xpath = BPELModelUtil.getXPathForActivity((Activity)a);
                bookmark.setXPath(xpath);
                bookmark.setBPELType(a.getTypeID());
                e.appendChild(bookmark.createElement(doc));
                continue;
            }
            PartnerLink pl = BPELModelUtil.getPartnerLinkForID((int)id, (Process)p);
            if (pl == null) continue;
            String xpath = BPELModelUtil.getXPathForPartnerLink((Process)p, (PartnerLink)pl);
            bookmark.setXPath(xpath);
            bookmark.setBPELType(11);
            e.appendChild(bookmark.createElement(doc));
        }
        return e;
    }
}

