/*
 * Decompiled with CFR 0.152.
 */
package oracle.tip.tools.ide.pm.bpelgraph.bookmarks;

import java.awt.Component;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.Icon;
import oracle.tip.tools.ide.common.bpelparser.iface.Activity;
import oracle.tip.tools.ide.common.bpelparser.iface.PartnerLink;
import oracle.tip.tools.ide.common.bpelparser.iface.Process;
import oracle.tip.tools.ide.common.bpelparser.util.BPELModelUtil;
import oracle.tip.tools.ide.common.graph.GraphUtils;
import oracle.tip.tools.ide.pm.bpelgraph.bookmarks.Bookmark;
import oracle.tip.tools.ide.pm.bpelgraph.model.BPELGraphModel;
import oracle.tip.tools.ide.pm.bpelgraph.views.BPELGraphPane;
import oracle.tip.tools.ide.pm.resources.images.ImageCache;

public class BookmarkAction
extends AbstractAction {
    private Bookmark m_mark;
    private BPELGraphPane m_graph;

    public BookmarkAction(BPELGraphPane graph, Bookmark mark) {
        super(mark.getName(), ImageCache.getIcon("bookmarks.png"));
        this.m_mark = mark;
        this.m_graph = graph;
        int type = mark.getBPELType();
        switch (type) {
            case 11: {
                this.setIcon(ImageCache.getIcon("partner_link_node"));
                break;
            }
            case 5: {
                this.setIcon(ImageCache.getIcon("process_node"));
                break;
            }
            case 29: {
                this.setIcon(ImageCache.getIcon("flow_n_node"));
                break;
            }
            case 3: {
                this.setIcon(ImageCache.getIcon("sequence_node"));
                break;
            }
            case 12: {
                this.setIcon(ImageCache.getIcon("wait_node"));
                break;
            }
            case 0: {
                this.setIcon(ImageCache.getIcon("invoke_node"));
                break;
            }
            case 14: {
                this.setIcon(ImageCache.getIcon("pick_node"));
                break;
            }
            case 4: {
                this.setIcon(ImageCache.getIcon("switch_node"));
                break;
            }
            case 6: {
                this.setIcon(ImageCache.getIcon("switch_node"));
                break;
            }
            case 7: {
                this.setIcon(ImageCache.getIcon("switch_node"));
                break;
            }
            case 16: {
                this.setIcon(ImageCache.getIcon("on_alarm_node"));
                break;
            }
            case 15: {
                this.setIcon(ImageCache.getIcon("on_message_node"));
                break;
            }
            case 18: {
                this.setIcon(ImageCache.getIcon("terminate_node"));
                break;
            }
            case 27: {
                this.setIcon(ImageCache.getIcon("transform_node"));
                break;
            }
            case 9: {
                this.setIcon(ImageCache.getIcon("assign_node"));
                break;
            }
            case 8: {
                this.setIcon(ImageCache.getIcon("flow_node"));
                break;
            }
            case 1: {
                this.setIcon(ImageCache.getIcon("receive_node"));
                break;
            }
            case 13: {
                this.setIcon(ImageCache.getIcon("reply_node"));
                break;
            }
            case 2: {
                this.setIcon(ImageCache.getIcon("scope_node"));
                break;
            }
            case 21: {
                this.setIcon(ImageCache.getIcon("throw_node"));
                break;
            }
            case 19: {
                this.setIcon(ImageCache.getIcon("empty_node"));
                break;
            }
            case 20: {
                this.setIcon(ImageCache.getIcon("compensate_node"));
                break;
            }
            case 17: {
                this.setIcon(ImageCache.getIcon("while_node"));
                break;
            }
            case 22: {
                this.setIcon(ImageCache.getIcon("catch_node"));
                break;
            }
            case 23: {
                this.setIcon(ImageCache.getIcon("catch_all_node"));
                break;
            }
            case 26: {
                this.setIcon(ImageCache.getIcon("process_node"));
                break;
            }
            case 28: {
                this.setIcon(ImageCache.getIcon("java_embedding_node"));
                break;
            }
        }
    }

    protected void setIcon(Icon icon) {
        this.putValue("SmallIcon", icon);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        BPELGraphModel model = (BPELGraphModel)this.m_graph.getModel();
        Process process = model.getProcess();
        int id = this.m_mark.getID();
        Activity a = BPELModelUtil.getActivityForID((int)id, (Process)process);
        if (a != null) {
            this.m_graph.selectActivity(a);
            return;
        }
        for (PartnerLink partnerLink : BPELModelUtil.getAllPartnerLinks((Process)process)) {
            if (id != partnerLink.getID()) continue;
            this.m_graph.selectPartnerLink(partnerLink);
            return;
        }
        GraphUtils.displayMessage((Component)GraphUtils.getFrame((Component)((Object)this.m_graph)), (String)"Bookmark activity could not be found!", (int)0);
    }
}

