/*
 * Decompiled with CFR 0.152.
 */
package oracle.tip.tools.ide.pm.bpelgraph.actions;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.List;
import oracle.tip.tools.ide.common.bpelparser.iface.Scope;
import oracle.tip.tools.ide.common.bpelparser.iface.Variable;
import oracle.tip.tools.ide.common.bpelparser.iface.Variables;
import oracle.tip.tools.ide.common.graph.GraphUtils;
import oracle.tip.tools.ide.common.graph.actions.GraphAction;
import oracle.tip.tools.ide.common.graph.view.View;
import oracle.tip.tools.ide.pm.bpelgraph.editors.VariablesEditDialog;
import oracle.tip.tools.ide.pm.bpelgraph.views.BPELGraphPane;
import oracle.tip.tools.ide.pm.i18n.BPELStringTranslator;
import oracle.tip.tools.ide.pm.resources.images.ImageCache;

public class VariablesAction
extends GraphAction {
    private View m_view;

    public VariablesAction(View v) {
        super(BPELStringTranslator.getString("COLLAXALAF_VARIABLES") + "...");
        this.m_view = v;
        this.setIcon(ImageCache.getIcon("graph/bpel/variables.png"));
        this.putValue("TRANSPARENT_ICON", ImageCache.getIcon("graph/bpel/variables_fadeout.png"));
    }

    public void actionPerformed(ActionEvent e) {
        Scope scope = (Scope)this.m_view.getNode().getUserObject();
        VariablesEditDialog dlg = new VariablesEditDialog(GraphUtils.getFrame((Component)this.m_view.getGraphPane()), (BPELGraphPane)this.m_view.getGraphPane(), scope);
        if (dlg.display() == 0) {
            List lst = dlg.getVariables();
            Variables vars = scope.getVariables();
            if (vars == null) {
                vars = scope.createVariables();
            }
            ArrayList<Variable> deleteList = new ArrayList<Variable>();
            for (Variable v : vars.getVariables()) {
                if (lst.contains(v)) continue;
                deleteList.add(v);
            }
            for (Variable v : deleteList) {
                vars.deleteVariable(v);
            }
            for (Variable v : lst) {
                if (vars.getVariables().contains(v)) continue;
                vars.addVariable(v);
            }
            if (vars.getVariables().size() == 0) {
                scope.deleteVariables();
            }
        }
    }

    public void updateState() {
        BPELGraphPane graph = (BPELGraphPane)this.m_view.getGraphPane();
        this.setVisible(graph.allowActionEditing());
        this.setEnabled(this.m_view.isEditable());
    }
}

