/*
 * Decompiled with CFR 0.152.
 */
package oracle.tip.tools.ide.pm.bpelgraph.actions;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.util.Iterator;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.UIManager;
import javax.swing.border.LineBorder;
import oracle.tip.tools.ide.common.bpelparser.iface.SwitchCase;
import oracle.tip.tools.ide.common.graph.actions.GraphAction;
import oracle.tip.tools.ide.common.graph.view.ActionInfo;
import oracle.tip.tools.ide.common.graph.view.GraphPane;
import oracle.tip.tools.ide.common.graph.view.View;
import oracle.tip.tools.ide.common.ui.UIHelper;
import oracle.tip.tools.ide.pm.bpelgraph.views.ConfigBox;
import oracle.tip.tools.ide.pm.bpelgraph.views.SwitchCaseView;
import oracle.tip.tools.ide.pm.i18n.BPELStringTranslator;
import oracle.tip.tools.ide.pm.resources.images.ImageCache;

public class SwitchCaseDescriptionAction
extends GraphAction {
    private View m_view;

    public SwitchCaseDescriptionAction(View v) {
        super(BPELStringTranslator.getString("ACTIONS_VIEW_DESCRIPTION", "View Name"));
        this.m_view = v;
        this.putValue("SmallIcon", new ImageIcon(ImageCache.getImage("graph/message.png")));
    }

    public void actionPerformed(ActionEvent e) {
        SwitchCaseView v = (SwitchCaseView)this.m_view;
        SwitchCase c = (SwitchCase)v.getNode().getUserObject();
        String desc = c.getDescription();
        ActionInfo target = null;
        ConfigBox box = v.getConfigBox();
        Iterator it = box.getActionInfos();
        while (it.hasNext()) {
            ActionInfo info = (ActionInfo)it.next();
            if (!(info.getAction() instanceof SwitchCaseDescriptionAction)) continue;
            target = info;
            break;
        }
        if (target == null) {
            return;
        }
        GraphPane pane = this.m_view.getGraphPane();
        JPanel p = new JPanel(new GridBagLayout());
        p.setPreferredSize(new Dimension(400, 150));
        JTextArea a = new JTextArea(desc);
        a.setLineWrap(true);
        a.setWrapStyleWord(true);
        a.setEditable(false);
        JScrollPane sp = new JScrollPane(a);
        sp.setBorder(new LineBorder(Color.cyan.darker(), 1));
        JLabel lbl = new JLabel(BPELStringTranslator.getString("NAME", "Name"), 0);
        lbl.setFont(new Font(UIManager.getFont("Label.font").getFontName(), 1, 12));
        UIHelper.addComponent((Container)p, (Component)lbl, (int)0, (int)0, (int)1, (int)1, (int)17, (int)2, (Insets)new Insets(5, 5, 5, 5), (int)0, (int)0, (double)1.0, (double)0.0);
        UIHelper.addComponent((Container)p, (Component)sp, (int)0, (int)1, (int)1, (int)1, (int)17, (int)1, (Insets)new Insets(0, 5, 5, 5), (int)0, (int)0, (double)1.0, (double)1.0);
        Dimension dim = new Dimension(300, 120);
        Rectangle r = target.getBounds();
        double zoom = pane.getZoom();
        int xTranslation = pane.getXTranslation();
        int yTranslation = pane.getYTranslation();
        double nonZoomXTranslation = (double)xTranslation * zoom;
        double nonZoomYTranslation = (double)yTranslation * zoom;
        Point mousePt = new Point(r.x - dim.width / 2, r.y + r.height);
        mousePt.x = (int)((double)mousePt.x * zoom) + (int)nonZoomXTranslation;
        mousePt.y = (int)((double)mousePt.y * zoom) + (int)nonZoomYTranslation;
        pane.showPopupPanel(mousePt.x, mousePt.y, (JComponent)p);
        a.requestFocus();
    }
}

