/*
 * Decompiled with CFR 0.152.
 */
package oracle.tip.tools.ide.pm.bpelgraph.actions;

import java.awt.event.ActionEvent;
import javax.swing.Icon;
import oracle.tip.tools.ide.common.graph.actions.DisplayAction;
import oracle.tip.tools.ide.common.graph.actions.GraphAction;
import oracle.tip.tools.ide.common.graph.view.View;
import oracle.tip.tools.ide.pm.bpelgraph.views.ProcessView;
import oracle.tip.tools.ide.pm.bpelgraph.views.ScopeView;
import oracle.tip.tools.ide.pm.i18n.BPELStringTranslator;
import oracle.tip.tools.ide.pm.resources.images.ImageCache;

public class ShowHideFaultHandlersAction
extends GraphAction
implements DisplayAction {
    private View m_view;
    private static Icon m_showIcon = ImageCache.getIcon("graph/bpel/expand_10x10.png");
    private static Icon m_hideIcon = ImageCache.getIcon("graph/bpel/collapse_10x10.png");

    public ShowHideFaultHandlersAction(View v) {
        super("Hide FaultHandlers");
        this.m_view = v;
        this.updateIcon();
    }

    public void actionPerformed(ActionEvent e) {
        if (this.m_view instanceof ScopeView) {
            ScopeView v;
            v.setShowHandlers(!(v = (ScopeView)this.m_view).getShowHandlers());
            this.updateIcon();
            v.getGraphPane().forceImmediateLayout(true);
        } else if (this.m_view instanceof ProcessView) {
            ProcessView v;
            v.setShowHandlers(!(v = (ProcessView)this.m_view).getShowHandlers());
            this.updateIcon();
            v.getGraphPane().forceImmediateLayout(true);
        }
    }

    public void updateIcon() {
        if (this.m_view instanceof ScopeView) {
            ScopeView v = (ScopeView)this.m_view;
            String s = null;
            Icon icon = null;
            if (v.getShowHandlers()) {
                icon = m_hideIcon;
                s = BPELStringTranslator.getString("ACTIONS_HIDE_FAULTHANDLERS", "Hide Fault Handlers");
                this.putValue("HOVER_ICON", ImageCache.getIcon("graph/bpel/collapse_over.png"));
            } else {
                icon = m_showIcon;
                s = BPELStringTranslator.getString("ACTIONS_SHOW_FAULTHANDLERS", "Show Fault Handlers");
                this.putValue("HOVER_ICON", ImageCache.getIcon("graph/bpel/expand_over.png"));
            }
            this.putValue("SmallIcon", icon);
            this.putValue("Name", s);
        } else if (this.m_view instanceof ProcessView) {
            ProcessView v = (ProcessView)this.m_view;
            String s = null;
            Icon icon = null;
            if (v.getShowHandlers()) {
                icon = m_hideIcon;
                s = BPELStringTranslator.getString("ACTIONS_HIDE_FAULTHANDLERS", "Hide Fault Handlers");
                this.putValue("HOVER_ICON", ImageCache.getIcon("graph/bpel/collapse_over.png"));
            } else {
                icon = m_showIcon;
                s = BPELStringTranslator.getString("ACTIONS_SHOW_FAULTHANDLERS", "Show Fault Handlers");
                this.putValue("HOVER_ICON", ImageCache.getIcon("graph/bpel/expand_over.png"));
            }
            this.putValue("SmallIcon", icon);
            this.putValue("Name", s);
        }
    }
}

