/*
 * Decompiled with CFR 0.152.
 */
package oracle.tip.tools.ide.pm.bpelgraph.actions;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Iterator;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.UIManager;
import javax.swing.border.LineBorder;
import javax.swing.text.JTextComponent;
import oracle.tip.tools.ide.common.bpeldesigner.models.schema.NSResolverFactory;
import oracle.tip.tools.ide.common.bpelparser.iface.Activity;
import oracle.tip.tools.ide.common.bpelparser.iface.Process;
import oracle.tip.tools.ide.common.bpelparser.iface.SwitchCase;
import oracle.tip.tools.ide.common.bpelparser.iface.While;
import oracle.tip.tools.ide.common.expressionbuilder.BpelExpressionBuilder;
import oracle.tip.tools.ide.common.expressionbuilder.ExpressionBuilderPicker;
import oracle.tip.tools.ide.common.expressionbuilders.FunctionsExpressionBuilderPicker;
import oracle.tip.tools.ide.common.graph.GraphUtils;
import oracle.tip.tools.ide.common.graph.actions.GraphAction;
import oracle.tip.tools.ide.common.graph.view.ActionInfo;
import oracle.tip.tools.ide.common.graph.view.GraphPane;
import oracle.tip.tools.ide.common.graph.view.View;
import oracle.tip.tools.ide.common.ui.ShadowedTextLabel;
import oracle.tip.tools.ide.common.ui.ToolBar;
import oracle.tip.tools.ide.common.ui.UIHelper;
import oracle.tip.tools.ide.common.utils.NamespaceResolver;
import oracle.tip.tools.ide.common.xpath.editor.XPathEditorPane;
import oracle.tip.tools.ide.common.xpath.editor.util.VariableDataCallBack;
import oracle.tip.tools.ide.pm.addin.model.BPELXmlModel;
import oracle.tip.tools.ide.pm.bpelgraph.editors.VariableDataCallBackImpl;
import oracle.tip.tools.ide.pm.bpelgraph.editors.VariableExpressionBuilderPicker;
import oracle.tip.tools.ide.pm.bpelgraph.editors.VariablePickerPanel;
import oracle.tip.tools.ide.pm.bpelgraph.model.BPELGraphModel;
import oracle.tip.tools.ide.pm.bpelgraph.views.BPELGraphPane;
import oracle.tip.tools.ide.pm.bpelgraph.views.BPELVerticalDropBranchView;
import oracle.tip.tools.ide.pm.bpelgraph.views.BaseSwitchBranchView;
import oracle.tip.tools.ide.pm.bpelgraph.views.ConfigBox;
import oracle.tip.tools.ide.pm.bpelgraph.views.SwitchCaseView;
import oracle.tip.tools.ide.pm.bpelgraph.views.WhileView;
import oracle.tip.tools.ide.pm.i18n.BPELStringTranslator;
import oracle.tip.tools.ide.pm.resources.images.ImageCache;

public class EditExpressionAction
extends GraphAction {
    private View m_view;
    private boolean m_bEditExpression;

    public EditExpressionAction(View v, boolean bEditable) {
        super(BPELStringTranslator.getString("ACTIONS_VIEW_CONDITION_EXPRESSION", "View Condition Expression"));
        this.m_bEditExpression = bEditable;
        this.m_view = v;
        this.setIcon(ImageCache.getIcon("edit_expression16"));
    }

    public void updateState() {
        BPELGraphPane graph = (BPELGraphPane)this.m_view.getGraphPane();
        this.setVisible(graph.allowActionEditing());
        this.setEnabled(this.m_view.isEditable());
    }

    public void actionPerformed(ActionEvent e) {
        this.showExpression();
    }

    private void showExpression() {
        ActionInfo info;
        Iterator it;
        ConfigBox box;
        BPELVerticalDropBranchView v;
        BPELGraphPane graphPane = (BPELGraphPane)this.m_view.getGraphPane();
        String title = "Condition Expression";
        String conditionClause = "";
        SwitchCase theActivity = null;
        ActionInfo target = null;
        if (this.m_view instanceof SwitchCaseView) {
            SwitchCase c;
            v = (SwitchCaseView)this.m_view;
            theActivity = c = (SwitchCase)v.getNode().getUserObject();
            conditionClause = c.getCondition();
            if (conditionClause == null) {
                conditionClause = "";
            }
            box = ((BaseSwitchBranchView)v).getConfigBox();
            it = box.getActionInfos();
            while (it.hasNext()) {
                info = (ActionInfo)it.next();
                if (!(info.getAction() instanceof EditExpressionAction)) continue;
                target = info;
                break;
            }
        } else if (this.m_view instanceof WhileView) {
            v = (WhileView)this.m_view;
            While w = (While)v.getNode().getUserObject();
            theActivity = w;
            conditionClause = w.getCondition();
            if (conditionClause == null) {
                conditionClause = "";
            }
            box = ((WhileView)v).getConfigBox();
            it = box.getActionInfos();
            while (it.hasNext()) {
                info = (ActionInfo)it.next();
                if (!(info.getAction() instanceof EditExpressionAction)) continue;
                target = info;
                break;
            }
        }
        if (target != null) {
            SwitchCase activity = theActivity;
            ToolBar tb = new ToolBar();
            tb.setBackground(Color.white);
            JButton exprBtn = UIHelper.createModelerButton((Icon)ImageCache.getIcon("expressionbuilder"));
            exprBtn.setToolTipText(BPELStringTranslator.getString("XPATH_EXPRESSSION_BUILDER", "XPath Expression Builder"));
            tb.add((Component)exprBtn);
            exprBtn.addActionListener(new ActionListener((Activity)activity, graphPane){
                final /* synthetic */ Activity val$activity;
                final /* synthetic */ BPELGraphPane val$graphPane;
                {
                    this.val$activity = activity;
                    this.val$graphPane = bPELGraphPane;
                }

                @Override
                public void actionPerformed(ActionEvent e) {
                    String text = "";
                    if (this.val$activity instanceof SwitchCase) {
                        SwitchCase sc = (SwitchCase)this.val$activity;
                        text = sc.getCondition();
                    } else if (this.val$activity instanceof While) {
                        While w = (While)this.val$activity;
                        text = w.getCondition();
                    }
                    BPELGraphModel m_graphModel = (BPELGraphModel)this.val$graphPane.getModel();
                    NamespaceResolver nsResolver = EditExpressionAction.this.getNSResolver(this.val$activity);
                    BPELXmlModel mainModel = this.val$graphPane.getBPELXmlModel();
                    VariableDataCallBackImpl dataCallBack = new VariableDataCallBackImpl(mainModel, this.val$activity, nsResolver);
                    VariablePickerPanel p = new VariablePickerPanel(this.val$graphPane, dataCallBack, nsResolver);
                    VariableExpressionBuilderPicker picker = new VariableExpressionBuilderPicker(p, this.val$activity);
                    ExpressionBuilderPicker[] pickers = new ExpressionBuilderPicker[]{picker, new FunctionsExpressionBuilderPicker(nsResolver)};
                    XPathEditorPane editorPane = new XPathEditorPane();
                    editorPane.initializeDocument();
                    editorPane.initializeEditorPane((VariableDataCallBack)dataCallBack, text, nsResolver, false);
                    BpelExpressionBuilder dlg = new BpelExpressionBuilder(GraphUtils.getFrame((Component)((Object)this.val$graphPane)), (JTextComponent)editorPane, pickers);
                    if (dlg.display() == 0) {
                        String t = dlg.getExpressionText();
                        if (this.val$activity instanceof SwitchCase) {
                            SwitchCase sc = (SwitchCase)this.val$activity;
                            sc.setCondition(t);
                        } else if (this.val$activity instanceof While) {
                            While w = (While)this.val$activity;
                            w.setCondition(t);
                        }
                    }
                    EditExpressionAction.this.showExpression();
                }
            });
            GraphPane pane = this.m_view.getGraphPane();
            JPanel p = new JPanel(new GridBagLayout());
            p.setBackground(Color.white);
            p.setPreferredSize(new Dimension(400, 150));
            JTextArea a = new JTextArea(conditionClause);
            a.setBackground(UIManager.getColor("Panel.background"));
            a.setLineWrap(true);
            a.setWrapStyleWord(true);
            a.setEditable(false);
            JScrollPane sp = new JScrollPane(a);
            sp.setBorder(new LineBorder(Color.cyan.darker(), 1));
            ShadowedTextLabel l = new ShadowedTextLabel(title);
            l.setBackground(Color.WHITE);
            UIHelper.addComponent((Container)p, (Component)l, (int)0, (int)0, (int)1, (int)1, (int)10, (int)2, (Insets)new Insets(5, 5, 0, 5), (int)0, (int)0, (double)1.0, (double)0.0);
            if (this.m_bEditExpression) {
                UIHelper.addComponent((Container)p, (Component)tb, (int)1, (int)0, (int)1, (int)1, (int)13, (int)2, (Insets)new Insets(5, 5, 0, 5), (int)0, (int)0, (double)0.0, (double)0.0);
            }
            UIHelper.addComponent((Container)p, (Component)sp, (int)0, (int)1, (int)2, (int)1, (int)17, (int)1, (Insets)new Insets(2, 5, 5, 5), (int)0, (int)0, (double)1.0, (double)1.0);
            Dimension dim = new Dimension(300, 120);
            Rectangle r = target.getBounds();
            double zoom = pane.getZoom();
            int xTranslation = pane.getXTranslation();
            int yTranslation = pane.getYTranslation();
            double nonZoomXTranslation = (double)xTranslation * zoom;
            double nonZoomYTranslation = (double)yTranslation * zoom;
            Point mousePt = new Point(r.x - dim.width / 2, r.y + r.height);
            mousePt.x = (int)((double)mousePt.x * zoom) + (int)nonZoomXTranslation;
            mousePt.y = (int)((double)mousePt.y * zoom) + (int)nonZoomYTranslation;
            pane.showPopupPanel(mousePt.x, mousePt.y, (JComponent)p);
            a.requestFocus();
        }
    }

    protected final NamespaceResolver getNSResolver(Activity activity) {
        GraphPane m_graphPane = this.m_view.getGraphPane();
        BPELGraphModel m_graphModel = (BPELGraphModel)m_graphPane.getModel();
        Process m_processModel = m_graphModel.getProcess();
        return NSResolverFactory.getNSResolver((Activity)activity, (Process)m_processModel);
    }
}

