/*
 * Decompiled with CFR 0.152.
 */
package oracle.tip.tools.ide.pm.bpelgraph.actions;

import java.awt.Component;
import java.awt.event.ActionEvent;
import oracle.tip.tools.ide.common.bpelparser.iface.CatchAll;
import oracle.tip.tools.ide.common.bpelparser.iface.FaultHandlers;
import oracle.tip.tools.ide.common.bpelparser.iface.Process;
import oracle.tip.tools.ide.common.bpelparser.iface.Scope;
import oracle.tip.tools.ide.common.graph.GraphUtils;
import oracle.tip.tools.ide.common.graph.actions.GraphAction;
import oracle.tip.tools.ide.common.graph.view.View;
import oracle.tip.tools.ide.pm.bpelgraph.model.ProcessNode;
import oracle.tip.tools.ide.pm.bpelgraph.model.ScopeNode;
import oracle.tip.tools.ide.pm.bpelgraph.views.BPELGraphPane;
import oracle.tip.tools.ide.pm.bpelgraph.views.ProcessView;
import oracle.tip.tools.ide.pm.bpelgraph.views.ScopeView;
import oracle.tip.tools.ide.pm.i18n.BPELStringTranslator;
import oracle.tip.tools.ide.pm.resources.images.ImageCache;

public class AddCatchAllAction
extends GraphAction {
    private View m_view;

    public AddCatchAllAction(View v) {
        super(BPELStringTranslator.getString("ACTIONS_ADD_CATCHALL_BRANCH", "Add Catch All Branch"));
        this.m_view = v;
        this.setIcon(ImageCache.getIcon("graph/bpel/add_catchall_16x16.png"));
        this.putValue("TRANSPARENT_ICON", ImageCache.getIcon("graph/bpel/add_catchall_16x16_fadeout.png"));
    }

    public void actionPerformed(ActionEvent e) {
        if (this.m_view instanceof ScopeView) {
            CatchAll ca;
            ScopeView v = (ScopeView)this.m_view;
            ScopeNode n = (ScopeNode)v.getNode();
            Scope s = (Scope)n.getUserObject();
            FaultHandlers f = s.getFaultHandlers();
            if (f != null && (ca = f.getCatchAll()) != null) {
                String msg = BPELStringTranslator.getString("ACTIONS_CATCHALL_ALREADY_EXISTS", "Catch All branch already exists!");
                GraphUtils.displayMessage((Component)GraphUtils.getFrame((Component)this.m_view.getGraphPane()), (String)msg, (int)2);
                return;
            }
            v.addCatchAll();
        } else if (this.m_view instanceof ProcessView) {
            CatchAll ca;
            ProcessView v = (ProcessView)this.m_view;
            ProcessNode n = (ProcessNode)v.getNode();
            Process p = (Process)n.getUserObject();
            FaultHandlers f = p.getFaultHandlers();
            if (f != null && (ca = f.getCatchAll()) != null) {
                String msg = BPELStringTranslator.getString("ACTIONS_CATCHALL_ALREADY_EXISTS", "Catch All branch already exists!");
                GraphUtils.displayMessage((Component)GraphUtils.getFrame((Component)this.m_view.getGraphPane()), (String)msg, (int)2);
                return;
            }
            v.addCatchAll();
        }
    }

    public void updateState() {
        BPELGraphPane graph = (BPELGraphPane)this.m_view.getGraphPane();
        this.setVisible(graph.allowActionEditing());
        this.setEnabled(this.m_view.isEditable());
    }
}

