/*
 * Decompiled with CFR 0.152.
 */
package oracle.tip.tools.ide.pm.addin.view;

import java.util.StringTokenizer;
import oracle.bali.xml.dom.position.DomPosition;
import oracle.bali.xml.dom.position.DomPositionFactory;
import oracle.bali.xml.dom.position.DomRange;
import oracle.bali.xml.model.XmlModel;
import oracle.bali.xml.model.XmlView;
import oracle.tip.tools.ide.pm.addin.view.BPELDesignerGUI;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class SourceEditor {
    protected BPELDesignerGUI m_designerGUI;

    public SourceEditor(BPELDesignerGUI gui) {
        this.m_designerGUI = gui;
    }

    private XmlView getView() {
        return this.m_designerGUI.getView();
    }

    public void clearSelection() {
        try {
            XmlView view = this.getView();
            view.getBaseModel().startTransaction("Clear_Selection");
            view.getSelection().clear();
            view.getBaseModel().commitTransaction();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void selectNode(String xpath) {
        XmlView view = this.getView();
        if (view != null && view.getSelection() != null && view.getBaseModel() != null) {
            boolean bSuccess = false;
            try {
                view.getBaseModel().startTransaction("Change_Selection");
                Node n = this.getNodeFromXPath(view.getBaseModel().getDocument(), xpath);
                if (n != null) {
                    bSuccess = true;
                    DomPosition pos = DomPositionFactory.createDomPosition((Node)n, (int)1);
                    DomRange range = view.getSelection().createDomRange(pos, pos);
                    view.getSelection().setRangeSelection(range);
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
            finally {
                try {
                    if (bSuccess) {
                        view.getBaseModel().commitTransaction();
                    } else {
                        view.getBaseModel().rollbackTransaction();
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
    }

    protected Node getNodeFromXPath(Document doc, String xpath) throws Exception {
        if (doc == null || xpath == null || xpath.length() == 0) {
            return null;
        }
        NodeList nl = null;
        String t = null;
        Node n = doc;
        Node retNode = null;
        StringTokenizer stz = new StringTokenizer(xpath, "/");
        boolean bCont = true;
        while (stz.hasMoreTokens() && bCont) {
            int index;
            retNode = null;
            t = stz.nextToken();
            int s1 = t.indexOf("[");
            if (s1 != -1) {
                int s2 = t.indexOf("]");
                if (s2 == -1) {
                    throw new Exception("Not a well-form xpath...");
                }
                index = Integer.parseInt(t.substring(s1 + 1, s2));
                t = t.substring(0, s1);
                if (index > 0) {
                    --index;
                }
            } else {
                index = 0;
            }
            if ((s1 = t.indexOf(":")) != -1) {
                t = t.substring(s1 + 1, t.length());
            }
            nl = n.getChildNodes();
            for (int i = 0; i < nl.getLength() && retNode == null; ++i) {
                Node d = nl.item(i);
                if (d.getLocalName() == null || !t.equals(d.getLocalName())) continue;
                if (index == 0) {
                    retNode = d;
                    n = d;
                    continue;
                }
                --index;
            }
            if (retNode != null) continue;
            bCont = false;
        }
        return retNode;
    }

    protected String generateXPathFromElement(Node e) {
        StringBuffer strBuf = new StringBuffer();
        Node sibling = null;
        int index = 0;
        String name = null;
        String s = null;
        String ns = null;
        do {
            if ((name = e.getLocalName()) == null) continue;
            index = 1;
            sibling = e;
            do {
                if ((sibling = sibling.getPreviousSibling()) == null || sibling.getLocalName() == null || !name.equals(sibling.getLocalName())) continue;
                ++index;
            } while (sibling != null);
            ns = e.getNamespaceURI();
            if (ns != null && !"http://schemas.xmlsoap.org/ws/2003/03/business-process/".equals(ns) && e.getPrefix() != null) {
                name = e.getPrefix() + ":" + name;
            }
            s = index > 1 ? "/" + name + "[" + index + "]" : "/" + name;
            strBuf.insert(0, s);
        } while ((e = e.getParentNode()) != null);
        return strBuf.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String getSelectedPath() {
        String selectionXPath = null;
        XmlView view = this.getView();
        if (view != null && view.getSelection() != null && view.getBaseModel() != null) {
            XmlModel xmlModel = view.getBaseModel();
            try {
                xmlModel.acquireReadLock();
                Node node = view.getSelection().getLatestSelectedNode();
                Element e = null;
                do {
                    if (node != null && node.getNodeType() == 1) {
                        e = (Element)node;
                        continue;
                    }
                    if (node == null) continue;
                    node = node.getParentNode();
                } while (e == null && node != null);
                if (e != null) {
                    selectionXPath = this.generateXPathFromElement(e);
                }
            }
            catch (Exception ex) {
            }
            finally {
                try {
                    xmlModel.releaseReadLock();
                }
                catch (Exception e) {}
            }
        }
        return selectionXPath;
    }
}

