/*
 * Decompiled with CFR 0.152.
 */
package oracle.tip.tools.ide.pm.addin.view;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.Stroke;
import javax.swing.Action;
import javax.swing.JToggleButton;
import javax.swing.UIManager;
import oracle.tip.tools.ide.common.graph.GraphUtils;
import oracle.tip.tools.ide.pm.resources.images.ImageCache;

public class RoundToggleButton
extends JToggleButton {
    protected Shape m_shape;
    protected Color m_background = Color.white;
    protected int m_arc = 11;
    protected Image m_tileImg = ImageCache.getImage("application/bpel/tile_background.png");
    protected Image m_selectedTileImg = ImageCache.getImage("application/bpel/tile_background_highlighted.png");

    public RoundToggleButton(Action a) {
        super(a);
        this.setBackground(this.m_background);
        Font f = UIManager.getFont("Button.font").deriveFont(10.0f);
        this.setFont(f);
        this.setContentAreaFilled(false);
        this.setMargin(new Insets(0, 2, 0, 2));
    }

    @Override
    protected void paintComponent(Graphics g) {
        if (!this.isEnabled()) {
            g.setColor(Color.lightGray);
            g.fillRoundRect(0, 0, this.getSize().width - 1, this.getSize().height - 1, this.m_arc, this.m_arc);
        } else if (this.getModel().isPressed() || this.getModel().isSelected()) {
            GradientPaint gradient1 = new GradientPaint(0.0f, 0.0f, Color.lightGray, 0.0f, this.getHeight(), Color.white, true);
            Graphics2D g2D = (Graphics2D)g;
            g2D.setPaint(gradient1);
            g.fillRoundRect(0, 0, this.getSize().width - 1, this.getSize().height - 1, this.m_arc, this.m_arc);
        } else {
            GradientPaint gradient1 = new GradientPaint(0.0f, 0.0f, Color.white, 0.0f, this.getHeight(), Color.lightGray, true);
            Graphics2D g2D = (Graphics2D)g;
            g2D.setPaint(gradient1);
            g.fillRoundRect(0, 0, this.getSize().width - 1, this.getSize().height - 1, this.m_arc, this.m_arc);
        }
        super.paintComponent(g);
    }

    @Override
    protected void paintBorder(Graphics g) {
        Graphics2D g2 = (Graphics2D)g;
        Stroke oldStroke = g2.getStroke();
        RenderingHints oldHints = g2.getRenderingHints();
        g2.setRenderingHints(GraphUtils.SMOOTH_LINE_HINTS);
        g2.setStroke(new BasicStroke(1.0f, 1, 0));
        Color c = Color.gray;
        g.setColor(c);
        g.drawRoundRect(0, 0, this.getSize().width - 1, this.getSize().height - 1, this.m_arc, this.m_arc);
        g2.setStroke(oldStroke);
        g2.setRenderingHints(oldHints);
    }

    @Override
    public boolean contains(int x, int y) {
        if (this.m_shape == null || !this.m_shape.getBounds().equals(this.getBounds())) {
            this.m_shape = new Rectangle(0, 0, this.getWidth(), this.getHeight());
        }
        return this.m_shape.contains(x, y);
    }
}

