/*
 * Decompiled with CFR 0.152.
 */
package oracle.tip.tools.ide.pm.addin.view;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JToggleButton;
import javax.swing.JToolBar;
import javax.swing.SwingUtilities;
import oracle.tip.tools.ide.common.bpeldesigner.util.Helper;
import oracle.tip.tools.ide.common.bpelparser.iface.Process;
import oracle.tip.tools.ide.common.graph.GraphUtils;
import oracle.tip.tools.ide.common.ui.CardPanel;
import oracle.tip.tools.ide.common.ui.GradientPanel;
import oracle.tip.tools.ide.pm.addin.logging.BPELLogPage;
import oracle.tip.tools.ide.pm.addin.logging.BPELModelerLogger;
import oracle.tip.tools.ide.pm.addin.model.BPELXmlModel;
import oracle.tip.tools.ide.pm.addin.thumbnail.ThumbnailCardPanel;
import oracle.tip.tools.ide.pm.addin.view.BPELDesignerGUI;
import oracle.tip.tools.ide.pm.addin.view.LookAndFeel;
import oracle.tip.tools.ide.pm.addin.view.PerspectiveAction;
import oracle.tip.tools.ide.pm.addin.view.RoundToggleButton;
import oracle.tip.tools.ide.pm.bpelgraph.views.BPELGraphPane;
import oracle.tip.tools.ide.pm.designerplugins.standard.plugin.perspective.StandardBPELEditor;
import oracle.tip.tools.ide.pm.i18n.BPELStringTranslator;
import oracle.tip.tools.ide.pm.modules.help.HelpSystem;
import oracle.tip.tools.ide.pm.plugin.BPELModelerPlugin;
import oracle.tip.tools.ide.pm.plugin.BPELPlugInManager;
import oracle.tip.tools.ide.pm.plugin.Perspective;
import oracle.tip.tools.ide.pm.resources.images.ImageCache;

public class PerspectivesPanel
extends JPanel
implements ActionListener {
    protected GradientPanel m_headerPnl;
    protected JPanel m_editorToolBarPnl;
    protected JButton m_helpBtn;
    protected CardPanel m_cardPnl;
    protected BPELDesignerGUI m_gui;
    protected JPanel m_searchPnl;
    protected List<JToggleButton> m_perspectiveButtons = new ArrayList<JToggleButton>();
    protected JPanel m_toggleBtnPnl;
    protected HashMap<String, Perspective> m_perspectiveHash = new HashMap();
    protected URL m_url;
    private boolean m_bInitialized = false;

    public PerspectivesPanel(BPELDesignerGUI gui, URL graphURL) {
        this.setBackground(Color.white);
        this.m_url = graphURL;
        this.m_gui = gui;
        this.createControls();
        this.layoutControls();
    }

    public void markDirty() {
        this.m_gui.markChange(true);
    }

    public List<Perspective> getPerspectives() {
        ArrayList<Perspective> perspectives = new ArrayList<Perspective>();
        for (Perspective p : this.m_perspectiveHash.values()) {
            perspectives.add(p);
        }
        return perspectives;
    }

    public void paintActivated() {
        this.m_headerPnl.setColors(LookAndFeel.getActivatedColor1(), LookAndFeel.getActivatedColor2());
        this.getSelectedPerspective().setActivatedColors(true);
    }

    public void paintDeactivated() {
        this.m_headerPnl.setColors(LookAndFeel.getDeactivatedColor(), LookAndFeel.getDeactivatedColor());
        this.getSelectedPerspective().setActivatedColors(false);
    }

    public void activated() {
        this.getSelectedPerspective().activated();
    }

    public void deactivated() {
        this.getSelectedPerspective().deactivated();
    }

    public Perspective getPerspective(String id) {
        return this.m_perspectiveHash.get(id);
    }

    public Perspective getSelectedPerspective() {
        String perspectiveID = this.m_cardPnl.getVisiblePanelID();
        return this.m_perspectiveHash.get(perspectiveID);
    }

    public void printDocument() {
        this.getSelectedPerspective().print();
    }

    public void showPerspective(String perspectiveID) {
        JToolBar tb;
        Perspective currentPerspective = this.getSelectedPerspective();
        String selection = null;
        if (currentPerspective != null) {
            if (currentPerspective.getID().equals(perspectiveID)) {
                return;
            }
            selection = currentPerspective.getSelectionXPath();
        }
        this.m_editorToolBarPnl.removeAll();
        this.m_searchPnl.removeAll();
        Perspective p = this.m_perspectiveHash.get(perspectiveID);
        JComponent searchComp = p.getPerspectiveEditor().getSearchComponent();
        if (searchComp != null) {
            GraphUtils.addComponent((Container)this.m_searchPnl, (Component)searchComp, (int)0, (int)0, (int)1, (int)1, (int)17, (int)0, (Insets)new Insets(0, 0, 0, 0), (int)0, (int)0, (double)0.0, (double)0.0);
        }
        if ((tb = p.getPerspectiveEditor().getEditorToolBar()) != null) {
            tb.setBorderPainted(false);
            tb.setOpaque(false);
            GraphUtils.addComponent((Container)this.m_editorToolBarPnl, (Component)tb, (int)0, (int)0, (int)1, (int)1, (int)17, (int)0, (Insets)new Insets(0, 2, 0, 2), (int)0, (int)0, (double)1.0, (double)0.0);
        }
        this.m_cardPnl.show(perspectiveID);
        p.perspectiveSelected(selection);
        if (currentPerspective != null) {
            currentPerspective.perspectiveDeselected();
        }
        this.m_gui.getJDevBPELEditor().getStructurePane().showStructureForPerspective(p);
        BPELModelerLogger.showLogWindow("BPEL_LOGWINDOW");
        BPELLogPage.getInstance().showLogWindow(p);
        if (Helper.isEqual((String)perspectiveID, (String)"BPEL")) {
            ThumbnailCardPanel.getInstance().showBPELThumbNail();
        } else {
            ThumbnailCardPanel.getInstance().showNoThumbNail();
        }
        for (JToggleButton btn : this.m_perspectiveButtons) {
            PerspectiveAction action = (PerspectiveAction)btn.getAction();
            Perspective perspective = action.getPerspective();
            if (perspectiveID != perspective.getID()) continue;
            if (btn.isSelected()) break;
            btn.setSelected(true);
            break;
        }
    }

    public URL getGraphURL() {
        return this.m_url;
    }

    public void loadPerspectiveEditor(final String selectionXPath) {
        Runnable r = new Runnable(){

            @Override
            public void run() {
                for (String key : PerspectivesPanel.this.m_perspectiveHash.keySet()) {
                    Perspective p = PerspectivesPanel.this.m_perspectiveHash.get(key);
                    p.loadModel(PerspectivesPanel.this.m_gui.getXMLModel());
                }
                String perspectiveID = PerspectivesPanel.this.m_cardPnl.getVisiblePanelID();
                if (PerspectivesPanel.this.m_gui.m_bInitialActivation) {
                    PerspectivesPanel.this.m_gui.m_bInitialActivation = false;
                    Perspective defaultPerspective = null;
                    for (String key : PerspectivesPanel.this.m_perspectiveHash.keySet()) {
                        Perspective p = PerspectivesPanel.this.m_perspectiveHash.get(key);
                        if (!p.isDefaultPerspectiveForModel()) continue;
                        defaultPerspective = p;
                        break;
                    }
                    if (defaultPerspective != null) {
                        perspectiveID = defaultPerspective.getID();
                    }
                }
                PerspectivesPanel.this.displayUI(perspectiveID, selectionXPath);
            }
        };
        new Thread(r).start();
    }

    private void displayUI(final String perspectiveID, final String selectionXPath) {
        Runnable r = new Runnable(){

            @Override
            public void run() {
                Perspective p;
                if (PerspectivesPanel.this.getSelectedPerspective().getID() != perspectiveID) {
                    PerspectivesPanel.this.showPerspective(perspectiveID);
                }
                if ((p = PerspectivesPanel.this.m_perspectiveHash.get(perspectiveID)) != null) {
                    p.getPerspectiveEditor().load(selectionXPath);
                }
                PerspectivesPanel.this.updatePerspectiveButtons();
            }
        };
        SwingUtilities.invokeLater(r);
    }

    protected void updatePerspectiveButtons() {
        for (JToggleButton btn : this.m_perspectiveButtons) {
            PerspectiveAction action = (PerspectiveAction)btn.getAction();
            Perspective p = action.getPerspective();
            BPELXmlModel model = this.m_gui.getXMLModel();
            Process process = model.getProcess();
            btn.setEnabled(p.canDisplay(process));
        }
    }

    public BPELGraphPane getBPELGraphPane() {
        Perspective p = this.m_perspectiveHash.get("BPEL");
        StandardBPELEditor comp = (StandardBPELEditor)p.getPerspectiveEditor().getEditorComponent();
        return comp.getBPELGraphPane();
    }

    public synchronized void initialize() {
        if (this.m_bInitialized) {
            return;
        }
        ArrayList<PerspectiveAction> actions = new ArrayList<PerspectiveAction>();
        for (BPELModelerPlugin plugin : BPELPlugInManager.getPlugins()) {
            for (Perspective p : plugin.getPerspectives()) {
                String name = p.getID();
                actions.add(new PerspectiveAction(p, this));
                this.m_perspectiveHash.put(name, p);
                JComponent comp = p.getPerspectiveEditor().createEditorComponent(this.m_gui, this.m_url);
                this.m_cardPnl.add(name, (Component)comp);
            }
        }
        this.m_toggleBtnPnl.removeAll();
        GridLayout layout = new GridLayout();
        layout.setHgap(3);
        this.m_toggleBtnPnl.setLayout(layout);
        this.m_perspectiveButtons.clear();
        ButtonGroup g = new ButtonGroup();
        for (PerspectiveAction action : actions) {
            RoundToggleButton btn = new RoundToggleButton(action);
            Perspective p = action.getPerspective();
            String s = BPELStringTranslator.formatString("CHANGE_TO_PERSPECTIVE", p.getDisplayName());
            btn.setToolTipText(s);
            this.m_perspectiveButtons.add(btn);
            this.m_toggleBtnPnl.add(btn);
            g.add(btn);
        }
        this.m_bInitialized = true;
        this.showPerspective("BPEL");
    }

    protected void createControls() {
        this.m_toggleBtnPnl = new JPanel(new GridLayout());
        this.m_toggleBtnPnl.setOpaque(false);
        this.m_searchPnl = new JPanel(new GridBagLayout());
        this.m_searchPnl.setOpaque(false);
        this.m_editorToolBarPnl = new JPanel();
        this.m_editorToolBarPnl.setOpaque(false);
        this.m_editorToolBarPnl.setLayout(new GridBagLayout());
        this.m_cardPnl = new CardPanel();
        this.m_helpBtn = new JButton(ImageCache.getIcon("application/bpel/helptopics.png"));
        this.m_helpBtn.addActionListener(this);
        this.m_helpBtn.setToolTipText(BPELStringTranslator.getString("EDITOR_HELP_TOPICS"));
    }

    protected void layoutControls() {
        JToolBar rightToolBar = new JToolBar();
        rightToolBar.setOpaque(false);
        rightToolBar.setMargin(new Insets(0, 0, 0, 0));
        rightToolBar.setBorderPainted(false);
        rightToolBar.add(this.m_helpBtn);
        this.m_headerPnl = new GradientPanel(LookAndFeel.getActivatedColor1(), LookAndFeel.getActivatedColor2());
        this.m_headerPnl.setLayout((LayoutManager)new GridBagLayout());
        GraphUtils.addComponent((Container)this.m_headerPnl, (Component)this.m_editorToolBarPnl, (int)0, (int)0, (int)1, (int)1, (int)17, (int)0, (Insets)new Insets(2, 2, 2, 2), (int)0, (int)0, (double)1.0, (double)0.0);
        GraphUtils.addComponent((Container)this.m_headerPnl, (Component)this.m_searchPnl, (int)1, (int)0, (int)1, (int)1, (int)13, (int)0, (Insets)new Insets(2, 2, 2, 2), (int)0, (int)0, (double)1.0, (double)0.0);
        GraphUtils.addComponent((Container)this.m_headerPnl, (Component)this.m_toggleBtnPnl, (int)2, (int)0, (int)1, (int)1, (int)13, (int)0, (Insets)new Insets(2, 2, 2, 2), (int)0, (int)0, (double)0.0, (double)0.0);
        GraphUtils.addComponent((Container)this.m_headerPnl, (Component)rightToolBar, (int)3, (int)0, (int)1, (int)1, (int)13, (int)0, (Insets)new Insets(2, 2, 2, 2), (int)0, (int)0, (double)0.0, (double)0.0);
        this.setLayout(new GridBagLayout());
        GraphUtils.addComponent((Container)this, (Component)this.m_headerPnl, (int)0, (int)0, (int)1, (int)1, (int)17, (int)2, (Insets)new Insets(0, 0, 0, 0), (int)0, (int)0, (double)1.0, (double)0.0);
        GraphUtils.addComponent((Container)this, (Component)this.m_cardPnl, (int)0, (int)1, (int)1, (int)1, (int)17, (int)1, (Insets)new Insets(0, 0, 0, 0), (int)0, (int)0, (double)1.0, (double)1.0);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Object src = e.getSource();
        if (src == this.m_helpBtn) {
            HelpSystem.gotoOracleHelpSystem("bpmjdev_default_page");
        }
    }
}

