/*
 * Decompiled with CFR 0.152.
 */
package oracle.tip.tools.ide.pm.addin.view;

import java.awt.Component;
import java.net.URL;
import oracle.ide.editor.Editor;
import oracle.ide.editor.EditorManager;
import oracle.ide.model.Element;
import oracle.ide.model.Project;
import oracle.ide.model.SupportsInspection;
import oracle.ide.net.URLFileSystem;
import oracle.tip.tools.ide.common.graph.GraphUtils;
import oracle.tip.tools.ide.common.graph.event.GraphSelectionEvent;
import oracle.tip.tools.ide.common.graph.event.GraphSelectionListener;
import oracle.tip.tools.ide.common.graph.model.ModelElement;
import oracle.tip.tools.ide.common.graph.model.Node;
import oracle.tip.tools.ide.common.ide.bpel.BPELProject;
import oracle.tip.tools.ide.pm.addin.model.BPELBeanPropertyElement;
import oracle.tip.tools.ide.pm.addin.modelbean.BeanUtil;
import oracle.tip.tools.ide.pm.addin.view.BPELXmlVisualEditor;
import oracle.tip.tools.ide.pm.addin.view.JDevBPELEditor;
import oracle.tip.tools.ide.pm.bpelgraph.views.BPELGraphPane;
import oracle.tip.tools.ide.pm.i18n.BPELStringTranslator;

public class JDevPropertiesPanelUpdater
implements GraphSelectionListener {
    protected BPELGraphPane m_graph;

    public JDevPropertiesPanelUpdater(BPELGraphPane graph) {
        this.m_graph = graph;
        this.m_graph.addGraphSelectionListener(this);
    }

    public void graphSelectionOccurred(GraphSelectionEvent evt) {
        switch (evt.getType()) {
            case 0: {
                this.fireSelectionEvent(evt);
            }
        }
    }

    protected Editor getEditor(URL u) {
        EditorManager mgr = EditorManager.getEditorManager();
        for (Object editor : mgr.getAllEditors()) {
            JDevBPELEditor bpelEditor;
            URL graphURL;
            BPELXmlVisualEditor pe;
            Component c;
            if (!(editor instanceof BPELXmlVisualEditor) || !((c = (pe = (BPELXmlVisualEditor)((Object)editor)).getGUI()) instanceof JDevBPELEditor) || !URLFileSystem.equals((URL)u, (URL)(graphURL = (bpelEditor = (JDevBPELEditor)c).getGraphURL()))) continue;
            return pe;
        }
        return null;
    }

    protected void fireSelectionEvent(GraphSelectionEvent evt) {
        Editor editor;
        ModelElement me = evt.getGraphElement().getModelElement();
        if (!(me instanceof Node)) {
            return;
        }
        BPELProject p = this.m_graph.getBPELProject();
        URL u = p.getBPELFileURL();
        if (((Project)p.getProjectContext()).getURL() == null && p.getProjectData("bpelFileURL") != null) {
            u = (URL)p.getProjectData("bpelFileURL");
        }
        if ((editor = this.getEditor(u)) == null) {
            GraphUtils.displayMessage((Component)((Object)this.m_graph), (String)BPELStringTranslator.getString("EDITOR_NOT_OPEM_WARNING"), (int)0);
            return;
        }
        if (!(editor instanceof BPELXmlVisualEditor)) {
            return;
        }
        EditorManager mgr = EditorManager.getEditorManager();
        if (mgr.getCurrentEditor() != editor) {
            mgr.openDefaultEditorInFrame(u);
        }
        BPELXmlVisualEditor view = (BPELXmlVisualEditor)editor;
        Element[] viewSelection = new Element[]{null};
        Node node = (Node)me;
        Object obj = node.getUserObject();
        Object newObj = BeanUtil.convertObjToBean(obj);
        viewSelection[0] = newObj instanceof SupportsInspection ? new BPELBeanPropertyElement(newObj) : new BPELBeanPropertyElement(null);
        try {
            view.setSelection(viewSelection);
            view.updateSelection();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

