/*
 * Decompiled with CFR 0.152.
 */
package oracle.tip.tools.ide.pm.addin.view;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.Stack;
import javax.swing.DefaultListModel;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import oracle.tip.tools.ide.common.graph.GraphUtils;
import oracle.tip.tools.ide.common.graph.view.NodeRenderer;
import oracle.tip.tools.ide.common.ui.ToolBar;
import oracle.tip.tools.ide.common.ui.UIHelper;
import oracle.tip.tools.ide.pm.addin.view.DrillDownStackCellRenderer;
import oracle.tip.tools.ide.pm.addin.view.DrillStackItem;
import oracle.tip.tools.ide.pm.bpelgraph.views.BPELGraphPane;
import oracle.tip.tools.ide.pm.i18n.BPELStringTranslator;
import oracle.tip.tools.ide.pm.resources.images.ImageCache;

public class DrillDownPanel
extends JPanel
implements PopupMenuListener,
MouseListener,
ActionListener {
    protected JList m_viewList;
    protected JLabel m_label;
    protected BPELGraphPane m_graph;
    protected JButton m_clearStackBtn;

    public DrillDownPanel(BPELGraphPane graph, JPopupMenu popup) {
        this.m_graph = graph;
        popup.addPopupMenuListener(this);
        this.setBackground(Color.white);
        this.createControls();
        this.layoutControls();
    }

    @Override
    public Dimension getPreferredSize() {
        Dimension prefDim = this.m_viewList.getPreferredScrollableViewportSize();
        Dimension lblDim = this.m_label.getPreferredSize();
        int padding = 2;
        int h = padding + lblDim.height + padding + prefDim.height + padding;
        if (h > 300) {
            h = 300;
        }
        return new Dimension(300, h);
    }

    protected void load() {
        Runnable r = new Runnable(){

            @Override
            public void run() {
                DefaultListModel<DrillStackItem> m = new DefaultListModel<DrillStackItem>();
                if (DrillDownPanel.this.m_graph.inDrillDownMode()) {
                    Stack stack = DrillDownPanel.this.m_graph.getDrillDownStack();
                    for (int i = stack.size() - 1; i >= 0; --i) {
                        DrillStackItem item = new DrillStackItem((NodeRenderer)stack.elementAt(i));
                        m.addElement(item);
                    }
                }
                DrillDownPanel.this.m_viewList.setModel(m);
                DrillDownPanel.this.m_clearStackBtn.setEnabled(m.size() > 0);
            }
        };
        SwingUtilities.invokeLater(r);
    }

    protected void createControls() {
        this.m_clearStackBtn = UIHelper.createToolBarButton((Icon)ImageCache.getIcon("garbage_empty16"), (String)BPELStringTranslator.getString("CLEAR_STACK"), (String)"S");
        this.m_clearStackBtn.addActionListener(this);
        this.m_viewList = new JList();
        this.m_viewList.setSelectionMode(0);
        this.m_viewList.addMouseListener(this);
        this.m_viewList.setCellRenderer(new DrillDownStackCellRenderer());
    }

    protected void layoutControls() {
        ToolBar tb = new ToolBar();
        tb.add((Component)this.m_clearStackBtn);
        this.m_label = new JLabel();
        BPELStringTranslator.setLabel(this.m_label, this.m_viewList, BPELStringTranslator.getString("DRILL_DOWN_LABEL"));
        this.setLayout(new GridBagLayout());
        int row = 0;
        this.setLayout(new GridBagLayout());
        GraphUtils.addComponent((Container)this, (Component)this.m_label, (int)0, (int)row, (int)1, (int)1, (int)16, (int)2, (Insets)new Insets(2, 2, 0, 2), (int)0, (int)0, (double)1.0, (double)0.0);
        GraphUtils.addComponent((Container)this, (Component)tb, (int)1, (int)row++, (int)1, (int)1, (int)13, (int)2, (Insets)new Insets(2, 2, 0, 2), (int)0, (int)0, (double)0.0, (double)0.0);
        GraphUtils.addComponent((Container)this, (Component)new JScrollPane(this.m_viewList), (int)0, (int)row++, (int)2, (int)1, (int)17, (int)1, (Insets)new Insets(2, 2, 2, 2), (int)0, (int)0, (double)1.0, (double)1.0);
    }

    protected void handleDrillViewSelection() {
        DrillStackItem item = (DrillStackItem)this.m_viewList.getSelectedValue();
        if (item != null) {
            NodeRenderer r = item.getNodeRenderer();
            this.m_graph.popToDrillDownRenderer(r);
            this.m_graph.repaint();
            this.load();
        }
    }

    @Override
    public void popupMenuCanceled(PopupMenuEvent e) {
    }

    @Override
    public void popupMenuWillBecomeInvisible(PopupMenuEvent e) {
    }

    @Override
    public void popupMenuWillBecomeVisible(PopupMenuEvent e) {
        this.load();
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        if (e.getSource() == this.m_viewList && e.getClickCount() > 1) {
            this.handleDrillViewSelection();
        }
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    @Override
    public void mousePressed(MouseEvent e) {
    }

    @Override
    public void mouseReleased(MouseEvent e) {
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Object src = e.getSource();
        if (src == this.m_clearStackBtn) {
            this.m_graph.clearDrillDownStack();
            this.m_graph.repaint();
            this.load();
        }
    }
}

