/*
 * Decompiled with CFR 0.152.
 */
package oracle.tip.tools.ide.pm.addin.view;

import java.awt.Component;
import java.net.URL;
import java.util.EventObject;
import java.util.HashMap;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.TreePath;
import oracle.bali.xml.gui.jdev.JDevInspectableViewTracker;
import oracle.bali.xml.gui.jdev.StandardXmlVisualEditor;
import oracle.ide.Context;
import oracle.ide.editor.Editor;
import oracle.ide.editor.EditorManager;
import oracle.ide.explorer.Explorer;
import oracle.ide.model.Element;
import oracle.ide.model.Node;
import oracle.ide.model.SupportsInspection;
import oracle.ide.view.View;
import oracle.tip.tools.ide.common.bpelparser.iface.Activity;
import oracle.tip.tools.ide.common.bpelparser.iface.PartnerLink;
import oracle.tip.tools.ide.pm.addin.model.BPELBeanPropertyElement;
import oracle.tip.tools.ide.pm.addin.model.BPELNode;
import oracle.tip.tools.ide.pm.addin.modelbean.BeanUtil;
import oracle.tip.tools.ide.pm.addin.structurepane.StructurePanePanel;
import oracle.tip.tools.ide.pm.addin.view.BPELExplorerMapData;
import oracle.tip.tools.ide.pm.addin.view.JDevBPELEditor;
import oracle.tip.tools.ide.pm.bpelgraph.views.BPELGraphPane;
import oracle.tip.tools.ide.pm.gui.explorer.ActivityInfo;
import oracle.tip.tools.ide.pm.plugin.Perspective;

public class BPELExplorer
extends Explorer {
    private Context m_context = null;
    private Element[] m_selElem;
    private BPELNode m_node = null;
    private HashMap<URL, BPELExplorerMapData> m_urlToDataMap = new HashMap();
    private static BPELExplorer m_instance;

    public static BPELExplorer getInstance() {
        return m_instance;
    }

    public BPELExplorer() {
        m_instance = this;
        this.m_selElem = new Element[]{new BPELBeanPropertyElement()};
    }

    public void remove(URL graphURL) {
        BPELExplorerMapData data = this.m_urlToDataMap.get(graphURL);
        if (data != null) {
            TreeMonitor tm = data.m_monitor;
            if (tm != null) {
                data.m_structurePanePnl.getProcessExplorer().getExplorerTree().getTree().removeTreeSelectionListener((TreeSelectionListener)tm);
            }
            this.m_urlToDataMap.remove(graphURL);
        }
    }

    public synchronized Component getGUI() {
        JComponent structComp;
        Perspective p;
        if (this.m_context == null) {
            return null;
        }
        Editor t = EditorManager.getEditorManager().getCurrentEditor();
        if (!(t instanceof StandardXmlVisualEditor)) {
            return null;
        }
        Component c = t.getGUI();
        if (!(c instanceof JDevBPELEditor)) {
            return null;
        }
        JDevBPELEditor editor = (JDevBPELEditor)c;
        URL url = editor.getGraphURL();
        if (!this.m_urlToDataMap.containsKey(url) && (p = editor.getPerspectivesPanel().getSelectedPerspective()) != null && p.getID().equals("BPEL") && (structComp = p.getStructure()) instanceof StructurePanePanel) {
            StructurePanePanel sp = (StructurePanePanel)structComp;
            TreeMonitor tm = new TreeMonitor(sp);
            BPELExplorerMapData data = new BPELExplorerMapData();
            data.m_editor = editor;
            data.m_monitor = tm;
            data.m_structurePanePnl = sp;
            sp.getProcessExplorer().getExplorerTree().getTree().addTreeSelectionListener((TreeSelectionListener)tm);
            this.m_urlToDataMap.put(url, data);
        }
        return editor.getStructurePane();
    }

    public Context getContext(EventObject event) {
        Context ctx;
        if (this.m_node != null) {
            ctx = Context.newIdeContext((Node)this.m_node);
        } else {
            ctx = Context.newIdeContext();
            ctx.setEvent(event);
        }
        this.m_context = ctx;
        return ctx;
    }

    public void setContext(Context context) {
        super.setContext(context);
        this.m_context = context;
        Node node = context.getNode();
        if (node instanceof BPELNode) {
            this.m_node = (BPELNode)node;
        }
    }

    public Element[] getSelectionFromUI() {
        if (this.m_context != null) {
            Object newObj;
            StructurePanePanel structurePanel;
            Object obj;
            Editor t = EditorManager.getEditorManager().getCurrentEditor();
            if (!(t instanceof StandardXmlVisualEditor)) {
                return super.getSelection();
            }
            Component c = t.getGUI();
            if (!(c instanceof JDevBPELEditor)) {
                return super.getSelection();
            }
            JDevBPELEditor editor = (JDevBPELEditor)c;
            Perspective p = editor.getPerspectivesPanel().getSelectedPerspective();
            if (p != null && p.getID().equals("BPEL") && (obj = (structurePanel = (StructurePanePanel)p.getStructure()).getSelectedNodeData()) != null && obj instanceof ActivityInfo && (newObj = BeanUtil.convertObjToBean(((ActivityInfo)obj).getActivity())) instanceof SupportsInspection) {
                ((BPELBeanPropertyElement)this.m_selElem[0]).setData(newObj);
                return this.m_selElem;
            }
        }
        return super.getSelection();
    }

    private boolean handleActivitySelection(StructurePanePanel structurePanel) {
        if (structurePanel == null) {
            return false;
        }
        int id = structurePanel.getProcessExplorer().getExplorerTree().getSelectedNodeType();
        if (id == 16) {
            ActivityInfo info = (ActivityInfo)structurePanel.getProcessExplorer().getExplorerTree().getSelectedNodeData();
            Activity a = info.getActivity();
            BPELGraphPane pane = (BPELGraphPane)structurePanel.getGraphPane();
            pane.selectActivity(a);
            return true;
        }
        if (id == 14) {
            PartnerLink link = (PartnerLink)structurePanel.getProcessExplorer().getExplorerTree().getSelectedNodeData();
            BPELGraphPane pane = (BPELGraphPane)structurePanel.getGraphPane();
            pane.selectPartnerLink(link);
        }
        return false;
    }

    private void fireSelectionChange() {
        if (JDevInspectableViewTracker.INSTANCE.getLastViewSupportingInspection((View)this) == this) {
            this.updateSelection();
        }
    }

    private void handleTreeSelection(TreeSelectionEvent evt, StructurePanePanel sp) {
        TreePath tp;
        if (this.handleActivitySelection(sp) && (tp = evt.getNewLeadSelectionPath()) != null) {
            this.fireSelectionChange();
        }
    }

    class TreeMonitor
    implements TreeSelectionListener {
        private StructurePanePanel m_structurePanePnl;

        TreeMonitor(StructurePanePanel structurePanePnl) {
            this.m_structurePanePnl = structurePanePnl;
        }

        @Override
        public void valueChanged(final TreeSelectionEvent evt) {
            if (SwingUtilities.isEventDispatchThread()) {
                BPELExplorer.this.handleTreeSelection(evt, this.m_structurePanePnl);
            } else {
                Runnable r = new Runnable(){

                    @Override
                    public void run() {
                        BPELExplorer.this.handleTreeSelection(evt, TreeMonitor.this.m_structurePanePnl);
                    }
                };
                SwingUtilities.invokeLater(r);
            }
        }
    }
}

