/*
 * Decompiled with CFR 0.152.
 */
package oracle.tip.tools.ide.pm.addin.view;

import java.awt.Component;
import java.net.URL;
import javax.swing.Action;
import oracle.bali.xml.gui.GuiXmlContext;
import oracle.bali.xml.gui.XmlGui;
import oracle.bali.xml.gui.jdev.JDevViewHostedGui;
import oracle.bali.xml.gui.swing.ComponentXmlGui;
import oracle.bali.xml.model.XmlUsage;
import oracle.bali.xml.model.XmlView;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.controller.IdeAction;
import oracle.ide.model.Node;
import oracle.ide.view.View;
import oracle.tip.tools.ide.common.bpelparser.iface.Process;
import oracle.tip.tools.ide.common.graph.GraphUtils;
import oracle.tip.tools.ide.common.ide.bpel.BPELProject;
import oracle.tip.tools.ide.pm.addin.logging.BPELLogPage;
import oracle.tip.tools.ide.pm.addin.model.BPELXmlModel;
import oracle.tip.tools.ide.pm.addin.model.ModelChangeNotifier;
import oracle.tip.tools.ide.pm.addin.view.GUIFactory;
import oracle.tip.tools.ide.pm.addin.view.JDevBPELEditor;
import oracle.tip.tools.ide.pm.addin.view.SourceEditor;
import oracle.tip.tools.ide.pm.addin.view.UndoRedoDisabler;
import oracle.tip.tools.ide.pm.plugin.Perspective;

public class BPELDesignerGUI
extends XmlGui
implements JDevViewHostedGui,
ComponentXmlGui,
ModelChangeNotifier {
    protected static final int NO_VIEW_ACTIVE = 0;
    protected static final int DIAGRAM_VIEW_ACTIVE = 1;
    protected static final int SOURCE_VIEW_ACTIVE = 2;
    protected View m_view;
    protected JDevBPELEditor m_editor;
    protected SourceEditor m_sourceEditor;
    protected URL m_bpelFileURL = this.getXMLModel().getDocumentURL();
    protected int m_viewMode = 0;
    protected UndoRedoDisabler m_undoStackClearer;
    protected boolean m_bInitialActivation;

    public BPELDesignerGUI(XmlView view) {
        super(view);
        this.getXMLModel().setGUI(this);
        this.m_sourceEditor = new SourceEditor(this);
        this.m_bInitialActivation = true;
    }

    public Node getNode() {
        Context ct = this.m_view.getContext();
        return ct.getNode();
    }

    public BPELXmlModel getXMLModel() {
        return (BPELXmlModel)this.getView().getBaseModel();
    }

    public void switchToSourceView() {
        GuiXmlContext context = this.getGuiContext();
        if (context != null) {
            XmlGui gui = context.getGui(XmlUsage.XML_CODE_EDITOR);
            if (gui == null) {
                gui = GUIFactory.getInstance().createGui(this.getView(), XmlUsage.XML_CODE_EDITOR);
            }
            if (gui.isGuiActivatable()) {
                this.deactivate();
                context.setActiveView(gui.getView());
                gui.activate();
            }
        }
    }

    public Action getGoToSourceAction() {
        XmlView view = this.getView();
        if (view == null) {
            return null;
        }
        return view.getAction("gotosource");
    }

    public UndoRedoDisabler getUndoRedoDisabler() {
        if (this.m_undoStackClearer == null) {
            this.m_undoStackClearer = new UndoRedoDisabler(this.getNode(), this.getXMLModel());
        }
        return this.m_undoStackClearer;
    }

    public void activate() {
        this.getUndoRedoDisabler().disableUndoRedo(true);
        this.verifyModelsInitialized();
        this.m_editor.loadEditor(this.getSourceEditorSelectionPath());
        this.m_editor.activated();
        this.m_sourceEditor.clearSelection();
        this.m_viewMode = 1;
    }

    public void handleShown() {
        if (this.m_editor == null) {
            return;
        }
        BPELLogPage.getInstance().loadLogWindow(this.m_editor);
    }

    public void dispose() {
        super.dispose();
        this.m_editor.cleanup();
        this.m_editor = null;
    }

    public void deactivate() {
        this.getUndoRedoDisabler().disableUndoRedo(false);
        if (this.getOwningJDevView() != null) {
            this.handleEditorTransition();
        }
        if (this.m_editor != null) {
            this.m_editor.deactivated();
        }
    }

    public void setOwningJDevView(View view) {
        this.m_view = view;
    }

    public View getOwningJDevView() {
        return this.m_view;
    }

    public Component getComponent() {
        if (this.m_editor == null) {
            this.m_editor = new JDevBPELEditor(this, this.m_bpelFileURL);
            this.m_editor.initialize();
        }
        return this.m_editor;
    }

    @Override
    public void markChange(boolean bChange) {
        IdeAction action;
        this.getXMLModel().newDiagramTimeStamp();
        if (this.m_view == null) {
            return;
        }
        Context ct = this.m_view.getContext();
        if (ct == null) {
            GraphUtils.displayMessage((Component)this.m_editor, (String)"Cannot mark change, context is null!");
            return;
        }
        Node doc = ct.getNode();
        if (doc == null) {
            GraphUtils.displayMessage((Component)this.m_editor, (String)"Cannot mark change, Node is null!");
            return;
        }
        doc.markDirty(bChange);
        Process p = this.getXMLModel().getProcess();
        if (p.getPrefixForNamespace("http://schemas.oracle.com/bpel/extension") == null) {
            p.addNamespace("http://schemas.oracle.com/bpel/extension", "bpelx");
        }
        if (bChange && !(action = IdeAction.find((int)11)).isEnabled()) {
            action.setEnabled(true);
        }
    }

    public JDevBPELEditor getJDevBPELEditor() {
        return this.m_editor;
    }

    protected void verifyModelsInitialized() {
        BPELXmlModel model = this.getXMLModel();
        if (model == null) {
            return;
        }
        model.setGUI(this);
        model.syncProcessToDOM();
        BPELProject prj = model.getBPELProject();
        if (prj != null && prj.getProjectContext() == null) {
            Context ct = (Context)prj.getIDEContext();
            prj.setProjectContext((Object)ct.getProject());
        }
    }

    protected void handleEditorTransition() {
        try {
            this.getXMLModel().saveEditorTransitionData();
            if (this.m_editor != null) {
                this.m_editor.getBPELPerspectiveComponent().saveGraphicsInformation();
                String selectionXPath = null;
                Perspective p = this.m_editor.getPerspectivesPanel().getSelectedPerspective();
                if (p != null) {
                    selectionXPath = p.getSelectionXPath();
                    this.m_sourceEditor.selectNode(selectionXPath);
                }
            }
        }
        catch (Exception e) {
            GraphUtils.displayError((Component)Ide.getMainWindow(), (Throwable)e);
        }
        this.m_viewMode = 2;
    }

    protected String getSourceEditorSelectionPath() {
        if (this.m_viewMode != 2) {
            return null;
        }
        return this.m_sourceEditor.getSelectedPath();
    }
}

