/*
 * Decompiled with CFR 0.152.
 */
package oracle.tip.tools.ide.pm.addin.view;

import java.awt.Component;
import java.net.URL;
import java.util.ArrayList;
import java.util.EventObject;
import javax.swing.JMenuItem;
import oracle.ide.Context;
import oracle.ide.controller.Controller;
import oracle.ide.controller.IdeAction;
import oracle.ide.controller.IdeActions;
import oracle.ide.model.Element;
import oracle.ide.model.Project;
import oracle.ide.net.URLFileSystem;
import oracle.tip.tools.ide.common.ide.bpel.BPELProject;
import oracle.tip.tools.ide.common.utils.BPELWSDLNode;
import oracle.tip.tools.ide.pm.addin.model.BPELNode;
import oracle.tip.tools.ide.pm.addin.model.XMLNode;
import oracle.tip.tools.ide.pm.addin.view.JDevBPELEditor;
import oracle.tip.tools.ide.pm.i18n.BPELStringTranslator;

public class BPELAddinController
implements Controller {
    public void install() {
        IdeAction action = IdeActions.getFileSaveAction();
        action.addController((Controller)this);
        action = IdeActions.getFileSaveAllAction();
        action.addController((Controller)this);
        IdeAction.find((int)16).addController((Controller)this);
        IdeAction.find((int)12).addController((Controller)this);
        IdeAction.find((int)21).addController((Controller)this);
        IdeAction.find((int)47).addController((Controller)this);
        IdeAction.find((int)20).addController((Controller)this);
        IdeAction.find((int)14).addController((Controller)this);
        ArrayList<IdeAction> actions = new ArrayList<IdeAction>();
        actions.add(IdeActions.getNavigateGoToLineAction());
        actions.add(IdeActions.getNavigateGoToPreviousMessageAction());
        actions.add(IdeActions.getNavigateGoToNextMessageAction());
        for (IdeAction a : actions) {
            a.addController((Controller)this);
            a.setEnabled(false);
        }
    }

    public boolean handleEvent(IdeAction action, Context ctx) {
        Component component;
        int id = action.getCommandId();
        if (id == 16) {
            Component component2 = ctx.getView().getGUI();
            if (component2 instanceof JDevBPELEditor) {
                ((JDevBPELEditor)component2).printDocument();
                return true;
            }
        } else if (id == 20 && (component = ctx.getView().getGUI()) instanceof JDevBPELEditor) {
            EventObject evt = ctx.getEvent();
            if (evt != null && evt.getSource() instanceof JMenuItem) {
                ((JDevBPELEditor)component).getBPELGraphPane().handleDeleteKey(true);
            }
            return true;
        }
        return false;
    }

    public boolean update(IdeAction action, Context context) {
        Element[] elementArray;
        int id = action.getCommandId();
        if (id == 16) {
            Component component = context.getView().getGUI();
            if (component instanceof JDevBPELEditor) {
                action.setEnabled(true);
                return true;
            }
        } else if (id == 12 || id == 21 || id == 47) {
            Element element = context.getElement();
            if (element instanceof BPELNode || element instanceof BPELWSDLNode || element instanceof XMLNode) {
                if (id == 21) {
                    action.putValue("Name", (Object)BPELStringTranslator.getString("REMOVE_FROM_INTEGRATION_CONT", "Remove from Integration Content"));
                }
                boolean bCheckEnabled = false;
                if (id == 21 || id == 47) {
                    bCheckEnabled = this.isEnabled(context);
                }
                action.setEnabled(bCheckEnabled);
                return true;
            }
        } else if (id == 20) {
            Component component = context.getView().getGUI();
            if (component instanceof JDevBPELEditor) {
                JDevBPELEditor editor = (JDevBPELEditor)component;
                action.setEnabled(editor.getBPELPerspectiveComponent().canDeleteSelectedNode());
                return true;
            }
        } else if (id == 14 && (elementArray = context.getSelection()) != null) {
            for (Element e : elementArray) {
                if (e == null || !(e instanceof BPELNode) && !(e.getData() instanceof BPELNode)) continue;
                action.setEnabled(false);
                return true;
            }
        }
        return false;
    }

    protected boolean isEnabled(Context context) {
        Project proj = context.getProject();
        if (proj == null) {
            return true;
        }
        String longLabel = context.getElement().getLongLabel();
        if (longLabel == null) {
            return true;
        }
        BPELProject prj = this.getBPELProject(context);
        if (prj == null) {
            return true;
        }
        URL depURL = prj.getDeploymentFileURL();
        if (depURL != null && longLabel.endsWith(URLFileSystem.getFileName((URL)depURL))) {
            return false;
        }
        URL wsdlURL = prj.getWSDLFileURL(prj.getProcessName());
        if (wsdlURL != null && longLabel.endsWith(URLFileSystem.getFileName((URL)wsdlURL))) {
            return false;
        }
        URL processURL = prj.getBPELFileURL();
        return processURL == null || !longLabel.endsWith(URLFileSystem.getFileName((URL)processURL));
    }

    protected BPELProject getBPELProject(Context ctx) {
        JDevBPELEditor editor = this.getJDevBPELEditor(ctx);
        if (editor != null) {
            return editor.getBPELGraphPane().getBPELProject();
        }
        return null;
    }

    protected JDevBPELEditor getJDevBPELEditor(Context ctx) {
        Component component = ctx.getView().getGUI();
        if (component instanceof JDevBPELEditor) {
            return (JDevBPELEditor)component;
        }
        return null;
    }
}

