/*
 * Decompiled with CFR 0.152.
 */
package oracle.tip.tools.ide.pm.addin.structurepane;

import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.Observable;
import java.util.Observer;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import oracle.tip.tools.ide.common.bpelparser.iface.Activity;
import oracle.tip.tools.ide.common.graph.GraphUtils;
import oracle.tip.tools.ide.common.graph.event.GraphModelEvent;
import oracle.tip.tools.ide.common.graph.event.GraphModelListener;
import oracle.tip.tools.ide.common.graph.event.GraphPaneStatusEvent;
import oracle.tip.tools.ide.common.graph.event.GraphPaneStatusListener;
import oracle.tip.tools.ide.common.graph.model.GraphModel;
import oracle.tip.tools.ide.common.graph.model.NodeInfo;
import oracle.tip.tools.ide.common.graph.view.GraphPane;
import oracle.tip.tools.ide.common.ui.CardPanel;
import oracle.tip.tools.ide.pm.bpelgraph.views.BPELGraphPane;
import oracle.tip.tools.ide.pm.gui.explorer.ExplorerTree;
import oracle.tip.tools.ide.pm.gui.explorer.ProcessExplorer;
import oracle.tip.tools.ide.pm.i18n.BPELStringTranslator;

public class StructurePanePanel
extends JPanel
implements Observer,
GraphModelListener {
    public static final String STRUCTURE_PANE_EXPLORER_NAME = "STRUCTURE_PANE_EXPLORER_NAME";
    private static final String BPEL_PANEL = "BPEL_PANEL";
    protected ProcessExplorer m_processExplorer;
    protected GraphPane m_graph;
    protected JLabel m_statusLbl;
    protected CardPanel m_cardPnl;

    public void showBPELStructure() {
        this.m_cardPnl.show(BPEL_PANEL);
    }

    public StructurePanePanel() {
        this.createControls();
        this.layoutControls();
    }

    public void setGraphPane(BPELGraphPane graph) {
        this.m_processExplorer.setGraphPane(graph);
        this.m_graph = graph;
        this.setCardPanel();
        this.m_graph.addGraphPaneStatusListener(new GraphPaneStatusListener(){

            public void statusChanged(GraphPaneStatusEvent e) {
            }

            public void modelLoaded(GraphModel model) {
                StructurePanePanel.this.setCardPanel();
                if (model != null) {
                    StructurePanePanel.this.updateGUI();
                    model.addGraphModelListener((GraphModelListener)StructurePanePanel.this);
                }
            }
        });
    }

    public Object getSelectedNodeData() {
        return this.m_processExplorer.getExplorerTree().getSelectedNodeData();
    }

    public ProcessExplorer getProcessExplorer() {
        return this.m_processExplorer;
    }

    public GraphPane getGraphPane() {
        return this.m_graph;
    }

    protected void createControls() {
        this.m_cardPnl = new CardPanel();
        this.m_cardPnl.add(BPEL_PANEL, (Component)this.createBPELPanel());
        this.m_cardPnl.show(BPEL_PANEL);
    }

    protected void setStatusMessage(String s) {
        if (s == null) {
            s = "    ";
        }
        this.m_statusLbl.setText(s);
    }

    protected JPanel createBPELPanel() {
        this.m_statusLbl = new JLabel("    ");
        this.m_statusLbl.setVisible(false);
        this.m_processExplorer = new ProcessExplorer();
        ExplorerTree tree = this.m_processExplorer.getExplorerTree();
        tree.setName(STRUCTURE_PANE_EXPLORER_NAME);
        tree.setStructurePane(true);
        JPanel p = new JPanel();
        p.setLayout(new GridBagLayout());
        GraphUtils.addComponent((Container)p, (Component)this.m_processExplorer, (int)0, (int)0, (int)1, (int)1, (int)17, (int)1, (Insets)new Insets(0, 0, 0, 0), (int)0, (int)0, (double)1.0, (double)1.0);
        GraphUtils.addComponent((Container)p, (Component)this.m_statusLbl, (int)0, (int)1, (int)1, (int)1, (int)17, (int)2, (Insets)new Insets(2, 5, 2, 0), (int)0, (int)0, (double)1.0, (double)0.0);
        return p;
    }

    protected void setCardPanel() {
        this.showBPELStructure();
    }

    protected void layoutControls() {
        this.setLayout(new GridBagLayout());
        GraphUtils.addComponent((Container)this, (Component)this.m_cardPnl, (int)0, (int)0, (int)1, (int)1, (int)17, (int)1, (Insets)new Insets(0, 0, 0, 0), (int)0, (int)0, (double)1.0, (double)1.0);
    }

    protected void refreshActivities() {
        this.m_processExplorer.getExplorerTree().refreshNode(22);
    }

    protected void refreshPartnerLinks() {
        this.m_processExplorer.getExplorerTree().refreshNode(13);
    }

    protected void refreshVariables() {
        this.m_processExplorer.getExplorerTree().refreshNode(0);
    }

    protected void refreshCorrelations() {
        this.m_processExplorer.getExplorerTree().refreshNode(21);
    }

    protected void updateGUI() {
        this.asyncLoadExplorer(null, true, true, true, true);
    }

    void asyncLoadExplorer(final Activity a, boolean bShowVariables, boolean bShowMessageTypes, boolean bShowCorrelationSets, boolean bImportedSchemas) {
        this.setStatusMessage(BPELStringTranslator.getString("EDITOR_REFRESHING"));
        Runnable r = new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                try {
                    StructurePanePanel.this.m_processExplorer.loadExplorer(a);
                }
                finally {
                    StructurePanePanel.this.setStatusMessage(null);
                }
            }
        };
        SwingUtilities.invokeLater(r);
    }

    protected boolean partnerLinkNodeChanged(GraphModelEvent e) {
        NodeInfo[] nodes = e.getChildNodeInfo();
        if (nodes != null) {
            for (int i = 0; i < nodes.length; ++i) {
                NodeInfo node = nodes[i];
                if (node.getNode().getNodeType() != 111) continue;
                return true;
            }
        }
        return false;
    }

    protected boolean scopeChanged(GraphModelEvent e) {
        NodeInfo[] nodes = e.getChildNodeInfo();
        if (nodes != null) {
            for (int i = 0; i < nodes.length; ++i) {
                NodeInfo node = nodes[i];
                if (node.getNode().getNodeType() != 102) continue;
                return true;
            }
        }
        return false;
    }

    public void graphNodesChanged(GraphModelEvent e) {
        this.refreshActivities();
        if (this.partnerLinkNodeChanged(e)) {
            this.refreshPartnerLinks();
        }
        if (this.scopeChanged(e)) {
            this.refreshVariables();
            this.refreshCorrelations();
        }
    }

    public void graphNodesInserted(GraphModelEvent e) {
        this.refreshActivities();
        if (this.partnerLinkNodeChanged(e)) {
            this.refreshPartnerLinks();
        }
        if (this.scopeChanged(e)) {
            this.refreshVariables();
            this.refreshCorrelations();
        }
    }

    public void graphNodesRemoved(GraphModelEvent e) {
        this.refreshActivities();
        if (this.partnerLinkNodeChanged(e)) {
            this.refreshPartnerLinks();
        }
        if (this.scopeChanged(e)) {
            this.refreshVariables();
            this.refreshCorrelations();
        }
    }

    public void graphStructureChanged(GraphModelEvent e) {
        this.refreshActivities();
    }

    public void edgesInserted(GraphModelEvent e) {
    }

    public void edgesRemoved(GraphModelEvent e) {
    }

    @Override
    public void update(Observable o, Object arg) {
        this.updateGUI();
    }
}

