/*
 * Decompiled with CFR 0.152.
 */
package oracle.tip.tools.ide.pm.addin.structurepane;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.JLabel;
import javax.swing.JPanel;
import oracle.tip.tools.ide.common.graph.GraphUtils;
import oracle.tip.tools.ide.common.ui.CardPanel;
import oracle.tip.tools.ide.pm.addin.view.JDevBPELEditor;
import oracle.tip.tools.ide.pm.plugin.Perspective;

public class StructurePane
extends JPanel {
    private static final String NO_STRUCTURE = "NO_STRUCTURE";
    protected CardPanel m_cardPnl;
    protected JDevBPELEditor m_editor;

    public StructurePane(JDevBPELEditor editor) {
        this.m_editor = editor;
        this.m_cardPnl = new CardPanel();
        this.m_cardPnl.add(NO_STRUCTURE, (Component)this.createNoStructurePanel());
        this.m_cardPnl.show(NO_STRUCTURE);
        this.setLayout(new GridBagLayout());
        GraphUtils.addComponent((Container)this, (Component)this.m_cardPnl, (int)0, (int)0, (int)1, (int)1, (int)17, (int)1, (Insets)new Insets(0, 0, 0, 0), (int)0, (int)0, (double)1.0, (double)1.0);
    }

    public void initialize() {
        for (Perspective p : this.m_editor.getPerspectivesPanel().getPerspectives()) {
            this.m_cardPnl.add(p.getID(), (Component)p.getStructure());
        }
        Perspective p = this.m_editor.getPerspectivesPanel().getSelectedPerspective();
        if (p != null) {
            this.showStructureForPerspective(p);
        }
    }

    public void showStructureForPerspective(Perspective p) {
        this.m_cardPnl.show(p.getID());
    }

    protected JPanel createNoStructurePanel() {
        JPanel p = new JPanel(new GridBagLayout());
        JLabel l = new JLabel("No Structure", 0);
        l.setForeground(Color.lightGray);
        GraphUtils.addComponent((Container)p, (Component)l, (int)0, (int)0, (int)1, (int)1, (int)17, (int)2, (Insets)new Insets(0, 0, 0, 0), (int)0, (int)0, (double)1.0, (double)0.0);
        return p;
    }
}

