/*
 * Decompiled with CFR 0.152.
 */
package oracle.tip.tools.ide.pm.addin.preferences;

import java.io.File;
import java.io.Serializable;
import java.net.MalformedURLException;
import java.net.URL;
import oracle.ide.Ide;
import oracle.ide.config.ClientSetting;
import oracle.ide.net.URLFileSystem;
import oracle.javatools.util.Copyable;
import oracle.tip.tools.ide.pm.addin.BPELAddin;
import oracle.tip.tools.ide.pm.bpelgraph.settings.BPELSettings;
import oracle.tip.tools.ide.pm.bpelgraph.settings.GraphicsFileUtil;
import org.w3c.dom.Document;

public class BPELDesignerSettings
implements Copyable,
Serializable {
    public static final String KEY = BPELDesignerSettings.class.getName();
    public static final String SETTINGS_FILE_NAME = "bpel_designer_settings.xml";
    private static BPELDesignerSettings m_globalSettings;
    private BPELSettings m_data = new BPELSettings();

    public static BPELDesignerSettings getGlobalSettings() {
        return m_globalSettings;
    }

    public BPELSettings getData() {
        return this.m_data;
    }

    public void setData(BPELSettings data) {
        this.m_data = data;
    }

    public static void install() {
        BPELDesignerSettings.register();
    }

    public static void register() {
        ClientSetting clientSetting = ClientSetting.findOrCreate((String)BPELAddin.getExtensionID());
        Copyable settings = clientSetting.getData(KEY);
        if (settings == null) {
            settings = new BPELDesignerSettings();
            clientSetting.putData(KEY, settings);
        }
        m_globalSettings = (BPELDesignerSettings)settings;
        try {
            BPELSettings bpelSettings = null;
            URL url = BPELDesignerSettings.getSettingsFileURL();
            if (URLFileSystem.exists((URL)url)) {
                Document doc = GraphicsFileUtil.loadGraphicsFile(url);
                bpelSettings = GraphicsFileUtil.readSettings(doc);
            }
            if (bpelSettings == null) {
                bpelSettings = new BPELSettings();
            }
            ((BPELDesignerSettings)settings).setData(bpelSettings);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public BPELDesignerSettings copyTo(Object target) {
        BPELDesignerSettings settings = null;
        settings = target == null ? m_globalSettings : (BPELDesignerSettings)target;
        BPELSettings srcData = this.getData();
        BPELSettings targetData = settings.getData();
        srcData.copyTo(targetData);
        return settings;
    }

    public static URL getSettingsFileURL() {
        URL u = null;
        try {
            File f = new File(Ide.getSystemDirectory(), SETTINGS_FILE_NAME);
            u = f.toURL();
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
        }
        return u;
    }
}

