/*
 * Decompiled with CFR 0.152.
 */
package oracle.tip.tools.ide.pm.addin.palette;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import oracle.ide.Context;
import oracle.ide.model.Project;
import oracle.ide.palette2.DefaultPaletteGroup;
import oracle.ide.palette2.DefaultPaletteItem;
import oracle.ide.palette2.DefaultPalettePage;
import oracle.ide.palette2.DefaultPaletteSection;
import oracle.ide.palette2.PaletteGroup;
import oracle.ide.palette2.PaletteItem;
import oracle.ide.palette2.PalettePage;
import oracle.ide.palette2.PalettePages;
import oracle.ide.palette2.PalettePagesListener;
import oracle.ide.palette2.PaletteSection;
import oracle.tip.tools.ide.fabric.addin.SCAProject;
import oracle.tip.tools.ide.fabric.resource.SCAResourceLookup;
import oracle.tip.tools.ide.pm.addin.palette.BpelPalettePageProvider;
import oracle.tip.tools.ide.pm.i18n.BPELStringTranslator;
import oracle.tip.tools.ide.pm.plugin.BPELModelerPlugin;
import oracle.tip.tools.ide.pm.plugin.BPELPlugInManager;
import oracle.tip.tools.ide.pm.plugin.palette.BpelPaletteItem;
import oracle.tip.tools.ide.pm.plugin.palette.PalettePlugin;

public class BpelPalettePages
extends PalettePages {
    private static BpelPalettePages m_bpelPalettePages;
    private Context m_context;
    private List<PalettePage> palettePages = new ArrayList<PalettePage>(1);
    private List<PalettePagesListener> palettePagesListeners = new ArrayList<PalettePagesListener>();
    public static final String BPEL_PAGE_NAME;
    public static final String SERVICES_GROUP_NAME;
    public static final String SCA_ADAPTER_SECTION_NAME;

    public static BpelPalettePages getInstance(Context context) {
        if (SCAProject.isSOAProject((Project)context.getProject())) {
            if (m_bpelPalettePages == null) {
                m_bpelPalettePages = new BpelPalettePages(context);
            }
            return m_bpelPalettePages;
        }
        if (m_bpelPalettePages == null) {
            m_bpelPalettePages = new BpelPalettePages(context);
        }
        return m_bpelPalettePages;
    }

    private BpelPalettePages(Context context) {
        this.m_context = context;
        this.createPalettePages();
    }

    private void createPalettePages() {
        ArrayList<String> showForTypes = new ArrayList<String>();
        showForTypes.add("SOA");
        ArrayList<String> technologyScopes = new ArrayList<String>();
        technologyScopes.add("SOA");
        DefaultPalettePage page = new DefaultPalettePage(BPEL_PAGE_NAME, null, "/" + SCAResourceLookup.getImageString((String)"SCA_ICON"), "oracle.tip.tools.ide.fabric.addin.CompositePalettePages.SCA", null, null, showForTypes, technologyScopes, "SOA", null);
        this.palettePages.add((PalettePage)page);
        DefaultPaletteGroup serviceGroup = new DefaultPaletteGroup(SERVICES_GROUP_NAME, null, "/" + SCAResourceLookup.getImageString((String)"SCA_ICON"), page.getData((Object)"pageId") + "." + SERVICES_GROUP_NAME, null, null, showForTypes, technologyScopes, "SOA");
        page.addGroup((PaletteGroup)serviceGroup);
        DefaultPaletteSection plSection = new DefaultPaletteSection(BPELStringTranslator.getString("PARTNER_LINK_PALETTE_SECTION_NAME"), serviceGroup.getData((Object)"groupId") + "PartnerLink");
        serviceGroup.addSection((PaletteSection)plSection);
        DefaultPaletteItem pl = new DefaultPaletteItem(BPELStringTranslator.getString("PARTNER_LINK_PALETTE_NAME"), BPELStringTranslator.getString("PARTNER_LINK_PALETTE_DESCRIPTION"), "/oracle/tip/tools/ide/pm/resources/images/palette/adapterservice/serviceicon_16x16.png", "PartnerLink", BpelPalettePageProvider.PROVIDER_ID, null, technologyScopes, "SOA", null, null, null, null, null, null, null);
        plSection.addItem((PaletteItem)pl);
        DefaultPaletteSection adapterSection = new DefaultPaletteSection(SCA_ADAPTER_SECTION_NAME, serviceGroup.getData((Object)"groupId") + "adapters");
        serviceGroup.addSection((PaletteSection)adapterSection);
        for (BPELModelerPlugin plugin : BPELPlugInManager.getPlugins()) {
            PalettePlugin p = plugin.getPalettePalettePlugin();
            if (p == null) continue;
            for (BpelPaletteItem item : p.getPaletteItems(this.m_context)) {
                DefaultPaletteItem bpelItem = new DefaultPaletteItem(item.getName(), item.getDescription(), item.getIcon(), item.getName(), BpelPalettePageProvider.PROVIDER_ID, null, technologyScopes, "SOA", null, null, null, null, null, null, null);
                adapterSection.addItem((PaletteItem)bpelItem);
            }
        }
    }

    public Collection<PalettePage> getPages() {
        return Collections.unmodifiableList(this.palettePages);
    }

    public PaletteItem getItem(String providerId, String itemId) {
        if (providerId == null || providerId.length() == 0 || itemId == null || itemId.length() == 0) {
            return null;
        }
        if (providerId.equals(BpelPalettePageProvider.PROVIDER_ID)) {
            for (PalettePage palettePage : this.palettePages) {
                PaletteItem paletteItem = ((DefaultPalettePage)palettePage).getItem(itemId);
                if (paletteItem == null) continue;
                return paletteItem;
            }
        }
        return null;
    }

    public void addPalettePagesListener(PalettePagesListener listener) {
        this.palettePagesListeners.add(listener);
    }

    public void removePalettePagesListener(PalettePagesListener listener) {
        this.palettePagesListeners.remove(listener);
    }

    public PalettePage getPreferredPage() {
        return this.palettePages.get(0);
    }

    public float getPreferredPageRank() {
        return Float.MAX_VALUE;
    }

    static {
        BPEL_PAGE_NAME = BPELStringTranslator.getString("PM_PALETTE_NAME");
        SERVICES_GROUP_NAME = BPELStringTranslator.getString("BPEL_SERVICES");
        SCA_ADAPTER_SECTION_NAME = BPELStringTranslator.getString("ADAPTER_PAGE_GROUP_NAME_L");
    }
}

