/*
 * Decompiled with CFR 0.152.
 */
package oracle.tip.tools.ide.pm.addin.modelbean;

import java.io.File;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;

public class ClassFinder {
    public static List findClasses(String pckgname) throws ClassNotFoundException {
        return ClassFinder.findClasses(pckgname, null);
    }

    public static List findClasses(String pckgname, String baseClassName) throws ClassNotFoundException {
        URL url;
        ArrayList<String> list = new ArrayList<String>();
        String name = new String(pckgname);
        if (!name.startsWith("/")) {
            name = "/" + name;
        }
        if ((url = ClassFinder.class.getResource(name = name.replace('.', '/'))) == null) {
            return list;
        }
        File directory = new File(url.getFile());
        if (directory.exists()) {
            String[] files = directory.list();
            for (int i = 0; i < files.length; ++i) {
                if (!files[i].endsWith(".class")) continue;
                String classname = files[i].substring(0, files[i].length() - 6);
                String fullPathName = pckgname + "." + classname;
                if (baseClassName == null) continue;
                Class<?> cls = Class.forName(fullPathName);
                List slist = ClassFinder.getSuperClass(fullPathName);
                if (!slist.contains(baseClassName)) continue;
                list.add(fullPathName);
                continue;
            }
        }
        return list;
    }

    public static void getInterface(String clsName, List list) throws ClassNotFoundException {
        Class<?>[] ints;
        Class<?> cls = Class.forName(clsName);
        if (cls.isInterface() && (ints = cls.getInterfaces()) != null) {
            for (int i = 0; i < ints.length; ++i) {
                list.add(ints[i].getName());
                ClassFinder.getInterface(ints[i].getName(), list);
            }
        }
    }

    public static List getSuperClass(String clsName) throws ClassNotFoundException {
        ArrayList<String> list = new ArrayList<String>();
        Class<?> cls = Class.forName(clsName);
        if (cls.isInterface()) {
            ClassFinder.getInterface(clsName, list);
        } else {
            boolean bCont = true;
            while (bCont) {
                Class<?> supCls = cls.getSuperclass();
                if (supCls == null) {
                    bCont = false;
                    continue;
                }
                list.add(supCls.getName());
                if ("java.lang.Object".equals(supCls.getName())) {
                    bCont = false;
                    continue;
                }
                cls = supCls;
            }
        }
        return list;
    }
}

