/*
 * Decompiled with CFR 0.152.
 */
package oracle.tip.tools.ide.pm.addin.modelbean;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.lang.reflect.Method;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import oracle.tip.tools.ide.pm.addin.modelbean.ClassFinder;

public class BeanGenerator {
    private static final String GET = "get";
    private static final String SET = "set";
    private static final String IS = "is";
    private static final String CRLF = "\r\n";
    private static final String HEADER_PATTERN = "/*\r\n * @(#){0}Bean.java\r\n *\r\n * Copyright 2004 by Oracle Corporation \r\n * http://www.oracle.com \r\n * All rights reserved. \r\n * \r\n * This software is the confidential and proprietary information\r\n * of Oracle Corporation (\"Confidential Information\"). You shall not\r\n * disclose such Confidential Information and shall use it only in \r\n * accordance with the terms of the license agreement you entered \r\n * into with Oracle Corporation. \r\n */\r\n\r\n/* \r\n * Note: This file is auto generated, please do not modified it. \r\n */\r\n\r\n";
    private static final String SUPPORT_INSPECTION = "oracle.ide.model.SupportsInspection";
    private static final String PACKAGE_NAME = "package oracle.tip.tools.ide.pm.addin.modelbean.generated;\r\n\r\n";
    private static final String IMPORT_PATTERN = "import {0};\r\n";
    private static final String CLASS_PATTERN = "public class {0}Bean implements SupportsInspection '{' \r\n";
    private static final String MEMBER_DECLARE = "\r\n\tprivate {0} m_{1};\r\n";
    private static final String CONSTRUCTOR_PATTEN = "\r\n\tpublic {0}Bean({1} p) '{'\r\n\t\tm_{2} = p;\r\n\t'}'\r\n";
    private static final String METHOD_PATTERN = "\r\n\tpublic {0} {1}({2}) {3} '{'\r\n\t\t{4} m_{5}.{6}({7});\r\n\t'}'\r\n";
    private static final String JAVA_LANG_STR = "java.lang";

    public static List getMethods(Class tarClass) {
        ArrayList<Method> list = new ArrayList<Method>();
        Method[] method = tarClass.getMethods();
        for (int i = 0; i < method.length; ++i) {
            String name;
            if (method[i].getModifiers() == 8 || !(name = method[i].getName()).startsWith(GET) && !name.startsWith(SET) && !name.startsWith(IS)) continue;
            list.add(method[i]);
        }
        return list;
    }

    private static boolean isJavaLangOrBaseType(String fullPathName) {
        if (fullPathName.indexOf(".") == -1) {
            return true;
        }
        int index = fullPathName.lastIndexOf(".");
        if (index == -1) {
            return false;
        }
        String langStr = fullPathName.substring(0, index);
        return JAVA_LANG_STR.equals(langStr);
    }

    private static String getClassName(String fullName) {
        int index = fullName.lastIndexOf(".");
        if (index == -1) {
            return fullName;
        }
        return fullName.substring(index + 1, fullName.length());
    }

    private static Params getParameterString(Method method, Map map, StringBuffer strImportBuffer) {
        Params params = new Params();
        Class<?>[] paramTypes = method.getParameterTypes();
        if (paramTypes == null || paramTypes.length == 0) {
            return params;
        }
        StringBuffer strBuf = new StringBuffer();
        StringBuffer strList = new StringBuffer();
        int i = 0;
        int suffix = 1;
        do {
            String pType = BeanGenerator.getClassName(paramTypes[i].getName());
            boolean bUseFull = false;
            if (!BeanGenerator.isJavaLangOrBaseType(paramTypes[i].getName())) {
                if (map.containsKey(pType)) {
                    String val = (String)map.get(pType);
                    if (!val.equals(paramTypes[i].getName())) {
                        bUseFull = true;
                    }
                } else {
                    map.put(pType, paramTypes[i].getName());
                    strImportBuffer.append(MessageFormat.format(IMPORT_PATTERN, paramTypes[i].getName()));
                }
            }
            if (bUseFull) {
                strBuf.append(paramTypes[i].getName());
            } else {
                strBuf.append(pType);
            }
            strBuf.append(" p" + suffix);
            strList.append("p" + suffix++);
            if (++i >= paramTypes.length) continue;
            strBuf.append(",");
            strList.append(", ");
        } while (i < paramTypes.length);
        params.m_pStr = strBuf.toString();
        params.m_pListStr = strList.toString();
        return params;
    }

    private static String getExceptionString(Method method, Map map, StringBuffer strImportBuffer) {
        Class<?>[] excTypes = method.getExceptionTypes();
        if (excTypes == null || excTypes.length == 0) {
            return "";
        }
        StringBuffer strBuf = new StringBuffer("throws");
        int i = 0;
        boolean suffix = true;
        do {
            String pType = BeanGenerator.getClassName(excTypes[i].getName());
            boolean bUseFull = false;
            if (!BeanGenerator.isJavaLangOrBaseType(excTypes[i].getName())) {
                if (map.containsKey(pType)) {
                    String val = (String)map.get(pType);
                    if (!val.equals(excTypes[i].getName())) {
                        bUseFull = true;
                    }
                } else {
                    map.put(pType, excTypes[i].getName());
                    strImportBuffer.append(MessageFormat.format(IMPORT_PATTERN, excTypes[i].getName()));
                }
            }
            if (bUseFull) {
                strBuf.append(excTypes[i].getName());
            } else {
                strBuf.append(pType);
            }
            if (++i >= excTypes.length) continue;
            strBuf.append(", ");
        } while (i < excTypes.length);
        return strBuf.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void generateBeanClass(Class tarClass, String path) {
        HashMap<String, String> map = new HashMap<String, String>();
        StringBuffer strImportBuffer = new StringBuffer();
        StringBuffer strCodeBuffer = new StringBuffer();
        map.put("SupportsInspection", SUPPORT_INSPECTION);
        strImportBuffer.append(MessageFormat.format(IMPORT_PATTERN, SUPPORT_INSPECTION));
        String fullName = tarClass.getName();
        String className = fullName.substring(fullName.lastIndexOf(".") + 1, fullName.length());
        map.put(className, fullName);
        strImportBuffer.append(MessageFormat.format(IMPORT_PATTERN, fullName));
        strCodeBuffer.append(MessageFormat.format(CLASS_PATTERN, className));
        strCodeBuffer.append(MessageFormat.format(MEMBER_DECLARE, className, className));
        strCodeBuffer.append(MessageFormat.format(CONSTRUCTOR_PATTEN, className, className, className));
        List list = BeanGenerator.getMethods(tarClass);
        for (int i = 0; i < list.size(); ++i) {
            Method method = (Method)list.get(i);
            Class<?> retType = method.getReturnType();
            String retName = BeanGenerator.getClassName(retType.getName());
            boolean bUseFull = false;
            if (!BeanGenerator.isJavaLangOrBaseType(retType.getName())) {
                if (map.containsKey(retName)) {
                    String val = (String)map.get(retName);
                    if (!val.equals(retType.getName())) {
                        bUseFull = true;
                    }
                } else {
                    map.put(retName, retType.getName());
                    strImportBuffer.append(MessageFormat.format(IMPORT_PATTERN, retType.getName()));
                }
            }
            String retStr = bUseFull ? retType.getName() : retName;
            Params params = BeanGenerator.getParameterString(method, map, strImportBuffer);
            String excStr = BeanGenerator.getExceptionString(method, map, strImportBuffer);
            String mRetStr = retStr.equals("void") ? "" : "return";
            String code = MessageFormat.format(METHOD_PATTERN, retStr, method.getName(), params.m_pStr, excStr, mRetStr, className, method.getName(), params.m_pListStr);
            strCodeBuffer.append(code);
        }
        strCodeBuffer.append("}");
        OutputStreamWriter fw = null;
        try {
            File dir = new File(path);
            if (!dir.exists()) {
                dir.mkdirs();
            }
            fw = new FileWriter(path + className + "Bean.java");
            fw.write(MessageFormat.format(HEADER_PATTERN, className));
            fw.write(PACKAGE_NAME);
            fw.write(strImportBuffer.toString());
            fw.write(CRLF);
            fw.write(strCodeBuffer.toString());
        }
        catch (IOException ioe) {
            System.out.println("ioe=" + ioe.getMessage());
            ioe.printStackTrace();
        }
        finally {
            if (fw != null) {
                try {
                    fw.close();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
    }

    public static void generate(String path, String packagename, String clsName) {
        System.out.println("Target Directory=" + path);
        System.out.println("Package=" + packagename);
        System.out.println("Base Class Name=" + clsName);
        try {
            List list = ClassFinder.findClasses(packagename, clsName);
            if (list != null) {
                System.out.println("Found " + list.size() + " class(es)");
                for (int i = 0; i < list.size(); ++i) {
                    String fName = (String)list.get(i);
                    fName = fName.substring(fName.lastIndexOf(".") + 1, fName.length());
                    System.out.println("Generating " + fName + "Bean.java");
                    Class<?> tarClass = Class.forName((String)list.get(i));
                    if (!path.endsWith("/")) {
                        path = path + "/";
                    }
                    BeanGenerator.generateBeanClass(tarClass, path);
                }
            }
        }
        catch (Exception ex) {
            System.out.println("Exception=" + ex.getMessage());
            ex.printStackTrace();
        }
    }

    public static void main(String[] args) {
        if (args.length == 3) {
            BeanGenerator.generate(args[0], args[1], args[2]);
        } else if (args.length == 2) {
            BeanGenerator.generate(args[0], args[1], null);
        } else {
            System.out.println("Usage: java BeanGenerator [<path> <package>] or");
            System.out.println("Usage: java BeanGenerator [<path> <package> <baseclass>");
        }
    }

    private static class Params {
        public String m_pStr = "";
        public String m_pListStr = "";

        private Params() {
        }
    }
}

